/*
 * font-info.c
 * Font metrics for Adobe Type1 Fonts
 *
 * extracted from ./tetex/fonts/afm/adobe
 *
 * see file LICENCE.texmf within that tree for a clear
 * statement that the files may be distributed.
 * Thank you to Adobe and to the teTeX people.
 * ftp.adobe.com/pub/adobe/type/win/all/afmfiles/base35
 * and www.tug.org/teTeX.
 */


/* Signature: 630442ba 24-May-2008 */


typedef struct font_info {
   const char *name;
   short int isfixed, fontwidth, maxleftbearing, maxrightbearing;
   short int capheight, xheight, ascent, descent;
   short int charwidth[256];
} font_info;

static font_info font_widths[] = {
{"AvantGarde-Demi", 0, 1280, 233, 234, 740, 555, 740, -185, {
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
   280,   280,   360,   560,   560,   860,   680,   280,
   380,   380,   440,   600,   280,   420,   280,   460,
   560,   560,   560,   560,   560,   560,   560,   560,
   560,   560,   280,   280,   600,   600,   600,   560,
   740,   740,   580,   780,   700,   520,   480,   840,
   680,   280,   480,   620,   440,   900,   740,   840,
   560,   840,   580,   520,   420,   640,   700,   900,
   680,   620,   500,   320,   640,   320,   600,   500,
   280,   660,   660,   640,   660,   640,   280,   660,
   600,   240,   260,   580,   240,   940,   600,   640,
   660,   660,   320,   440,   300,   600,   560,   800,
   560,   580,   460,   340,   600,   340,   600,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   280,   560,   560,   160,   560,   560,   560,
   560,   220,   480,   460,   240,   240,   520,   520,
    -1,   500,   560,   560,   280,    -1,   600,   600,
   280,   480,   480,   460,  1000,  1280,    -1,   560,
    -1,   420,   420,   540,   480,   420,   480,   280,
   500,    -1,   360,   340,    -1,   700,   340,   540,
  1000,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   900,    -1,   360,    -1,    -1,    -1,    -1,
   480,   840,  1060,   360,    -1,    -1,    -1,    -1,
    -1,  1080,    -1,    -1,    -1,   240,    -1,    -1,
   320,   660,  1080,   600,    -1,    -1,    -1,    -1 }},
{"AvantGarde-DemiOblique", 0, 1280, 258, 115, 740, 555, 740, -185, {
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
   280,   280,   360,   560,   560,   860,   680,   280,
   380,   380,   440,   600,   280,   420,   280,   460,
   560,   560,   560,   560,   560,   560,   560,   560,
   560,   560,   280,   280,   600,   600,   600,   560,
   740,   740,   580,   780,   700,   520,   480,   840,
   680,   280,   480,   620,   440,   900,   740,   840,
   560,   840,   580,   520,   420,   640,   700,   900,
   680,   620,   500,   320,   640,   320,   600,   500,
   280,   660,   660,   640,   660,   640,   280,   660,
   600,   240,   260,   580,   240,   940,   600,   640,
   660,   660,   320,   440,   300,   600,   560,   800,
   560,   580,   460,   340,   600,   340,   600,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   280,   560,   560,   160,   560,   560,   560,
   560,   220,   480,   460,   240,   240,   520,   520,
    -1,   500,   560,   560,   280,    -1,   600,   600,
   280,   480,   480,   460,  1000,  1280,    -1,   560,
    -1,   420,   420,   540,   480,   420,   480,   280,
   500,    -1,   360,   340,    -1,   700,   340,   540,
  1000,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   900,    -1,   360,    -1,    -1,    -1,    -1,
   480,   840,  1060,   360,    -1,    -1,    -1,    -1,
    -1,  1080,    -1,    -1,    -1,   240,    -1,    -1,
   320,   660,  1080,   600,    -1,    -1,    -1,    -1 }},
{"AvantGarde-Book", 0, 1194, 299, 299, 740, 547, 740, -192, {
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
   277,   295,   309,   554,   554,   775,   757,   351,
   369,   369,   425,   606,   277,   332,   277,   437,
   554,   554,   554,   554,   554,   554,   554,   554,
   554,   554,   277,   277,   606,   606,   606,   591,
   867,   740,   574,   813,   744,   536,   485,   872,
   683,   226,   482,   591,   462,   919,   740,   869,
   592,   871,   607,   498,   426,   655,   702,   960,
   609,   592,   480,   351,   605,   351,   606,   500,
   351,   683,   682,   647,   685,   650,   314,   673,
   610,   200,   203,   502,   200,   938,   610,   655,
   682,   682,   301,   388,   339,   608,   554,   831,
   480,   536,   425,   351,   672,   351,   606,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   295,   554,   554,   166,   554,   554,   615,
   554,   198,   502,   425,   251,   251,   487,   485,
    -1,   500,   553,   553,   277,    -1,   564,   606,
   354,   502,   484,   425,  1000,  1174,    -1,   591,
    -1,   378,   375,   502,   439,   485,   453,   222,
   369,    -1,   332,   324,    -1,   552,   302,   502,
  1000,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   992,    -1,   369,    -1,    -1,    -1,    -1,
   517,   868,  1194,   369,    -1,    -1,    -1,    -1,
    -1,  1157,    -1,    -1,    -1,   200,    -1,    -1,
   300,   653,  1137,   554,    -1,    -1,    -1,    -1 }},
{"AvantGarde-BookOblique", 0, 1194, 280, 162, 740, 547, 740, -192, {
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
   277,   295,   309,   554,   554,   775,   757,   351,
   369,   369,   425,   606,   277,   332,   277,   437,
   554,   554,   554,   554,   554,   554,   554,   554,
   554,   554,   277,   277,   606,   606,   606,   591,
   867,   740,   574,   813,   744,   536,   485,   872,
   683,   226,   482,   591,   462,   919,   740,   869,
   592,   871,   607,   498,   426,   655,   702,   960,
   609,   592,   480,   351,   605,   351,   606,   500,
   351,   683,   682,   647,   685,   650,   314,   673,
   610,   200,   203,   502,   200,   938,   610,   655,
   682,   682,   301,   388,   339,   608,   554,   831,
   480,   536,   425,   351,   672,   351,   606,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   295,   554,   554,   166,   554,   554,   615,
   554,   198,   502,   425,   251,   251,   487,   485,
    -1,   500,   553,   553,   277,    -1,   564,   606,
   354,   502,   484,   425,  1000,  1174,    -1,   591,
    -1,   378,   375,   502,   439,   485,   453,   222,
   369,    -1,   332,   324,    -1,   552,   302,   502,
  1000,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   992,    -1,   369,    -1,    -1,    -1,    -1,
   517,   868,  1194,   369,    -1,    -1,    -1,    -1,
    -1,  1157,    -1,    -1,    -1,   200,    -1,    -1,
   300,   653,  1137,   554,    -1,    -1,    -1,    -1 }},
{"Bookman-Demi", 0, 1360, 243, 238, 681, 502, 725, -212, {
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
   340,   360,   420,   660,   660,   940,   800,   320,
   320,   320,   460,   600,   340,   360,   340,   600,
   660,   660,   660,   660,   660,   660,   660,   660,
   660,   660,   340,   340,   600,   600,   600,   660,
   820,   720,   720,   740,   780,   720,   680,   780,
   820,   400,   640,   800,   640,   940,   740,   800,
   660,   800,   780,   660,   700,   740,   720,   940,
   780,   700,   640,   300,   600,   300,   600,   500,
   320,   580,   600,   580,   640,   580,   380,   580,
   680,   360,   340,   660,   340,  1000,   680,   620,
   640,   620,   460,   520,   460,   660,   600,   800,
   600,   620,   560,   320,   600,   320,   600,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   360,   660,   660,   120,   660,   660,   600,
   660,   240,   540,   400,   220,   220,   740,   740,
    -1,   500,   440,   380,   340,    -1,   800,   460,
   320,   540,   540,   400,  1000,  1360,    -1,   660,
    -1,   400,   400,   500,   480,   460,   500,   320,
   500,    -1,   340,   360,    -1,   440,   320,   500,
  1000,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,  1140,    -1,   400,    -1,    -1,    -1,    -1,
   640,   800,  1220,   400,    -1,    -1,    -1,    -1,
    -1,   880,    -1,    -1,    -1,   360,    -1,    -1,
   340,   620,   940,   660,    -1,    -1,    -1,    -1 }},
{"Bookman-DemiItalic", 0, 1360, 303, 198, 681, 515, 732, -213, {
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
   340,   320,   380,   680,   680,   880,   980,   320,
   260,   260,   460,   600,   340,   280,   340,   360,
   680,   680,   680,   680,   680,   680,   680,   680,
   680,   680,   340,   340,   620,   600,   620,   620,
   780,   720,   720,   700,   760,   720,   660,   760,
   800,   380,   620,   780,   640,   860,   740,   760,
   640,   760,   740,   700,   700,   740,   660,  1000,
   740,   660,   680,   260,   580,   260,   620,   500,
   320,   680,   600,   560,   680,   560,   420,   620,
   700,   380,   320,   700,   380,   960,   680,   600,
   660,   620,   500,   540,   440,   680,   540,   860,
   620,   600,   560,   300,   620,   300,   620,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   320,   680,   680,   120,   680,   680,   620,
   680,   180,   520,   380,   220,   220,   820,   820,
    -1,   500,   420,   420,   340,    -1,   680,   360,
   300,   520,   520,   380,  1000,  1360,    -1,   620,
    -1,   380,   340,   480,   480,   480,   460,   380,
   520,    -1,   360,   360,    -1,   560,   320,   480,
  1000,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,  1140,    -1,   440,    -1,    -1,    -1,    -1,
   640,   760,  1180,   440,    -1,    -1,    -1,    -1,
    -1,   880,    -1,    -1,    -1,   380,    -1,    -1,
   380,   600,   920,   660,    -1,    -1,    -1,    -1 }},
{"Bookman-Light", 0, 1280, 264, 258, 681, 484, 717, -228, {
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
   320,   300,   380,   620,   620,   900,   800,   220,
   300,   300,   440,   600,   320,   400,   320,   600,
   620,   620,   620,   620,   620,   620,   620,   620,
   620,   620,   320,   320,   600,   600,   600,   540,
   820,   680,   740,   740,   800,   720,   640,   800,
   800,   340,   600,   720,   600,   920,   740,   800,
   620,   820,   720,   660,   620,   780,   700,   960,
   720,   640,   640,   300,   600,   300,   600,   500,
   220,   580,   620,   520,   620,   520,   320,   540,
   660,   300,   300,   620,   300,   940,   660,   560,
   620,   580,   440,   520,   380,   680,   520,   780,
   560,   540,   480,   280,   600,   280,   600,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   300,   620,   620,   140,   620,   620,   520,
   620,   220,   400,   360,   240,   240,   620,   620,
    -1,   500,   540,   540,   320,    -1,   600,   460,
   220,   400,   400,   360,  1000,  1280,    -1,   540,
    -1,   340,   340,   420,   440,   440,   460,   260,
   420,    -1,   320,   320,    -1,   380,   320,   420,
  1000,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,  1260,    -1,   420,    -1,    -1,    -1,    -1,
   600,   800,  1240,   420,    -1,    -1,    -1,    -1,
    -1,   860,    -1,    -1,    -1,   300,    -1,    -1,
   320,   560,   900,   660,    -1,    -1,    -1,    -1 }},
{"Bookman-LightItalic", 0, 1220, 294, 228, 681, 494, 717, -212, {
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
   300,   320,   360,   620,   620,   800,   820,   280,
   280,   280,   440,   600,   300,   320,   300,   600,
   620,   620,   620,   620,   620,   620,   620,   620,
   620,   620,   300,   300,   600,   600,   600,   540,
   780,   700,   720,   720,   740,   680,   620,   760,
   800,   320,   560,   720,   580,   860,   720,   760,
   600,   780,   700,   640,   600,   720,   680,   960,
   700,   660,   580,   260,   600,   260,   600,   500,
   280,   620,   600,   480,   640,   540,   340,   560,
   620,   280,   280,   600,   280,   880,   620,   540,
   600,   560,   400,   540,   340,   620,   540,   880,
   540,   600,   520,   360,   600,   380,   600,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   320,   620,   620,    20,   620,   620,   620,
   620,   200,   440,   300,   180,   180,   640,   660,
    -1,   500,   620,   620,   300,    -1,   620,   460,
   320,   480,   440,   300,  1000,  1180,    -1,   540,
    -1,   340,   320,   440,   440,   440,   440,   260,
   420,    -1,   300,   320,    -1,   340,   260,   440,
  1000,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,  1220,    -1,   440,    -1,    -1,    -1,    -1,
   580,   760,  1180,   400,    -1,    -1,    -1,    -1,
    -1,   880,    -1,    -1,    -1,   280,    -1,    -1,
   340,   540,   900,   620,    -1,    -1,    -1,    -1 }},
{"Courier-Bold", 1, 600, 255, 255, 562, 439, 626, -142, {
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
   600,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,   600,
    -1,   600,   600,   600,   600,    -1,   600,   600,
   600,   600,   600,   600,   600,   600,    -1,   600,
    -1,   600,   600,   600,   600,   600,   600,   600,
   600,    -1,   600,   600,    -1,   600,   600,   600,
   600,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   600,    -1,   600,    -1,    -1,    -1,    -1,
   600,   600,   600,   600,    -1,    -1,    -1,    -1,
    -1,   600,    -1,    -1,    -1,   600,    -1,    -1,
   600,   600,   600,   600,    -1,    -1,    -1,    -1 }},
{"Courier-BoldOblique", 1, 600, 346, 250, 562, 439, 626, -142, {
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
   600,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,   600,
    -1,   600,   600,   600,   600,    -1,   600,   600,
   600,   600,   600,   600,   600,   600,    -1,   600,
    -1,   600,   600,   600,   600,   600,   600,   600,
   600,    -1,   600,   600,    -1,   600,   600,   600,
   600,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   600,    -1,   600,    -1,    -1,    -1,    -1,
   600,   600,   600,   600,    -1,    -1,    -1,    -1,
    -1,   600,    -1,    -1,    -1,   600,    -1,    -1,
   600,   600,   600,   600,    -1,    -1,    -1,    -1 }},
{"Courier", 1, 600, 275, 274, 562, 426, 629, -157, {
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
   600,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,   600,
    -1,   600,   600,   600,   600,    -1,   600,   600,
   600,   600,   600,   600,   600,   600,    -1,   600,
    -1,   600,   600,   600,   600,   600,   600,   600,
   600,    -1,   600,   600,    -1,   600,   600,   600,
   600,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   600,    -1,   600,    -1,    -1,    -1,    -1,
   600,   600,   600,   600,    -1,    -1,    -1,    -1,
    -1,   600,    -1,    -1,    -1,   600,    -1,    -1,
   600,   600,   600,   600,    -1,    -1,    -1,    -1 }},
{"Courier-Oblique", 1, 600, 360, 256, 562, 426, 629, -157, {
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
   600,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   600,   600,   600,   600,   600,   600,   600,
   600,   600,   600,   600,   600,   600,   600,   600,
    -1,   600,   600,   600,   600,    -1,   600,   600,
   600,   600,   600,   600,   600,   600,    -1,   600,
    -1,   600,   600,   600,   600,   600,   600,   600,
   600,    -1,   600,   600,    -1,   600,   600,   600,
   600,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   600,    -1,   600,    -1,    -1,    -1,    -1,
   600,   600,   600,   600,    -1,    -1,    -1,    -1,
    -1,   600,    -1,    -1,    -1,   600,    -1,    -1,
   600,   600,   600,   600,    -1,    -1,    -1,    -1 }},
{"Helvetica-Bold", 0, 1000, 118, 178, 718, 532, 718, -207, {
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
   278,   333,   474,   556,   556,   889,   722,   278,
   333,   333,   389,   584,   278,   333,   278,   278,
   556,   556,   556,   556,   556,   556,   556,   556,
   556,   556,   333,   333,   584,   584,   584,   611,
   975,   722,   722,   722,   722,   667,   611,   778,
   722,   278,   556,   722,   611,   833,   722,   778,
   667,   778,   722,   667,   611,   722,   667,   944,
   667,   667,   611,   333,   278,   333,   584,   556,
   278,   556,   611,   556,   611,   556,   333,   611,
   611,   278,   278,   556,   278,   889,   611,   611,
   611,   611,   389,   556,   333,   611,   556,   778,
   556,   556,   500,   389,   280,   389,   584,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   333,   556,   556,   167,   556,   556,   556,
   556,   238,   500,   556,   333,   333,   611,   611,
    -1,   556,   556,   556,   278,    -1,   556,   350,
   278,   500,   500,   556,  1000,  1000,    -1,   611,
    -1,   333,   333,   333,   333,   333,   333,   333,
   333,    -1,   333,   333,    -1,   333,   333,   333,
  1000,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,  1000,    -1,   370,    -1,    -1,    -1,    -1,
   611,   778,  1000,   365,    -1,    -1,    -1,    -1,
    -1,   889,    -1,    -1,    -1,   278,    -1,    -1,
   278,   611,   944,   611,    -1,    -1,    -1,    -1 }},
{"Helvetica-Narrow-Bold", 0, 820, 97, 146, 718, 532, 718, -207, {
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
   228,   273,   389,   456,   456,   729,   592,   228,
   273,   273,   319,   479,   228,   273,   228,   228,
   456,   456,   456,   456,   456,   456,   456,   456,
   456,   456,   273,   273,   479,   479,   479,   501,
   800,   592,   592,   592,   592,   547,   501,   638,
   592,   228,   456,   592,   501,   683,   592,   638,
   547,   638,   592,   547,   501,   592,   547,   774,
   547,   547,   501,   273,   228,   273,   479,   456,
   228,   456,   501,   456,   501,   456,   273,   501,
   501,   228,   228,   456,   228,   729,   501,   501,
   501,   501,   319,   456,   273,   501,   456,   638,
   456,   456,   410,   319,   230,   319,   479,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   273,   456,   456,   137,   456,   456,   456,
   456,   195,   410,   456,   273,   273,   501,   501,
    -1,   456,   456,   456,   228,    -1,   456,   287,
   228,   410,   410,   456,   820,   820,    -1,   501,
    -1,   273,   273,   273,   273,   273,   273,   273,
   273,    -1,   273,   273,    -1,   273,   273,   273,
   820,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   820,    -1,   303,    -1,    -1,    -1,    -1,
   501,   638,   820,   299,    -1,    -1,    -1,    -1,
    -1,   729,    -1,    -1,    -1,   228,    -1,    -1,
   228,   501,   774,   501,    -1,    -1,    -1,    -1 }},
{"Helvetica-BoldOblique", 0, 1000, 236, 113, 718, 532, 718, -207, {
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
   278,   333,   474,   556,   556,   889,   722,   278,
   333,   333,   389,   584,   278,   333,   278,   278,
   556,   556,   556,   556,   556,   556,   556,   556,
   556,   556,   333,   333,   584,   584,   584,   611,
   975,   722,   722,   722,   722,   667,   611,   778,
   722,   278,   556,   722,   611,   833,   722,   778,
   667,   778,   722,   667,   611,   722,   667,   944,
   667,   667,   611,   333,   278,   333,   584,   556,
   278,   556,   611,   556,   611,   556,   333,   611,
   611,   278,   278,   556,   278,   889,   611,   611,
   611,   611,   389,   556,   333,   611,   556,   778,
   556,   556,   500,   389,   280,   389,   584,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   333,   556,   556,   167,   556,   556,   556,
   556,   238,   500,   556,   333,   333,   611,   611,
    -1,   556,   556,   556,   278,    -1,   556,   350,
   278,   500,   500,   556,  1000,  1000,    -1,   611,
    -1,   333,   333,   333,   333,   333,   333,   333,
   333,    -1,   333,   333,    -1,   333,   333,   333,
  1000,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,  1000,    -1,   370,    -1,    -1,    -1,    -1,
   611,   778,  1000,   365,    -1,    -1,    -1,    -1,
    -1,   889,    -1,    -1,    -1,   278,    -1,    -1,
   278,   611,   944,   611,    -1,    -1,    -1,    -1 }},
{"Helvetica-Narrow-BoldOblique", 0, 820, 194, 93, 718, 532, 718, -207, {
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
   228,   273,   389,   456,   456,   729,   592,   228,
   273,   273,   319,   479,   228,   273,   228,   228,
   456,   456,   456,   456,   456,   456,   456,   456,
   456,   456,   273,   273,   479,   479,   479,   501,
   800,   592,   592,   592,   592,   547,   501,   638,
   592,   228,   456,   592,   501,   683,   592,   638,
   547,   638,   592,   547,   501,   592,   547,   774,
   547,   547,   501,   273,   228,   273,   479,   456,
   228,   456,   501,   456,   501,   456,   273,   501,
   501,   228,   228,   456,   228,   729,   501,   501,
   501,   501,   319,   456,   273,   501,   456,   638,
   456,   456,   410,   319,   230,   319,   479,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   273,   456,   456,   137,   456,   456,   456,
   456,   195,   410,   456,   273,   273,   501,   501,
    -1,   456,   456,   456,   228,    -1,   456,   287,
   228,   410,   410,   456,   820,   820,    -1,   501,
    -1,   273,   273,   273,   273,   273,   273,   273,
   273,    -1,   273,   273,    -1,   273,   273,   273,
   820,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   820,    -1,   303,    -1,    -1,    -1,    -1,
   501,   638,   820,   299,    -1,    -1,    -1,    -1,
    -1,   729,    -1,    -1,    -1,   228,    -1,    -1,
   228,   501,   774,   501,    -1,    -1,    -1,    -1 }},
{"Helvetica", 0, 1015, 147, 197, 718, 523, 718, -207, {
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
   278,   278,   355,   556,   556,   889,   667,   222,
   333,   333,   389,   584,   278,   333,   278,   278,
   556,   556,   556,   556,   556,   556,   556,   556,
   556,   556,   278,   278,   584,   584,   584,   556,
  1015,   667,   667,   722,   722,   667,   611,   778,
   722,   278,   500,   667,   556,   833,   722,   778,
   667,   778,   722,   667,   611,   722,   667,   944,
   667,   667,   611,   278,   278,   278,   469,   556,
   222,   556,   556,   500,   556,   556,   278,   556,
   556,   222,   222,   500,   222,   833,   556,   556,
   556,   556,   333,   500,   278,   556,   500,   722,
   500,   500,   500,   334,   260,   334,   584,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   333,   556,   556,   167,   556,   556,   556,
   556,   191,   333,   556,   333,   333,   500,   500,
    -1,   556,   556,   556,   278,    -1,   537,   350,
   222,   333,   333,   556,  1000,  1000,    -1,   611,
    -1,   333,   333,   333,   333,   333,   333,   333,
   333,    -1,   333,   333,    -1,   333,   333,   333,
  1000,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,  1000,    -1,   370,    -1,    -1,    -1,    -1,
   556,   778,  1000,   365,    -1,    -1,    -1,    -1,
    -1,   889,    -1,    -1,    -1,   278,    -1,    -1,
   222,   611,   944,   611,    -1,    -1,    -1,    -1 }},
{"Helvetica-Narrow", 0, 832, 121, 162, 718, 523, 718, -207, {
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
   228,   228,   291,   456,   456,   729,   547,   182,
   273,   273,   319,   479,   228,   273,   228,   228,
   456,   456,   456,   456,   456,   456,   456,   456,
   456,   456,   228,   228,   479,   479,   479,   456,
   832,   547,   547,   592,   592,   547,   501,   638,
   592,   228,   410,   547,   456,   683,   592,   638,
   547,   638,   592,   547,   501,   592,   547,   774,
   547,   547,   501,   228,   228,   228,   385,   456,
   182,   456,   456,   410,   456,   456,   228,   456,
   456,   182,   182,   410,   182,   683,   456,   456,
   456,   456,   273,   410,   228,   456,   410,   592,
   410,   410,   410,   274,   213,   274,   479,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   273,   456,   456,   137,   456,   456,   456,
   456,   157,   273,   456,   273,   273,   410,   410,
    -1,   456,   456,   456,   228,    -1,   440,   287,
   182,   273,   273,   456,   820,   820,    -1,   501,
    -1,   273,   273,   273,   273,   273,   273,   273,
   273,    -1,   273,   273,    -1,   273,   273,   273,
   820,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   820,    -1,   303,    -1,    -1,    -1,    -1,
   456,   638,   820,   299,    -1,    -1,    -1,    -1,
    -1,   729,    -1,    -1,    -1,   228,    -1,    -1,
   182,   501,   774,   501,    -1,    -1,    -1,    -1 }},
{"Helvetica-Oblique", 0, 1015, 249, 101, 718, 523, 718, -207, {
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
   278,   278,   355,   556,   556,   889,   667,   222,
   333,   333,   389,   584,   278,   333,   278,   278,
   556,   556,   556,   556,   556,   556,   556,   556,
   556,   556,   278,   278,   584,   584,   584,   556,
  1015,   667,   667,   722,   722,   667,   611,   778,
   722,   278,   500,   667,   556,   833,   722,   778,
   667,   778,   722,   667,   611,   722,   667,   944,
   667,   667,   611,   278,   278,   278,   469,   556,
   222,   556,   556,   500,   556,   556,   278,   556,
   556,   222,   222,   500,   222,   833,   556,   556,
   556,   556,   333,   500,   278,   556,   500,   722,
   500,   500,   500,   334,   260,   334,   584,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   333,   556,   556,   167,   556,   556,   556,
   556,   191,   333,   556,   333,   333,   500,   500,
    -1,   556,   556,   556,   278,    -1,   537,   350,
   222,   333,   333,   556,  1000,  1000,    -1,   611,
    -1,   333,   333,   333,   333,   333,   333,   333,
   333,    -1,   333,   333,    -1,   333,   333,   333,
  1000,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,  1000,    -1,   370,    -1,    -1,    -1,    -1,
   556,   778,  1000,   365,    -1,    -1,    -1,    -1,
    -1,   889,    -1,    -1,    -1,   278,    -1,    -1,
   222,   611,   944,   611,    -1,    -1,    -1,    -1 }},
{"Helvetica-Narrow-Oblique", 0, 832, 204, 82, 718, 523, 718, -207, {
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
   228,   228,   291,   456,   456,   729,   547,   182,
   273,   273,   319,   479,   228,   273,   228,   228,
   456,   456,   456,   456,   456,   456,   456,   456,
   456,   456,   228,   228,   479,   479,   479,   456,
   832,   547,   547,   592,   592,   547,   501,   638,
   592,   228,   410,   547,   456,   683,   592,   638,
   547,   638,   592,   547,   501,   592,   547,   774,
   547,   547,   501,   228,   228,   228,   385,   456,
   182,   456,   456,   410,   456,   456,   228,   456,
   456,   182,   182,   410,   182,   683,   456,   456,
   456,   456,   273,   410,   228,   456,   410,   592,
   410,   410,   410,   274,   213,   274,   479,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   273,   456,   456,   137,   456,   456,   456,
   456,   157,   273,   456,   273,   273,   410,   410,
    -1,   456,   456,   456,   228,    -1,   440,   287,
   182,   273,   273,   456,   820,   820,    -1,   501,
    -1,   273,   273,   273,   273,   273,   273,   273,
   273,    -1,   273,   273,    -1,   273,   273,   273,
   820,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   820,    -1,   303,    -1,    -1,    -1,    -1,
   456,   638,   820,   299,    -1,    -1,    -1,    -1,
    -1,   729,    -1,    -1,    -1,   228,    -1,    -1,
   182,   501,   774,   501,    -1,    -1,    -1,    -1 }},
{"NewCenturySchlbk-Bold", 0, 1000, 249, 249, 722, 475, 737, -205, {
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
   287,   296,   333,   574,   574,   833,   852,   241,
   389,   389,   500,   606,   278,   333,   278,   278,
   574,   574,   574,   574,   574,   574,   574,   574,
   574,   574,   278,   278,   606,   606,   606,   500,
   747,   759,   778,   778,   833,   759,   722,   833,
   870,   444,   648,   815,   722,   981,   833,   833,
   759,   833,   815,   667,   722,   833,   759,   981,
   722,   722,   667,   389,   606,   389,   606,   500,
   241,   611,   648,   556,   667,   574,   389,   611,
   685,   370,   352,   667,   352,   963,   685,   611,
   667,   648,   519,   500,   426,   685,   611,   889,
   611,   611,   537,   389,   606,   389,   606,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   296,   574,   574,   167,   574,   574,   500,
   574,   241,   481,   500,   333,   333,   685,   685,
    -1,   500,   500,   500,   278,    -1,   747,   606,
   241,   481,   481,   500,  1000,  1000,    -1,   500,
    -1,   333,   333,   333,   333,   333,   333,   333,
   333,    -1,   333,   333,    -1,   333,   333,   333,
  1000,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   981,    -1,   367,    -1,    -1,    -1,    -1,
   722,   833,  1000,   367,    -1,    -1,    -1,    -1,
    -1,   870,    -1,    -1,    -1,   370,    -1,    -1,
   352,   611,   907,   611,    -1,    -1,    -1,    -1 }},
{"NewCenturySchlbk-BoldItalic", 0, 1167, 249, 249, 722, 477, 737, -205, {
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
   287,   333,   400,   574,   574,   889,   889,   259,
   407,   407,   500,   606,   287,   333,   287,   278,
   574,   574,   574,   574,   574,   574,   574,   574,
   574,   574,   287,   287,   606,   606,   606,   481,
   747,   741,   759,   759,   833,   741,   704,   815,
   870,   444,   667,   778,   704,   944,   852,   833,
   741,   833,   796,   685,   722,   833,   741,   944,
   741,   704,   704,   407,   606,   407,   606,   500,
   259,   667,   611,   537,   667,   519,   389,   611,
   685,   389,   370,   648,   389,   944,   685,   574,
   648,   630,   519,   481,   407,   685,   556,   833,
   574,   519,   519,   407,   606,   407,   606,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   333,   574,   574,   167,   574,   574,   500,
   574,   287,   481,   481,   278,   278,   685,   685,
    -1,   500,   500,   500,   287,    -1,   650,   606,
   259,   481,   481,   481,  1000,  1167,    -1,   481,
    -1,   333,   333,   333,   333,   333,   333,   333,
   333,    -1,   333,   333,    -1,   333,   333,   333,
  1000,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   889,    -1,   412,    -1,    -1,    -1,    -1,
   704,   833,   963,   356,    -1,    -1,    -1,    -1,
    -1,   815,    -1,    -1,    -1,   389,    -1,    -1,
   389,   574,   852,   574,    -1,    -1,    -1,    -1 }},
{"NewCenturySchlbk-Roman", 0, 1000, 267, 267, 722, 464, 737, -205, {
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
   278,   296,   389,   556,   556,   833,   815,   204,
   333,   333,   500,   606,   278,   333,   278,   278,
   556,   556,   556,   556,   556,   556,   556,   556,
   556,   556,   278,   278,   606,   606,   606,   444,
   737,   722,   722,   722,   778,   722,   667,   778,
   833,   407,   556,   778,   667,   944,   815,   778,
   667,   778,   722,   630,   667,   815,   722,   981,
   704,   704,   611,   333,   606,   333,   606,   500,
   204,   556,   556,   444,   574,   500,   333,   537,
   611,   315,   296,   593,   315,   889,   611,   500,
   574,   556,   444,   463,   389,   611,   537,   778,
   537,   537,   481,   333,   606,   333,   606,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   296,   556,   556,   167,   556,   556,   500,
   556,   204,   389,   426,   259,   259,   611,   611,
    -1,   556,   500,   500,   278,    -1,   606,   606,
   204,   389,   389,   426,  1000,  1000,    -1,   444,
    -1,   333,   333,   333,   333,   333,   333,   333,
   333,    -1,   333,   333,    -1,   333,   333,   333,
  1000,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,  1000,    -1,   334,    -1,    -1,    -1,    -1,
   667,   778,  1000,   300,    -1,    -1,    -1,    -1,
    -1,   796,    -1,    -1,    -1,   315,    -1,    -1,
   315,   500,   833,   574,    -1,    -1,    -1,    -1 }},
{"NewCenturySchlbk-Italic", 0, 1000, 267, 267, 722, 466, 737, -205, {
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
   278,   333,   400,   556,   556,   833,   852,   204,
   333,   333,   500,   606,   278,   333,   278,   606,
   556,   556,   556,   556,   556,   556,   556,   556,
   556,   556,   278,   278,   606,   606,   606,   444,
   747,   704,   722,   722,   778,   722,   667,   778,
   833,   407,   611,   741,   667,   944,   815,   778,
   667,   778,   741,   667,   685,   815,   704,   926,
   704,   685,   667,   333,   606,   333,   606,   500,
   204,   574,   556,   444,   611,   444,   333,   537,
   611,   333,   315,   556,   333,   889,   611,   500,
   574,   556,   444,   444,   352,   611,   519,   778,
   500,   500,   463,   333,   606,   333,   606,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   333,   556,   556,   167,   556,   556,   500,
   556,   278,   389,   426,   333,   333,   611,   611,
    -1,   500,   500,   500,   278,    -1,   650,   606,
   204,   389,   389,   426,  1000,  1000,    -1,   444,
    -1,   333,   333,   333,   333,   333,   333,   333,
   333,    -1,   333,   333,    -1,   333,   333,   333,
  1000,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   870,    -1,   422,    -1,    -1,    -1,    -1,
   667,   778,   981,   372,    -1,    -1,    -1,    -1,
    -1,   722,    -1,    -1,    -1,   333,    -1,    -1,
   333,   500,   778,   556,    -1,    -1,    -1,    -1 }},
{"Palatino-Bold", 0, 1000, 260, 260, 681, 471, 720, -258, {
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
   250,   278,   402,   500,   500,   889,   833,   278,
   333,   333,   444,   606,   250,   333,   250,   296,
   500,   500,   500,   500,   500,   500,   500,   500,
   500,   500,   250,   250,   606,   606,   606,   444,
   747,   778,   667,   722,   833,   611,   556,   833,
   833,   389,   389,   778,   611,  1000,   833,   833,
   611,   833,   722,   611,   667,   778,   778,  1000,
   667,   667,   667,   333,   606,   333,   606,   500,
   278,   500,   611,   444,   611,   500,   389,   556,
   611,   333,   333,   611,   333,   889,   611,   556,
   611,   611,   389,   444,   333,   611,   556,   833,
   500,   556,   500,   310,   606,   310,   606,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   278,   500,   500,   167,   500,   500,   500,
   500,   227,   500,   500,   389,   389,   611,   611,
    -1,   500,   500,   500,   250,    -1,   641,   606,
   333,   500,   500,   500,  1000,  1000,    -1,   444,
    -1,   333,   333,   333,   333,   333,   333,   333,
   333,    -1,   333,   333,    -1,   333,   333,   333,
  1000,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,  1000,    -1,   438,    -1,    -1,    -1,    -1,
   611,   833,  1000,   488,    -1,    -1,    -1,    -1,
    -1,   778,    -1,    -1,    -1,   333,    -1,    -1,
   333,   556,   833,   611,    -1,    -1,    -1,    -1 }},
{"Palatino-BoldItalic", 0, 1000, 277, 259, 681, 469, 726, -271, {
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
   250,   333,   500,   500,   500,   889,   833,   278,
   333,   333,   444,   606,   250,   389,   250,   315,
   500,   500,   500,   500,   500,   500,   500,   500,
   500,   500,   250,   250,   606,   606,   606,   444,
   833,   722,   667,   685,   778,   611,   556,   778,
   778,   389,   389,   722,   611,   944,   778,   833,
   667,   833,   722,   556,   611,   778,   667,  1000,
   722,   611,   667,   333,   606,   333,   606,   500,
   278,   556,   537,   444,   556,   444,   333,   500,
   556,   333,   333,   556,   333,   833,   556,   556,
   556,   537,   389,   444,   389,   556,   556,   833,
   500,   556,   500,   333,   606,   333,   606,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   333,   500,   500,   167,   500,   500,   556,
   500,   250,   500,   500,   333,   333,   611,   611,
    -1,   500,   556,   556,   250,    -1,   556,   606,
   250,   500,   500,   500,  1000,  1000,    -1,   444,
    -1,   333,   333,   333,   333,   333,   333,   333,
   333,    -1,   556,   333,    -1,   333,   333,   333,
  1000,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   944,    -1,   333,    -1,    -1,    -1,    -1,
   611,   833,   944,   333,    -1,    -1,    -1,    -1,
    -1,   738,    -1,    -1,    -1,   333,    -1,    -1,
   333,   556,   778,   556,    -1,    -1,    -1,    -1 }},
{"Palatino-Roman", 0, 1144, 275, 275, 692, 469, 726, -281, {
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
   250,   278,   371,   500,   500,   840,   778,   278,
   333,   333,   389,   606,   250,   333,   250,   606,
   500,   500,   500,   500,   500,   500,   500,   500,
   500,   500,   250,   250,   606,   606,   606,   444,
   747,   778,   611,   709,   774,   611,   556,   763,
   832,   337,   333,   726,   611,   946,   831,   786,
   604,   786,   668,   525,   613,   778,   722,  1000,
   667,   667,   667,   333,   606,   333,   606,   500,
   278,   500,   553,   444,   611,   479,   333,   556,
   582,   291,   234,   556,   291,   883,   582,   546,
   601,   560,   395,   424,   326,   603,   565,   834,
   516,   556,   500,   333,   606,   333,   606,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   278,   500,   500,   167,   500,   500,   500,
   500,   208,   500,   500,   331,   331,   605,   608,
    -1,   500,   500,   500,   250,    -1,   628,   606,
   278,   500,   500,   500,  1000,  1144,    -1,   444,
    -1,   333,   333,   333,   333,   333,   333,   250,
   333,    -1,   333,   333,    -1,   380,   313,   333,
  1000,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   944,    -1,   333,    -1,    -1,    -1,    -1,
   611,   833,   998,   333,    -1,    -1,    -1,    -1,
    -1,   758,    -1,    -1,    -1,   287,    -1,    -1,
   291,   556,   827,   556,    -1,    -1,    -1,    -1 }},
{"Palatino-Italic", 0, 1028, 275, 275, 692, 482, 733, -276, {
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
   250,   333,   500,   500,   500,   889,   778,   278,
   333,   333,   389,   606,   250,   333,   250,   296,
   500,   500,   500,   500,   500,   500,   500,   500,
   500,   500,   250,   250,   606,   606,   606,   500,
   747,   722,   611,   667,   778,   611,   556,   722,
   778,   333,   333,   667,   556,   944,   778,   778,
   611,   778,   667,   556,   611,   778,   722,   944,
   722,   667,   667,   333,   606,   333,   606,   500,
   278,   444,   463,   407,   500,   389,   278,   500,
   500,   278,   278,   444,   278,   778,   556,   444,
   500,   463,   389,   389,   333,   556,   500,   722,
   500,   500,   444,   333,   606,   333,   606,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   333,   500,   500,   167,   500,   500,   500,
   500,   333,   500,   500,   333,   333,   528,   545,
    -1,   500,   500,   500,   250,    -1,   500,   500,
   278,   500,   500,   500,  1000,  1000,    -1,   500,
    -1,   333,   333,   333,   333,   333,   333,   333,
   333,    -1,   333,   333,    -1,   333,   333,   333,
  1000,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   941,    -1,   333,    -1,    -1,    -1,    -1,
   556,   778,  1028,   333,    -1,    -1,    -1,    -1,
    -1,   638,    -1,    -1,    -1,   278,    -1,    -1,
   278,   444,   669,   500,    -1,    -1,    -1,    -1 }},
{"Symbol", 0, 1042, 480, 329, -1, -1, -1, -1, {
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
   250,   333,   713,   500,   549,   833,   778,   439,
   333,   333,   500,   549,   250,   549,   250,   278,
   500,   500,   500,   500,   500,   500,   500,   500,
   500,   500,   278,   278,   549,   549,   549,   444,
   549,   722,   667,   722,   612,   611,   763,   603,
   722,   333,   631,   722,   686,   889,   722,   722,
   768,   741,   556,   592,   611,   690,   439,   768,
   645,   795,   611,   333,   863,   333,   658,   500,
   500,   631,   549,   549,   494,   439,   521,   411,
   603,   329,   603,   549,   549,   576,   521,   549,
   549,   521,   549,   603,   439,   576,   713,   686,
   493,   686,   494,   480,   200,   480,   549,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   620,   247,   549,   167,   713,   500,   753,
   753,   753,   753,  1042,   987,   603,   987,   603,
   400,   549,   411,   549,   549,   713,   494,   460,
   549,   549,   549,   549,  1000,   603,  1000,   658,
   823,   686,   795,   987,   768,   768,   823,   768,
   768,   713,   713,   713,   713,   713,   713,   713,
   768,   713,   790,   790,   890,   823,   549,   250,
   713,   603,   603,  1042,   987,   603,   987,   603,
   494,   329,   790,   790,   786,   713,   384,   384,
   384,   384,   384,   384,   494,   494,   494,   494,
    -1,   329,   274,   686,   686,   686,   384,   384,
   384,   384,   384,   384,   494,   494,   494,    -1 }},
{"Times-Bold", 0, 1000, 124, 123, 676, 461, 676, -205, {
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
   250,   333,   555,   500,   500,  1000,   833,   333,
   333,   333,   500,   570,   250,   333,   250,   278,
   500,   500,   500,   500,   500,   500,   500,   500,
   500,   500,   333,   333,   570,   570,   570,   500,
   930,   722,   667,   722,   722,   667,   611,   778,
   778,   389,   500,   778,   667,   944,   722,   778,
   611,   778,   722,   556,   667,   722,   722,  1000,
   722,   722,   667,   333,   278,   333,   581,   500,
   333,   500,   556,   444,   556,   444,   333,   500,
   556,   278,   333,   556,   278,   833,   556,   500,
   556,   556,   444,   389,   333,   556,   500,   722,
   500,   500,   444,   394,   220,   394,   520,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   333,   500,   500,   167,   500,   500,   500,
   500,   278,   500,   500,   333,   333,   556,   556,
    -1,   500,   500,   500,   250,    -1,   540,   350,
   333,   500,   500,   500,  1000,  1000,    -1,   500,
    -1,   333,   333,   333,   333,   333,   333,   333,
   333,    -1,   333,   333,    -1,   333,   333,   333,
  1000,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,  1000,    -1,   300,    -1,    -1,    -1,    -1,
   667,   778,  1000,   330,    -1,    -1,    -1,    -1,
    -1,   722,    -1,    -1,    -1,   278,    -1,    -1,
   278,   500,   722,   556,    -1,    -1,    -1,    -1 }},
{"Times-BoldItalic", 0, 1000, 163, 177, 669, 462, 699, -205, {
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
   250,   389,   555,   500,   500,   833,   778,   333,
   333,   333,   500,   570,   250,   333,   250,   278,
   500,   500,   500,   500,   500,   500,   500,   500,
   500,   500,   333,   333,   570,   570,   570,   500,
   832,   667,   667,   667,   722,   667,   667,   722,
   778,   389,   500,   667,   611,   889,   722,   722,
   611,   722,   667,   556,   611,   722,   667,   889,
   667,   611,   611,   333,   278,   333,   570,   500,
   333,   500,   500,   444,   500,   444,   333,   500,
   556,   278,   278,   500,   278,   778,   556,   500,
   500,   500,   389,   389,   278,   556,   444,   667,
   500,   444,   389,   348,   220,   348,   570,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   389,   500,   500,   167,   500,   500,   500,
   500,   278,   500,   500,   333,   333,   556,   556,
    -1,   500,   500,   500,   250,    -1,   500,   350,
   333,   500,   500,   500,  1000,  1000,    -1,   500,
    -1,   333,   333,   333,   333,   333,   333,   333,
   333,    -1,   333,   333,    -1,   333,   333,   333,
  1000,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   944,    -1,   266,    -1,    -1,    -1,    -1,
   611,   722,   944,   300,    -1,    -1,    -1,    -1,
    -1,   722,    -1,    -1,    -1,   278,    -1,    -1,
   278,   500,   722,   500,    -1,    -1,    -1,    -1 }},
{"Times-Roman", 0, 1000, 130, 130, 662, 450, 683, -217, {
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
   250,   333,   408,   500,   500,   833,   778,   333,
   333,   333,   500,   564,   250,   333,   250,   278,
   500,   500,   500,   500,   500,   500,   500,   500,
   500,   500,   278,   278,   564,   564,   564,   444,
   921,   722,   667,   667,   722,   611,   556,   722,
   722,   333,   389,   722,   611,   889,   722,   722,
   556,   722,   667,   556,   611,   722,   722,   944,
   722,   722,   611,   333,   278,   333,   469,   500,
   333,   444,   500,   444,   500,   444,   333,   500,
   500,   278,   278,   500,   278,   778,   500,   500,
   500,   500,   333,   389,   278,   500,   500,   722,
   500,   500,   444,   480,   200,   480,   541,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   333,   500,   500,   167,   500,   500,   500,
   500,   180,   444,   500,   333,   333,   556,   556,
    -1,   500,   500,   500,   250,    -1,   453,   350,
   333,   444,   444,   500,  1000,  1000,    -1,   444,
    -1,   333,   333,   333,   333,   333,   333,   333,
   333,    -1,   333,   333,    -1,   333,   333,   333,
  1000,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   889,    -1,   276,    -1,    -1,    -1,    -1,
   611,   722,   889,   310,    -1,    -1,    -1,    -1,
    -1,   667,    -1,    -1,    -1,   278,    -1,    -1,
   278,   500,   722,   500,    -1,    -1,    -1,    -1 }},
{"Times-Italic", 0, 1000, 207, 151, 653, 441, 683, -205, {
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
   250,   333,   420,   500,   500,   833,   778,   333,
   333,   333,   500,   675,   250,   333,   250,   278,
   500,   500,   500,   500,   500,   500,   500,   500,
   500,   500,   333,   333,   675,   675,   675,   500,
   920,   611,   611,   667,   722,   611,   611,   722,
   722,   333,   444,   667,   556,   833,   667,   722,
   611,   722,   611,   500,   556,   722,   611,   833,
   611,   556,   556,   389,   278,   389,   422,   500,
   333,   500,   500,   444,   500,   444,   278,   500,
   500,   278,   278,   444,   278,   722,   500,   500,
   500,   500,   389,   389,   278,   500,   444,   667,
   444,   444,   389,   400,   275,   400,   541,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   389,   500,   500,   167,   500,   500,   500,
   500,   214,   556,   500,   333,   333,   500,   500,
    -1,   500,   500,   500,   250,    -1,   523,   350,
   333,   556,   556,   500,   889,  1000,    -1,   500,
    -1,   333,   333,   333,   333,   333,   333,   333,
   333,    -1,   333,   333,    -1,   333,   333,   333,
   889,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   889,    -1,   276,    -1,    -1,    -1,    -1,
   556,   722,   944,   310,    -1,    -1,    -1,    -1,
    -1,   667,    -1,    -1,    -1,   278,    -1,    -1,
   278,   500,   667,   500,    -1,    -1,    -1,    -1 }},
{"ZapfChancery-MediumItalic", 0, 1000, 320, 142, 708, 438, 714, -314, {
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
   220,   280,   220,   440,   440,   680,   780,   240,
   260,   220,   420,   520,   220,   280,   220,   340,
   440,   440,   440,   440,   440,   440,   440,   440,
   440,   440,   260,   240,   520,   520,   520,   380,
   700,   620,   600,   520,   700,   620,   580,   620,
   680,   380,   400,   660,   580,   840,   700,   600,
   540,   600,   600,   460,   500,   740,   640,   880,
   560,   560,   620,   240,   480,   320,   520,   500,
   240,   420,   420,   340,   440,   340,   320,   400,
   440,   240,   220,   440,   240,   620,   460,   400,
   440,   400,   300,   320,   320,   460,   440,   680,
   420,   400,   440,   240,   520,   240,   520,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   280,   440,   440,    60,   440,   440,   420,
   440,   160,   340,   340,   240,   260,   520,   520,
    -1,   500,   460,   480,   220,    -1,   500,   600,
   180,   280,   360,   380,  1000,   960,    -1,   400,
    -1,   220,   300,   340,   440,   440,   440,   220,
   360,    -1,   300,   300,    -1,   400,   280,   340,
  1000,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   740,    -1,   260,    -1,    -1,    -1,    -1,
   580,   660,   820,   260,    -1,    -1,    -1,    -1,
    -1,   540,    -1,    -1,    -1,   240,    -1,    -1,
   300,   440,   560,   420,    -1,    -1,    -1,    -1 }},
{"ZapfDingbats", 0, 1016, 56, 56, -1, -1, -1, -1, {
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
   278,   974,   961,   974,   980,   719,   789,   790,
   791,   690,   960,   939,   549,   855,   911,   933,
   911,   945,   974,   755,   846,   762,   761,   571,
   677,   763,   760,   759,   754,   494,   552,   537,
   577,   692,   786,   788,   788,   790,   793,   794,
   816,   823,   789,   841,   823,   833,   816,   831,
   923,   744,   723,   749,   790,   792,   695,   776,
   768,   792,   759,   707,   708,   682,   701,   826,
   815,   789,   789,   707,   687,   696,   689,   786,
   787,   713,   791,   785,   791,   873,   761,   762,
   762,   759,   759,   892,   892,   788,   784,   438,
   138,   277,   415,   392,   392,   668,   668,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   732,   544,   544,   910,   667,   760,   760,
   776,   595,   694,   626,   788,   788,   788,   788,
   788,   788,   788,   788,   788,   788,   788,   788,
   788,   788,   788,   788,   788,   788,   788,   788,
   788,   788,   788,   788,   788,   788,   788,   788,
   788,   788,   788,   788,   788,   788,   788,   788,
   788,   788,   788,   788,   894,   838,  1016,   458,
   748,   924,   748,   918,   927,   928,   928,   834,
   873,   828,   924,   924,   917,   930,   931,   463,
   883,   836,   836,   867,   867,   696,   696,   874,
    -1,   874,   760,   946,   771,   865,   771,   888,
   967,   888,   831,   873,   927,   970,   918,    -1 }},
{(char *)0, 0,0,0,0,0,0,0,0, {0}}};


/* End of font-info.c */
