/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.filetransfer.FileTransferNegotiator;

public abstract class FileTransfer {
    private String fileName;
    private String filePath;
    private long fileSize;
    private String peer;
    private Status status = Status.INITIAL;
    private final Object statusMonitor = new Object();
    protected FileTransferNegotiator negotiator;
    protected String streamID;
    protected long amountWritten = -1L;
    private Error error;
    private Exception exception;
    private static final int BUFFER_SIZE = 8192;

    protected FileTransfer(String peer, String streamID, FileTransferNegotiator negotiator) {
        this.peer = peer;
        this.streamID = streamID;
        this.negotiator = negotiator;
    }

    protected void setFileInfo(String fileName, long fileSize) {
        this.fileName = fileName;
        this.fileSize = fileSize;
    }

    protected void setFileInfo(String path, String fileName, long fileSize) {
        this.filePath = path;
        this.fileName = fileName;
        this.fileSize = fileSize;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getPeer() {
        return this.peer;
    }

    public double getProgress() {
        if (this.amountWritten <= 0L || this.fileSize <= 0L) {
            return 0.0;
        }
        return (double)this.amountWritten / (double)this.fileSize;
    }

    public boolean isDone() {
        return this.status == Status.CANCLED || this.status == Status.ERROR || this.status == Status.COMPLETE;
    }

    public Status getStatus() {
        return this.status;
    }

    protected void setError(Error type) {
        this.error = type;
    }

    public Error getError() {
        return this.error;
    }

    public Exception getException() {
        return this.exception;
    }

    public abstract void cancel();

    protected void setException(Exception exception) {
        this.exception = exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setStatus(Status status) {
        Object object = this.statusMonitor;
        synchronized (object) {
            this.status = status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean updateStatus(Status oldStatus, Status newStatus) {
        Object object = this.statusMonitor;
        synchronized (object) {
            if (oldStatus != this.status) {
                return false;
            }
            this.status = newStatus;
            return true;
        }
    }

    protected void writeToStream(InputStream in, OutputStream out) throws XMPPException {
        byte[] b = new byte[8192];
        int count = 0;
        this.amountWritten = 0L;
        do {
            try {
                out.write(b, 0, count);
            }
            catch (IOException e) {
                throw new XMPPException("error writing to output stream", (Throwable)e);
            }
            this.amountWritten += (long)count;
            try {
                count = in.read(b);
            }
            catch (IOException e) {
                throw new XMPPException("error reading from input stream", (Throwable)e);
            }
        } while (count != -1 && !this.getStatus().equals(Status.CANCLED));
        if (!this.getStatus().equals(Status.CANCLED) && this.getError() == Error.NONE && this.amountWritten != this.fileSize) {
            this.setStatus(Status.ERROR);
            this.error = Error.CONNECTION;
        }
    }

    public long getAmountWritten() {
        return this.amountWritten;
    }

    public static class Error {
        public static final Error NONE = new Error("No error");
        public static final Error NOT_ACCEPTABLE = new Error("The peer did not find any of the provided stream mechanisms acceptable.");
        public static final Error BAD_FILE = new Error("The provided file to transfer does not exist or could not be read.");
        public static final Error NO_RESPONSE = new Error("The remote user did not respond or the connection timed out.");
        public static final Error CONNECTION = new Error("An error occured over the socket connected to send the file.");
        protected static final Error STREAM = new Error("An error occured while sending or recieving the file");
        private final String msg;

        private Error(String msg) {
            this.msg = msg;
        }

        public String getMessage() {
            return this.msg;
        }

        public String toString() {
            return this.msg;
        }
    }

    public static class Status {
        public static final Status ERROR = new Status("Error");
        public static final Status INITIAL = new Status("Initial");
        public static final Status NEGOTIATING_TRANSFER = new Status("Negotiating Transfer");
        public static final Status REFUSED = new Status("Refused");
        public static final Status NEGOTIATING_STREAM = new Status("Negotiating Stream");
        public static final Status NEGOTIATED = new Status("Negotiated");
        public static final Status IN_PROGRESS = new Status("In Progress");
        public static final Status COMPLETE = new Status("Complete");
        public static final Status CANCLED = new Status("Cancled");
        private String status;

        private Status(String status) {
            this.status = status;
        }

        public String toString() {
            return this.status;
        }
    }
}

