/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.context;

import java.lang.reflect.Constructor;
import org.acegisecurity.context.GlobalSecurityContextHolderStrategy;
import org.acegisecurity.context.InheritableThreadLocalSecurityContextHolderStrategy;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolderStrategy;
import org.acegisecurity.context.ThreadLocalSecurityContextHolderStrategy;
import org.springframework.util.ReflectionUtils;

public class SecurityContextHolder {
    public static final String MODE_THREADLOCAL = "MODE_THREADLOCAL";
    public static final String MODE_INHERITABLETHREADLOCAL = "MODE_INHERITABLETHREADLOCAL";
    public static final String MODE_GLOBAL = "MODE_GLOBAL";
    public static final String SYSTEM_PROPERTY = "acegi.security.strategy";
    private static String strategyName = System.getProperty("acegi.security.strategy");
    private static Constructor customStrategy;
    private static SecurityContextHolderStrategy strategy;

    public static void clearContext() {
        SecurityContextHolder.initialize();
        strategy.clearContext();
    }

    public static SecurityContext getContext() {
        SecurityContextHolder.initialize();
        return strategy.getContext();
    }

    private static void initialize() {
        if (strategyName == null || "".equals(strategyName)) {
            strategyName = MODE_THREADLOCAL;
        }
        if (strategyName.equals(MODE_THREADLOCAL)) {
            strategy = new ThreadLocalSecurityContextHolderStrategy();
        } else if (strategyName.equals(MODE_INHERITABLETHREADLOCAL)) {
            strategy = new InheritableThreadLocalSecurityContextHolderStrategy();
        } else if (strategyName.equals(MODE_GLOBAL)) {
            strategy = new GlobalSecurityContextHolderStrategy();
        } else {
            try {
                if (customStrategy == null) {
                    Class<?> clazz = Class.forName(strategyName);
                    customStrategy = clazz.getConstructor(new Class[0]);
                }
                strategy = (SecurityContextHolderStrategy)customStrategy.newInstance(new Object[0]);
            }
            catch (Exception ex) {
                ReflectionUtils.handleReflectionException((Exception)ex);
            }
        }
    }

    public static void setContext(SecurityContext context) {
        SecurityContextHolder.initialize();
        strategy.setContext(context);
    }

    public static void setStrategyName(String strategyName) {
        SecurityContextHolder.strategyName = strategyName;
        SecurityContextHolder.initialize();
    }

    public String toString() {
        return "SecurityContextHolder[strategy='" + strategyName + "']";
    }
}

