/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.MemoryImageSource;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.util.CSVWriter;
import org.hsqldb.util.ConnectionDialog;
import org.hsqldb.util.DatabaseManagerCommon;
import org.hsqldb.util.Grid;
import org.hsqldb.util.RCData;
import org.hsqldb.util.Transfer;
import org.hsqldb.util.Tree;

public class DatabaseManager
extends Applet
implements ActionListener,
WindowListener,
KeyListener {
    private static final String DEFAULT_RCFILE = System.getProperty("user.home") + "/dbmanager.rc";
    static final String NL = System.getProperty("line.separator");
    static final int iMaxRecent = 24;
    Connection cConn;
    DatabaseMetaData dMeta;
    Statement sStatement;
    Menu mRecent;
    String[] sRecent;
    int iRecent;
    TextArea txtCommand;
    Button butExecute;
    Button butClear;
    Tree tTree;
    Panel pResult;
    long lTime;
    int iResult;
    Grid gResult;
    TextArea txtResult;
    boolean bHelp;
    Frame fMain;
    Image imgEmpty;
    static boolean bMustExit;
    String ifHuge = "";
    static String defDriver;
    static String defURL;
    static String defUser;
    static String defPassword;
    static String defScript;
    static String defDirectory;

    public void connect(Connection c) {
        if (c == null) {
            return;
        }
        if (this.cConn != null) {
            try {
                this.cConn.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        this.cConn = c;
        try {
            this.dMeta = this.cConn.getMetaData();
            this.sStatement = this.cConn.createStatement();
            this.refreshTree();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void init() {
        DatabaseManager m = new DatabaseManager();
        m.main();
        try {
            m.connect(ConnectionDialog.createConnection(defDriver, defURL, defUser, defPassword));
            m.insertTestData();
            m.refreshTree();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] arg) {
        System.getProperties().put("sun.java2d.noddraw", "true");
        String urlid = null;
        String rcFile = null;
        boolean autoConnect = false;
        boolean urlidConnect = false;
        bMustExit = true;
        for (int i = 0; i < arg.length; ++i) {
            String lowerArg = arg[i].toLowerCase();
            if (lowerArg.length() > 1 && lowerArg.charAt(1) == '-') {
                lowerArg = lowerArg.substring(1);
            }
            if (++i == arg.length) {
                DatabaseManager.showUsage();
                return;
            }
            if (lowerArg.equals("-driver")) {
                defDriver = arg[i];
                autoConnect = true;
                continue;
            }
            if (lowerArg.equals("-url")) {
                defURL = arg[i];
                autoConnect = true;
                continue;
            }
            if (lowerArg.equals("-user")) {
                defUser = arg[i];
                autoConnect = true;
                continue;
            }
            if (lowerArg.equals("-password")) {
                defPassword = arg[i];
                autoConnect = true;
                continue;
            }
            if (lowerArg.equals("-urlid")) {
                urlid = arg[i];
                urlidConnect = true;
                continue;
            }
            if (lowerArg.equals("-rcfile")) {
                rcFile = arg[i];
                urlidConnect = true;
                continue;
            }
            if (lowerArg.equals("-dir")) {
                defDirectory = arg[i];
                continue;
            }
            if (lowerArg.equals("-script")) {
                defScript = arg[i];
                continue;
            }
            if (lowerArg.equals("-noexit")) {
                bMustExit = false;
                --i;
                continue;
            }
            DatabaseManager.showUsage();
            return;
        }
        DatabaseManager m = new DatabaseManager();
        m.main();
        Connection c = null;
        try {
            if (autoConnect && urlidConnect) {
                throw new IllegalArgumentException("You may not specify both (urlid) AND (url/user/password).");
            }
            if (autoConnect) {
                c = ConnectionDialog.createConnection(defDriver, defURL, defUser, defPassword);
            } else if (urlidConnect) {
                if (urlid == null) {
                    throw new IllegalArgumentException("You must specify an 'urlid' to use an RC file");
                }
                autoConnect = true;
                c = new RCData(new File(rcFile == null ? DEFAULT_RCFILE : rcFile), urlid).getConnection(null, System.getProperty("sqlfile.charset"), System.getProperty("javax.net.ssl.trustStore"));
            } else {
                c = ConnectionDialog.createConnection(m.fMain, "Connect");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (c == null) {
            return;
        }
        m.connect(c);
    }

    private static void showUsage() {
        System.out.println("Usage: java DatabaseManager [--options]\nwhere options include:\n    --driver <classname>  jdbc driver class\n    --url <name>          jdbc url\n    --user <name>         username used for connection\n    --password <password> password for this user\n    --urlid <urlid>       use url/user/password/driver in rc file\n    --rcfile <file>       (defaults to 'dbmanager.rc' in home dir)\n    --dir <path>          default directory\n    --script <file>       reads from script file\n    --noexit              do not call system.exit()\n(Single-hypen switches like '-driver' are also supported)");
    }

    void insertTestData() {
        try {
            DatabaseManagerCommon.createTestTables(this.sStatement);
            this.refreshTree();
            this.txtCommand.setText(DatabaseManagerCommon.createTestData(this.sStatement));
            this.refreshTree();
            for (int i = 0; i < DatabaseManagerCommon.testDataSql.length; ++i) {
                this.addToRecent(DatabaseManagerCommon.testDataSql[i]);
            }
            this.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void main() {
        this.fMain = new Frame("HSQL Database Manager");
        this.imgEmpty = this.createImage(new MemoryImageSource(2, 2, new int[16], 2, 2));
        this.fMain.setIconImage(this.imgEmpty);
        this.fMain.addWindowListener(this);
        MenuBar bar = new MenuBar();
        String[] fitems = new String[]{"-Connect...", "--", "-Open Script...", "-Save Script...", "-Save Result...", "-Save Result csv...", "--", "-Exit"};
        this.addMenu(bar, "File", fitems);
        String[] vitems = new String[]{"RRefresh Tree", "--", "GResults in Grid", "TResults in Text", "--", "1Shrink Tree", "2Enlarge Tree", "3Shrink Command", "4Enlarge Command"};
        this.addMenu(bar, "View", vitems);
        String[] sitems = new String[]{"SSELECT", "IINSERT", "UUPDATE", "DDELETE", "--", "-CREATE TABLE", "-DROP TABLE", "-CREATE INDEX", "-DROP INDEX", "--", "-CHECKPOINT", "-SCRIPT", "-SET", "-SHUTDOWN", "--", "-Test Script"};
        this.addMenu(bar, "Command", sitems);
        Menu recent = new Menu("Recent");
        this.mRecent = new Menu("Recent");
        bar.add(this.mRecent);
        String[] soptions = new String[]{"-AutoCommit on", "-AutoCommit off", "OCommit", "LRollback", "--", "-Disable MaxRows", "-Set MaxRows to 100", "--", "-Logging on", "-Logging off", "--", "-Insert test data"};
        this.addMenu(bar, "Options", soptions);
        String[] stools = new String[]{"-Dump", "-Restore", "-Transfer"};
        this.addMenu(bar, "Tools", stools);
        this.fMain.setMenuBar(bar);
        this.fMain.setSize(640, 480);
        this.fMain.add("Center", this);
        this.initGUI();
        this.sRecent = new String[24];
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = this.fMain.getSize();
        if (d.width >= 640) {
            this.fMain.setLocation((d.width - size.width) / 2, (d.height - size.height) / 2);
        } else {
            this.fMain.setLocation(0, 0);
            this.fMain.setSize(d);
        }
        this.fMain.show();
        if (defScript != null) {
            if (defDirectory != null) {
                defScript = defDirectory + File.separator + defScript;
            }
            this.txtCommand.setText(DatabaseManagerCommon.readFile(defScript));
        }
        this.txtCommand.requestFocus();
    }

    void addMenu(MenuBar b, String name, String[] items) {
        Menu menu = new Menu(name);
        this.addMenuItems(menu, items);
        b.add(menu);
    }

    void addMenuItems(Menu f, String[] m) {
        for (int i = 0; i < m.length; ++i) {
            MenuItem item = new MenuItem(m[i].substring(1));
            char c = m[i].charAt(0);
            if (c != '-') {
                item.setShortcut(new MenuShortcut(c));
            }
            item.addActionListener(this);
            f.add(item);
        }
    }

    public void keyPressed(KeyEvent k) {
    }

    public void keyReleased(KeyEvent k) {
    }

    public void keyTyped(KeyEvent k) {
        if (k.getKeyChar() == '\n' && k.isControlDown()) {
            k.consume();
            this.execute();
        }
    }

    public void actionPerformed(ActionEvent ev) {
        String s = ev.getActionCommand();
        if (s == null && ev.getSource() instanceof MenuItem) {
            s = ((MenuItem)ev.getSource()).getLabel();
        }
        if (s != null) {
            if (s.equals("Execute")) {
                this.execute();
            } else if (s.equals("Clear")) {
                this.clear();
            } else if (s.equals("Exit")) {
                this.windowClosing(null);
            } else if (s.equals("Transfer")) {
                Transfer.work(null);
            } else if (s.equals("Dump")) {
                Transfer.work((String[])new String[]{"-d"});
            } else if (s.equals("Restore")) {
                Transfer.work((String[])new String[]{"-r"});
            } else if (s.equals("Logging on")) {
                JavaSystem.setLogToSystem(true);
            } else if (s.equals("Logging off")) {
                JavaSystem.setLogToSystem(false);
            } else if (s.equals("Refresh Tree")) {
                this.refreshTree();
            } else if (s.startsWith("#")) {
                int i = Integer.parseInt(s.substring(1));
                this.txtCommand.setText(this.sRecent[i]);
            } else if (s.equals("Connect...")) {
                this.connect(ConnectionDialog.createConnection(this.fMain, "Connect"));
                this.refreshTree();
            } else if (s.equals("Results in Grid")) {
                this.iResult = 0;
                this.pResult.removeAll();
                this.pResult.add("Center", this.gResult);
                this.pResult.doLayout();
            } else if (s.equals("Open Script...")) {
                FileDialog f = new FileDialog(this.fMain, "Open Script", 0);
                if (defDirectory != null) {
                    f.setDirectory(defDirectory);
                }
                f.show();
                String file = f.getFile();
                if (file != null) {
                    StringBuffer buf = new StringBuffer();
                    this.ifHuge = DatabaseManagerCommon.readFile(f.getDirectory() + file);
                    if (4096 <= this.ifHuge.length()) {
                        buf.append("This huge file cannot be edited. Please execute\n");
                        this.txtCommand.setText(buf.toString());
                    } else {
                        this.txtCommand.setText(this.ifHuge);
                    }
                }
            } else if (s.equals("Save Script...")) {
                FileDialog f = new FileDialog(this.fMain, "Save Script", 1);
                if (defDirectory != null) {
                    f.setDirectory(defDirectory);
                }
                f.show();
                String file = f.getFile();
                if (file != null) {
                    DatabaseManagerCommon.writeFile(f.getDirectory() + file, this.txtCommand.getText());
                }
            } else if (s.equals("Save Result csv...")) {
                FileDialog f = new FileDialog(this.fMain, "Save Result CSV", 1);
                if (defDirectory != null) {
                    f.setDirectory(defDirectory);
                }
                f.show();
                String dir = f.getDirectory();
                String file = f.getFile();
                if (dir != null) {
                    file = dir + "/" + file;
                }
                if (file != null) {
                    this.showResultInText();
                    this.saveAsCsv(file);
                }
            } else if (s.equals("Save Result...")) {
                FileDialog f = new FileDialog(this.fMain, "Save Result", 1);
                if (defDirectory != null) {
                    f.setDirectory(defDirectory);
                }
                f.show();
                String file = f.getFile();
                if (file != null) {
                    this.showResultInText();
                    DatabaseManagerCommon.writeFile(f.getDirectory() + file, this.txtResult.getText());
                }
            } else if (s.equals("Results in Text")) {
                this.iResult = 1;
                this.pResult.removeAll();
                this.pResult.add("Center", this.txtResult);
                this.pResult.doLayout();
                this.showResultInText();
            } else if (s.equals("AutoCommit on")) {
                try {
                    this.cConn.setAutoCommit(true);
                }
                catch (SQLException e) {}
            } else if (s.equals("AutoCommit off")) {
                try {
                    this.cConn.setAutoCommit(false);
                }
                catch (SQLException e) {}
            } else if (s.equals("Enlarge Tree")) {
                Dimension d = this.tTree.getMinimumSize();
                d.width += 20;
                this.tTree.setMinimumSize(d);
                this.fMain.pack();
            } else if (s.equals("Shrink Tree")) {
                Dimension d = this.tTree.getMinimumSize();
                d.width -= 20;
                if (d.width >= 0) {
                    this.tTree.setMinimumSize(d);
                }
                this.fMain.pack();
            } else if (s.equals("Enlarge Command")) {
                this.txtCommand.setRows(this.txtCommand.getRows() + 1);
                this.fMain.pack();
            } else if (s.equals("Shrink Command")) {
                int i = this.txtCommand.getRows() - 1;
                this.txtCommand.setRows(i < 1 ? 1 : i);
                this.fMain.pack();
            } else if (s.equals("Commit")) {
                try {
                    this.cConn.commit();
                }
                catch (SQLException e) {}
            } else if (s.equals("Insert test data")) {
                this.insertTestData();
            } else if (s.equals("Rollback")) {
                try {
                    this.cConn.rollback();
                }
                catch (SQLException e) {}
            } else if (s.equals("Disable MaxRows")) {
                try {
                    this.sStatement.setMaxRows(0);
                }
                catch (SQLException e) {}
            } else if (s.equals("Set MaxRows to 100")) {
                try {
                    this.sStatement.setMaxRows(100);
                }
                catch (SQLException sQLException) {}
            } else if (s.equals("SELECT")) {
                this.showHelp(DatabaseManagerCommon.selectHelp);
            } else if (s.equals("INSERT")) {
                this.showHelp(DatabaseManagerCommon.insertHelp);
            } else if (s.equals("UPDATE")) {
                this.showHelp(DatabaseManagerCommon.updateHelp);
            } else if (s.equals("DELETE")) {
                this.showHelp(DatabaseManagerCommon.deleteHelp);
            } else if (s.equals("CREATE TABLE")) {
                this.showHelp(DatabaseManagerCommon.createTableHelp);
            } else if (s.equals("DROP TABLE")) {
                this.showHelp(DatabaseManagerCommon.dropTableHelp);
            } else if (s.equals("CREATE INDEX")) {
                this.showHelp(DatabaseManagerCommon.createIndexHelp);
            } else if (s.equals("DROP INDEX")) {
                this.showHelp(DatabaseManagerCommon.dropIndexHelp);
            } else if (s.equals("CHECKPOINT")) {
                this.showHelp(DatabaseManagerCommon.checkpointHelp);
            } else if (s.equals("SCRIPT")) {
                this.showHelp(DatabaseManagerCommon.scriptHelp);
            } else if (s.equals("SHUTDOWN")) {
                this.showHelp(DatabaseManagerCommon.shutdownHelp);
            } else if (s.equals("SET")) {
                this.showHelp(DatabaseManagerCommon.setHelp);
            } else if (s.equals("Test Script")) {
                this.showHelp(DatabaseManagerCommon.testHelp);
            }
        }
    }

    void showHelp(String[] help) {
        this.txtCommand.setText(help[0]);
        this.txtResult.setText(help[1]);
        this.bHelp = true;
        this.pResult.removeAll();
        this.pResult.add("Center", this.txtResult);
        this.pResult.doLayout();
        this.txtCommand.requestFocus();
        this.txtCommand.setCaretPosition(help[0].length());
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent ev) {
        try {
            this.cConn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fMain.dispose();
        if (bMustExit) {
            System.exit(0);
        }
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    void clear() {
        this.ifHuge = "";
        this.txtCommand.setText(this.ifHuge);
    }

    void execute() {
        String sCmd = null;
        sCmd = 4096 <= this.ifHuge.length() ? this.ifHuge : this.txtCommand.getText();
        if (sCmd.startsWith("-->>>TEST<<<--")) {
            this.testPerformance();
            return;
        }
        String[] g = new String[1];
        this.lTime = System.currentTimeMillis();
        try {
            this.sStatement.execute(sCmd);
            this.lTime = System.currentTimeMillis() - this.lTime;
            int r = this.sStatement.getUpdateCount();
            if (r == -1) {
                this.formatResultSet(this.sStatement.getResultSet());
            } else {
                g[0] = "update count";
                this.gResult.setHead(g);
                g[0] = String.valueOf(r);
                this.gResult.addRow(g);
            }
            this.addToRecent(this.txtCommand.getText());
        }
        catch (SQLException e) {
            this.lTime = System.currentTimeMillis() - this.lTime;
            g[0] = "SQL Error";
            this.gResult.setHead(g);
            String s = e.getMessage();
            s = s + " / Error Code: " + e.getErrorCode();
            g[0] = s = s + " / State: " + e.getSQLState();
            this.gResult.addRow(g);
        }
        this.updateResult();
        System.gc();
    }

    void updateResult() {
        if (this.iResult == 0) {
            if (this.bHelp) {
                this.pResult.removeAll();
                this.pResult.add("Center", this.gResult);
                this.pResult.doLayout();
                this.bHelp = false;
            }
            this.gResult.update();
            this.gResult.repaint();
        } else {
            this.showResultInText();
        }
        this.txtCommand.selectAll();
        this.txtCommand.requestFocus();
    }

    void formatResultSet(ResultSet r) {
        if (r == null) {
            String[] g = new String[]{"Result"};
            this.gResult.setHead(g);
            g[0] = "(empty)";
            this.gResult.addRow(g);
            return;
        }
        try {
            int i;
            ResultSetMetaData m = r.getMetaData();
            int col = m.getColumnCount();
            String[] h = new String[col];
            for (i = 1; i <= col; ++i) {
                h[i - 1] = m.getColumnLabel(i);
            }
            this.gResult.setHead(h);
            while (r.next()) {
                for (i = 1; i <= col; ++i) {
                    try {
                        h[i - 1] = r.getString(i);
                        if (!r.wasNull()) continue;
                        h[i - 1] = "(null)";
                        continue;
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                }
                this.gResult.addRow(h);
            }
            r.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    void testPerformance() {
        String all = this.txtCommand.getText();
        StringBuffer b = new StringBuffer();
        long total = 0L;
        for (int i = 0; i < all.length(); ++i) {
            char c = all.charAt(i);
            if (c == '\n') continue;
            b.append(c);
        }
        all = b.toString();
        String[] g = new String[]{"ms", "count", "sql", "error"};
        this.gResult.setHead(g);
        int max = 1;
        this.lTime = System.currentTimeMillis() - this.lTime;
        while (!all.equals("")) {
            String sql;
            int i = all.indexOf(59);
            if (i != -1) {
                sql = all.substring(0, i);
                all = all.substring(i + 1);
            } else {
                sql = all;
                all = "";
            }
            if (sql.startsWith("--#")) {
                max = Integer.parseInt(sql.substring(3));
                continue;
            }
            if (sql.startsWith("--")) continue;
            g[2] = sql;
            long l = 0L;
            try {
                l = DatabaseManagerCommon.testStatement(this.sStatement, sql, max);
                total += l;
                g[0] = String.valueOf(l);
                g[1] = String.valueOf(max);
                g[3] = "";
            }
            catch (SQLException e) {
                g[1] = "n/a";
                g[0] = "n/a";
                g[3] = e.toString();
            }
            this.gResult.addRow(g);
            System.out.println(l + " ms : " + sql);
        }
        g[0] = "" + total;
        g[1] = "total";
        g[2] = "";
        this.gResult.addRow(g);
        this.lTime = System.currentTimeMillis() - this.lTime;
        this.updateResult();
    }

    void saveAsCsv(String filename) {
        try {
            File file = new File(filename);
            CSVWriter writer = new CSVWriter(file, null);
            String[] col = this.gResult.getHead();
            int width = col.length;
            Vector data = this.gResult.getData();
            int height = data.size();
            writer.writeHeader(col);
            for (int i = 0; i < height; ++i) {
                String[] row = (String[])data.elementAt(i);
                String[] myRow = new String[row.length];
                for (int j = 0; j < row.length; ++j) {
                    String r = row[j];
                    if (r.equals("(null)")) {
                        r = "";
                    }
                    myRow[j] = r;
                }
                writer.writeData(myRow);
            }
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException("IOError: " + e.getMessage());
        }
    }

    void showResultInText() {
        int i;
        int l;
        String[] row;
        int i2;
        String[] col = this.gResult.getHead();
        int width = col.length;
        int[] size = new int[width];
        Vector data = this.gResult.getData();
        int height = data.size();
        for (i2 = 0; i2 < width; ++i2) {
            size[i2] = col[i2].length();
        }
        for (i2 = 0; i2 < height; ++i2) {
            row = (String[])data.elementAt(i2);
            for (int j = 0; j < width; ++j) {
                l = row[j].length();
                if (l <= size[j]) continue;
                size[j] = l;
            }
        }
        StringBuffer b = new StringBuffer();
        for (i = 0; i < width; ++i) {
            b.append(col[i]);
            for (l = col[i].length(); l <= size[i]; ++l) {
                b.append(' ');
            }
        }
        b.append(NL);
        for (i = 0; i < width; ++i) {
            for (l = 0; l < size[i]; ++l) {
                b.append('-');
            }
            b.append(' ');
        }
        b.append(NL);
        for (i = 0; i < height; ++i) {
            row = (String[])data.elementAt(i);
            for (int j = 0; j < width; ++j) {
                b.append(row[j]);
                for (int l2 = row[j].length(); l2 <= size[j]; ++l2) {
                    b.append(' ');
                }
            }
            b.append(NL);
        }
        b.append(NL + height + " row(s) in " + this.lTime + " ms");
        this.txtResult.setText(b.toString());
    }

    private void addToRecent(String s) {
        for (int i = 0; i < 24; ++i) {
            if (!s.equals(this.sRecent[i])) continue;
            return;
        }
        if (this.sRecent[this.iRecent] != null) {
            this.mRecent.remove(this.iRecent);
        }
        this.sRecent[this.iRecent] = s;
        if (s.length() > 43) {
            s = s.substring(0, 40) + "...";
        }
        MenuItem item = new MenuItem(s);
        item.setActionCommand("#" + this.iRecent);
        item.addActionListener(this);
        this.mRecent.insert(item, this.iRecent);
        this.iRecent = (this.iRecent + 1) % 24;
    }

    private void initGUI() {
        Panel pQuery = new Panel();
        Panel pCommand = new Panel();
        this.pResult = new Panel();
        pQuery.setLayout(new BorderLayout());
        pCommand.setLayout(new BorderLayout());
        this.pResult.setLayout(new BorderLayout());
        Font fFont = new Font("Dialog", 0, 12);
        this.txtCommand = new TextArea(5, 40);
        this.txtCommand.addKeyListener(this);
        this.txtResult = new TextArea(20, 40);
        this.txtCommand.setFont(fFont);
        this.txtResult.setFont(new Font("Courier", 0, 12));
        this.butExecute = new Button("Execute");
        this.butClear = new Button("Clear");
        this.butExecute.addActionListener(this);
        this.butClear.addActionListener(this);
        pCommand.add("East", this.butExecute);
        pCommand.add("West", this.butClear);
        pCommand.add("Center", this.txtCommand);
        this.gResult = new Grid();
        this.setLayout(new BorderLayout());
        this.pResult.add("Center", this.gResult);
        pQuery.add("North", pCommand);
        pQuery.add("Center", this.pResult);
        this.fMain.add("Center", pQuery);
        this.tTree = new Tree();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        if (d.width >= 640) {
            this.tTree.setMinimumSize(new Dimension(200, 100));
        } else {
            this.tTree.setMinimumSize(new Dimension(80, 100));
        }
        this.gResult.setMinimumSize(new Dimension(200, 300));
        this.fMain.add("West", this.tTree);
        this.doLayout();
        this.fMain.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshTree() {
        this.tTree.removeAll();
        try {
            int color_table = Color.yellow.getRGB();
            int color_column = Color.orange.getRGB();
            int color_index = Color.red.getRGB();
            this.tTree.addRow("", this.dMeta.getURL(), "-", 0);
            String[] usertables = new String[]{"TABLE", "GLOBAL TEMPORARY", "VIEW"};
            Vector<String> schemas = new Vector<String>();
            Vector<String> tables = new Vector<String>();
            Vector<String> remarks = new Vector<String>();
            ResultSet result = this.dMeta.getTables(null, null, null, usertables);
            try {
                while (result.next()) {
                    schemas.addElement(result.getString(2));
                    tables.addElement(result.getString(3));
                    remarks.addElement(result.getString(5));
                }
            }
            finally {
                result.close();
            }
            for (int i = 0; i < tables.size(); ++i) {
                String name = (String)tables.elementAt(i);
                String schema = (String)schemas.elementAt(i);
                String key = "tab-" + name + "-";
                this.tTree.addRow(key, name, "+", color_table);
                String remark = (String)remarks.elementAt(i);
                if (schema != null && !schema.trim().equals("")) {
                    this.tTree.addRow(key + "s", "schema: " + schema);
                }
                if (remark != null && !remark.trim().equals("")) {
                    this.tTree.addRow(key + "r", " " + remark);
                }
                ResultSet col = this.dMeta.getColumns(null, schema, name, null);
                try {
                    while (col.next()) {
                        String c = col.getString(4);
                        String k1 = key + "col-" + c + "-";
                        this.tTree.addRow(k1, c, "+", color_column);
                        String type = col.getString(6);
                        this.tTree.addRow(k1 + "t", "Type: " + type);
                        boolean nullable = col.getInt(11) != 0;
                        this.tTree.addRow(k1 + "n", "Nullable: " + nullable);
                    }
                }
                finally {
                    col.close();
                }
                this.tTree.addRow(key + "ind", "Indices", "+", 0);
                ResultSet ind = this.dMeta.getIndexInfo(null, schema, name, false, false);
                String oldiname = null;
                try {
                    while (ind.next()) {
                        boolean nonunique = ind.getBoolean(4);
                        String iname = ind.getString(6);
                        String k2 = key + "ind-" + iname + "-";
                        if (oldiname == null || !oldiname.equals(iname)) {
                            this.tTree.addRow(k2, iname, "+", color_index);
                            this.tTree.addRow(k2 + "u", "Unique: " + !nonunique);
                            oldiname = iname;
                        }
                        String c = ind.getString(9);
                        this.tTree.addRow(k2 + "c-" + c + "-", c);
                    }
                    continue;
                }
                finally {
                    ind.close();
                }
            }
            this.tTree.addRow("p", "Properties", "+", 0);
            this.tTree.addRow("pu", "User: " + this.dMeta.getUserName());
            this.tTree.addRow("pr", "ReadOnly: " + this.cConn.isReadOnly());
            this.tTree.addRow("pa", "AutoCommit: " + this.cConn.getAutoCommit());
            this.tTree.addRow("pd", "Driver: " + this.dMeta.getDriverName());
            this.tTree.addRow("pp", "Product: " + this.dMeta.getDatabaseProductName());
            this.tTree.addRow("pv", "Version: " + this.dMeta.getDatabaseProductVersion());
        }
        catch (SQLException e) {
            this.tTree.addRow("", "Error getting metadata:", "-", 0);
            this.tTree.addRow("-", e.getMessage());
            this.tTree.addRow("-", e.getSQLState());
        }
        this.tTree.update();
    }

    static {
        defDriver = "org.hsqldb.jdbcDriver";
        defURL = "jdbc:hsqldb:.";
        defUser = "sa";
        defPassword = "";
    }
}

