/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.hsqldb.Database;
import org.hsqldb.DatabaseManager;
import org.hsqldb.DatabaseScript;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.index.RowIterator;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HsqlTimer;
import org.hsqldb.lib.Iterator;
import org.hsqldb.scriptio.ScriptWriterBinary;
import org.hsqldb.scriptio.ScriptWriterText;
import org.hsqldb.scriptio.ScriptWriterZipped;

public abstract class ScriptWriterBase
implements Runnable {
    Database database;
    String outFile;
    OutputStream fileStreamOut;
    FileAccess.FileSync outDescriptor;
    int tableRowCount;
    HsqlNameManager.HsqlName schemaToLog;
    boolean isDump;
    boolean includeCachedData;
    long byteCount;
    volatile boolean needsSync;
    volatile boolean forceSync;
    volatile boolean busyWriting;
    private int syncCount;
    static final int INSERT = 0;
    static final int INSERT_WITH_SCHEMA = 1;
    Session currentSession;
    public static final String[] LIST_SCRIPT_FORMATS = new String[]{"TEXT", "BINARY", null, "COMPRESSED"};
    public static final int SCRIPT_TEXT_170 = 0;
    public static final int SCRIPT_BINARY_172 = 1;
    public static final int SCRIPT_ZIPPED_BINARY_172 = 3;
    private Object timerTask;
    protected volatile int writeDelay = 60000;

    public static ScriptWriterBase newScriptWriter(Database db, String file, boolean includeCachedData, boolean newFile, int scriptType) throws HsqlException {
        if (scriptType == 0) {
            return new ScriptWriterText(db, file, includeCachedData, newFile, false);
        }
        if (scriptType == 1) {
            return new ScriptWriterBinary(db, file, includeCachedData, newFile);
        }
        return new ScriptWriterZipped(db, file, includeCachedData, newFile);
    }

    ScriptWriterBase() {
    }

    ScriptWriterBase(Database db, String file, boolean includeCachedData, boolean isNewFile, boolean isDump) throws HsqlException {
        this.isDump = isDump;
        this.initBuffers();
        boolean exists = false;
        exists = isDump ? FileUtil.exists(file) : db.getFileAccess().isStreamElement(file);
        if (exists && isNewFile) {
            throw Trace.error(29, file);
        }
        this.database = db;
        this.includeCachedData = includeCachedData;
        this.outFile = file;
        this.currentSession = this.database.sessionManager.getSysSession();
        this.schemaToLog = this.currentSession.loggedSchema = this.currentSession.currentSchema;
        this.openFile();
    }

    public void reopen() throws HsqlException {
        this.openFile();
    }

    protected abstract void initBuffers();

    public synchronized void sync() {
        if (this.needsSync && this.fileStreamOut != null) {
            if (this.busyWriting) {
                this.forceSync = true;
                return;
            }
            try {
                this.fileStreamOut.flush();
                this.outDescriptor.sync();
                ++this.syncCount;
            }
            catch (IOException e) {
                Trace.printSystemOut("flush() or sync() error: " + e.toString());
            }
            this.needsSync = false;
            this.forceSync = false;
        }
    }

    public void close() throws HsqlException {
        this.stop();
        try {
            if (this.fileStreamOut != null) {
                this.fileStreamOut.flush();
                this.fileStreamOut.close();
                this.fileStreamOut = null;
            }
        }
        catch (IOException e) {
            throw Trace.error(29);
        }
        this.byteCount = 0L;
    }

    public long size() {
        return this.byteCount;
    }

    public void writeAll() throws HsqlException {
        try {
            this.writeDDL();
            this.writeExistingData();
            this.finishStream();
        }
        catch (IOException e) {
            throw Trace.error(29);
        }
    }

    protected void openFile() throws HsqlException {
        try {
            FileUtil fa = this.isDump ? FileUtil.getDefaultInstance() : this.database.getFileAccess();
            OutputStream fos = fa.openOutputStreamElement(this.outFile);
            this.outDescriptor = fa.getFileSync(fos);
            this.fileStreamOut = new BufferedOutputStream(fos, 8192);
        }
        catch (IOException e) {
            throw Trace.error(29, 115, new Object[]{e.toString(), this.outFile});
        }
    }

    protected void finishStream() throws IOException {
    }

    protected void writeDDL() throws IOException, HsqlException {
        Result ddlPart = DatabaseScript.getScript(this.database, !this.includeCachedData);
        this.writeSingleColumnResult(ddlPart);
    }

    protected void writeExistingData() throws HsqlException, IOException {
        this.currentSession.loggedSchema = null;
        Iterator schemas = this.database.schemaManager.userSchemaNameIterator();
        while (schemas.hasNext()) {
            String schema = (String)schemas.next();
            Iterator tables = this.database.schemaManager.tablesIterator(schema);
            while (tables.hasNext()) {
                Table t = (Table)tables.next();
                boolean script = false;
                switch (t.getTableType()) {
                    case 3: {
                        script = true;
                        break;
                    }
                    case 4: {
                        script = this.includeCachedData;
                        break;
                    }
                    case 6: {
                        script = this.includeCachedData && !t.isReadOnly();
                    }
                }
                try {
                    if (!script) continue;
                    this.schemaToLog = t.getName().schema;
                    this.writeTableInit(t);
                    RowIterator it = t.rowIterator(this.currentSession);
                    while (it.hasNext()) {
                        this.writeRow(this.currentSession, t, it.next().getData());
                    }
                    this.writeTableTerm(t);
                }
                catch (Exception e) {
                    throw Trace.error(38, e.toString());
                }
            }
        }
        this.writeDataTerm();
    }

    protected void writeTableInit(Table t) throws HsqlException, IOException {
    }

    protected void writeTableTerm(Table t) throws HsqlException, IOException {
        if (t.isDataReadOnly() && !t.isTemp() && !t.isText()) {
            StringBuffer a = new StringBuffer("SET TABLE ");
            a.append(t.getName().statementName);
            a.append(" READONLY TRUE");
            this.writeLogStatement(this.currentSession, a.toString());
        }
    }

    protected void writeSingleColumnResult(Result r) throws HsqlException, IOException {
        Iterator it = r.iterator();
        while (it.hasNext()) {
            Object[] data = (Object[])it.next();
            this.writeLogStatement(this.currentSession, (String)data[0]);
        }
    }

    abstract void writeRow(Session var1, Table var2, Object[] var3) throws HsqlException, IOException;

    protected abstract void writeDataTerm() throws IOException;

    protected abstract void addSessionId(Session var1) throws IOException;

    public abstract void writeLogStatement(Session var1, String var2) throws IOException, HsqlException;

    public abstract void writeInsertStatement(Session var1, Table var2, Object[] var3) throws HsqlException, IOException;

    public abstract void writeDeleteStatement(Session var1, Table var2, Object[] var3) throws HsqlException, IOException;

    public abstract void writeSequenceStatement(Session var1, NumberSequence var2) throws HsqlException, IOException;

    public abstract void writeCommitStatement(Session var1) throws HsqlException, IOException;

    public void run() {
        block3: {
            try {
                if (this.writeDelay != 0) {
                    this.sync();
                }
            }
            catch (Exception e) {
                if (!Trace.TRACE) break block3;
                Trace.printSystemOut(e.toString());
            }
        }
    }

    public void setWriteDelay(int delay) {
        this.writeDelay = delay;
        int period = this.writeDelay == 0 ? 1000 : this.writeDelay;
        HsqlTimer.setPeriod(this.timerTask, period);
    }

    public void start() {
        int period = this.writeDelay == 0 ? 1000 : this.writeDelay;
        this.timerTask = DatabaseManager.getTimer().schedulePeriodicallyAfter(0L, period, this, false);
    }

    public void stop() {
        if (this.timerTask != null) {
            HsqlTimer.cancel(this.timerTask);
            this.timerTask = null;
        }
    }

    public int getWriteDelay() {
        return this.writeDelay;
    }
}

