/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.Trace;
import org.hsqldb.lib.SimpleLog;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.rowio.RowInputTextLog;
import org.hsqldb.scriptio.ScriptReaderBase;

public class ScriptReaderText
extends ScriptReaderBase {
    BufferedReader dataStreamIn;
    RowInputTextLog rowIn = new RowInputTextLog();
    boolean isInsert;

    ScriptReaderText(Database db, String file) throws HsqlException, IOException {
        super(db, file);
    }

    protected void openFile() throws IOException {
        InputStream d = this.db.isFilesInJar() ? this.getClass().getResourceAsStream(this.fileName) : this.db.getFileAccess().openInputStreamElement(this.fileName);
        this.dataStreamIn = new BufferedReader(new InputStreamReader(new BufferedInputStream(d)));
    }

    protected void readDDL(Session session) throws IOException, HsqlException {
        while (this.readLoggedStatement(session)) {
            if (this.rowIn.getStatementType() == 3) {
                this.isInsert = true;
                break;
            }
            Result result = session.sqlExecuteDirectNoPreChecks(this.statement);
            if (result == null || !result.isError()) continue;
            this.db.logger.appLog.logContext(SimpleLog.LOG_ERROR, result.getMainString());
            throw Trace.error(78, 113, new Object[]{new Integer(this.lineCount), result.getMainString()});
        }
    }

    protected void readExistingData(Session session) throws IOException, HsqlException {
        try {
            String tablename = null;
            this.db.setReferentialIntegrity(false);
            while (this.isInsert || this.readLoggedStatement(session)) {
                if (this.statementType == 7) {
                    session.setSchema(this.currentSchema);
                } else if (this.statementType == 3) {
                    if (!this.rowIn.getTableName().equals(tablename)) {
                        tablename = this.rowIn.getTableName();
                        String schema = session.getSchemaName(this.currentSchema);
                        this.currentTable = this.db.schemaManager.getUserTable(session, tablename, schema);
                    }
                    this.currentTable.insertFromScript(this.rowData);
                }
                this.isInsert = false;
            }
            this.db.setReferentialIntegrity(true);
        }
        catch (Exception e) {
            this.db.logger.appLog.logContext(e, null);
            throw Trace.error(78, 114, new Object[]{new Integer(this.lineCount), e.toString()});
        }
    }

    public boolean readLoggedStatement(Session session) throws IOException {
        String s = this.dataStreamIn.readLine();
        ++this.lineCount;
        this.statement = StringConverter.asciiToUnicode(s);
        if (this.statement == null) {
            return false;
        }
        this.processStatement(session);
        return true;
    }

    private void processStatement(Session session) throws IOException {
        try {
            if (this.statement.startsWith("/*C")) {
                int endid = this.statement.indexOf(42, 4);
                this.sessionNumber = Integer.parseInt(this.statement.substring(3, endid));
                this.statement = this.statement.substring(endid + 2);
            }
            this.rowIn.setSource(this.statement);
            this.statementType = this.rowIn.getStatementType();
            if (this.statementType == 1) {
                this.rowData = null;
                this.currentTable = null;
                return;
            }
            if (this.statementType == 5) {
                this.rowData = null;
                this.currentTable = null;
                return;
            }
            if (this.statementType == 7) {
                this.rowData = null;
                this.currentTable = null;
                this.currentSchema = this.rowIn.getSchemaName();
                return;
            }
            String name = this.rowIn.getTableName();
            String schema = session.getSchemaName(null);
            this.currentTable = this.db.schemaManager.getUserTable(session, name, schema);
            int[] colTypes = this.statementType == 3 ? this.currentTable.getColumnTypes() : (this.currentTable.hasPrimaryKey() ? this.currentTable.getPrimaryKeyTypes() : this.currentTable.getColumnTypes());
            this.rowData = this.rowIn.readData(colTypes);
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    public void close() {
        try {
            this.dataStreamIn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

