/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.SimpleLog;
import org.hsqldb.rowio.RowInputBase;
import org.hsqldb.rowio.RowInputBinary;
import org.hsqldb.scriptio.ScriptReaderBase;

class ScriptReaderBinary
extends ScriptReaderBase {
    private RowInputBinary rowIn = new RowInputBinary();
    protected DataInputStream dataStreamIn;

    ScriptReaderBinary(Database db, String file) throws HsqlException, IOException {
        super(db, file);
    }

    protected void openFile() throws IOException {
        InputStream d = this.db.isFilesInJar() ? this.getClass().getResourceAsStream(this.fileName) : this.db.getFileAccess().openInputStreamElement(this.fileName);
        this.dataStreamIn = new DataInputStream(new BufferedInputStream(d, 8192));
    }

    protected void readDDL(Session session) throws IOException, HsqlException {
        Result r = Result.read(this.rowIn, this.dataStreamIn);
        Iterator it = r.iterator();
        while (it.hasNext()) {
            Object[] data = (Object[])it.next();
            String s = (String)data[0];
            Result result = session.sqlExecuteDirectNoPreChecks(s);
            if (!result.isError()) continue;
            this.db.logger.appLog.logContext(SimpleLog.LOG_ERROR, result.getMainString());
            throw Trace.error(result);
        }
    }

    protected void readExistingData(Session session) throws IOException, HsqlException {
        String s;
        while ((s = this.readTableInit()) != null) {
            String schema = session.getSchemaName(this.currentSchema);
            Table t = this.db.schemaManager.getUserTable(session, s, schema);
            int j = 0;
            j = 0;
            while (this.readRow(t)) {
                ++j;
            }
            int checkCount = this.readTableTerm();
            if (j == checkCount) continue;
            throw Trace.error(78, 96, new Object[]{s, new Integer(j), new Integer(checkCount)});
        }
    }

    protected boolean readRow(Table t) throws IOException, HsqlException {
        boolean more = this.readRow(this.rowIn, 0);
        if (!more) {
            return false;
        }
        Object[] data = this.rowIn.readData(t.getColumnTypes());
        t.insertFromScript(data);
        return true;
    }

    protected int readTableTerm() throws IOException, HsqlException {
        return this.dataStreamIn.readInt();
    }

    protected String readTableInit() throws IOException, HsqlException {
        boolean more = this.readRow(this.rowIn, 0);
        if (!more) {
            return null;
        }
        String s = this.rowIn.readString();
        int checkOp = this.rowIn.readIntData();
        this.currentSchema = checkOp == 1 ? this.rowIn.readString() : null;
        if (checkOp != 0 && checkOp != 1) {
            throw Trace.error(78, 97);
        }
        return s;
    }

    boolean readRow(RowInputBase rowin, int pos) throws IOException {
        try {
            int length = this.dataStreamIn.readInt();
            int count = 4;
            if (length == 0) {
                return false;
            }
            rowin.resetRow(pos, length);
            this.dataStreamIn.readFully(rowin.getBuffer(), count, length - count);
            return true;
        }
        catch (EOFException e) {
            return false;
        }
    }

    public boolean readLoggedStatement(Session session) throws IOException {
        return false;
    }

    public void close() {
        try {
            this.dataStreamIn.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

