/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.hsqldb.DatabaseManager;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.Trace;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HsqlTimer;
import org.hsqldb.lib.java.JavaSystem;

public class LockFile {
    protected File f;
    private String cpath = null;
    protected RandomAccessFile raf;
    public static final long HEARTBEAT_INTERVAL = 10000L;
    public static final byte[] MAGIC = "HSQLLOCK".getBytes();
    protected boolean locked;
    protected static final HsqlTimer timer = DatabaseManager.getTimer();
    private Object timerTask;

    private void checkHeartbeat() throws Exception {
        long lastHeartbeat;
        String mn = "checkHeartbeat(): ";
        String path = "lock file [" + this.cpath + "]";
        this.trace(mn + "entered.");
        if (!this.f.exists()) {
            this.trace(mn + path + " does not exist. Check OK.");
            return;
        }
        if (this.f.length() != 16L) {
            this.trace(mn + path + " length != 16; Check OK.");
            return;
        }
        try {
            lastHeartbeat = System.currentTimeMillis() - this.readHeartbeat();
        }
        catch (Exception e) {
            throw new Exception(Trace.getMessage(143, true, new Object[]{e.toString(), this.cpath}));
        }
        this.trace(mn + path + " last heartbeat " + lastHeartbeat + " ms ago.");
        if (Math.abs(lastHeartbeat) < 10000L) {
            throw new Exception(Trace.getMessage(144, true, new Object[]{mn, path}));
        }
    }

    private void closeRAF() throws Exception {
        String mn = "closeRAF(): ";
        this.trace(mn + "entered.");
        if (this.raf == null) {
            this.trace(mn + "raf was null upon entry. Exiting immediately.");
        } else {
            this.trace(mn + "closing " + this.raf);
            this.raf.close();
            this.trace(mn + this.raf + " closed successfully. Setting raf null");
            this.raf = null;
        }
    }

    private void setFile(File file) throws Exception {
        if (this.isLocked()) {
            try {
                this.tryRelease();
            }
            catch (Exception e) {
                this.trace(e);
            }
        }
        this.f = FileUtil.canonicalFile(file);
        this.cpath = this.f.getPath();
        this.raf = null;
        this.locked = false;
    }

    protected boolean lockImpl() throws Exception {
        String mn = "lockImpl(): ";
        this.trace(mn + "entered.");
        FileUtil.deleteOnExit(this.f);
        return true;
    }

    private void openRAF() throws Exception {
        this.trace("openRAF(): entered.");
        this.raf = new RandomAccessFile(this.f, "rw");
        this.trace("openRAF(): got new 'rw' mode " + this.raf);
    }

    private long readHeartbeat() throws Exception {
        long heartbeat = Long.MIN_VALUE;
        String mn = "readHeartbeat(): ";
        String path = "lock file [" + this.cpath + "]";
        this.trace(mn + "entered.");
        if (!this.f.exists()) {
            this.trace(mn + path + " does not exist. Return  '" + heartbeat + "'");
            return heartbeat;
        }
        DataInputStream dis = new DataInputStream(new FileInputStream(this.f));
        this.trace(mn + " got new " + dis);
        for (int i = 0; i < MAGIC.length; ++i) {
            if (MAGIC[i] == dis.readByte()) continue;
            this.trace(mn + path + " is not lock file. Return '" + heartbeat + "'");
            return heartbeat;
        }
        heartbeat = dis.readLong();
        this.trace(mn + " read:  [" + HsqlDateTime.getTimestampString(heartbeat) + "]");
        dis.close();
        this.trace(mn + " closed " + dis);
        return heartbeat;
    }

    protected boolean releaseImpl() throws Exception {
        this.trace("releaseImpl(): no action: returning true");
        return true;
    }

    private void startHeartbeat() {
        this.trace("startHeartbeat(): entered.");
        if (this.timerTask == null || HsqlTimer.isCancelled(this.timerTask)) {
            HeartbeatRunner r = new HeartbeatRunner();
            this.timerTask = timer.schedulePeriodicallyAfter(0L, 10000L, r, true);
            this.trace("startHeartbeat(): heartbeat task scheduled.");
        }
        this.trace("startHeartbeat(): exited.");
    }

    private void stopHeartbeat() {
        String mn = "stopHeartbeat(): ";
        this.trace(mn + "entered");
        if (this.timerTask != null && !HsqlTimer.isCancelled(this.timerTask)) {
            HsqlTimer.cancel(this.timerTask);
            this.timerTask = null;
        }
        this.trace(mn + "exited");
    }

    private void writeMagic() throws Exception {
        String mn = "writeMagic(): ";
        String path = "lock file [" + this.cpath + "]";
        this.trace(mn + "entered.");
        this.trace(mn + "raf.seek(0)");
        this.raf.seek(0L);
        this.trace(mn + "raf.write(byte[])");
        this.raf.write(MAGIC);
        this.trace(mn + "wrote [\"HSQLLOCK\".getBytes()] to " + path);
    }

    private void writeHeartbeat() throws Exception {
        String mn = "writeHeartbeat(): ";
        String path = "lock file [" + this.cpath + "]";
        this.trace(mn + "entered.");
        long time = System.currentTimeMillis();
        this.trace(mn + "raf.seek(" + MAGIC.length + ")");
        this.raf.seek(MAGIC.length);
        this.trace(mn + "raf.writeLong(" + time + ")");
        this.raf.writeLong(time);
        this.trace(mn + "wrote [" + time + "] to " + path);
    }

    public static LockFile newLockFile(String path) throws Exception {
        LockFile lf;
        Class<?> c = null;
        try {
            Class.forName("java.nio.channels.FileLock");
            c = Class.forName("org.hsqldb.persist.NIOLockFile");
            lf = (LockFile)c.newInstance();
        }
        catch (Exception e) {
            lf = new LockFile();
        }
        File f = new File(path);
        FileUtil.makeParentDirectories(f);
        lf.setFile(f);
        return lf;
    }

    public static LockFile newLockFileLock(String path) throws HsqlException {
        LockFile lf = null;
        try {
            lf = LockFile.newLockFile(path + ".lck");
        }
        catch (Exception e) {
            throw Trace.error(29, e.toString());
        }
        boolean locked = false;
        String msg = "";
        try {
            locked = lf.tryLock();
        }
        catch (Exception e) {
            msg = e.toString();
        }
        if (!locked) {
            throw Trace.error(1, lf + ": " + msg);
        }
        return lf;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LockFile) {
            LockFile that = (LockFile)obj;
            return this.f == null ? that.f == null : this.f.equals(that.f);
        }
        return false;
    }

    public String getCanonicalPath() {
        return this.cpath;
    }

    public int hashCode() {
        return this.f == null ? 0 : this.f.hashCode();
    }

    public boolean isLocked() {
        return this.locked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLocked(String path) {
        FileInputStream fis = null;
        try {
            LockFile lf = LockFile.newLockFile(path);
            lf.checkHeartbeat();
            if (lf.f.exists() && lf.f.isFile()) {
                fis = new FileInputStream(lf.f);
                fis.read();
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        return true;
    }

    public boolean isValid() {
        return this.isLocked() && this.f != null && this.f.exists() && this.raf != null;
    }

    public String toString() {
        return super.toString() + "[file =" + this.cpath + ", exists=" + this.f.exists() + ", locked=" + this.isLocked() + ", valid=" + this.isValid() + ", " + this.toStringImpl() + "]";
    }

    protected String toStringImpl() {
        return "";
    }

    public boolean tryLock() throws Exception {
        String mn = "tryLock(): ";
        this.trace(mn + "entered.");
        if (this.locked) {
            this.trace(mn + " lock already held. Returning true immediately.");
            return true;
        }
        this.checkHeartbeat();
        this.openRAF();
        this.locked = this.lockImpl();
        if (this.locked) {
            this.writeMagic();
            this.startHeartbeat();
            try {
                JavaSystem.runFinalizers();
                this.trace(mn + "success for System.runFinalizersOnExit(true)");
            }
            catch (Exception e) {
                this.trace(mn + e.toString());
            }
        } else {
            try {
                this.releaseImpl();
                this.closeRAF();
            }
            catch (Exception e) {
                this.trace(mn + e.toString());
            }
        }
        this.trace(mn + "ran to completion.  Returning " + this.locked);
        return this.locked;
    }

    public boolean tryRelease() throws Exception {
        boolean released;
        String mn = "tryRelease(): ";
        this.trace(mn + "entered.");
        boolean bl = released = !this.locked;
        if (released) {
            this.trace(mn + "No lock held. Returning true immediately");
            return true;
        }
        try {
            released = this.releaseImpl();
        }
        catch (Exception e) {
            this.trace(mn + e);
        }
        if (!released) {
            this.trace(mn + "releaseImpl() failed. Returning false immediately.");
            return false;
        }
        this.trace(mn + "releaseImpl() succeeded.");
        this.stopHeartbeat();
        this.closeRAF();
        this.trace(mn + "Starting Thread.sleep(100).");
        try {
            Thread.sleep(100L);
        }
        catch (Exception e) {
            this.trace(mn + e.toString());
        }
        this.trace(mn + "Finished Thread.sleep(100).");
        String path = "[" + this.cpath + "]";
        if (this.f.exists()) {
            this.trace(mn + path + " exists.");
            released = this.f.delete();
            this.trace(mn + path + (released ? "" : "not") + " deleted.");
            if (this.f.exists()) {
                this.trace(mn + " WARNING!: " + path + "still exists.");
            }
        }
        this.locked = !released;
        this.trace(mn + "ran to completion.  Returning " + released);
        return released;
    }

    protected void trace(Object o) {
        if (Trace.TRACE) {
            Trace.printSystemOut("[" + super.toString() + "]: " + o);
        }
    }

    protected void finalize() throws Throwable {
        this.trace("finalize(): calling tryRelease()");
        this.tryRelease();
    }

    protected class HeartbeatRunner
    implements Runnable {
        protected HeartbeatRunner() {
        }

        public void run() {
            try {
                LockFile.this.trace("HeartbeatRunner.run(): writeHeartbeat()");
                LockFile.this.writeHeartbeat();
            }
            catch (Throwable t) {
                LockFile.this.trace("HeartbeatRunner.run(): caught Throwable: " + t);
            }
        }
    }
}

