/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.util.Enumeration;
import org.hsqldb.Database;
import org.hsqldb.DatabaseURL;
import org.hsqldb.HsqlException;
import org.hsqldb.Trace;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Set;
import org.hsqldb.lib.SimpleLog;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.store.ValuePool;

public class HsqlDatabaseProperties
extends HsqlProperties {
    public static final int indexName = 0;
    public static final int indexAccess = 1;
    public static final int indexClass = 2;
    public static final int indexIsRange = 3;
    public static final int indexDefaultValue = 4;
    public static final int indexRangeLow = 5;
    public static final int indexRangeHigh = 6;
    public static final int indexValues = 7;
    public static final int indexLimit = 8;
    private static final int SET_PROPERTY = 0;
    private static final int SQL_PROPERTY = 1;
    private static final int FILE_PROPERTY = 2;
    public static final int FILES_NOT_MODIFIED = 0;
    public static final int FILES_MODIFIED = 1;
    public static final int FILES_NEW = 2;
    private static final String MODIFIED_NO = "no";
    private static final String MODIFIED_YES = "yes";
    private static final String MODIFIED_NEW = "no-new-files";
    private static HashMap meta = new HashMap();
    public static final String VERSION_STRING_1_7_0 = "1.7.0";
    public static final String VERSION_STRING_1_8_0 = "1.8.0";
    public static final String FIRST_COMPATIBLE_VERSION = "1.8.0";
    public static final String THIS_VERSION = "1.8.0";
    public static final String THIS_FULL_VERSION = "1.8.0.7";
    public static final String PRODUCT_NAME = "HSQL Database Engine";
    public static final int MAJOR = 1;
    public static final int MINOR = 8;
    public static final int REVISION = 0;
    public static final String db_version = "version";
    private static final String db_readonly = "readonly";
    private static final String db_modified = "modified";
    private static final String runtime_gc_interval = "runtime.gc_interval";
    public static final String hsqldb_applog = "hsqldb.applog";
    public static final String hsqldb_cache_file_scale = "hsqldb.cache_file_scale";
    public static final String hsqldb_cache_free_count_scale = "hsqldb.cache_free_count_scale";
    public static final String hsqldb_cache_scale = "hsqldb.cache_scale";
    public static final String hsqldb_cache_size_scale = "hsqldb.cache_size_scale";
    public static final String hsqldb_cache_version = "hsqldb.cache_version";
    private static final String hsqldb_catalogs = "hsqldb.catalogs";
    public static final String hsqldb_compatible_version = "hsqldb.compatible_version";
    public static final String hsqldb_default_table_type = "hsqldb.default_table_type";
    public static final String hsqldb_defrag_limit = "hsqldb.defrag_limit";
    private static final String hsqldb_files_readonly = "hsqldb.files_readonly";
    public static final String hsqldb_log_size = "hsqldb.log_size";
    public static final String hsqldb_nio_data_file = "hsqldb.nio_data_file";
    public static final String hsqldb_max_nio_scale = "hsqldb.max_nio_scale";
    public static final String hsqldb_raf_buffer_scale = "hsqldb.raf_buffer_scale";
    private static final String hsqldb_original_version = "hsqldb.original_version";
    public static final String hsqldb_script_format = "hsqldb.script_format";
    private static final String sql_compare_in_locale = "sql.compare_in_locale";
    private static final String sql_enforce_strict_size = "sql.enforce_strict_size";
    public static final String sql_tx_no_multi_write = "sql.tx_no_multi_rewrite";
    public static final String textdb_cache_scale = "textdb.cache_scale";
    public static final String textdb_cache_size_scale = "textdb.cache_size_scale";
    public static final String textdb_all_quoted = "textdb.all_quoted";
    public static final String textdb_allow_full_path = "textdb.allow_full_path";
    public static final String textdb_encoding = "textdb.encoding";
    public static final String textdb_ignore_first = "textdb.ignore_first";
    public static final String textdb_quoted = "textdb.quoted";
    public static final String textdb_fs = "textdb.fs";
    public static final String textdb_vs = "textdb.vs";
    public static final String textdb_lvs = "textdb.lvs";
    private Database database;

    public HsqlDatabaseProperties(Database db) {
        super(db.getPath(), db.getFileAccess(), db.isFilesInJar());
        this.database = db;
        this.setProperty(sql_enforce_strict_size, false);
        this.setProperty(db_version, "1.8.0");
        this.setProperty(hsqldb_compatible_version, "1.8.0");
        this.setProperty(hsqldb_cache_version, VERSION_STRING_1_7_0);
        this.setProperty(hsqldb_original_version, "1.8.0");
        this.setProperty(runtime_gc_interval, 0);
        this.setProperty(hsqldb_cache_file_scale, 1);
        this.setProperty(hsqldb_cache_size_scale, 8);
        this.setProperty(hsqldb_cache_scale, 14);
        this.setProperty(hsqldb_log_size, 200);
        this.setProperty(hsqldb_script_format, 0);
        this.setProperty(db_readonly, false);
        this.setProperty(db_modified, MODIFIED_NEW);
        this.setProperty(hsqldb_nio_data_file, true);
        this.setProperty(hsqldb_default_table_type, "memory");
        if (db.isStoredFileAccess()) {
            this.setProperty(hsqldb_default_table_type, "cached");
            this.setProperty(hsqldb_cache_scale, 13);
            this.setProperty(hsqldb_log_size, 10);
            this.setProperty(sql_enforce_strict_size, true);
            this.setProperty(hsqldb_nio_data_file, false);
        }
    }

    public boolean load() throws HsqlException {
        boolean exists;
        if (!DatabaseURL.isFileBasedDatabaseType(this.database.getType())) {
            return true;
        }
        try {
            exists = super.load();
        }
        catch (Exception e) {
            throw Trace.error(29, 116, new Object[]{this.fileName, e});
        }
        if (!exists) {
            return false;
        }
        this.filterLoadedProperties();
        String version = this.getProperty(hsqldb_compatible_version);
        int check = version.substring(0, 5).compareTo("1.8.0");
        Trace.check(check <= 0, 30);
        version = this.getProperty(db_version);
        if (version.charAt(2) == '6') {
            this.setProperty(hsqldb_cache_version, "1.6.0");
        }
        JavaSystem.gcFrequency = this.getIntegerProperty(runtime_gc_interval, 0);
        return true;
    }

    public void setDatabaseVariables() {
        if (this.isPropertyTrue(db_readonly)) {
            this.database.setReadOnly();
        }
        if (this.isPropertyTrue(hsqldb_files_readonly)) {
            this.database.setFilesReadOnly();
        }
        this.database.sqlEnforceStrictSize = this.isPropertyTrue(sql_enforce_strict_size);
        if (this.isPropertyTrue(sql_compare_in_locale)) {
            this.stringProps.remove(sql_compare_in_locale);
            this.database.collation.setCollationAsLocale();
        }
        this.database.txManager.setReWriteProtection(this.isPropertyTrue(sql_tx_no_multi_write));
        this.database.setMetaDirty(false);
    }

    public void save() throws HsqlException {
        if (!DatabaseURL.isFileBasedDatabaseType(this.database.getType()) || this.database.isFilesReadOnly() || this.database.isFilesInJar()) {
            return;
        }
        try {
            super.save(this.fileName + ".properties" + ".new");
            this.fa.renameElement(this.fileName + ".properties" + ".new", this.fileName + ".properties");
        }
        catch (Exception e) {
            this.database.logger.appLog.logContext(SimpleLog.LOG_ERROR, "failed");
            throw Trace.error(29, 116, new Object[]{this.fileName, e});
        }
    }

    void filterLoadedProperties() {
        Enumeration<?> en = this.stringProps.propertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            boolean accept = meta.containsKey(key);
            if (accept) continue;
            this.stringProps.remove(key);
        }
    }

    public void setURLProperties(HsqlProperties p) {
        if (p != null) {
            Enumeration e = p.propertyNames();
            while (e.hasMoreElements()) {
                String propertyName = (String)e.nextElement();
                Object[] row = (Object[])meta.get(propertyName);
                if (row == null || !db_readonly.equals(propertyName) && (Integer)row[1] != 0) continue;
                this.setProperty(propertyName, p.getProperty(propertyName));
            }
        }
    }

    public Set getUserDefinedPropertyData() {
        HashSet set = new HashSet();
        Iterator it = meta.values().iterator();
        while (it.hasNext()) {
            Object[] row = (Object[])it.next();
            if ((Integer)row[1] != 0) continue;
            set.add(row);
        }
        return set;
    }

    public boolean isUserDefinedProperty(String key) {
        Object[] row = (Object[])meta.get(key);
        return row != null && (Integer)row[1] == 0;
    }

    public boolean isBoolean(String key) {
        Object[] row = (Object[])meta.get(key);
        return row != null && row[2].equals("boolean") && (Integer)row[1] == 0;
    }

    public boolean isIntegral(String key) {
        Object[] row = (Object[])meta.get(key);
        return row != null && row[2].equals("int") && (Integer)row[1] == 0;
    }

    public boolean isString(String key) {
        Object[] row = (Object[])meta.get(key);
        return row != null && row[2].equals("java.lang.String") && (Integer)row[1] == 0;
    }

    public String setDatabaseProperty(String key, String value) throws HsqlException {
        Object[] row = (Object[])meta.get(key);
        value = super.setProperty(key, value);
        return value;
    }

    public int getDefaultWriteDelay() {
        return this.database.isStoredFileAccess() ? 2000 : 10000;
    }

    public void setDBModified(int mode) throws HsqlException {
        String value = MODIFIED_NO;
        if (mode == 1) {
            value = MODIFIED_YES;
        } else if (mode == 2) {
            value = MODIFIED_NEW;
        }
        this.setProperty(db_modified, value);
        this.save();
    }

    public int getDBModified() throws HsqlException {
        String value = this.getProperty(db_modified);
        if (MODIFIED_YES.equals(value)) {
            return 1;
        }
        if (MODIFIED_NEW.equals(value)) {
            return 2;
        }
        return 0;
    }

    private static Object[] getMeta(String name, int accessLevel, String defaultValue) {
        Object[] row = new Object[8];
        row[0] = name;
        row[1] = ValuePool.getInt(accessLevel);
        row[2] = "java.lang.String";
        row[4] = defaultValue;
        return row;
    }

    private static Object[] getMeta(String name, int accessLevel, boolean defaultValue) {
        Object[] row = new Object[8];
        row[0] = name;
        row[1] = ValuePool.getInt(accessLevel);
        row[2] = "boolean";
        row[4] = defaultValue ? Boolean.TRUE : Boolean.FALSE;
        return row;
    }

    private static Object[] getMeta(String name, int accessLevel, int defaultValue, byte[] values) {
        Object[] row = new Object[8];
        row[0] = name;
        row[1] = ValuePool.getInt(accessLevel);
        row[2] = "int";
        row[4] = ValuePool.getInt(defaultValue);
        row[7] = values;
        return row;
    }

    private static Object[] getMeta(String name, int accessLevel, int defaultValue, int rangeLow, int rangeHigh) {
        Object[] row = new Object[8];
        row[0] = name;
        row[1] = ValuePool.getInt(accessLevel);
        row[2] = "int";
        row[4] = ValuePool.getInt(defaultValue);
        row[3] = Boolean.TRUE;
        row[5] = ValuePool.getInt(rangeLow);
        row[6] = ValuePool.getInt(rangeHigh);
        return row;
    }

    static {
        meta.put(db_version, HsqlDatabaseProperties.getMeta(db_version, 2, null));
        meta.put(hsqldb_compatible_version, HsqlDatabaseProperties.getMeta(hsqldb_compatible_version, 2, null));
        meta.put(hsqldb_cache_version, HsqlDatabaseProperties.getMeta(hsqldb_cache_version, 2, null));
        meta.put(hsqldb_original_version, HsqlDatabaseProperties.getMeta(hsqldb_original_version, 2, null));
        meta.put(db_modified, HsqlDatabaseProperties.getMeta(db_modified, 2, null));
        meta.put(hsqldb_default_table_type, HsqlDatabaseProperties.getMeta(hsqldb_default_table_type, 0, "memory"));
        meta.put(textdb_fs, HsqlDatabaseProperties.getMeta(textdb_fs, 0, ","));
        meta.put(textdb_vs, HsqlDatabaseProperties.getMeta(textdb_vs, 0, null));
        meta.put(textdb_lvs, HsqlDatabaseProperties.getMeta(textdb_lvs, 0, null));
        meta.put(textdb_encoding, HsqlDatabaseProperties.getMeta(textdb_encoding, 0, null));
        meta.put(db_readonly, HsqlDatabaseProperties.getMeta(db_readonly, 2, false));
        meta.put(hsqldb_files_readonly, HsqlDatabaseProperties.getMeta(hsqldb_files_readonly, 2, false));
        meta.put(textdb_allow_full_path, HsqlDatabaseProperties.getMeta(textdb_allow_full_path, 2, false));
        meta.put(hsqldb_nio_data_file, HsqlDatabaseProperties.getMeta(hsqldb_nio_data_file, 0, false));
        meta.put(hsqldb_catalogs, HsqlDatabaseProperties.getMeta(hsqldb_catalogs, 0, false));
        meta.put(sql_enforce_strict_size, HsqlDatabaseProperties.getMeta(sql_enforce_strict_size, 0, false));
        meta.put(sql_tx_no_multi_write, HsqlDatabaseProperties.getMeta(sql_tx_no_multi_write, 0, false));
        meta.put(textdb_quoted, HsqlDatabaseProperties.getMeta(textdb_quoted, 0, false));
        meta.put(textdb_all_quoted, HsqlDatabaseProperties.getMeta(textdb_all_quoted, 0, false));
        meta.put(textdb_ignore_first, HsqlDatabaseProperties.getMeta(textdb_ignore_first, 0, false));
        meta.put(hsqldb_applog, HsqlDatabaseProperties.getMeta(hsqldb_applog, 0, 0, new byte[]{0, 1, 2}));
        meta.put(hsqldb_cache_file_scale, HsqlDatabaseProperties.getMeta(hsqldb_cache_file_scale, 0, 1, new byte[]{1, 8}));
        meta.put(hsqldb_script_format, HsqlDatabaseProperties.getMeta(hsqldb_script_format, 0, 0, new byte[]{0, 1, 3}));
        meta.put(hsqldb_log_size, HsqlDatabaseProperties.getMeta(hsqldb_log_size, 1, 0, 0, 16000));
        meta.put(hsqldb_defrag_limit, HsqlDatabaseProperties.getMeta(hsqldb_defrag_limit, 1, 200, 0, 16000));
        meta.put(runtime_gc_interval, HsqlDatabaseProperties.getMeta(runtime_gc_interval, 0, 0, 0, 1000000));
        meta.put(hsqldb_cache_free_count_scale, HsqlDatabaseProperties.getMeta(hsqldb_cache_free_count_scale, 0, 9, 6, 12));
        meta.put(hsqldb_cache_scale, HsqlDatabaseProperties.getMeta(hsqldb_cache_scale, 0, 14, 8, 18));
        meta.put(hsqldb_cache_size_scale, HsqlDatabaseProperties.getMeta(hsqldb_cache_size_scale, 0, 10, 6, 20));
        meta.put(hsqldb_max_nio_scale, HsqlDatabaseProperties.getMeta(hsqldb_max_nio_scale, 0, 28, 24, 31));
        meta.put(hsqldb_raf_buffer_scale, HsqlDatabaseProperties.getMeta(hsqldb_raf_buffer_scale, 0, 12, 8, 13));
        meta.put(textdb_cache_scale, HsqlDatabaseProperties.getMeta(textdb_cache_scale, 0, 10, 8, 16));
        meta.put(textdb_cache_size_scale, HsqlDatabaseProperties.getMeta(textdb_cache_size_scale, 0, 10, 6, 20));
    }
}

