/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.Date;
import org.hsqldb.lib.HsqlArrayHeap;
import org.hsqldb.lib.HsqlThreadFactory;
import org.hsqldb.lib.ObjectComparator;
import org.hsqldb.lib.ThreadFactory;

public class HsqlTimer
implements ObjectComparator {
    protected final TaskQueue taskQueue = new TaskQueue(16, this);
    protected final TaskRunner taskRunner = new TaskRunner();
    protected Thread taskRunnerThread;
    protected ThreadFactory threadFactory;
    static int nowCount = 0;

    public HsqlTimer() {
        this(null);
    }

    public HsqlTimer(ThreadFactory tf) {
        this.threadFactory = new HsqlThreadFactory(tf);
    }

    public int compare(Object a, Object b) {
        long awhen = ((Task)a).getNextScheduled();
        long bwhen = ((Task)b).getNextScheduled();
        return (int)(awhen - bwhen);
    }

    public synchronized Thread getThread() {
        return this.taskRunnerThread;
    }

    public synchronized void restart() {
        if (this.taskRunnerThread == null) {
            this.taskRunnerThread = this.threadFactory.newThread(this.taskRunner);
            this.taskRunnerThread.setName("HSQLDB Timer @" + Integer.toHexString(this.hashCode()));
            this.taskRunnerThread.setDaemon(true);
            this.taskRunnerThread.start();
        } else {
            this.notify();
        }
    }

    public Object scheduleAfter(long delay, Runnable r) {
        return this.addTask(HsqlTimer.now() + delay, r, 0L, false);
    }

    public Object scheduleAt(Date date, Runnable r) {
        return this.addTask(date.getTime(), r, -1L, false);
    }

    public Object schedulePeriodicallyAt(Date date, long p, Runnable r, boolean relative) {
        if (p <= 0L) {
            throw new IllegalArgumentException();
        }
        return this.addTask(date.getTime(), r, p, relative);
    }

    public Object schedulePeriodicallyAfter(long delay, long p, Runnable r, boolean relative) {
        if (p <= 0L) {
            throw new IllegalArgumentException();
        }
        return this.addTask(HsqlTimer.now() + delay, r, p, relative);
    }

    public synchronized void shutDown() {
        this.taskQueue.clear();
        if (this.taskRunnerThread != null) {
            this.taskRunnerThread.interrupt();
        }
        this.taskRunnerThread = null;
    }

    public static void cancel(Object task) throws ClassCastException {
        if (task != null) {
            ((Task)task).cancel();
        }
    }

    public static boolean isCancelled(Object task) throws ClassCastException {
        return task == null ? true : ((Task)task).isCancelled();
    }

    public static boolean isFixedRate(Object task) throws ClassCastException {
        return task == null ? false : ((Task)task).relative && ((Task)task).period > 0L;
    }

    public static boolean isFixedDelay(Object task) throws ClassCastException {
        return task == null ? false : !((Task)task).relative && ((Task)task).period > 0L;
    }

    public static boolean isPeriodic(Object task) throws ClassCastException {
        return task == null ? false : ((Task)task).period != 0L;
    }

    public static Date getLastScheduled(Object task) throws ClassCastException {
        long last = task == null ? 0L : ((Task)task).getLastScheduled();
        return last == 0L ? null : new Date(last);
    }

    public static void setPeriod(Object task, long period) throws ClassCastException {
        if (task == null) {
            return;
        }
        ((Task)task).setPeriod(period);
    }

    public static Date getNextScheduled(Object task) throws ClassCastException {
        return HsqlTimer.isCancelled(task) ? null : new Date(((Task)task).getNextScheduled());
    }

    protected Task addTask(long n, Runnable r, long p, boolean b) {
        Task task = new Task(n, r, p, b);
        this.taskQueue.add(task);
        this.restart();
        return task;
    }

    protected synchronized void clearThread() {
        this.taskRunnerThread = null;
    }

    protected synchronized Task nextTask() {
        try {
            while (!Thread.interrupted()) {
                Task task = (Task)this.taskQueue.peek();
                if (task == null) {
                    this.wait();
                    continue;
                }
                long now = HsqlTimer.now();
                long next = task.getNextScheduled();
                if (next > now) {
                    this.wait(next - now);
                    continue;
                }
                task = (Task)this.taskQueue.remove();
                if (task == null || task.isCancelled()) continue;
                long period = task.period;
                if (period > 0L) {
                    long late;
                    now = HsqlTimer.now();
                    if (task.relative && (late = now - next) > 0L) {
                        period -= late;
                    }
                    next = now + period;
                    task.setNextScheduled(next);
                    this.taskQueue.add(task);
                }
                return task;
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return null;
    }

    private static long now() {
        ++nowCount;
        return System.currentTimeMillis();
    }

    protected class TaskQueue
    extends HsqlArrayHeap {
        TaskQueue(int capacity, ObjectComparator oc) {
            super(capacity, oc);
        }

        public synchronized void clear() {
            for (int i = 0; i < this.count; ++i) {
                ((Task)this.heap[i]).cancel();
                this.heap[i] = null;
            }
            this.count = 0;
        }
    }

    protected class Task {
        final Runnable runnable;
        long period;
        private long last = 0L;
        private long next;
        private boolean cancelled = false;
        private Object cancel_mutex = new Object();
        final boolean relative;

        Task(long n, Runnable r, long p, boolean b) {
            this.next = n;
            this.runnable = r;
            this.period = p;
            this.relative = b;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancel() {
            Object object = this.cancel_mutex;
            synchronized (object) {
                this.cancelled = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isCancelled() {
            Object object = this.cancel_mutex;
            synchronized (object) {
                return this.cancelled;
            }
        }

        synchronized long getLastScheduled() {
            return this.last;
        }

        synchronized void setLastScheduled(long l) {
            this.last = l;
        }

        synchronized long getNextScheduled() {
            return this.next;
        }

        synchronized void setNextScheduled(long n) {
            this.next = n;
        }

        synchronized void setPeriod(long n) {
            this.period = n;
        }
    }

    protected class TaskRunner
    implements Runnable {
        protected TaskRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Task task;
                while ((task = HsqlTimer.this.nextTask()) != null) {
                    task.setLastScheduled(HsqlTimer.now());
                    task.runnable.run();
                }
            }
            finally {
                HsqlTimer.this.clearThread();
            }
        }
    }
}

