/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.lang.reflect.Array;
import org.hsqldb.lib.IntValueHashMap;

public class ArrayUtil {
    public static final int CLASS_CODE_BYTE = 66;
    public static final int CLASS_CODE_CHAR = 67;
    public static final int CLASS_CODE_DOUBLE = 68;
    public static final int CLASS_CODE_FLOAT = 70;
    public static final int CLASS_CODE_INT = 73;
    public static final int CLASS_CODE_LONG = 74;
    public static final int CLASS_CODE_OBJECT = 76;
    public static final int CLASS_CODE_SHORT = 83;
    public static final int CLASS_CODE_BOOLEAN = 90;
    private static IntValueHashMap classCodeMap = new IntValueHashMap();

    static int getClassCode(Class cla) {
        if (!cla.isPrimitive()) {
            return 76;
        }
        return classCodeMap.get((Object)cla, -1);
    }

    public static void clearArray(int type, Object data, int from, int to) {
        switch (type) {
            case 66: {
                byte[] array = (byte[])data;
                while (--to >= from) {
                    array[to] = 0;
                }
                return;
            }
            case 67: {
                byte[] array = (byte[])data;
                while (--to >= from) {
                    array[to] = 0;
                }
                return;
            }
            case 83: {
                short[] array = (short[])data;
                while (--to >= from) {
                    array[to] = 0;
                }
                return;
            }
            case 73: {
                int[] array = (int[])data;
                while (--to >= from) {
                    array[to] = 0;
                }
                return;
            }
            case 74: {
                long[] array = (long[])data;
                while (--to >= from) {
                    array[to] = 0L;
                }
                return;
            }
            case 70: {
                float[] array = (float[])data;
                while (--to >= from) {
                    array[to] = 0.0f;
                }
                return;
            }
            case 68: {
                double[] array = (double[])data;
                while (--to >= from) {
                    array[to] = 0.0;
                }
                return;
            }
            case 90: {
                boolean[] array = (boolean[])data;
                while (--to >= from) {
                    array[to] = false;
                }
                return;
            }
        }
        Object[] array = (Object[])data;
        while (--to >= from) {
            array[to] = null;
        }
    }

    public static void adjustArray(int type, Object array, int usedElements, int index, int count) {
        int size;
        int target;
        int source;
        if (index >= usedElements) {
            return;
        }
        int newCount = usedElements + count;
        if (count >= 0) {
            source = index;
            target = index + count;
            size = usedElements - index;
        } else {
            source = index - count;
            target = index;
            size = usedElements - index + count;
        }
        if (size > 0) {
            System.arraycopy(array, source, array, target, size);
        }
        if (count < 0) {
            ArrayUtil.clearArray(type, array, newCount, usedElements);
        }
    }

    public static void sortArray(int[] array) {
        boolean swapped;
        do {
            swapped = false;
            for (int i = 0; i < array.length - 1; ++i) {
                if (array[i] <= array[i + 1]) continue;
                int temp = array[i + 1];
                array[i + 1] = array[i];
                array[i] = temp;
                swapped = true;
            }
        } while (swapped);
    }

    public static int find(Object[] array, Object object) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == object) {
                return i;
            }
            if (object == null || !object.equals(array[i])) continue;
            return i;
        }
        return -1;
    }

    public static int find(int[] array, int value) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static int findNot(int[] array, int value) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == value) continue;
            return i;
        }
        return -1;
    }

    public static boolean areEqualSets(int[] arra, int[] arrb) {
        return arra.length == arrb.length && ArrayUtil.haveEqualSets(arra, arrb, arra.length);
    }

    public static boolean areEqual(int[] arra, int[] arrb, int count, boolean full) {
        if (ArrayUtil.haveEqualArrays(arra, arrb, count)) {
            if (full) {
                return arra.length == arrb.length && count == arra.length;
            }
            return true;
        }
        return false;
    }

    public static boolean haveEqualSets(int[] arra, int[] arrb, int count) {
        if (count > arra.length || count > arrb.length) {
            return false;
        }
        if (count == 1) {
            return arra[0] == arrb[0];
        }
        int[] tempa = (int[])ArrayUtil.resizeArray(arra, count);
        int[] tempb = (int[])ArrayUtil.resizeArray(arrb, count);
        ArrayUtil.sortArray(tempa);
        ArrayUtil.sortArray(tempb);
        for (int j = 0; j < count; ++j) {
            if (tempa[j] == tempb[j]) continue;
            return false;
        }
        return true;
    }

    public static boolean haveEqualArrays(int[] arra, int[] arrb, int count) {
        if (count > arra.length || count > arrb.length) {
            return false;
        }
        for (int j = 0; j < count; ++j) {
            if (arra[j] == arrb[j]) continue;
            return false;
        }
        return true;
    }

    public static boolean haveEqualArrays(Object[] arra, Object[] arrb, int count) {
        if (count > arra.length || count > arrb.length) {
            return false;
        }
        for (int j = 0; j < count; ++j) {
            if (arra[j] == arrb[j] || arra[j] != null && arra[j].equals(arrb[j])) continue;
            return false;
        }
        return true;
    }

    public static boolean haveCommonElement(int[] arra, int[] arrb, int bcount) {
        for (int i = 0; i < arra.length; ++i) {
            int c = arra[i];
            for (int j = 0; j < bcount; ++j) {
                if (c != arrb[j]) continue;
                return true;
            }
        }
        return false;
    }

    public static int[] commonElements(int[] arra, int[] arrb) {
        int[] c = null;
        int n = ArrayUtil.countCommonElements(arra, arrb);
        if (n > 0) {
            c = new int[n];
            int k = 0;
            for (int i = 0; i < arra.length; ++i) {
                for (int j = 0; j < arrb.length; ++j) {
                    if (arra[i] != arrb[j]) continue;
                    c[k++] = arra[i];
                }
            }
        }
        return c;
    }

    public static int countCommonElements(int[] arra, int[] arrb) {
        int k = 0;
        for (int i = 0; i < arra.length; ++i) {
            for (int j = 0; j < arrb.length; ++j) {
                if (arra[i] != arrb[j]) continue;
                ++k;
            }
        }
        return k;
    }

    public static int countSameElements(byte[] arra, int start, byte[] arrb) {
        int k = 0;
        int limit = arra.length - start;
        if (limit > arrb.length) {
            limit = arrb.length;
        }
        for (int i = 0; i < limit && arra[i + start] == arrb[i]; ++i) {
            ++k;
        }
        return k;
    }

    public static int find(byte[] arra, int start, int limit, byte[] arrb) {
        limit = limit - arrb.length + 1;
        byte value = arrb[0];
        for (int k = 0; k < limit; ++k) {
            if (arra[k] != value) continue;
            if (arrb.length == 1) {
                return k;
            }
            if (!ArrayUtil.containsAt(arra, k, arrb)) continue;
            return k;
        }
        return -1;
    }

    public static int findNotIn(byte[] arra, int start, int limit, byte[] charset) {
        int k = 0;
        if (k < limit) {
            for (int i = 0; i < charset.length; ++i) {
                if (arra[k] != charset[i]) continue;
            }
            return k;
        }
        return -1;
    }

    public static int findIn(byte[] arra, int start, int limit, byte[] charset) {
        for (int k = 0; k < limit; ++k) {
            for (int i = 0; i < charset.length; ++i) {
                if (arra[k] != charset[i]) continue;
                return k;
            }
        }
        return -1;
    }

    public static int find(byte[] arra, int start, int limit, int b, int c) {
        for (int k = 0; k < limit; ++k) {
            if (arra[k] != b && arra[k] != c) continue;
            return k;
        }
        return -1;
    }

    public static void intIndexesToBooleanArray(int[] arra, boolean[] arrb) {
        boolean k = false;
        for (int i = 0; i < arra.length; ++i) {
            if (arra[i] >= arrb.length) continue;
            arrb[arra[i]] = true;
        }
    }

    public static boolean containsAllTrueElements(boolean[] arra, boolean[] arrb) {
        for (int i = 0; i < arra.length; ++i) {
            if (!arrb[i] || arra[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAt(byte[] arra, int start, byte[] arrb) {
        return ArrayUtil.countSameElements(arra, start, arrb) == arrb.length;
    }

    public static int countStartElementsAt(byte[] arra, int start, byte[] arrb) {
        int k = 0;
        block0: for (int i = start; i < arra.length; ++i) {
            for (int j = 0; j < arrb.length; ++j) {
                if (arra[i] != arrb[j]) continue;
                ++k;
                continue block0;
            }
        }
        return k;
    }

    public static int countNonStartElementsAt(byte[] arra, int start, byte[] arrb) {
        int k = 0;
        block0: for (int i = start; i < arra.length; ++i) {
            for (int j = 0; j < arrb.length; ++j) {
                if (arra[i] == arrb[j]) break block0;
            }
            ++k;
        }
        return k;
    }

    public static void copyArray(Object source, Object dest, int count) {
        System.arraycopy(source, 0, dest, 0, count);
    }

    public static int[] arraySlice(int[] source, int start, int count) {
        int[] slice = new int[count];
        System.arraycopy(source, start, slice, 0, count);
        return slice;
    }

    public static void fillArray(Object[] array, Object value) {
        int to = array.length;
        while (--to >= 0) {
            array[to] = value;
        }
    }

    public static void fillArray(int[] array, int value) {
        int to = array.length;
        while (--to >= 0) {
            array[to] = value;
        }
    }

    public static Object duplicateArray(Object source) {
        int size = Array.getLength(source);
        Object newarray = Array.newInstance(source.getClass().getComponentType(), size);
        System.arraycopy(source, 0, newarray, 0, size);
        return newarray;
    }

    public static Object resizeArrayIfDifferent(Object source, int newsize) {
        int oldsize = Array.getLength(source);
        if (oldsize == newsize) {
            return source;
        }
        Object newarray = Array.newInstance(source.getClass().getComponentType(), newsize);
        if (oldsize < newsize) {
            newsize = oldsize;
        }
        System.arraycopy(source, 0, newarray, 0, newsize);
        return newarray;
    }

    public static Object resizeArray(Object source, int newsize) {
        Object newarray = Array.newInstance(source.getClass().getComponentType(), newsize);
        int oldsize = Array.getLength(source);
        if (oldsize < newsize) {
            newsize = oldsize;
        }
        System.arraycopy(source, 0, newarray, 0, newsize);
        return newarray;
    }

    public static Object toAdjustedArray(Object source, Object addition, int colindex, int adjust) {
        int newsize = Array.getLength(source) + adjust;
        Object newarray = Array.newInstance(source.getClass().getComponentType(), newsize);
        ArrayUtil.copyAdjustArray(source, newarray, addition, colindex, adjust);
        return newarray;
    }

    public static void copyAdjustArray(Object source, Object dest, Object addition, int colindex, int adjust) {
        int length = Array.getLength(source);
        if (colindex < 0) {
            System.arraycopy(source, 0, dest, 0, length);
            return;
        }
        System.arraycopy(source, 0, dest, 0, colindex);
        if (adjust == 0) {
            int endcount = length - colindex - 1;
            Array.set(dest, colindex, addition);
            if (endcount > 0) {
                System.arraycopy(source, colindex + 1, dest, colindex + 1, endcount);
            }
        } else if (adjust < 0) {
            int endcount = length - colindex - 1;
            if (endcount > 0) {
                System.arraycopy(source, colindex + 1, dest, colindex, endcount);
            }
        } else {
            int endcount = length - colindex;
            Array.set(dest, colindex, addition);
            if (endcount > 0) {
                System.arraycopy(source, colindex, dest, colindex + 1, endcount);
            }
        }
    }

    public static int[] toAdjustedColumnArray(int[] colarr, int colindex, int adjust) {
        if (colarr == null) {
            return null;
        }
        int[] intarr = new int[colarr.length];
        int j = 0;
        for (int i = 0; i < colarr.length; ++i) {
            if (colarr[i] > colindex) {
                intarr[j] = colarr[i] + adjust;
                ++j;
                continue;
            }
            if (colarr[i] == colindex) {
                if (adjust < 0) continue;
                intarr[j] = colarr[i] + adjust;
                ++j;
                continue;
            }
            intarr[j] = colarr[i];
            ++j;
        }
        if (colarr.length != j) {
            int[] newarr = new int[j];
            ArrayUtil.copyArray(intarr, newarr, j);
            return newarr;
        }
        return intarr;
    }

    public static void copyColumnValues(Object[] row, int[] colindex, Object[] colobject) {
        for (int i = 0; i < colindex.length; ++i) {
            colobject[i] = row[colindex[i]];
        }
    }

    public static void copyColumnValues(int[] row, int[] colindex, int[] colobject) {
        for (int i = 0; i < colindex.length; ++i) {
            colobject[i] = row[colindex[i]];
        }
    }

    public static void fillSequence(int[] colindex) {
        for (int i = 0; i < colindex.length; ++i) {
            colindex[i] = i;
        }
    }

    static {
        classCodeMap.put(Byte.TYPE, 66);
        classCodeMap.put(Character.TYPE, 83);
        classCodeMap.put(Short.TYPE, 83);
        classCodeMap.put(Integer.TYPE, 73);
        classCodeMap.put(Long.TYPE, 74);
        classCodeMap.put(Float.TYPE, 70);
        classCodeMap.put(Double.TYPE, 68);
        classCodeMap.put(Boolean.TYPE, 90);
        classCodeMap.put(Object.class, 76);
    }
}

