/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.GrantConstants;
import org.hsqldb.Grantee;
import org.hsqldb.GranteeManager;
import org.hsqldb.HsqlException;
import org.hsqldb.SchemaManager;
import org.hsqldb.Session;
import org.hsqldb.Trace;
import org.hsqldb.User;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;

class UserManager
implements GrantConstants {
    User sysUser = null;
    private HashMappedList userList;
    private GranteeManager granteeManager;

    UserManager(Database database) throws HsqlException {
        this.granteeManager = database.getGranteeManager();
        this.userList = new HashMappedList();
        this.createUser("PUBLIC", null);
        this.sysUser = this.createUser("_SYSTEM", null);
        this.sysUser.getGrantee().setAdminDirect();
    }

    User createUser(String name, String password) throws HsqlException {
        if (name == null) {
            Trace.doAssert(false, Trace.getMessage(236));
        }
        Grantee g = this.granteeManager.addGrantee(name);
        User u = new User(name, password, g);
        if ("_SYSTEM".equals(name)) {
            return u;
        }
        boolean success = this.userList.add(name, u);
        if (!success) {
            throw Trace.error(36, name);
        }
        return u;
    }

    void dropUser(String name) throws HsqlException {
        boolean reservedUser = GranteeManager.isReserved(name);
        Trace.check(!reservedUser, 231, name);
        boolean result = this.granteeManager.removeGrantee(name);
        Trace.check(result, 232, name);
        User u = (User)this.userList.remove(name);
        Trace.check(u != null, 37, name);
    }

    User getUser(String name, String password) throws HsqlException {
        if (name == null) {
            name = "";
        }
        if (password == null) {
            password = "";
        }
        if (name.equals("PUBLIC")) {
            throw Trace.error(33);
        }
        name = name.toUpperCase();
        password = password.toUpperCase();
        User u = this.get(name);
        u.checkPassword(password);
        return u;
    }

    HashMappedList getUsers() {
        return this.userList;
    }

    boolean exists(String name) {
        return this.userList.get(name) != null;
    }

    User get(String name) throws HsqlException {
        User u = (User)this.userList.get(name);
        if (u == null) {
            throw Trace.error(37, name);
        }
        return u;
    }

    HsqlArrayList listVisibleUsers(Session session, boolean andPublicUser) {
        HsqlArrayList list = new HsqlArrayList();
        boolean isAdmin = session.isAdmin();
        String sessName = session.getUsername();
        if (this.userList == null || this.userList.size() == 0) {
            return list;
        }
        for (int i = 0; i < this.userList.size(); ++i) {
            User user = (User)this.userList.get(i);
            if (user == null) continue;
            String userName = user.getName();
            if ("PUBLIC".equals(userName)) {
                if (!andPublicUser) continue;
                list.add(user);
                continue;
            }
            if (isAdmin) {
                list.add(user);
                continue;
            }
            if (!sessName.equals(userName)) continue;
            list.add(user);
        }
        return list;
    }

    static String[] getRightsArray(int rights) {
        return GranteeManager.getRightsArray(rights);
    }

    void removeDbObject(Object dbobject) {
        this.granteeManager.removeDbObject(dbobject);
    }

    User getSysUser() {
        return this.sysUser;
    }

    public synchronized void removeSchemaReference(SchemaManager.Schema schema) {
        for (int i = 0; i < this.userList.size(); ++i) {
            User user = (User)this.userList.get(i);
            if (user.getInitialSchema() != schema.name) continue;
            user.setInitialSchema(null);
        }
    }
}

