/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.CachedRow;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.persist.TextCache;

class TextTable
extends Table {
    private String dataSource = "";
    private boolean isReversed = false;

    TextTable(Database db, HsqlNameManager.HsqlName name, int type) throws HsqlException {
        super(db, name, type);
    }

    private void openCache(String dataSourceNew, boolean isReversedNew, boolean isReadOnlyNew) throws HsqlException {
        if (dataSourceNew == null) {
            dataSourceNew = "";
        }
        this.database.logger.closeTextCache(this);
        this.cache = null;
        this.clearAllRows(null);
        if (dataSourceNew.length() > 0) {
            try {
                this.cache = this.database.logger.openTextCache(this, dataSourceNew, isReadOnlyNew, isReversedNew);
                CachedRow row = null;
                int nextpos = 0;
                if (((TextCache)this.cache).ignoreFirst) {
                    nextpos += ((TextCache)this.cache).readHeaderLine();
                }
                while ((row = (CachedRow)this.rowStore.get(nextpos)) != null) {
                    nextpos = row.getPos() + row.getStorageSize();
                    row.setNewNodes();
                    this.insertFromTextSource(row);
                }
            }
            catch (HsqlException e) {
                int linenumber;
                int n = linenumber = this.cache == null ? 0 : ((TextCache)this.cache).getLineNumber();
                if (!this.dataSource.equals(dataSourceNew) || isReversedNew != this.isReversed || isReadOnlyNew != this.isReadOnly) {
                    this.openCache(this.dataSource, this.isReversed, this.isReadOnly);
                } else {
                    if (this.cache != null) {
                        this.cache.close(false);
                    }
                    this.cache = null;
                    this.dataSource = "";
                    this.isReversed = false;
                }
                throw Trace.error(76, new Object[]{new Integer(linenumber), e.getMessage()});
            }
        }
        this.dataSource = dataSourceNew;
        this.isReversed = isReversedNew && dataSourceNew.length() > 0;
    }

    protected void setDataSource(Session s, String dataSourceNew, boolean isReversedNew, boolean newFile) throws HsqlException {
        if (this.getTableType() != 5) {
            s.checkAdmin();
        }
        dataSourceNew = dataSourceNew.trim();
        if (newFile && FileUtil.exists(dataSourceNew)) {
            throw Trace.error(196, dataSourceNew);
        }
        if (isReversedNew || isReversedNew != this.isReversed || !this.dataSource.equals(dataSourceNew)) {
            this.openCache(dataSourceNew, isReversedNew, this.isReadOnly);
        }
        if (this.isReversed) {
            this.isReadOnly = true;
        }
    }

    protected String getDataSource() {
        return this.dataSource;
    }

    protected boolean isDescDataSource() {
        return this.isReversed;
    }

    public void setHeader(String header) throws HsqlException {
        if (this.cache != null && ((TextCache)this.cache).ignoreFirst) {
            ((TextCache)this.cache).setHeader(header);
            return;
        }
        throw Trace.error(150);
    }

    public String getHeader() {
        String header = this.cache == null ? null : ((TextCache)this.cache).getHeader();
        return header == null ? null : StringConverter.toQuotedString(header, '\"', true);
    }

    void checkDataReadOnly() throws HsqlException {
        if (this.dataSource.length() == 0) {
            throw Trace.error(48);
        }
        if (this.isReadOnly) {
            throw Trace.error(32);
        }
    }

    void setDataReadOnly(boolean value) throws HsqlException {
        if (this.isReversed && value) {
            throw Trace.error(32);
        }
        this.openCache(this.dataSource, this.isReversed, value);
        this.isReadOnly = value;
    }

    boolean isIndexCached() {
        return false;
    }

    protected Table duplicate() throws HsqlException {
        return new TextTable(this.database, this.tableName, this.getTableType());
    }

    void drop() throws HsqlException {
        this.openCache("", false, false);
    }

    void setIndexRoots(String s) throws HsqlException {
    }
}

