/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Column;
import org.hsqldb.Constraint;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Index;
import org.hsqldb.Result;
import org.hsqldb.Row;
import org.hsqldb.Select;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.index.RowIterator;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashSet;

class TableWorks {
    private Table table;
    private Session session;

    TableWorks(Session session, Table table) {
        this.table = table;
        this.session = session;
    }

    Table getTable() {
        return this.table;
    }

    void createForeignKey(int[] fkcol, int[] expcol, HsqlNameManager.HsqlName name, Table mainTable, int deleteAction, int updateAction) throws HsqlException {
        this.table.database.schemaManager.checkConstraintExists(name.name, this.table.getSchemaName(), false);
        if (this.table.getConstraint(name.name) != null) {
            throw Trace.error(60);
        }
        if (this.table.getConstraintForColumns(mainTable, expcol, fkcol) != null) {
            throw Trace.error(60);
        }
        if (mainTable.isTemp() != this.table.isTemp()) {
            throw Trace.error(47);
        }
        boolean isSelf = this.table == mainTable;
        int offset = this.table.database.schemaManager.getTableIndex(this.table);
        boolean isforward = offset != -1 && offset < this.table.database.schemaManager.getTableIndex(mainTable);
        Index exportindex = mainTable.getUniqueConstraintIndexForColumns(expcol);
        if (exportindex == null) {
            throw Trace.error(170, mainTable.getName().statementName);
        }
        Constraint.checkReferencedRows(this.session, this.table, fkcol, exportindex);
        HsqlNameManager.HsqlName iname = this.table.database.nameManager.newAutoName("IDX");
        Index fkindex = this.createIndex(fkcol, iname, false, true, isforward);
        HsqlNameManager.HsqlName pkname = this.table.database.nameManager.newAutoName("REF", name.name);
        if (isSelf) {
            mainTable = this.table;
        }
        Constraint c = new Constraint(pkname, name, mainTable, this.table, expcol, fkcol, exportindex, fkindex, deleteAction, updateAction);
        this.table.addConstraint(c);
        mainTable.addConstraint(new Constraint(pkname, c));
        this.table.database.schemaManager.registerConstraintName(name.name, this.table.getName());
    }

    Index createIndex(int[] col, HsqlNameManager.HsqlName name, boolean unique, boolean constraint, boolean forward) throws HsqlException {
        Index newindex;
        if (this.table.isEmpty(this.session) || this.table.isIndexingMutable()) {
            newindex = this.table.createIndex(this.session, col, name, unique, constraint, forward);
            this.table.database.schemaManager.clearTempTables(this.session, this.table);
        } else {
            Table tn = this.table.moveDefinition(null, null, -1, 0);
            newindex = tn.createIndexStructure(col, name, unique, constraint, forward);
            tn.moveData(this.session, this.table, -1, 0);
            tn.updateConstraintsTables(this.session, this.table, -1, 0);
            int index = this.table.database.schemaManager.getTableIndex(this.table);
            this.table.database.schemaManager.setTable(index, tn);
            this.table = tn;
        }
        this.table.database.schemaManager.clearTempTables(this.session, this.table);
        this.table.database.schemaManager.registerIndexName(newindex.getName().name, this.table.getName());
        this.table.database.schemaManager.recompileViews(this.table);
        return newindex;
    }

    void addPrimaryKey(int[] cols, HsqlNameManager.HsqlName name) throws HsqlException {
        if (name == null) {
            name = this.table.makeSysPKName();
        }
        this.table.database.schemaManager.checkConstraintExists(name.name, this.table.getSchemaName(), false);
        this.addOrDropPrimaryKey(cols, false);
        Constraint newconstraint = new Constraint(name, this.table, this.table.getPrimaryIndex(), 4);
        this.table.addPKConstraint(newconstraint);
        this.table.database.schemaManager.registerConstraintName(name.name, this.table.getName());
    }

    void addOrDropPrimaryKey(int[] cols, boolean identity) throws HsqlException {
        if (cols == null) {
            this.table.checkDropIndex(this.table.getIndexes()[0].getName().name, null, true);
        }
        Table tn = this.table.moveDefinitionPK(cols, identity);
        tn.moveData(this.session, this.table, -1, 0);
        tn.updateConstraintsTables(this.session, this.table, -1, 0);
        int index = this.table.database.schemaManager.getTableIndex(this.table);
        this.table.database.schemaManager.setTable(index, tn);
        this.table = tn;
        this.table.database.schemaManager.recompileViews(this.table);
    }

    void createUniqueConstraint(int[] col, HsqlNameManager.HsqlName name) throws HsqlException {
        this.table.database.schemaManager.checkConstraintExists(name.name, this.table.getSchemaName(), false);
        for (Constraint c : this.table.getConstraints()) {
            if (!c.isEquivalent(col, 2) && !c.getName().name.equals(name.name)) continue;
            throw Trace.error(60);
        }
        HsqlNameManager.HsqlName indexname = this.table.database.nameManager.newAutoName("IDX", name.name);
        Index index = this.createIndex(col, indexname, true, true, false);
        Constraint newconstraint = new Constraint(name, this.table, index, 2);
        this.table.addConstraint(newconstraint);
        this.table.database.schemaManager.registerConstraintName(name.name, this.table.getName());
    }

    void createCheckConstraint(Constraint c, HsqlNameManager.HsqlName name) throws HsqlException {
        this.table.database.schemaManager.checkConstraintExists(name.name, this.table.getSchemaName(), false);
        Expression e = c.core.check;
        e.setLikeOptimised();
        Select s = Expression.getCheckSelect(this.session, this.table, e);
        Result r = s.getResult(this.session, 1);
        c.core.checkFilter = s.tFilter[0];
        c.core.mainTable = this.table;
        if (r.getSize() != 0) {
            throw Trace.error(157);
        }
        e.getDDL();
        c.core.checkFilter.setAsCheckFilter();
        this.table.addConstraint(c);
        this.table.database.schemaManager.registerConstraintName(name.name, this.table.getName());
    }

    void dropIndex(String indexname) throws HsqlException {
        if (this.table.isIndexingMutable()) {
            this.table.dropIndex(this.session, indexname);
        } else {
            int[] removeIndex = new int[]{this.table.getIndexIndex(indexname)};
            Table tn = this.table.moveDefinition(removeIndex, null, -1, 0);
            tn.moveData(this.session, this.table, -1, 0);
            tn.updateConstraintsTables(this.session, this.table, -1, 0);
            int i = this.table.database.schemaManager.getTableIndex(this.table);
            this.table.database.schemaManager.setTable(i, tn);
            this.table = tn;
        }
        this.table.database.schemaManager.removeIndexName(indexname, this.table.getName());
        this.table.database.schemaManager.recompileViews(this.table);
    }

    void retypeColumn(Column column, int colindex) throws HsqlException {
        if (this.table.isText() && !this.table.isEmpty(this.session)) {
            throw Trace.error(73);
        }
        this.table.database.schemaManager.checkColumnIsInView(this.table, this.table.getColumn((int)colindex).columnName.name);
        this.table.checkColumnInCheckConstraint(this.table.getColumn((int)colindex).columnName.name);
        int[] dropIndexes = null;
        Table tn = this.table.moveDefinition(dropIndexes, column, colindex, 0);
        tn.moveData(this.session, this.table, colindex, 0);
        tn.updateConstraintsTables(this.session, this.table, colindex, 0);
        int i = this.table.database.schemaManager.getTableIndex(this.table);
        this.table.database.schemaManager.setTable(i, tn);
        this.table = tn;
        this.table.database.schemaManager.recompileViews(this.table);
    }

    void dropColumn(int colIndex) throws HsqlException {
        Constraint c;
        HsqlNameManager.HsqlName constNameRemove = null;
        if (this.table.isText() && !this.table.isEmpty(this.session)) {
            throw Trace.error(73);
        }
        this.table.database.schemaManager.checkColumnIsInView(this.table, this.table.getColumn((int)colIndex).columnName.name);
        this.table.checkColumnInCheckConstraint(this.table.getColumn((int)colIndex).columnName.name);
        Table tn = this.table;
        int[] dropIndexes = null;
        String colName = tn.getColumn((int)colIndex).columnName.name;
        tn.checkColumnInFKConstraint(colIndex);
        if (this.table.getPrimaryKey().length == 1 && this.table.getPrimaryKey()[0] == colIndex) {
            this.table.checkDropIndex(this.table.getIndex((int)0).getName().name, null, true);
            constNameRemove = this.table.constraintList[0].getName();
            tn = this.table.moveDefinitionPK(null, false);
        }
        if ((c = tn.getUniqueConstraintForColumns(new int[]{colIndex})) != null) {
            Index idx = c.getMainIndex();
            dropIndexes = new int[]{tn.getIndexIndex(idx.getName().name)};
            constNameRemove = c.getName();
        }
        tn = tn.moveDefinition(dropIndexes, null, colIndex, -1);
        tn.moveData(this.session, this.table, colIndex, -1);
        tn.updateConstraintsTables(this.session, this.table, colIndex, -1);
        int i = this.table.database.schemaManager.getTableIndex(this.table);
        this.table.database.schemaManager.setTable(i, tn);
        this.table = tn;
        this.table.database.schemaManager.recompileViews(this.table);
        if (constNameRemove != null) {
            this.table.removeConstraint(constNameRemove.name);
            this.table.database.schemaManager.removeConstraintName(constNameRemove.name, this.table.getName());
        }
    }

    void addColumn(Column column, int colIndex) throws HsqlException {
        if (this.table.isText() && !this.table.isEmpty(this.session)) {
            throw Trace.error(73);
        }
        Table tn = this.table;
        tn = tn.moveDefinition(null, column, colIndex, 1);
        if (column.isPrimaryKey()) {
            tn = tn.moveDefinitionPK(new int[]{colIndex}, true);
        }
        tn.moveData(this.session, this.table, colIndex, 1);
        tn.updateConstraintsTables(this.session, this.table, colIndex, 1);
        int i = this.table.database.schemaManager.getTableIndex(this.table);
        this.table.database.schemaManager.setTable(i, tn);
        this.table = tn;
        this.table.database.schemaManager.recompileViews(this.table);
        if (column.isPrimaryKey()) {
            HsqlNameManager.HsqlName pkNameAdd = tn.makeSysPKName();
            Constraint newconstraint = new Constraint(pkNameAdd, this.table, this.table.getPrimaryIndex(), 4);
            this.table.addConstraint(newconstraint);
            this.table.database.schemaManager.registerConstraintName(pkNameAdd.name, this.table.getName());
        }
    }

    void dropConstraint(String name) throws HsqlException {
        Constraint c = this.table.getConstraint(name);
        if (c == null) {
            throw Trace.error(61, 171, new Object[]{name, this.table.getName().name});
        }
        int ctype = c.getType();
        if (ctype == 1) {
            throw Trace.error(59);
        }
        if (ctype == 4) {
            this.addOrDropPrimaryKey(null, false);
            this.table.removeConstraint(name);
        } else if (ctype == 0) {
            this.dropFKConstraint(c);
        } else if (ctype == 2) {
            HashSet cset = new HashSet();
            cset.add(c);
            this.table.checkDropIndex(c.getMainIndex().getName().name, cset, false);
            this.dropIndex(c.getMainIndex().getName().name);
            this.table.removeConstraint(name);
        } else if (ctype == 3) {
            this.table.removeConstraint(name);
        }
        this.table.database.schemaManager.removeConstraintName(name, this.table.getName());
    }

    void dropFKConstraint(Constraint c) throws HsqlException {
        Index constIndex = c.getRefIndex();
        this.dropIndex(constIndex.getName().name);
        Table mainTable = c.getMain();
        mainTable.removeConstraint(c.getPkName());
        this.table.removeConstraint(c.getFkName());
    }

    void reTypeColumn(Column oldCol, Column newCol) throws HsqlException {
        boolean notallowed = false;
        int oldtype = oldCol.getType();
        int newtype = newCol.getType();
        switch (newtype) {
            case -4: 
            case -3: 
            case -2: 
            case 1111: 
            case 2000: {
                notallowed = newtype != oldtype && !this.table.isEmpty(this.session);
            }
        }
        switch (oldtype) {
            case -4: 
            case -3: 
            case -2: 
            case 1111: 
            case 2000: {
                notallowed = newtype != oldtype && !this.table.isEmpty(this.session);
                break;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                switch (newtype) {
                    case 91: 
                    case 92: 
                    case 93: {
                        notallowed = !this.table.isEmpty(this.session);
                    }
                }
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                switch (newtype) {
                    case -6: 
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        notallowed = !this.table.isEmpty(this.session);
                    }
                }
            }
        }
        if (notallowed) {
            throw Trace.error(95);
        }
        int colIndex = this.table.getColumnNr(oldCol.columnName.name);
        if (this.table.getPrimaryKey().length > 1) {
            if (newCol.isIdentity()) {
                throw Trace.error(24);
            }
            newCol.setPrimaryKey(oldCol.isPrimaryKey());
            if (ArrayUtil.find(this.table.getPrimaryKey(), colIndex) != -1) {
                newCol.setNullable(false);
            }
        } else if (this.table.hasPrimaryKey()) {
            if (oldCol.isPrimaryKey()) {
                newCol.setPrimaryKey(true);
                newCol.setNullable(false);
            } else if (newCol.isPrimaryKey()) {
                throw Trace.error(24);
            }
        } else if (newCol.isPrimaryKey()) {
            throw Trace.error(251);
        }
        if (newtype == oldtype && oldCol.isNullable() == newCol.isNullable() && oldCol.getScale() == newCol.getScale() && oldCol.isIdentity() == newCol.isIdentity() && oldCol.identityIncrement == newCol.identityIncrement && (oldCol.getSize() == newCol.getSize() || oldCol.getSize() < newCol.getSize() && (oldtype == 12 || oldtype == 3 || oldtype == 2))) {
            oldCol.setType(newCol);
            oldCol.setDefaultExpression(newCol.getDefaultExpression());
            this.table.setColumnTypeVars(colIndex);
            this.table.resetDefaultsFlag();
            return;
        }
        this.table.database.schemaManager.checkColumnIsInView(this.table, this.table.getColumn((int)colIndex).columnName.name);
        this.table.checkColumnInCheckConstraint(this.table.getColumn((int)colIndex).columnName.name);
        this.table.checkColumnInFKConstraint(colIndex);
        this.checkConvertColDataType(oldCol, newCol);
        this.retypeColumn(newCol, colIndex);
    }

    void checkConvertColDataType(Column oldCol, Column newCol) throws HsqlException {
        int colIndex = this.table.getColumnNr(oldCol.columnName.name);
        RowIterator it = this.table.getPrimaryIndex().firstRow(this.session);
        while (it.hasNext()) {
            Row row = it.next();
            Object o = row.getData()[colIndex];
            Column.convertObject(this.session, o, newCol.getType(), newCol.getSize(), newCol.getScale());
        }
    }

    void setColNullability(Column column, boolean nullable) throws HsqlException {
        int colIndex = this.table.getColumnNr(column.columnName.name);
        if (nullable) {
            if (column.isPrimaryKey()) {
                throw Trace.error(10);
            }
            this.table.checkColumnInFKConstraint(colIndex, 2);
        } else {
            RowIterator it = this.table.getPrimaryIndex().firstRow(this.session);
            while (it.hasNext()) {
                Row row = it.next();
                Object o = row.getData()[colIndex];
                if (o != null) continue;
                throw Trace.error(10);
            }
        }
        column.setNullable(nullable);
        this.table.setColumnTypeVars(colIndex);
    }

    void setColDefaultExpression(int colIndex, Expression def) throws HsqlException {
        if (def == null) {
            this.table.checkColumnInFKConstraint(colIndex, 4);
        }
        this.table.setDefaultExpression(colIndex, def);
    }
}

