/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hsqldb.DatabaseManager;
import org.hsqldb.DatabaseURL;
import org.hsqldb.HsqlException;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.rowio.RowInputBinary;
import org.hsqldb.rowio.RowOutputBinary;

public class Servlet
extends HttpServlet {
    private static final int BUFFER_SIZE = 256;
    private String dbType;
    private String dbPath;
    private String errorStr;
    private RowOutputBinary rowOut;
    private RowInputBinary rowIn;
    private int iQueries;
    private static long lModified = 0L;

    public void init(ServletConfig config) {
        try {
            super.init(config);
            this.rowOut = new RowOutputBinary(256);
            this.rowIn = new RowInputBinary(this.rowOut);
        }
        catch (ServletException e) {
            this.log(e.toString());
        }
        String dbStr = this.getInitParameter("hsqldb.server.database");
        if (dbStr == null) {
            dbStr = ".";
        }
        String useWebInfStr = this.getInitParameter("hsqldb.server.use_web-inf_path");
        if (!dbStr.equals(".") && "true".equalsIgnoreCase(useWebInfStr)) {
            dbStr = this.getServletContext().getRealPath("/") + "WEB-INF" + dbStr;
        }
        HsqlProperties dbURL = DatabaseURL.parseURL(dbStr, false);
        this.log("Database filename = " + dbStr);
        if (dbURL == null) {
            this.errorStr = "Bad Database name";
        } else {
            this.dbPath = dbURL.getProperty("database");
            this.dbType = dbURL.getProperty("connection_type");
            try {
                DatabaseManager.getDatabase(this.dbType, this.dbPath, dbURL);
            }
            catch (HsqlException e) {
                this.errorStr = e.getMessage();
            }
        }
        this.log(this.errorStr);
        this.log("Initialization completed.");
    }

    protected long getLastModified(HttpServletRequest req) {
        return lModified++;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String query = request.getQueryString();
        if (query == null || query.length() == 0) {
            response.setContentType("text/html");
            response.setHeader("Pragma", "no-cache");
            PrintWriter out = response.getWriter();
            out.println("<html><head><title>HSQL Database Engine Servlet</title>");
            out.println("</head><body><h1>HSQL Database Engine Servlet</h1>");
            out.println("The servlet is running.<p>");
            if (this.errorStr == null) {
                out.println("The database is also running.<p>");
                out.println("Database name: " + this.dbType + this.dbPath + "<p>");
                out.println("Queries processed: " + this.iQueries + "<p>");
            } else {
                out.println("<h2>The database is not running!</h2>");
                out.println("The error message is:<p>");
                out.println(this.errorStr);
            }
            out.println("</body></html>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Servlet servlet = this;
        synchronized (servlet) {
            DataInputStream inStream = null;
            ServletOutputStream outStream = null;
            try {
                Result resultOut;
                inStream = new DataInputStream((InputStream)request.getInputStream());
                Result resultIn = Result.read(this.rowIn, inStream);
                if (resultIn.mode == 65543) {
                    try {
                        Session session = DatabaseManager.newSession(this.dbType, this.dbPath, resultIn.getMainString(), resultIn.getSubString(), null);
                        resultOut = new Result(1);
                        resultOut.sessionID = session.getId();
                    }
                    catch (HsqlException e) {
                        resultOut = new Result(e, null);
                    }
                } else {
                    int dbId = resultIn.databaseID;
                    int sessionId = resultIn.sessionID;
                    Session session = DatabaseManager.getSession(dbId, sessionId);
                    resultOut = session.execute(resultIn);
                }
                this.rowOut.reset();
                resultOut.write(this.rowOut);
                response.setContentType("application/octet-stream");
                response.setContentLength(this.rowOut.size());
                outStream = response.getOutputStream();
                outStream.write(this.rowOut.getOutputStream().getBuffer(), 0, this.rowOut.getOutputStream().size());
                ++this.iQueries;
            }
            catch (HsqlException e) {
            }
            finally {
                if (outStream != null) {
                    outStream.close();
                }
                if (inStream != null) {
                    inStream.close();
                }
            }
        }
    }
}

