/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.Connection;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.Random;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.Trace;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.store.ValuePool;

public class Library {
    static final SimpleDateFormat tocharFormat = new SimpleDateFormat();
    static final SimpleDateFormat daynameFormat = new SimpleDateFormat("EEEE", Locale.ENGLISH);
    static final SimpleDateFormat monthnameFormat = new SimpleDateFormat("MMMM", Locale.ENGLISH);
    static final StringBuffer daynameBuffer = new StringBuffer();
    static final StringBuffer monthnameBuffer = new StringBuffer();
    static final FieldPosition monthPosition = new FieldPosition(2);
    static final FieldPosition dayPosition = new FieldPosition(9);
    public static final String[][] sNumeric = new String[][]{{"ABS", "org.hsqldb.Library.abs"}, {"ACOS", "java.lang.Math.acos"}, {"ASIN", "java.lang.Math.asin"}, {"ATAN", "java.lang.Math.atan"}, {"ATAN2", "java.lang.Math.atan2"}, {"CEILING", "java.lang.Math.ceil"}, {"COS", "java.lang.Math.cos"}, {"COT", "org.hsqldb.Library.cot"}, {"DEGREES", "java.lang.Math.toDegrees"}, {"EXP", "java.lang.Math.exp"}, {"FLOOR", "java.lang.Math.floor"}, {"LOG", "java.lang.Math.log"}, {"LOG10", "org.hsqldb.Library.log10"}, {"MOD", "org.hsqldb.Library.mod"}, {"PI", "org.hsqldb.Library.pi"}, {"POWER", "java.lang.Math.pow"}, {"RADIANS", "java.lang.Math.toRadians"}, {"RAND", "java.lang.Math.random"}, {"ROUND", "org.hsqldb.Library.round"}, {"SIGN", "org.hsqldb.Library.sign"}, {"SIN", "java.lang.Math.sin"}, {"SQRT", "java.lang.Math.sqrt"}, {"TAN", "java.lang.Math.tan"}, {"TRUNCATE", "org.hsqldb.Library.truncate"}, {"BITAND", "org.hsqldb.Library.bitand"}, {"BITOR", "org.hsqldb.Library.bitor"}, {"BITXOR", "org.hsqldb.Library.bitxor"}, {"ROUNDMAGIC", "org.hsqldb.Library.roundMagic"}};
    public static final String[][] sString = new String[][]{{"ASCII", "org.hsqldb.Library.ascii"}, {"BIT_LENGTH", "org.hsqldb.Library.bitLength"}, {"CHAR", "org.hsqldb.Library.character"}, {"CHAR_LENGTH", "org.hsqldb.Library.length"}, {"CHARACTER_LENGTH", "org.hsqldb.Library.length"}, {"CONCAT", "org.hsqldb.Library.concat"}, {"DIFFERENCE", "org.hsqldb.Library.difference"}, {"HEXTORAW", "org.hsqldb.Library.hexToRaw"}, {"INSERT", "org.hsqldb.Library.insert"}, {"LCASE", "org.hsqldb.Library.lcase"}, {"LEFT", "org.hsqldb.Library.left"}, {"LENGTH", "org.hsqldb.Library.length"}, {"LOCATE", "org.hsqldb.Library.locate"}, {"LTRIM", "org.hsqldb.Library.ltrim"}, {"OCTET_LENGTH", "org.hsqldb.Library.octetLength"}, {"RAWTOHEX", "org.hsqldb.Library.rawToHex"}, {"REPEAT", "org.hsqldb.Library.repeat"}, {"REPLACE", "org.hsqldb.Library.replace"}, {"RIGHT", "org.hsqldb.Library.right"}, {"RTRIM", "org.hsqldb.Library.rtrim"}, {"SOUNDEX", "org.hsqldb.Library.soundex"}, {"SPACE", "org.hsqldb.Library.space"}, {"SUBSTR", "org.hsqldb.Library.substring"}, {"SUBSTRING", "org.hsqldb.Library.substring"}, {"UCASE", "org.hsqldb.Library.ucase"}, {"LOWER", "org.hsqldb.Library.lcase"}, {"UPPER", "org.hsqldb.Library.ucase"}};
    public static final String[][] sTimeDate = new String[][]{{"CURDATE", "org.hsqldb.Library.curdate"}, {"CURTIME", "org.hsqldb.Library.curtime"}, {"DATEDIFF", "org.hsqldb.Library.datediff"}, {"DAYNAME", "org.hsqldb.Library.dayname"}, {"DAY", "org.hsqldb.Library.dayofmonth"}, {"DAYOFMONTH", "org.hsqldb.Library.dayofmonth"}, {"DAYOFWEEK", "org.hsqldb.Library.dayofweek"}, {"DAYOFYEAR", "org.hsqldb.Library.dayofyear"}, {"HOUR", "org.hsqldb.Library.hour"}, {"MINUTE", "org.hsqldb.Library.minute"}, {"MONTH", "org.hsqldb.Library.month"}, {"MONTHNAME", "org.hsqldb.Library.monthname"}, {"NOW", "org.hsqldb.Library.now"}, {"QUARTER", "org.hsqldb.Library.quarter"}, {"SECOND", "org.hsqldb.Library.second"}, {"WEEK", "org.hsqldb.Library.week"}, {"YEAR", "org.hsqldb.Library.year"}, {"TO_CHAR", "org.hsqldb.Library.to_char"}};
    public static final String[][] sSystem = new String[][]{{"DATABASE", "org.hsqldb.Library.database"}, {"USER", "org.hsqldb.Library.user"}, {"IDENTITY", "org.hsqldb.Library.identity"}};
    private static final Random rRandom = new Random();
    private static final double LOG10_FACTOR = 0.4342944819032518;
    static final int abs = 0;
    static final int ascii = 1;
    static final int bitand = 2;
    static final int bitLength = 3;
    static final int bitor = 4;
    static final int bitxor = 5;
    static final int character = 6;
    static final int concat = 7;
    static final int cot = 8;
    static final int curdate = 9;
    static final int curtime = 10;
    static final int database = 11;
    static final int datediff = 12;
    static final int day = 13;
    static final int dayname = 14;
    static final int dayofmonth = 15;
    static final int dayofweek = 16;
    static final int dayofyear = 17;
    static final int difference = 18;
    static final int getAutoCommit = 19;
    static final int getDatabaseFullProductVersion = 20;
    static final int getDatabaseMajorVersion = 21;
    static final int getDatabaseMinorVersion = 22;
    static final int getDatabaseProductName = 23;
    static final int getDatabaseProductVersion = 24;
    static final int hexToRaw = 25;
    static final int hour = 26;
    static final int identity = 27;
    static final int insert = 28;
    static final int isReadOnlyConnection = 29;
    static final int isReadOnlyDatabase = 30;
    static final int isReadOnlyDatabaseFiles = 31;
    static final int lcase = 32;
    static final int left = 33;
    static final int length = 34;
    static final int locate = 35;
    static final int log10 = 36;
    static final int ltrim = 37;
    static final int minute = 38;
    static final int mod = 39;
    static final int month = 40;
    static final int monthname = 41;
    static final int now = 42;
    static final int octetLength = 43;
    static final int pi = 44;
    static final int position = 45;
    static final int quarter = 46;
    static final int rand = 47;
    static final int rawToHex = 48;
    static final int repeat = 49;
    static final int replace = 50;
    static final int right = 51;
    static final int round = 52;
    static final int roundMagic = 53;
    static final int rtrim = 54;
    static final int second = 55;
    static final int sign = 56;
    static final int soundex = 57;
    static final int space = 58;
    static final int substring = 59;
    static final int to_char = 60;
    static final int trim = 61;
    static final int truncate = 62;
    static final int ucase = 63;
    static final int user = 64;
    static final int week = 65;
    static final int year = 66;
    private static final IntValueHashMap functionMap = new IntValueHashMap(67);
    static final Double piValue = new Double(Library.pi());
    static final String prefix = "org.hsqldb.Library.";
    static final int prefixLength;

    private Library() {
    }

    static HashMap getAliasMap() {
        HashMap h = new HashMap(83, 1.0f);
        Library.register(h, sNumeric);
        Library.register(h, sString);
        Library.register(h, sTimeDate);
        Library.register(h, sSystem);
        return h;
    }

    private static void register(HashMap h, String[][] s) {
        for (int i = 0; i < s.length; ++i) {
            h.put(s[i][0], s[i][1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double rand(Integer seed) {
        Random random = rRandom;
        synchronized (random) {
            if (seed != null) {
                rRandom.setSeed(seed.intValue());
            }
            return rRandom.nextDouble();
        }
    }

    public static double abs(double d) {
        return Math.abs(d);
    }

    public static double log10(double x) {
        return Library.roundMagic(Math.log(x) * 0.4342944819032518);
    }

    public static double roundMagic(double d) {
        if (d < 1.0E-13 && d > -1.0E-13) {
            return 0.0;
        }
        if (d > 1.0E12 || d < -1.0E12) {
            return d;
        }
        StringBuffer s = new StringBuffer();
        s.append(d);
        int len = s.length();
        if (len < 16) {
            return d;
        }
        char cx = s.charAt(len - 1);
        char c1 = s.charAt(len - 2);
        char c2 = s.charAt(len - 3);
        char c3 = s.charAt(len - 4);
        if (c1 == '0' && c2 == '0' && c3 == '0' && cx != '.') {
            s.setCharAt(len - 1, '0');
        } else if (c1 == '9' && c2 == '9' && c3 == '9' && cx != '.') {
            s.setCharAt(len - 1, '9');
            s.append('9');
            s.append('9');
        }
        return Double.valueOf(s.toString());
    }

    public static double cot(double d) {
        return 1.0 / Math.tan(d);
    }

    public static int mod(int i1, int i2) {
        return i1 % i2;
    }

    public static double pi() {
        return Math.PI;
    }

    public static double round(double d, int p) {
        double f = Math.pow(10.0, p);
        return (double)Math.round(d * f) / f;
    }

    public static int sign(double d) {
        return d < 0.0 ? -1 : (d > 0.0 ? 1 : 0);
    }

    public static double truncate(double d, int p) {
        double f = Math.pow(10.0, p);
        double g = d * f;
        return (d < 0.0 ? Math.ceil(g) : Math.floor(g)) / f;
    }

    public static int bitand(int i, int j) {
        return i & j;
    }

    public static int bitor(int i, int j) {
        return i | j;
    }

    public static int bitxor(int i, int j) {
        return i ^ j;
    }

    public static Integer ascii(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        return ValuePool.getInt(s.charAt(0));
    }

    public static String character(int code) {
        return String.valueOf((char)code);
    }

    public static String concat(String s1, String s2) {
        if (s1 == null) {
            if (s2 == null) {
                return null;
            }
            return s2;
        }
        if (s2 == null) {
            return s1;
        }
        return s1.concat(s2);
    }

    public static int difference(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return 0;
        }
        s1 = Library.soundex(s1);
        s2 = Library.soundex(s2);
        int e = 0;
        for (int i = 0; i < 4; ++i) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            ++e;
        }
        return e;
    }

    public static String hexToRaw(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer to = new StringBuffer();
        int len = s.length();
        if (len % 4 != 0) {
            return null;
        }
        for (int i = 0; i < len; i += 4) {
            char raw = (char)Integer.parseInt(s.substring(i, i + 4), 16);
            to.append(raw);
        }
        return to.toString();
    }

    public static String insert(String s1, int start, int length, String s2) {
        if (s1 == null) {
            return s2;
        }
        if (s2 == null) {
            return s1;
        }
        int len1 = s1.length();
        int len2 = s2.length();
        if (--start < 0 || length <= 0 || len2 == 0 || start > len1) {
            return s1;
        }
        if (start + length > len1) {
            length = len1 - start;
        }
        return s1.substring(0, start) + s2 + s1.substring(start + length);
    }

    public static String lcase(String s) {
        return s == null ? null : s.toLowerCase();
    }

    public static String left(String s, int count) {
        if (s == null) {
            return null;
        }
        return s.substring(0, count < 0 ? 0 : (count < s.length() ? count : s.length()));
    }

    public static Integer length(String s) {
        return s == null ? null : ValuePool.getInt(s.length());
    }

    public static Integer octetLength(String s) {
        return s == null ? null : ValuePool.getInt(s.length() * 2);
    }

    public static Integer bitLength(String s) {
        return s == null ? null : ValuePool.getInt(s.length() * 16);
    }

    public static int locate(String search, String s, Integer start) {
        if (s == null || search == null) {
            return 0;
        }
        int i = start == null ? 0 : start - 1;
        return s.indexOf(search, i < 0 ? 0 : i) + 1;
    }

    public static int position(String search, String s) {
        return Library.locate(search, s, null);
    }

    public static String ltrim(String s) {
        int i;
        if (s == null) {
            return s;
        }
        int len = s.length();
        for (i = 0; i < len && s.charAt(i) <= ' '; ++i) {
        }
        return i == 0 ? s : s.substring(i);
    }

    public static String rawToHex(String s) {
        if (s == null) {
            return null;
        }
        char[] from = s.toCharArray();
        StringBuffer to = new StringBuffer(4 * s.length());
        for (int i = 0; i < from.length; ++i) {
            String hex = Integer.toHexString(from[i] & 0xFFFF);
            for (int j = hex.length(); j < 4; ++j) {
                to.append('0');
            }
            to.append(hex);
        }
        return to.toString();
    }

    public static String repeat(String s, Integer count) {
        if (s == null || count == null || count < 0) {
            return null;
        }
        int i = count;
        StringBuffer b = new StringBuffer(s.length() * i);
        while (i-- > 0) {
            b.append(s);
        }
        return b.toString();
    }

    public static String replace(String s, String replace, String with) {
        if (s == null || replace == null) {
            return s;
        }
        if (with == null) {
            with = "";
        }
        StringBuffer b = new StringBuffer();
        int start = 0;
        int lenreplace = replace.length();
        while (true) {
            int i;
            if ((i = s.indexOf(replace, start)) == -1) break;
            b.append(s.substring(start, i));
            b.append(with);
            start = i + lenreplace;
        }
        b.append(s.substring(start));
        return b.toString();
    }

    public static String right(String s, int count) {
        if (s == null) {
            return null;
        }
        count = s.length() - count;
        return s.substring(count < 0 ? 0 : (count < s.length() ? count : s.length()));
    }

    public static String rtrim(String s) {
        int endindex;
        int i;
        if (s == null) {
            return s;
        }
        for (i = endindex = s.length() - 1; i >= 0 && s.charAt(i) == ' '; --i) {
        }
        return i == endindex ? s : s.substring(0, i + 1);
    }

    public static String trim(String s, String trimstr, boolean leading, boolean trailing) {
        int startindex;
        if (s == null) {
            return s;
        }
        char trim = trimstr.charAt(0);
        int endindex = s.length();
        if (trailing) {
            --endindex;
            while (endindex >= 0 && s.charAt(endindex) == trim) {
                --endindex;
            }
            ++endindex;
        }
        if (endindex == 0) {
            return "";
        }
        if (leading) {
            for (startindex = 0; startindex < endindex && s.charAt(startindex) == trim; ++startindex) {
            }
        }
        if (startindex == 0 && endindex == s.length()) {
            return s;
        }
        return s.substring(startindex, endindex);
    }

    public static String soundex(String s) {
        if (s == null) {
            return s;
        }
        s = s.toUpperCase(Locale.ENGLISH);
        int len = s.length();
        char[] b = new char[]{'0', '0', '0', '0'};
        int lastdigit = 48;
        int j = 0;
        for (int i = 0; i < len && j < 4; ++i) {
            int newdigit;
            char c = s.charAt(i);
            if ("AEIOUY".indexOf(c) != -1) {
                newdigit = 55;
            } else if (c == 'H' || c == 'W') {
                newdigit = 56;
            } else if ("BFPV".indexOf(c) != -1) {
                newdigit = 49;
            } else if ("CGJKQSXZ".indexOf(c) != -1) {
                newdigit = 50;
            } else if (c == 'D' || c == 'T') {
                newdigit = 51;
            } else if (c == 'L') {
                newdigit = 52;
            } else if (c == 'M' || c == 'N') {
                newdigit = 53;
            } else {
                if (c != 'R') continue;
                newdigit = 54;
            }
            if (j == 0) {
                b[j++] = c;
                lastdigit = newdigit;
                continue;
            }
            if (newdigit <= 54) {
                if (newdigit == lastdigit) continue;
                b[j++] = newdigit;
                lastdigit = newdigit;
                continue;
            }
            if (newdigit != 55) continue;
            lastdigit = newdigit;
        }
        return new String(b, 0, 4);
    }

    public static String space(int count) {
        if (count < 0) {
            return null;
        }
        char[] c = new char[count];
        while (count > 0) {
            c[--count] = 32;
        }
        return new String(c);
    }

    public static String substring(String s, int start, Integer length) {
        int ol;
        if (s == null) {
            return null;
        }
        int sl = s.length();
        int n = ol = length == null ? sl : length;
        if (ol < 1) {
            return null;
        }
        if (start < 0) {
            start = sl + start;
        } else if (start > 0) {
            --start;
        }
        if (start < 0 || start >= sl) {
            return null;
        }
        if (start > sl - ol) {
            ol = sl - start;
        }
        return s.substring(start, start + ol);
    }

    public static String ucase(String s) {
        return s == null ? null : s.toUpperCase();
    }

    public static Date curdate(Connection c) {
        return null;
    }

    public static Time curtime(Connection c) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dayname(Date d) {
        if (d == null) {
            return null;
        }
        StringBuffer stringBuffer = daynameBuffer;
        synchronized (stringBuffer) {
            daynameBuffer.setLength(0);
            return daynameFormat.format((java.util.Date)d, daynameBuffer, dayPosition).toString();
        }
    }

    public static Integer dayofmonth(Date d) {
        if (d == null) {
            return null;
        }
        return ValuePool.getInt(HsqlDateTime.getDateTimePart(d, 5));
    }

    public static Integer dayofweek(Date d) {
        if (d == null) {
            return null;
        }
        return ValuePool.getInt(HsqlDateTime.getDateTimePart(d, 7));
    }

    public static Integer dayofyear(Date d) {
        if (d == null) {
            return null;
        }
        return ValuePool.getInt(HsqlDateTime.getDateTimePart(d, 6));
    }

    public static Integer hour(Time t) {
        if (t == null) {
            return null;
        }
        return ValuePool.getInt(HsqlDateTime.getDateTimePart(t, 11));
    }

    public static Integer minute(Time t) {
        if (t == null) {
            return null;
        }
        return ValuePool.getInt(HsqlDateTime.getDateTimePart(t, 12));
    }

    public static Integer month(Date d) {
        if (d == null) {
            return null;
        }
        return ValuePool.getInt(HsqlDateTime.getDateTimePart(d, 2) + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String monthname(Date d) {
        if (d == null) {
            return null;
        }
        StringBuffer stringBuffer = monthnameBuffer;
        synchronized (stringBuffer) {
            monthnameBuffer.setLength(0);
            return monthnameFormat.format((java.util.Date)d, monthnameBuffer, monthPosition).toString();
        }
    }

    public static Timestamp now(Connection c) {
        return null;
    }

    public static Integer quarter(Date d) {
        if (d == null) {
            return null;
        }
        return ValuePool.getInt(HsqlDateTime.getDateTimePart(d, 2) / 3 + 1);
    }

    public static Integer second(Time d) {
        if (d == null) {
            return null;
        }
        return ValuePool.getInt(HsqlDateTime.getDateTimePart(d, 13));
    }

    public static Integer week(Date d) {
        if (d == null) {
            return null;
        }
        return ValuePool.getInt(HsqlDateTime.getDateTimePart(d, 3));
    }

    public static Integer year(Date d) {
        if (d == null) {
            return null;
        }
        return ValuePool.getInt(HsqlDateTime.getDateTimePart(d, 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String to_char(java.util.Date d, String format) {
        if (d == null || format == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = tocharFormat;
        synchronized (simpleDateFormat) {
            tocharFormat.applyPattern(HsqlDateTime.toJavaDatePattern(format));
            return tocharFormat.format(d);
        }
    }

    public static Long datediff(String datepart, Timestamp d1, Timestamp d2) throws HsqlException {
        if (d1 == null || d2 == null) {
            return null;
        }
        if ("yy".equalsIgnoreCase(datepart) || "year".equalsIgnoreCase(datepart)) {
            return ValuePool.getLong(Library.getElapsed(1, d1, d2));
        }
        if ("mm".equalsIgnoreCase(datepart) || "month".equalsIgnoreCase(datepart)) {
            return ValuePool.getLong(Library.getElapsed(2, d1, d2));
        }
        if ("dd".equalsIgnoreCase(datepart) || "day".equalsIgnoreCase(datepart)) {
            return ValuePool.getLong(Library.getElapsed(5, d1, d2));
        }
        if ("hh".equalsIgnoreCase(datepart) || "hour".equalsIgnoreCase(datepart)) {
            return ValuePool.getLong(Library.getElapsed(10, d1, d2));
        }
        if ("mi".equalsIgnoreCase(datepart) || "minute".equalsIgnoreCase(datepart)) {
            return ValuePool.getLong(Library.getElapsed(12, d1, d2));
        }
        if ("ss".equalsIgnoreCase(datepart) || "second".equalsIgnoreCase(datepart)) {
            return ValuePool.getLong(Library.getElapsed(13, d1, d2));
        }
        if ("ms".equalsIgnoreCase(datepart) || "millisecond".equalsIgnoreCase(datepart)) {
            return ValuePool.getLong(Library.getElapsed(14, d1, d2));
        }
        throw Trace.error(95);
    }

    private static long getElapsed(int field, java.util.Date d1, java.util.Date d2) {
        if (field == 14) {
            return d2.getTime() - d1.getTime();
        }
        Calendar g1 = Calendar.getInstance();
        Calendar g2 = Calendar.getInstance();
        g1.setTime(d1);
        g2.setTime(d2);
        g1.set(14, 0);
        g2.set(14, 0);
        if (field == 13) {
            return (g2.getTime().getTime() - g1.getTime().getTime()) / 1000L;
        }
        g1.set(13, 0);
        g2.set(13, 0);
        if (field == 12) {
            return (g2.getTime().getTime() - g1.getTime().getTime()) / 60000L;
        }
        g1.set(12, 0);
        g2.set(12, 0);
        if (field == 10) {
            return (g2.getTime().getTime() - g1.getTime().getTime()) / 3600000L;
        }
        long elapsed = 0L;
        int sign = 1;
        if (g2.before(g1)) {
            sign = -1;
            Calendar tmp = g1;
            g1 = g2;
            g2 = tmp;
        }
        g1.set(11, 0);
        g2.set(11, 0);
        if (field == 2 || field == 1) {
            g1.set(5, 1);
            g2.set(5, 1);
        }
        if (field == 1) {
            g1.set(2, 1);
            g2.set(2, 1);
        }
        while (g1.before(g2)) {
            g1.add(field, 1);
            ++elapsed;
        }
        return (long)sign * elapsed;
    }

    public static String database(Connection conn) throws HsqlException {
        return null;
    }

    public static String user(Connection conn) throws HsqlException {
        return null;
    }

    public static int identity() throws HsqlException {
        return 0;
    }

    public static boolean getAutoCommit(Connection conn) {
        return false;
    }

    public static String getDatabaseFullProductVersion() {
        return "1.8.0.7";
    }

    public static String getDatabaseProductName() {
        return "HSQL Database Engine";
    }

    public static String getDatabaseProductVersion() {
        return "1.8.0";
    }

    public static int getDatabaseMajorVersion() {
        return 1;
    }

    public static int getDatabaseMinorVersion() {
        return 8;
    }

    public static boolean isReadOnlyConnection(Connection conn) {
        return false;
    }

    public static boolean isReadOnlyDatabase(Connection c) {
        return false;
    }

    public static boolean isReadOnlyDatabaseFiles(Connection c) {
        return false;
    }

    static Object invoke(int fID, Object[] params) throws HsqlException {
        try {
            switch (fID) {
                case 0: {
                    return new Double(Library.abs(((Number)params[0]).doubleValue()));
                }
                case 1: {
                    return Library.ascii((String)params[0]);
                }
                case 2: {
                    return ValuePool.getInt(Library.bitand(((Number)params[0]).intValue(), ((Number)params[1]).intValue()));
                }
                case 3: {
                    return Library.bitLength((String)params[0]);
                }
                case 4: {
                    return ValuePool.getInt(Library.bitor(((Number)params[0]).intValue(), ((Number)params[1]).intValue()));
                }
                case 5: {
                    return ValuePool.getInt(Library.bitxor(((Number)params[0]).intValue(), ((Number)params[1]).intValue()));
                }
                case 6: {
                    return Library.character(((Number)params[0]).intValue());
                }
                case 7: {
                    return Library.concat((String)params[0], (String)params[1]);
                }
                case 8: {
                    return new Double(Library.cot(((Number)params[0]).doubleValue()));
                }
                case 9: {
                    return null;
                }
                case 10: {
                    return null;
                }
                case 11: {
                    return null;
                }
                case 12: {
                    return Library.datediff((String)params[0], (Timestamp)params[1], (Timestamp)params[2]);
                }
                case 14: {
                    return Library.dayname((Date)params[0]);
                }
                case 13: 
                case 15: {
                    return Library.dayofmonth((Date)params[0]);
                }
                case 16: {
                    return Library.dayofweek((Date)params[0]);
                }
                case 17: {
                    return Library.dayofyear((Date)params[0]);
                }
                case 18: {
                    return ValuePool.getInt(Library.difference((String)params[0], (String)params[1]));
                }
                case 19: {
                    return null;
                }
                case 20: {
                    return Library.getDatabaseFullProductVersion();
                }
                case 21: {
                    return ValuePool.getInt(Library.getDatabaseMajorVersion());
                }
                case 22: {
                    return ValuePool.getInt(Library.getDatabaseMinorVersion());
                }
                case 23: {
                    return Library.getDatabaseProductName();
                }
                case 24: {
                    return Library.getDatabaseProductVersion();
                }
                case 25: {
                    return Library.hexToRaw((String)params[0]);
                }
                case 26: {
                    return Library.hour((Time)params[0]);
                }
                case 27: {
                    return null;
                }
                case 28: {
                    return Library.insert((String)params[0], ((Number)params[1]).intValue(), ((Number)params[2]).intValue(), (String)params[3]);
                }
                case 29: {
                    return null;
                }
                case 30: {
                    return null;
                }
                case 32: {
                    return Library.lcase((String)params[0]);
                }
                case 33: {
                    return Library.left((String)params[0], ((Number)params[1]).intValue());
                }
                case 34: {
                    return Library.length((String)params[0]);
                }
                case 35: {
                    return ValuePool.getInt(Library.locate((String)params[0], (String)params[1], (Integer)params[2]));
                }
                case 36: {
                    return new Double(Library.log10(((Number)params[0]).doubleValue()));
                }
                case 37: {
                    return Library.ltrim((String)params[0]);
                }
                case 38: {
                    return Library.minute((Time)params[0]);
                }
                case 39: {
                    return ValuePool.getInt(Library.mod(((Number)params[0]).intValue(), ((Number)params[1]).intValue()));
                }
                case 40: {
                    return Library.month((Date)params[0]);
                }
                case 41: {
                    return ValuePool.getString(Library.monthname((Date)params[0]));
                }
                case 42: {
                    return null;
                }
                case 43: {
                    return Library.octetLength((String)params[0]);
                }
                case 45: {
                    return ValuePool.getInt(Library.position((String)params[0], (String)params[1]));
                }
                case 44: {
                    return piValue;
                }
                case 46: {
                    return Library.quarter((Date)params[0]);
                }
                case 47: {
                    return new Double(Library.rand((Integer)params[0]));
                }
                case 48: {
                    return Library.rawToHex((String)params[0]);
                }
                case 49: {
                    return Library.repeat((String)params[0], (Integer)params[1]);
                }
                case 50: {
                    return Library.replace((String)params[0], (String)params[1], (String)params[2]);
                }
                case 51: {
                    return Library.right((String)params[0], ((Number)params[1]).intValue());
                }
                case 52: {
                    return new Double(Library.round(((Number)params[0]).doubleValue(), ((Number)params[1]).intValue()));
                }
                case 53: {
                    return new Double(Library.roundMagic(((Number)params[0]).doubleValue()));
                }
                case 54: {
                    return Library.rtrim((String)params[0]);
                }
                case 55: {
                    return Library.second((Time)params[0]);
                }
                case 56: {
                    return ValuePool.getInt(Library.sign(((Number)params[0]).doubleValue()));
                }
                case 57: {
                    return Library.soundex((String)params[0]);
                }
                case 58: {
                    return Library.space(((Number)params[0]).intValue());
                }
                case 59: {
                    return Library.substring((String)params[0], ((Number)params[1]).intValue(), (Integer)params[2]);
                }
                case 61: {
                    return Library.trim((String)params[0], (String)params[1], (Boolean)params[2], (Boolean)params[3]);
                }
                case 62: {
                    return new Double(Library.truncate(((Number)params[0]).doubleValue(), ((Number)params[1]).intValue()));
                }
                case 63: {
                    return Library.ucase((String)params[0]);
                }
                case 64: {
                    return null;
                }
                case 65: {
                    return Library.week((Date)params[0]);
                }
                case 66: {
                    return Library.year((Date)params[0]);
                }
                case 60: {
                    return Library.to_char((java.util.Date)params[0], (String)params[1]);
                }
                case 31: {
                    return null;
                }
            }
            Trace.doAssert(false);
            return null;
        }
        catch (Exception e) {
            throw Trace.error(198, e.toString());
        }
    }

    static int functionID(String fname) {
        return fname.startsWith(prefix) ? functionMap.get((Object)fname.substring(prefixLength), -1) : -1;
    }

    static {
        functionMap.put("abs", 0);
        functionMap.put("ascii", 1);
        functionMap.put("bitand", 2);
        functionMap.put("bitlength", 3);
        functionMap.put("bitor", 4);
        functionMap.put("bitxor", 4);
        functionMap.put("character", 6);
        functionMap.put("concat", 7);
        functionMap.put("cot", 8);
        functionMap.put("curdate", 9);
        functionMap.put("curtime", 10);
        functionMap.put("database", 11);
        functionMap.put("datediff", 12);
        functionMap.put("dayname", 14);
        functionMap.put("day", 13);
        functionMap.put("dayofmonth", 15);
        functionMap.put("dayofweek", 16);
        functionMap.put("dayofyear", 17);
        functionMap.put("difference", 18);
        functionMap.put("getAutoCommit", 19);
        functionMap.put("getDatabaseFullProductVersion", 20);
        functionMap.put("getDatabaseMajorVersion", 21);
        functionMap.put("getDatabaseMinorVersion", 22);
        functionMap.put("getDatabaseProductName", 23);
        functionMap.put("getDatabaseProductVersion", 24);
        functionMap.put("hexToRaw", 25);
        functionMap.put("hour", 26);
        functionMap.put("identity", 27);
        functionMap.put("insert", 28);
        functionMap.put("isReadOnlyConnection", 29);
        functionMap.put("isReadOnlyDatabase", 30);
        functionMap.put("isReadOnlyDatabaseFiles", 31);
        functionMap.put("lcase", 32);
        functionMap.put("left", 33);
        functionMap.put("length", 34);
        functionMap.put("locate", 35);
        functionMap.put("log10", 36);
        functionMap.put("ltrim", 37);
        functionMap.put("minute", 38);
        functionMap.put("mod", 39);
        functionMap.put("month", 40);
        functionMap.put("monthname", 41);
        functionMap.put("now", 42);
        functionMap.put("octetLength", 43);
        functionMap.put("pi", 44);
        functionMap.put("position", 45);
        functionMap.put("quarter", 46);
        functionMap.put("rand", 47);
        functionMap.put("rawToHex", 48);
        functionMap.put("repeat", 49);
        functionMap.put("replace", 50);
        functionMap.put("right", 51);
        functionMap.put("round", 52);
        functionMap.put("roundMagic", 53);
        functionMap.put("rtrim", 54);
        functionMap.put("second", 55);
        functionMap.put("sign", 56);
        functionMap.put("soundex", 57);
        functionMap.put("space", 58);
        functionMap.put("substring", 59);
        functionMap.put("to_char", 60);
        functionMap.put("trim", 61);
        functionMap.put("truncate", 62);
        functionMap.put("ucase", 63);
        functionMap.put("user", 64);
        functionMap.put("week", 65);
        functionMap.put("year", 66);
        prefixLength = prefix.length();
    }
}

