/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Token;
import org.hsqldb.lib.StringConverter;

public class HsqlNameManager {
    private static HsqlNameManager staticManager = new HsqlNameManager();
    private int serialNumber = 1;
    private int sysNumber = 0;

    static HsqlName newHsqlSystemObjectName(String name) {
        return new HsqlName(staticManager, name);
    }

    public HsqlName newHsqlName(String name, boolean isquoted) {
        return new HsqlName(this, name, isquoted);
    }

    HsqlName newHsqlName(String prefix, String name, boolean isquoted) {
        return new HsqlName(this, prefix, name, isquoted);
    }

    HsqlName newHsqlName(String name) {
        return new HsqlName(this, name);
    }

    public HsqlName newAutoName(String type) {
        return this.newAutoName(type, null);
    }

    HsqlName newAutoName(String type, String namepart) {
        StringBuffer sbname = new StringBuffer();
        if (type != null) {
            if (type.length() != 0) {
                sbname.append("SYS_");
                sbname.append(type);
                sbname.append('_');
                if (namepart != null) {
                    sbname.append(namepart);
                    sbname.append('_');
                }
                sbname.append(++this.sysNumber);
            }
        } else {
            sbname.append(namepart);
        }
        return new HsqlName(this, sbname.toString());
    }

    void resetNumbering() {
        this.sysNumber = 0;
        this.serialNumber = 0;
    }

    static {
        HsqlNameManager.staticManager.serialNumber = Integer.MIN_VALUE;
    }

    public static class HsqlName {
        HsqlNameManager manager;
        public String name;
        boolean isNameQuoted;
        public String statementName;
        public HsqlName schema;
        private final int hashCode;

        private HsqlName(HsqlNameManager man) {
            this.manager = man;
            this.hashCode = this.manager.serialNumber++;
        }

        private HsqlName(HsqlNameManager man, String name, boolean isquoted) {
            this(man);
            this.rename(name, isquoted);
        }

        private HsqlName(HsqlNameManager man, String prefix, String name, boolean isquoted) {
            this(man);
            this.rename(prefix, name, isquoted);
        }

        private HsqlName(HsqlNameManager man, String name) {
            this(man);
            this.name = this.statementName = name;
        }

        void rename(String name, boolean isquoted) {
            this.name = name;
            this.statementName = name;
            this.isNameQuoted = isquoted;
            if (this.isNameQuoted) {
                this.statementName = StringConverter.toQuotedString(name, '\"', true);
            }
            if (name.startsWith("SYS_")) {
                int index = name.lastIndexOf(95) + 1;
                try {
                    int temp = Integer.parseInt(name.substring(index));
                    if (temp > this.manager.sysNumber) {
                        this.manager.sysNumber = temp;
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }

        void rename(String prefix, String name, boolean isquoted) {
            StringBuffer sbname = new StringBuffer(prefix);
            sbname.append('_');
            sbname.append(name);
            this.rename(sbname.toString(), isquoted);
        }

        public boolean equals(Object other) {
            if (other instanceof HsqlName) {
                return this.hashCode == ((HsqlName)other).hashCode;
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }

        static boolean isReservedIndexName(String name) {
            return name.startsWith("SYS_IDX_") || name.startsWith("SYS_PK_") || name.startsWith("SYS_REF_");
        }

        boolean isReservedIndexName() {
            return HsqlName.isReservedIndexName(this.name);
        }

        public String toString() {
            return this.getClass().getName() + super.hashCode() + "[this.hashCode()=" + this.hashCode + ", name=" + this.name + ", name.hashCode()=" + this.name.hashCode() + ", isNameQuoted=" + this.isNameQuoted + "]";
        }

        public int compareTo(Object o) {
            return this.hashCode - o.hashCode();
        }

        static boolean isRegularIdentifier(String name) {
            int length = name.length();
            for (int i = 0; i < length; ++i) {
                char c = name.charAt(i);
                if (c >= 'A' && c <= 'Z' || c == '_' && i > 0 || c >= '0' && c <= '9') continue;
                return false;
            }
            return !Token.isKeyword(name);
        }
    }
}

