/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import org.hsqldb.HSQLClientConnection;
import org.hsqldb.HsqlException;
import org.hsqldb.Result;
import org.hsqldb.lib.InOutUtil;

public class HTTPClientConnection
extends HSQLClientConnection {
    static final String ENCODING = "8859_1";

    public HTTPClientConnection(String host, int port, String path, String database, boolean isTLS, String user, String password) throws HsqlException {
        super(host, port, path, database, isTLS, user, password);
    }

    protected void initConnection(String host, int port, boolean isTLS) throws HsqlException {
    }

    public synchronized Result execute(Result r) throws HsqlException {
        super.openConnection(this.host, this.port, this.isTLS);
        Result result = super.execute(r);
        super.closeConnection();
        return result;
    }

    protected void write(Result r) throws IOException, HsqlException {
        this.rowOut.reset();
        r.write(this.rowOut);
        this.dataOutput.write("POST ".getBytes(ENCODING));
        this.dataOutput.write(this.path.getBytes(ENCODING));
        this.dataOutput.write(" HTTP/1.0\r\n".getBytes(ENCODING));
        this.dataOutput.write("Content-Type: application/octet-stream\r\n".getBytes(ENCODING));
        this.dataOutput.write(("Content-Length: " + this.rowOut.size() + "\r\n").getBytes(ENCODING));
        this.dataOutput.write("\r\n".getBytes(ENCODING));
        this.dataOutput.write(this.rowOut.getOutputStream().getBuffer(), 0, this.rowOut.getOutputStream().size());
        this.dataOutput.flush();
    }

    protected Result read() throws IOException, HsqlException {
        int count;
        this.rowOut.reset();
        while ((count = InOutUtil.readLine(this.dataInput, this.rowOut)) > 2) {
        }
        Result resultIn = Result.read(this.rowIn, this.dataInput);
        return resultIn;
    }
}

