/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Result;
import org.hsqldb.Select;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.Iterator;

class GroupedResult {
    private Result result;
    int groupBegin;
    int groupEnd;
    private final boolean isGrouped;
    private final boolean isAggregated;
    private HashSet groups;
    private ResultGroup currGroup;

    GroupedResult(Select select, Result.ResultMetaData meta) {
        this.result = new Result(meta);
        this.groupBegin = select.iResultLen;
        this.groupEnd = this.groupBegin + select.iGroupLen;
        this.isGrouped = this.groupBegin != this.groupEnd;
        this.isAggregated = select.isAggregated;
        if (this.isGrouped) {
            this.groups = new HashSet();
        }
    }

    Object[] getRow(Object[] row) {
        if (this.isGrouped) {
            ResultGroup newGroup = new ResultGroup(row);
            ResultGroup group = (ResultGroup)this.groups.get(newGroup);
            if (group != null) {
                ArrayUtil.copyArray(group.row, row, row.length);
            }
        } else if (this.isAggregated && this.currGroup != null) {
            ArrayUtil.copyArray(this.currGroup.row, row, row.length);
        }
        return row;
    }

    void addRow(Object[] row) {
        if (this.isGrouped) {
            ResultGroup newGroup = new ResultGroup(row);
            this.currGroup = (ResultGroup)this.groups.get(newGroup);
            if (this.currGroup == null) {
                this.currGroup = newGroup;
                this.groups.add(this.currGroup);
                this.result.add(row);
            } else {
                System.arraycopy(row, 0, this.currGroup.row, 0, row.length);
            }
        } else if (this.isAggregated) {
            if (this.currGroup == null) {
                this.currGroup = new ResultGroup(row);
                this.result.add(row);
            } else {
                System.arraycopy(row, 0, this.currGroup.row, 0, row.length);
            }
        } else {
            this.result.add(row);
        }
    }

    int size() {
        return this.result.getSize();
    }

    Iterator iterator() {
        return this.result.iterator();
    }

    Result getResult() {
        return this.result;
    }

    class ResultGroup {
        Object[] row;
        int hashCode;

        private ResultGroup(Object[] row) {
            this.row = row;
            this.hashCode = 0;
            for (int i = GroupedResult.this.groupBegin; i < GroupedResult.this.groupEnd; ++i) {
                if (row[i] == null) continue;
                this.hashCode += row[i].hashCode();
            }
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof ResultGroup)) {
                return false;
            }
            ResultGroup group = (ResultGroup)obj;
            for (int i = GroupedResult.this.groupBegin; i < GroupedResult.this.groupEnd; ++i) {
                if (this.equals(this.row[i], group.row[i])) continue;
                return false;
            }
            return true;
        }

        private boolean equals(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }
    }
}

