/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Column;
import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.Grantee;
import org.hsqldb.GranteeManager;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Index;
import org.hsqldb.Library;
import org.hsqldb.NumberSequence;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TriggerDef;
import org.hsqldb.Types;
import org.hsqldb.User;
import org.hsqldb.View;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.StringConverter;

public class DatabaseScript {
    public static Result getScript(Database database, boolean indexRoots) {
        Result r = Result.newSingleColumnResult("COMMAND", 12);
        r.metaData.tableNames[0] = "SYSTEM_SCRIPT";
        if (database.collation.name != null) {
            String name = StringConverter.toQuotedString(database.collation.name, '\"', true);
            DatabaseScript.addRow(r, "SET DATABASE COLLATION " + name);
        }
        Iterator it = database.getGranteeManager().getRoleNames().iterator();
        while (it.hasNext()) {
            String role = (String)it.next();
            if ("DBA".equals(role)) continue;
            DatabaseScript.addRow(r, "CREATE ROLE " + role);
        }
        HashMap h = database.getAliasMap();
        HashMap builtin = Library.getAliasMap();
        it = h.keySet().iterator();
        while (it.hasNext()) {
            String alias = (String)it.next();
            String java = (String)h.get(alias);
            String biJava = (String)builtin.get(alias);
            if (biJava != null && biJava.equals(java)) continue;
            StringBuffer buffer = new StringBuffer(64);
            buffer.append("CREATE").append(' ').append("ALIAS").append(' ');
            buffer.append(alias);
            buffer.append(" FOR \"");
            buffer.append(java);
            buffer.append('\"');
            DatabaseScript.addRow(r, buffer.toString());
        }
        DatabaseScript.addSchemaStatements(database, r, indexRoots);
        DatabaseScript.addRightsStatements(database, r);
        if (database.logger.hasLog()) {
            boolean millis;
            int delay = database.logger.getWriteDelay();
            boolean bl = millis = delay < 1000;
            if (millis) {
                if (delay != 0 && delay < 20) {
                    delay = 20;
                }
            } else {
                delay /= 1000;
            }
            String statement = "SET WRITE_DELAY " + delay + (millis ? " MILLIS" : "");
            DatabaseScript.addRow(r, statement);
        }
        return r;
    }

    static void addSchemaStatements(Database database, Result r, boolean indexRoots) {
        Iterator schemas = database.schemaManager.userSchemaNameIterator();
        while (schemas.hasNext()) {
            Table t;
            int i;
            StringBuffer a;
            int i2;
            String schemaKey = (String)schemas.next();
            HsqlNameManager.HsqlName schema = database.schemaManager.toSchemaHsqlName(schemaKey);
            HashMappedList tTable = database.schemaManager.getTables(schema.name);
            HsqlArrayList forwardFK = new HsqlArrayList();
            String ddl = DatabaseScript.getSchemaCreateDDL(database, schema);
            DatabaseScript.addRow(r, ddl);
            Iterator it = database.schemaManager.sequenceIterator(schema.name);
            while (it.hasNext()) {
                NumberSequence seq = (NumberSequence)it.next();
                StringBuffer a2 = new StringBuffer(128);
                a2.append("CREATE").append(' ');
                a2.append("SEQUENCE").append(' ');
                a2.append(seq.getName().statementName).append(' ');
                a2.append("AS").append(' ');
                a2.append(Types.getTypeString(seq.getType())).append(' ');
                a2.append("START").append(' ');
                a2.append("WITH").append(' ');
                a2.append(seq.peek()).append(' ');
                if (seq.getIncrement() != 1L) {
                    a2.append("INCREMENT").append(' ');
                    a2.append("BY").append(' ');
                    a2.append(seq.getIncrement()).append(' ');
                }
                DatabaseScript.addRow(r, a2.toString());
            }
            int tSize = tTable.size();
            for (i2 = 0; i2 < tSize; ++i2) {
                String dataSource;
                Table t2 = (Table)tTable.get(i2);
                if (t2.isView()) continue;
                a = new StringBuffer(128);
                DatabaseScript.getTableDDL(database, t2, i2, forwardFK, false, a);
                DatabaseScript.addRow(r, a.toString());
                for (int j = 1; j < t2.getIndexCount(); ++j) {
                    Index index = t2.getIndex(j);
                    if (HsqlNameManager.HsqlName.isReservedIndexName(index.getName().name)) continue;
                    a = new StringBuffer(64);
                    a.append("CREATE").append(' ');
                    if (index.isUnique()) {
                        a.append("UNIQUE").append(' ');
                    }
                    a.append("INDEX").append(' ');
                    a.append(index.getName().statementName);
                    a.append(' ').append("ON").append(' ');
                    a.append(t2.getName().statementName);
                    int[] col = index.getColumns();
                    int len = index.getVisibleColumns();
                    DatabaseScript.getColumnList(t2, col, len, a);
                    DatabaseScript.addRow(r, a.toString());
                }
                if (t2.isText() && t2.isDataReadOnly()) {
                    a = new StringBuffer(64);
                    a.append("SET").append(' ').append("TABLE").append(' ');
                    a.append(t2.getName().statementName);
                    a.append(' ').append("READONLY").append(' ').append("TRUE");
                    DatabaseScript.addRow(r, a.toString());
                }
                if ((dataSource = DatabaseScript.getDataSource(t2)) != null) {
                    DatabaseScript.addRow(r, dataSource);
                }
                String header = DatabaseScript.getDataSourceHeader(t2);
                if (!indexRoots && header != null) {
                    DatabaseScript.addRow(r, header);
                }
                int numTrigs = 12;
                for (int tv = 0; tv < numTrigs; ++tv) {
                    HsqlArrayList trigVec = t2.triggerLists[tv];
                    if (trigVec == null) continue;
                    int trCount = trigVec.size();
                    for (int k = 0; k < trCount; ++k) {
                        a = ((TriggerDef)trigVec.get(k)).getDDL();
                        DatabaseScript.addRow(r, a.toString());
                    }
                }
            }
            tSize = forwardFK.size();
            for (i2 = 0; i2 < tSize; ++i2) {
                Constraint c = (Constraint)forwardFK.get(i2);
                a = new StringBuffer(128);
                a.append("ALTER").append(' ').append("TABLE").append(' ');
                a.append(c.getRef().getName().statementName);
                a.append(' ').append("ADD").append(' ');
                DatabaseScript.getFKStatement(c, a);
                DatabaseScript.addRow(r, a.toString());
            }
            Session sysSession = database.sessionManager.getSysSession();
            int tSize2 = tTable.size();
            for (i = 0; i < tSize2; ++i) {
                t = (Table)tTable.get(i);
                if (!indexRoots || !t.isIndexCached() || t.isEmpty(sysSession)) continue;
                DatabaseScript.addRow(r, DatabaseScript.getIndexRootsDDL((Table)tTable.get(i)));
            }
            tSize2 = tTable.size();
            for (i = 0; i < tSize2; ++i) {
                t = (Table)tTable.get(i);
                if (t.isTemp()) continue;
                String ddl2 = DatabaseScript.getIdentityUpdateDDL(t);
                DatabaseScript.addRow(r, ddl2);
            }
            tSize2 = tTable.size();
            for (i = 0; i < tSize2; ++i) {
                t = (Table)tTable.get(i);
                if (!t.isView()) continue;
                View v = (View)tTable.get(i);
                StringBuffer a3 = new StringBuffer(128);
                a3.append("CREATE").append(' ').append("VIEW").append(' ');
                a3.append(v.getName().statementName).append(' ').append('(');
                int count = v.getColumnCount();
                for (int j = 0; j < count; ++j) {
                    a3.append(v.getColumn((int)j).columnName.statementName);
                    if (j >= count - 1) continue;
                    a3.append(',');
                }
                a3.append(')').append(' ').append("AS").append(' ');
                a3.append(v.getStatement());
                DatabaseScript.addRow(r, a3.toString());
            }
        }
    }

    static String getIdentityUpdateDDL(Table t) {
        if (t.identityColumn == -1) {
            return "";
        }
        String tablename = t.getName().statementName;
        String colname = t.getColumn((int)t.identityColumn).columnName.statementName;
        long idval = t.identitySequence.peek();
        StringBuffer a = new StringBuffer(128);
        a.append("ALTER").append(' ').append("TABLE").append(' ').append(tablename).append(' ').append("ALTER").append(' ').append("COLUMN").append(' ').append(colname).append(' ').append("RESTART").append(' ').append("WITH").append(' ').append(idval);
        return a.toString();
    }

    static String getIndexRootsDDL(Table t) {
        StringBuffer a = new StringBuffer(128);
        a.append("SET").append(' ').append("TABLE").append(' ');
        a.append(t.getName().statementName);
        a.append(' ').append("INDEX").append('\'');
        a.append(t.getIndexRoots());
        a.append('\'');
        return a.toString();
    }

    static String getSchemaCreateDDL(Database database, HsqlNameManager.HsqlName schemaName) {
        StringBuffer ab = new StringBuffer(128);
        ab.append("CREATE").append(' ');
        ab.append("SCHEMA").append(' ');
        ab.append(schemaName.statementName).append(' ');
        ab.append("AUTHORIZATION").append(' ');
        ab.append("DBA");
        return ab.toString();
    }

    static void getTableDDL(Database database, Table t, int i, HsqlArrayList forwardFK, boolean useSchema, StringBuffer a) {
        a.append("CREATE").append(' ');
        if (t.isTemp) {
            a.append("GLOBAL").append(' ');
            a.append("TEMPORARY").append(' ');
        }
        if (t.isText()) {
            a.append("TEXT").append(' ');
        } else if (t.isCached()) {
            a.append("CACHED").append(' ');
        } else {
            a.append("MEMORY").append(' ');
        }
        a.append("TABLE").append(' ');
        if (useSchema) {
            a.append(t.getName().schema.statementName).append('.');
        }
        a.append(t.getName().statementName);
        a.append('(');
        int columns = t.getColumnCount();
        int[] pk = t.getPrimaryKey();
        HsqlNameManager.HsqlName pkName = null;
        Constraint pkConst = t.getPrimaryConstraint();
        if (pkConst != null && !pkConst.getName().isReservedIndexName()) {
            pkName = pkConst.getName();
        }
        for (int j = 0; j < columns; ++j) {
            String defaultString;
            Column column = t.getColumn(j);
            String colname = column.columnName.statementName;
            a.append(colname);
            a.append(' ');
            String sType = Types.getTypeString(column.getType());
            a.append(sType);
            boolean hasSize = false;
            if (column.getType() == 93) {
                if (column.getSize() != 6) {
                    hasSize = true;
                }
            } else {
                boolean bl = hasSize = column.getSize() > 0;
            }
            if (hasSize) {
                a.append('(');
                a.append(column.getSize());
                if (column.getScale() > 0) {
                    a.append(',');
                    a.append(column.getScale());
                }
                a.append(')');
            }
            if ((defaultString = column.getDefaultDDL()) != null) {
                a.append(' ').append("DEFAULT").append(' ');
                a.append(defaultString);
            }
            if (j == t.getIdentityColumn()) {
                a.append(" GENERATED BY DEFAULT AS IDENTITY(START WITH ");
                a.append(column.identityStart);
                if (column.identityIncrement != 1L) {
                    a.append(",").append("INCREMENT").append(' ').append("BY").append(' ');
                    a.append(column.identityIncrement);
                }
                a.append(")");
            }
            if (!column.isNullable()) {
                a.append(' ').append("NOT").append(' ').append("NULL");
            }
            if (pk.length == 1 && j == pk[0] && pkName == null) {
                a.append(' ').append("PRIMARY").append(' ').append("KEY");
            }
            if (j >= columns - 1) continue;
            a.append(',');
        }
        if (pk.length > 1 || pk.length == 1 && pkName != null) {
            a.append(',');
            if (pkName != null) {
                a.append("CONSTRAINT").append(' ');
                a.append(pkName.statementName).append(' ');
            }
            a.append("PRIMARY").append(' ').append("KEY");
            DatabaseScript.getColumnList(t, pk, pk.length, a);
        }
        block8: for (Constraint c : t.getConstraints()) {
            switch (c.getType()) {
                case 2: {
                    a.append(',').append("CONSTRAINT").append(' ');
                    a.append(c.getName().statementName);
                    a.append(' ').append("UNIQUE");
                    int[] col = c.getMainColumns();
                    DatabaseScript.getColumnList(c.getMain(), col, col.length, a);
                    continue block8;
                }
                case 0: {
                    Table maintable = c.getMain();
                    int maintableindex = database.schemaManager.getTableIndex(maintable);
                    if (maintableindex > i) {
                        forwardFK.add(c);
                        continue block8;
                    }
                    a.append(',');
                    DatabaseScript.getFKStatement(c, a);
                    continue block8;
                }
                case 3: {
                    try {
                        a.append(',').append("CONSTRAINT").append(' ');
                        a.append(c.getName().statementName);
                        a.append(' ').append("CHECK").append('(');
                        a.append(c.core.check.getDDL());
                        a.append(')');
                        continue block8;
                    }
                    catch (HsqlException e) {
                        // empty catch block
                    }
                }
            }
        }
        a.append(')');
        if (t.onCommitPreserve) {
            a.append(' ').append("ON").append(' ');
            a.append("COMMIT").append(' ').append("PRESERVE");
            a.append(' ').append("ROWS");
        }
    }

    static String getDataSource(Table t) {
        String dataSource = t.getDataSource();
        if (dataSource == null) {
            return null;
        }
        boolean isDesc = t.isDescDataSource();
        StringBuffer a = new StringBuffer(128);
        a.append("SET").append(' ').append("TABLE").append(' ');
        a.append(t.getName().statementName);
        a.append(' ').append("SOURCE").append(' ').append('\"');
        a.append(dataSource);
        a.append('\"');
        if (isDesc) {
            a.append(' ').append("DESC");
        }
        return a.toString();
    }

    static String getDataSourceHeader(Table t) {
        String header = t.getHeader();
        if (header == null) {
            return null;
        }
        StringBuffer a = new StringBuffer(128);
        a.append("SET").append(' ').append("TABLE").append(' ');
        a.append(t.getName().statementName);
        a.append(' ').append("SOURCE").append(' ');
        a.append("HEADER").append(' ');
        a.append(header);
        return a.toString();
    }

    private static void getColumnList(Table t, int[] col, int len, StringBuffer a) {
        a.append('(');
        for (int i = 0; i < len; ++i) {
            a.append(t.getColumn((int)col[i]).columnName.statementName);
            if (i >= len - 1) continue;
            a.append(',');
        }
        a.append(')');
    }

    private static void getFKStatement(Constraint c, StringBuffer a) {
        a.append("CONSTRAINT").append(' ');
        a.append(c.getName().statementName);
        a.append(' ').append("FOREIGN").append(' ').append("KEY");
        int[] col = c.getRefColumns();
        DatabaseScript.getColumnList(c.getRef(), col, col.length, a);
        a.append(' ').append("REFERENCES").append(' ');
        a.append(c.getMain().getName().statementName);
        col = c.getMainColumns();
        DatabaseScript.getColumnList(c.getMain(), col, col.length, a);
        if (c.getDeleteAction() != 3) {
            a.append(' ').append("ON").append(' ').append("DELETE").append(' ');
            a.append(DatabaseScript.getFKAction(c.getDeleteAction()));
        }
        if (c.getUpdateAction() != 3) {
            a.append(' ').append("ON").append(' ').append("UPDATE").append(' ');
            a.append(DatabaseScript.getFKAction(c.getUpdateAction()));
        }
    }

    private static String getFKAction(int action) {
        switch (action) {
            case 0: {
                return "CASCADE";
            }
            case 4: {
                return "SET DEFAULT";
            }
            case 2: {
                return "SET NULL";
            }
        }
        return "NO ACTION";
    }

    private static void addRow(Result r, String sql) {
        if (sql == null || sql.length() == 0) {
            return;
        }
        Object[] s = new String[]{sql};
        r.add(s);
    }

    private static void addRightsStatements(Database dDatabase, Result r) {
        String name;
        HashMappedList userlist = dDatabase.getUserManager().getUsers();
        Iterator users = userlist.values().iterator();
        GranteeManager gm = dDatabase.getGranteeManager();
        Iterator grantees = gm.getGrantees().iterator();
        while (users.hasNext()) {
            User u = (User)users.next();
            name = u.getName();
            if (name.equals("PUBLIC")) continue;
            DatabaseScript.addRow(r, u.getCreateUserDDL());
        }
        while (grantees.hasNext()) {
            IntValueHashMap rightsmap;
            Grantee g = (Grantee)grantees.next();
            name = g.getName();
            if (name.equals("_SYSTEM") || name.equals("DBA")) continue;
            String roleString = g.allRolesString();
            if (roleString != null) {
                DatabaseScript.addRow(r, "GRANT " + roleString + " TO " + name);
            }
            if ((rightsmap = g.getRights()) == null) continue;
            Iterator dbobjects = rightsmap.keySet().iterator();
            while (dbobjects.hasNext()) {
                Object nameobject = dbobjects.next();
                int right = rightsmap.get(nameobject, 0);
                StringBuffer a = new StringBuffer(64);
                a.append("GRANT").append(' ');
                a.append(GranteeManager.getRightsList(right));
                a.append(' ').append("ON").append(' ');
                if (nameobject instanceof String) {
                    if (nameobject.equals("java.lang.Math") || nameobject.equals("org.hsqldb.Library")) continue;
                    a.append("CLASS \"");
                    a.append((String)nameobject);
                    a.append('\"');
                } else {
                    HsqlNameManager.HsqlName hsqlname = (HsqlNameManager.HsqlName)nameobject;
                    Table table = dDatabase.schemaManager.findUserTable(null, hsqlname.name, hsqlname.schema.name);
                    if (table == null) continue;
                    a.append(hsqlname.schema.statementName).append('.').append(hsqlname.statementName);
                }
                a.append(' ').append("TO").append(' ');
                a.append(g.getName());
                DatabaseScript.addRow(r, a.toString());
            }
        }
    }
}

