/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.DINameSpace;
import org.hsqldb.HsqlException;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.resources.BundleHandler;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Binary;

final class DIProcedureInfo {
    static final String conClsName = "java.sql.Connection";
    static final int procedureResultUnknown = 0;
    static final int procedureNoResult = 1;
    static final int procedureReturnsResult = 2;
    static final int procedureColumnUnknown = 0;
    static final int procedureColumnIn = 1;
    static final int procedureColumnInOut = 2;
    static final int procedureColumnResult = 3;
    static final int procedureColumnOut = 4;
    static final int procedureColumnReturn = 5;
    static final int procedureNoNulls = 0;
    static final int procedureNullable = 1;
    static final int procedureNullableUnknown = 2;
    private Class clazz;
    private Class[] colClasses;
    private int[] colTypes;
    private int colOffset;
    private int colCount;
    private boolean colsResolved;
    private String fqn;
    private String specificName;
    private int hnd_remarks;
    private Method method;
    private String sig;
    private DINameSpace nameSpace;
    private final HashMap typeMap = new HashMap();

    public DIProcedureInfo(DINameSpace ns) throws HsqlException {
        this.setNameSpace(ns);
    }

    private int colOffset() {
        if (!this.colsResolved) {
            this.resolveCols();
        }
        return this.colOffset;
    }

    HsqlArrayList getAliases() {
        return (HsqlArrayList)this.nameSpace.getInverseAliasMap().get(this.getFQN());
    }

    Class getColClass(int i) {
        return this.colClasses[i + this.colOffset()];
    }

    int getColCount() {
        if (!this.colsResolved) {
            this.resolveCols();
        }
        return this.colCount;
    }

    Integer getColDataType(int i) {
        return ValuePool.getInt(this.getColTypeCode(i));
    }

    Integer getColLen(int i) {
        int size;
        int type = this.getColTypeCode(i);
        switch (type) {
            case -4: 
            case -3: 
            case -2: {
                size = Integer.MAX_VALUE;
                break;
            }
            case -5: 
            case 6: 
            case 8: 
            case 91: 
            case 92: {
                size = 8;
                break;
            }
            case 93: {
                size = 12;
                break;
            }
            case 4: 
            case 7: {
                size = 4;
                break;
            }
            case 5: {
                size = 2;
                break;
            }
            case -6: 
            case 16: {
                size = 1;
                break;
            }
            default: {
                size = 0;
            }
        }
        return size == 0 ? null : ValuePool.getInt(size);
    }

    String getColName(int i) {
        return "@p" + (i + this.colOffset());
    }

    Integer getColNullability(int i) {
        int cn = this.getColClass(i).isPrimitive() ? 0 : 1;
        return ValuePool.getInt(cn);
    }

    String getColRemark(int i) {
        StringBuffer sb = new StringBuffer(this.getSignature());
        String key = sb.append('@').append(i + this.colOffset()).toString();
        return BundleHandler.getString(this.hnd_remarks, key);
    }

    int getColSequence(int i) {
        return i + this.colOffset() == 0 ? this.colCount : i;
    }

    int getColTypeCode(int i) {
        return this.colTypes[i += this.colOffset()];
    }

    Integer getColUsage(int i) {
        switch (i + this.colOffset()) {
            case 0: {
                return ValuePool.getInt(3);
            }
        }
        return ValuePool.getInt(1);
    }

    Class getDeclaringClass() {
        return this.clazz;
    }

    String getFQN() {
        if (this.fqn == null) {
            StringBuffer sb = new StringBuffer();
            this.fqn = sb.append(this.clazz.getName()).append('.').append(this.method.getName()).toString();
        }
        return this.fqn;
    }

    String getSpecificName() {
        if (this.specificName == null) {
            this.specificName = this.clazz.getName() + "." + this.getSignature();
        }
        return this.specificName;
    }

    Integer getInputParmCount() {
        return ValuePool.getInt(this.method.getParameterTypes().length);
    }

    Method getMethod() {
        return this.method;
    }

    String getOrigin(String srcType) {
        return (this.nameSpace.isBuiltin(this.clazz) ? "BUILTIN " : "USER DEFINED ") + srcType;
    }

    Integer getOutputParmCount() {
        return ValuePool.getInt(0);
    }

    String getRemark() {
        return BundleHandler.getString(this.hnd_remarks, this.getSignature());
    }

    Integer getResultSetCount() {
        return this.method.getReturnType() == Void.TYPE ? ValuePool.getInt(0) : ValuePool.getInt(1);
    }

    Integer getResultType(String origin) {
        int type = !"ROUTINE".equals(origin) ? 0 : (this.method.getReturnType() == Void.TYPE ? 1 : 2);
        return ValuePool.getInt(type);
    }

    String getSignature() {
        if (this.sig == null) {
            this.sig = DINameSpace.getSignature(this.method);
        }
        return this.sig;
    }

    static String getMethodSpecificName(Method m) {
        return m == null ? null : m.getDeclaringClass().getName() + '.' + DINameSpace.getSignature(m);
    }

    DINameSpace getNameSpace() {
        return this.nameSpace;
    }

    void setNameSpace(DINameSpace ns) throws HsqlException {
        Class c;
        this.nameSpace = ns;
        try {
            c = this.nameSpace.classForName("org.hsqldb.jdbc.jdbcArray");
            this.typeMap.put(c, ValuePool.getInt(2003));
        }
        catch (Exception e) {
            // empty catch block
        }
        Integer type = ValuePool.getInt(-5);
        this.typeMap.put(Long.TYPE, type);
        this.typeMap.put(Long.class, type);
        type = ValuePool.getInt(16);
        this.typeMap.put(Boolean.TYPE, type);
        this.typeMap.put(Boolean.class, type);
        type = ValuePool.getInt(2004);
        try {
            c = this.nameSpace.classForName("org.hsqldb.jdbc.jdbcBlob");
            this.typeMap.put(c, type);
        }
        catch (Exception e) {
            // empty catch block
        }
        type = ValuePool.getInt(1);
        this.typeMap.put(Character.TYPE, type);
        this.typeMap.put(Character.class, type);
        this.typeMap.put(Character[].class, type);
        this.typeMap.put(char[].class, type);
        type = ValuePool.getInt(2005);
        try {
            c = this.nameSpace.classForName("org.hsqldb.jdbc.jdbcClob");
            this.typeMap.put(c, type);
        }
        catch (Exception e) {
            // empty catch block
        }
        type = ValuePool.getInt(70);
        this.typeMap.put(URL.class, type);
        type = ValuePool.getInt(91);
        this.typeMap.put(java.util.Date.class, type);
        this.typeMap.put(Date.class, type);
        type = ValuePool.getInt(3);
        try {
            c = this.nameSpace.classForName("java.math.BigDecimal");
            this.typeMap.put(c, type);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            c = this.nameSpace.classForName("org.hsqldb.jdbc.jdbcDistinct");
            this.typeMap.put(c, ValuePool.getInt(2001));
        }
        catch (Exception e) {
            // empty catch block
        }
        type = ValuePool.getInt(8);
        this.typeMap.put(Double.TYPE, type);
        this.typeMap.put(Double.class, type);
        type = ValuePool.getInt(6);
        this.typeMap.put(Float.TYPE, type);
        this.typeMap.put(Float.class, type);
        type = ValuePool.getInt(4);
        this.typeMap.put(Integer.TYPE, type);
        this.typeMap.put(Integer.class, type);
        type = ValuePool.getInt(2000);
        this.typeMap.put(Object.class, type);
        type = ValuePool.getInt(-4);
        this.typeMap.put(byte[].class, type);
        this.typeMap.put(Binary.class, type);
        type = ValuePool.getInt(-1);
        this.typeMap.put(String.class, type);
        type = ValuePool.getInt(0);
        this.typeMap.put(Void.TYPE, type);
        this.typeMap.put(Void.class, type);
        type = ValuePool.getInt(2006);
        try {
            c = this.nameSpace.classForName("org.hsqldb.jdbc.jdbcRef");
            this.typeMap.put(c, type);
        }
        catch (Exception e) {
            // empty catch block
        }
        type = ValuePool.getInt(5);
        this.typeMap.put(Short.TYPE, type);
        this.typeMap.put(Short.class, type);
        type = ValuePool.getInt(2002);
        try {
            c = this.nameSpace.classForName("org.hsqldb.jdbc.jdbcStruct");
            this.typeMap.put(c, type);
        }
        catch (Exception e) {
            // empty catch block
        }
        type = ValuePool.getInt(92);
        this.typeMap.put(Time.class, type);
        type = ValuePool.getInt(93);
        this.typeMap.put(Timestamp.class, type);
        type = ValuePool.getInt(-6);
        this.typeMap.put(Byte.TYPE, type);
        this.typeMap.put(Byte.class, type);
        type = ValuePool.getInt(137);
        try {
            c = this.nameSpace.classForName("org.w3c.dom.Document");
            this.typeMap.put(c, type);
            c = this.nameSpace.classForName("org.w3c.dom.DocumentFragment");
            this.typeMap.put(c, type);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void resolveCols() {
        Class<?> rType = this.method.getReturnType();
        Class<?>[] pTypes = this.method.getParameterTypes();
        int ptlen = pTypes.length;
        boolean isFPCON = ptlen > 0 && pTypes[0].getName().equals(conClsName);
        int pclen = 1 + ptlen - (isFPCON ? 1 : 0);
        this.colClasses = new Class[pclen];
        this.colTypes = new int[pclen];
        this.colClasses[0] = rType;
        this.colTypes[0] = this.typeForClass(rType);
        int i = isFPCON ? 1 : 0;
        int idx = 1;
        while (i < ptlen) {
            Class<?> clazz;
            this.colClasses[idx] = clazz = pTypes[i];
            this.colTypes[idx] = this.typeForClass(clazz);
            ++i;
            ++idx;
        }
        this.colOffset = rType == Void.TYPE ? 1 : 0;
        this.colCount = pclen - this.colOffset;
    }

    void setMethod(Method m) {
        this.method = m;
        this.clazz = this.method.getDeclaringClass();
        this.fqn = null;
        this.specificName = null;
        this.sig = null;
        this.colsResolved = false;
        String remarkKey = this.clazz.getName().replace('.', '_');
        this.hnd_remarks = BundleHandler.getBundleHandle(remarkKey, null);
    }

    int typeForClass(Class c) {
        Class<?> to;
        Integer type = (Integer)this.typeMap.get(c);
        if (type != null) {
            return type;
        }
        if (c.isArray() && !c.getComponentType().isArray()) {
            return 2003;
        }
        try {
            to = Class.forName("java.sql.Array");
            if (to.isAssignableFrom(c)) {
                return 2003;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (Number.class.isAssignableFrom(c)) {
            return 2;
        }
        try {
            to = Class.forName("java.sql.Timestamp");
            if (to.isAssignableFrom(c)) {
                return 93;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            to = Class.forName("java.sql.Time");
            if (to.isAssignableFrom(c)) {
                return 93;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            to = Class.forName("java.sql.Date");
            if (to.isAssignableFrom(c)) {
                return 91;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            to = Class.forName("java.sql.Blob");
            if (to.isAssignableFrom(c)) {
                return 2004;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            to = Class.forName("java.sql.Clob");
            if (to.isAssignableFrom(c)) {
                return 2005;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            to = Class.forName("java.sql.Ref");
            if (to.isAssignableFrom(c)) {
                return 2006;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            to = Class.forName("java.sql.Struct");
            if (to.isAssignableFrom(c)) {
                return 2002;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (Binary.class.isAssignableFrom(c)) {
            return -4;
        }
        try {
            to = Class.forName("java.lang.CharSequence");
            if (to.isAssignableFrom(c)) {
                return -1;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (Serializable.class.isAssignableFrom(c)) {
            return 1111;
        }
        return 2000;
    }
}

