/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ConstraintCore;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Index;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.index.RowIterator;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.Iterator;

class Constraint {
    static final int CASCADE = 0;
    static final int SET_NULL = 2;
    static final int NO_ACTION = 3;
    static final int SET_DEFAULT = 4;
    static final int INIT_DEFERRED = 5;
    static final int INIT_IMMEDIATE = 6;
    static final int NOT_DEFERRABLE = 7;
    static final int FOREIGN_KEY = 0;
    static final int MAIN = 1;
    static final int UNIQUE = 2;
    static final int CHECK = 3;
    static final int PRIMARY_KEY = 4;
    ConstraintCore core;
    HsqlNameManager.HsqlName constName;
    int constType;

    Constraint(HsqlNameManager.HsqlName name, Table t, Index index, int type) {
        this.core = new ConstraintCore();
        this.constName = name;
        this.constType = type;
        this.core.mainTable = t;
        this.core.mainIndex = index;
        this.core.mainColArray = ArrayUtil.arraySlice(index.getColumns(), 0, index.getVisibleColumns());
        this.core.colLen = this.core.mainColArray.length;
    }

    Constraint(HsqlNameManager.HsqlName name, Constraint fkconstraint) {
        this.constName = name;
        this.constType = 1;
        this.core = fkconstraint.core;
    }

    Constraint(HsqlNameManager.HsqlName pkname, HsqlNameManager.HsqlName name, Table mainTable, Table refTable, int[] mainCols, int[] refCols, Index mainIndex, Index refIndex, int deleteAction, int updateAction) throws HsqlException {
        this.core = new ConstraintCore();
        this.core.pkName = pkname;
        this.core.fkName = name;
        this.constName = name;
        this.constType = 0;
        this.core.mainTable = mainTable;
        this.core.refTable = refTable;
        this.core.mainColArray = mainCols;
        this.core.colLen = this.core.mainColArray.length;
        this.core.refColArray = refCols;
        this.core.mainIndex = mainIndex;
        this.core.refIndex = refIndex;
        this.core.deleteAction = deleteAction;
        this.core.updateAction = updateAction;
    }

    Constraint(HsqlNameManager.HsqlName name, int[] mainCols, Table refTable, int[] refCols, int type, int deleteAction, int updateAction) {
        this.core = new ConstraintCore();
        this.constName = name;
        this.constType = type;
        this.core.mainColArray = mainCols;
        this.core.refTable = refTable;
        this.core.refColArray = refCols;
        this.core.deleteAction = deleteAction;
        this.core.updateAction = updateAction;
    }

    private Constraint() {
    }

    HsqlNameManager.HsqlName getName() {
        return this.constName;
    }

    private void setName(String name, boolean isquoted) throws HsqlException {
        this.constName.rename(name, isquoted);
    }

    String getPkName() {
        return this.core.pkName == null ? null : this.core.pkName.name;
    }

    String getFkName() {
        return this.core.fkName == null ? null : this.core.fkName.name;
    }

    int getType() {
        return this.constType;
    }

    Table getMain() {
        return this.core.mainTable;
    }

    Index getMainIndex() {
        return this.core.mainIndex;
    }

    Table getRef() {
        return this.core.refTable;
    }

    Index getRefIndex() {
        return this.core.refIndex;
    }

    int getDeleteAction() {
        return this.core.deleteAction;
    }

    int getUpdateAction() {
        return this.core.updateAction;
    }

    int[] getMainColumns() {
        return this.core.mainColArray;
    }

    int[] getRefColumns() {
        return this.core.refColArray;
    }

    boolean isIndexFK(Index index) {
        return !(this.constType != 0 && this.constType != 1 || this.core.mainIndex != index && this.core.refIndex != index);
    }

    boolean isIndexUnique(Index index) {
        return this.constType == 2 && this.core.mainIndex == index;
    }

    boolean hasColumn(Table table, String colname) {
        if (this.constType != 3) {
            return false;
        }
        Expression.Collector coll = new Expression.Collector();
        coll.addAll(this.core.check, 2);
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            if (!e.getColumnName().equals(colname) || !table.tableName.name.equals(e.getTableName())) continue;
            return true;
        }
        return false;
    }

    boolean hasColumn(int colIndex) {
        if (this.constType == 1) {
            return ArrayUtil.find(this.core.mainColArray, colIndex) != -1;
        }
        if (this.constType == 0) {
            return ArrayUtil.find(this.core.refColArray, colIndex) != -1;
        }
        return false;
    }

    boolean isEquivalent(int[] col, int type) {
        if (type != this.constType || this.constType != 2 || this.core.colLen != col.length) {
            return false;
        }
        return ArrayUtil.haveEqualSets(this.core.mainColArray, col, this.core.colLen);
    }

    boolean isEquivalent(Table tablemain, int[] colmain, Table tableref, int[] colref) {
        if (this.constType != 1 && this.constType != 0) {
            return false;
        }
        if (tablemain != this.core.mainTable || tableref != this.core.refTable) {
            return false;
        }
        return ArrayUtil.areEqualSets(this.core.mainColArray, colmain) && ArrayUtil.areEqualSets(this.core.refColArray, colref);
    }

    void replaceTable(Table oldt, Table newt, int colindex, int adjust) throws HsqlException {
        if (oldt == this.core.mainTable) {
            this.core.mainTable = newt;
            if (this.core.mainIndex != null) {
                this.core.mainIndex = this.core.mainTable.getIndex(this.core.mainIndex.getName().name);
                this.core.mainColArray = ArrayUtil.toAdjustedColumnArray(this.core.mainColArray, colindex, adjust);
            }
        }
        if (oldt == this.core.refTable) {
            this.core.refTable = newt;
            if (this.core.refIndex != null) {
                this.core.refIndex = this.core.refTable.getIndex(this.core.refIndex.getName().name);
                if (this.core.refIndex != this.core.mainIndex) {
                    this.core.refColArray = ArrayUtil.toAdjustedColumnArray(this.core.refColArray, colindex, adjust);
                }
            }
        }
    }

    void checkInsert(Session session, Object[] row) throws HsqlException {
        if (this.constType == 1 || this.constType == 2 || this.constType == 4) {
            return;
        }
        if (this.constType == 3) {
            this.checkCheckConstraint(session, row);
            return;
        }
        if (Index.isNull(row, this.core.refColArray)) {
            return;
        }
        boolean exists = this.core.mainIndex.exists(session, row, this.core.refColArray);
        if (!exists) {
            if (this.core.mainTable == this.core.refTable) {
                boolean match = true;
                for (int i = 0; i < this.core.colLen; ++i) {
                    if (row[this.core.refColArray[i]].equals(row[this.core.mainColArray[i]])) continue;
                    match = false;
                    break;
                }
                if (match) {
                    return;
                }
            }
            throw Trace.error(177, 100, new Object[]{this.core.fkName.name, this.core.mainTable.getName().name});
        }
    }

    void checkCheckConstraint(Session session, Object[] row) throws HsqlException {
        this.core.checkFilter.currentData = row;
        boolean nomatch = Boolean.FALSE.equals(this.core.check.test(session));
        this.core.checkFilter.currentData = null;
        if (nomatch) {
            throw Trace.error(157, 100, new Object[]{this.constName.name, this.core.mainTable.tableName.name});
        }
    }

    RowIterator findFkRef(Session session, Object[] row, boolean delete) throws HsqlException {
        if (row == null || Index.isNull(row, this.core.mainColArray)) {
            return this.core.refIndex.emptyIterator();
        }
        return delete ? this.core.refIndex.findFirstRowForDelete(session, row, this.core.mainColArray) : this.core.refIndex.findFirstRow(session, row, this.core.mainColArray);
    }

    boolean hasMainRef(Session session, Object[] row) throws HsqlException {
        if (Index.isNull(row, this.core.refColArray)) {
            return false;
        }
        boolean exists = this.core.mainIndex.exists(session, row, this.core.refColArray);
        if (!exists) {
            throw Trace.error(177, 100, new Object[]{this.core.fkName.name, this.core.refTable.getName().name});
        }
        return exists;
    }

    private static boolean hasReferencedRow(Session session, Object[] rowdata, int[] rowColArray, Index mainIndex) throws HsqlException {
        if (Index.isNull(rowdata, rowColArray)) {
            return true;
        }
        return mainIndex.exists(session, rowdata, rowColArray);
    }

    static void checkReferencedRows(Session session, Table table, int[] rowColArray, Index mainIndex) throws HsqlException {
        Row row;
        RowIterator it = table.getPrimaryIndex().firstRow(session);
        while ((row = it.next()) != null) {
            Object[] rowdata = row.getData();
            if (Constraint.hasReferencedRow(session, rowdata, rowColArray, mainIndex)) continue;
            String colvalues = "";
            for (int i = 0; i < rowColArray.length; ++i) {
                Object o = rowdata[rowColArray[i]];
                colvalues = colvalues + o;
                colvalues = colvalues + ",";
            }
            throw Trace.error(177, 100, new Object[]{colvalues, table.getName().name});
        }
    }
}

