/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.CharSegment;
import java.io.InputStream;

public final class CharBuffer
extends CharSegment {
    private static final int MIN_CAPACITY = 16;

    public CharBuffer() {
        this._buffer = new char[16];
        this._length = 0;
    }

    public CharBuffer(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        if (capacity < 16) {
            capacity = 16;
        }
        this._buffer = new char[capacity];
        this._length = 0;
    }

    public CharBuffer(String string) {
        int length = string.length();
        int capacity = length + 16;
        this._buffer = new char[capacity];
        this._length = length;
        string.getChars(0, length, this._buffer, 0);
    }

    public CharBuffer(String string, int offset, int length) {
        int capacity = length;
        if (capacity < 16) {
            capacity = 16;
        }
        this._buffer = new char[capacity];
        this._length = length;
        string.getChars(offset, length, this._buffer, 0);
    }

    public static CharBuffer allocate() {
        return new CharBuffer();
    }

    public void free() {
    }

    public int length() {
        return this._length;
    }

    public int getLength() {
        return this._length;
    }

    public int capacity() {
        return this._buffer.length;
    }

    public int getCapacity() {
        return this._buffer.length;
    }

    public final void ensureCapacity(int minimumCapacity) {
        if (minimumCapacity <= this._buffer.length) {
            return;
        }
        this.expandCapacity(minimumCapacity);
    }

    private final void expandCapacity(int minimumCapacity) {
        int oldCapacity = this._buffer.length;
        int newCapacity = oldCapacity * 2;
        if (newCapacity < 0) {
            newCapacity = Integer.MAX_VALUE;
        } else if (newCapacity < minimumCapacity) {
            newCapacity = minimumCapacity;
        }
        char[] chars = new char[newCapacity];
        System.arraycopy(this._buffer, 0, chars, 0, oldCapacity);
        this._buffer = chars;
    }

    public final void clear() {
        this._length = 0;
    }

    public final void setLength(int newLength) {
        if (newLength < 0) {
            throw new IndexOutOfBoundsException("illegal argument");
        }
        if (this._buffer.length < newLength) {
            this.expandCapacity(newLength);
        }
        this._length = newLength;
    }

    public char charAt(int i) {
        if (i < 0 || this._length <= i) {
            throw new IndexOutOfBoundsException();
        }
        return this._buffer[i];
    }

    public char getLastChar() {
        if (this._length == 0) {
            throw new IndexOutOfBoundsException();
        }
        return this._buffer[this._length - 1];
    }

    public final char[] getBuffer() {
        return this._buffer;
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        char[] buffer = this._buffer;
        while (srcBegin < srcEnd) {
            dst[dstBegin++] = buffer[srcBegin++];
        }
    }

    public void setCharAt(int index, char ch) {
        if (index < 0 || this._length <= index) {
            throw new IndexOutOfBoundsException();
        }
        this._buffer[index] = ch;
    }

    public CharBuffer append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public CharBuffer append(CharBuffer cb) {
        return this.append(cb._buffer, 0, cb._length);
    }

    public CharBuffer append(String string) {
        if (string == null) {
            string = "null";
        }
        int len = string.length();
        int newLength = this._length + len;
        int length = this._length;
        if (this._buffer.length <= newLength) {
            this.expandCapacity(newLength);
        }
        string.getChars(0, len, this._buffer, length);
        this._length = newLength;
        return this;
    }

    public CharBuffer append(String string, int offset, int len) {
        if (this._buffer.length <= len + this._length) {
            this.expandCapacity(len + this._length);
        }
        string.getChars(offset, offset + len, this._buffer, this._length);
        this._length += len;
        return this;
    }

    public CharBuffer append(char[] buffer) {
        return this.append(buffer, 0, buffer.length);
    }

    public CharBuffer append(char[] buffer, int offset, int length) {
        if (this._buffer.length < this._length + length) {
            this.expandCapacity(this._length + length);
        }
        System.arraycopy(buffer, offset, this._buffer, this._length, length);
        this._length += length;
        return this;
    }

    public final CharBuffer append(boolean b) {
        return this.append(String.valueOf(b));
    }

    public final CharBuffer append(char ch) {
        if (this._buffer.length <= this._length) {
            this.expandCapacity(this._length + 1);
        }
        this._buffer[this._length++] = ch;
        return this;
    }

    public CharBuffer append(int i) {
        int length = this._length;
        if (this._buffer.length <= length + 16) {
            this.expandCapacity(length + 16);
        }
        char[] buffer = this._buffer;
        if (i < 0) {
            buffer[length++] = 45;
            i = -i;
        } else if (i == 0) {
            buffer[this._length++] = 48;
            return this;
        }
        int start = length;
        while (i > 0) {
            buffer[length++] = (char)(i % 10 + 48);
            i /= 10;
        }
        for (int j = (length - start) / 2; j > 0; --j) {
            char temp = buffer[length - j];
            buffer[length - j] = buffer[start + j - 1];
            buffer[start + j - 1] = temp;
        }
        this._length = length;
        return this;
    }

    public CharBuffer append(long i) {
        if (i == Long.MIN_VALUE) {
            return this.append("-9223372036854775808");
        }
        int length = this._length;
        if (this._buffer.length < length + 32) {
            this.expandCapacity(length + 32);
        }
        char[] buffer = this._buffer;
        if (i < 0L) {
            buffer[length++] = 45;
            i = -i;
        } else if (i == 0L) {
            buffer[this._length++] = 48;
            return this;
        }
        int start = length;
        while (i > 0L) {
            buffer[length++] = (char)(i % 10L + 48L);
            i /= 10L;
        }
        for (int j = (length - start) / 2; j > 0; --j) {
            char temp = buffer[length - j];
            buffer[length - j] = buffer[start + j - 1];
            buffer[start + j - 1] = temp;
        }
        this._length = length;
        return this;
    }

    public CharBuffer append(float f) {
        return this.append(String.valueOf(f));
    }

    public CharBuffer append(double d) {
        return this.append(String.valueOf(d));
    }

    public final CharBuffer append(byte[] buf, int offset, int len) {
        int length = this._length;
        if (this._buffer.length < this._length + len) {
            this.expandCapacity(this._length + len);
        }
        char[] buffer = this._buffer;
        while (len > 0) {
            buffer[length++] = (char)buf[offset++];
            --len;
        }
        this._length = length;
        return this;
    }

    public CharBuffer delete(int start, int end) {
        if (start < 0 || end < start || this._length < start) {
            throw new StringIndexOutOfBoundsException();
        }
        if (this._length < end) {
            end = this._length;
        }
        int tail = this._length - end;
        char[] buffer = this._buffer;
        for (int i = 0; i < tail; ++i) {
            buffer[start + i] = buffer[end + i];
        }
        this._length -= end - start;
        return this;
    }

    public CharBuffer deleteCharAt(int index) {
        if (index < 0 || this._length < index) {
            throw new StringIndexOutOfBoundsException();
        }
        if (index == this._length) {
            return this;
        }
        int tail = this._length - index + 1;
        char[] buffer = this._buffer;
        for (int i = 0; i < tail; ++i) {
            buffer[index + i] = buffer[index + i + 1];
        }
        --this._length;
        return this;
    }

    public CharBuffer replace(int start, int end, String string) {
        int length;
        if (start < 0 || end < start || this._length < start) {
            throw new StringIndexOutOfBoundsException();
        }
        int len = string.length();
        if (this._buffer.length < len + (length = this._length) - (end - start)) {
            this.expandCapacity(len + length - (end - start));
        }
        char[] buffer = this._buffer;
        if (len < end - start) {
            int tail = length - end;
            for (int i = 0; i < tail; ++i) {
                buffer[start + len + i] = buffer[end + i];
            }
        } else {
            int tail = length - end;
            for (int i = tail - 1; i >= 0; --i) {
                buffer[end + i] = buffer[start + len + i];
            }
        }
        string.getChars(0, len, buffer, start);
        this._length = length + len - (end - start);
        return this;
    }

    public CharBuffer replace(int start, int end, char[] buffer, int offset, int len) {
        if (start < 0 || end < start || this._length < start) {
            throw new StringIndexOutOfBoundsException();
        }
        if (this._buffer.length < len + this._length - (end - start)) {
            this.expandCapacity(len + this._length - (end - start));
        }
        char[] thisBuffer = this._buffer;
        if (len < end - start) {
            int tail = this._length - end;
            for (int i = 0; i < tail; ++i) {
                thisBuffer[start + len + i] = thisBuffer[end + i];
            }
        } else {
            int tail = this._length - end;
            for (int i = tail - 1; i >= 0; --i) {
                thisBuffer[end + i] = thisBuffer[start + len + i];
            }
        }
        System.arraycopy(buffer, offset, thisBuffer, start, len);
        this._length += len - (end - start);
        return this;
    }

    public String substring(int start) {
        if (this._length < start || start < 0) {
            throw new StringIndexOutOfBoundsException();
        }
        return new String(this._buffer, start, this._length - start);
    }

    public String substring(int start, int end) {
        if (this._length < start || start < 0 || end < start) {
            throw new StringIndexOutOfBoundsException();
        }
        return new String(this._buffer, start, end - start);
    }

    public CharBuffer insert(int index, String string) {
        if (string == null) {
            string = "null";
        }
        if (index < 0 || this._length < index) {
            throw new StringIndexOutOfBoundsException();
        }
        int len = string.length();
        if (this._buffer.length < this._length + len) {
            this.expandCapacity(len + this._length);
        }
        int tail = this._length - index;
        char[] buffer = this._buffer;
        for (int i = tail - 1; i >= 0; --i) {
            buffer[index + len + i] = buffer[index + i];
        }
        string.getChars(0, len, buffer, index);
        this._length += len;
        return this;
    }

    public CharBuffer insert(int index, char[] buffer, int offset, int len) {
        if (index < 0 || this._length < index) {
            throw new StringIndexOutOfBoundsException();
        }
        if (this._buffer.length < len + this._length) {
            this.expandCapacity(len + this._length);
        }
        int tail = this._length - index;
        char[] thisBuffer = this._buffer;
        for (int i = tail - 1; i >= 0; --i) {
            buffer[index + len + i] = thisBuffer[index + i];
        }
        System.arraycopy(buffer, offset, thisBuffer, index, len);
        this._length += len;
        return this;
    }

    public CharBuffer insert(int offset, Object o) {
        return this.insert(offset, String.valueOf(o));
    }

    public CharBuffer insert(int offset, char ch) {
        return this.insert(offset, String.valueOf(ch));
    }

    public CharBuffer insert(int offset, int i) {
        return this.insert(offset, String.valueOf(i));
    }

    public CharBuffer insert(int offset, long l) {
        return this.insert(offset, String.valueOf(l));
    }

    public CharBuffer insert(int offset, float f) {
        return this.insert(offset, String.valueOf(f));
    }

    public CharBuffer insert(int offset, double d) {
        return this.insert(offset, String.valueOf(d));
    }

    public int indexOf(char ch) {
        return this.indexOf(ch, 0);
    }

    public Object clone() {
        CharBuffer newBuffer = new CharBuffer();
        newBuffer.setLength(this._length);
        System.arraycopy(this._buffer, 0, newBuffer._buffer, 0, this._length);
        return newBuffer;
    }

    public String toString() {
        return new String(this._buffer, 0, this._length);
    }

    public String close() {
        String string = new String(this._buffer, 0, this._length);
        this.free();
        return string;
    }

    public InputStream getInputStream() {
        return new CBInputStream();
    }

    class CBInputStream
    extends InputStream {
        int _index = 0;

        CBInputStream() {
        }

        public int read() {
            if (CharBuffer.this._length <= this._index) {
                return -1;
            }
            return CharBuffer.this._buffer[this._index++];
        }
    }
}

