/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class SVNXMLSerializer
implements ContentHandler {
    private Writer myWriter;
    private String myEol = System.getProperty("line.separator");
    private boolean myCharacters = false;

    public SVNXMLSerializer(OutputStream os) {
        try {
            this.myWriter = new OutputStreamWriter(os, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.myWriter = new OutputStreamWriter(os);
        }
    }

    public SVNXMLSerializer(Writer writer) {
        this.myWriter = writer;
    }

    public void flush() throws IOException {
        this.myWriter.flush();
    }

    public void startDocument() throws SAXException {
        try {
            this.myWriter.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        try {
            this.myWriter.write(this.myEol);
            this.myWriter.write("<");
            this.myWriter.write(qName);
            for (int i = 0; i < atts.getLength(); ++i) {
                this.myWriter.write(this.myEol);
                this.myWriter.write("   ");
                this.myWriter.write(atts.getQName(i));
                this.myWriter.write("=\"");
                this.myWriter.write(atts.getValue(i));
                this.myWriter.write("\"");
            }
            if ("against".equals(qName)) {
                this.myWriter.write("/>");
            } else {
                this.myWriter.write(">");
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.myCharacters = true;
        try {
            this.myWriter.write(ch, start, length);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("against".equals(qName)) {
            return;
        }
        try {
            if (!this.myCharacters) {
                this.myWriter.write(this.myEol);
            }
            this.myWriter.write("</");
            this.myWriter.write(qName);
            this.myWriter.write(">");
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        finally {
            this.myCharacters = false;
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.myWriter.write(this.myEol);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }
}

