/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc.xml;

import java.util.Date;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNTimeUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.ISVNAnnotateHandler;
import org.tmatesoft.svn.core.wc.xml.AbstractXMLHandler;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SVNXMLAnnotateHandler
extends AbstractXMLHandler
implements ISVNAnnotateHandler {
    public static final String PATH_ATTR = "path";
    public static final String REVISION_ATTR = "revision";
    public static final String DATE_TAG = "date";
    public static final String AUTHOR_TAG = "author";
    public static final String COMMIT_TAG = "commit";
    public static final String ENTRY_TAG = "entry";
    public static final String LINE_NUMBER_TAG = "line-number";
    public static final String TARGET_TAG = "target";
    public static final String BLAME_TAG = "blame";
    private long myLineNumber;

    public SVNXMLAnnotateHandler(ContentHandler contentHandler) {
        super(contentHandler);
    }

    protected String getHeaderName() {
        return BLAME_TAG;
    }

    public void startTarget(String pathOrURL) {
        this.myLineNumber = 1L;
        try {
            this.addAttribute(PATH_ATTR, pathOrURL);
            this.openTag(TARGET_TAG);
        }
        catch (SAXException e) {
            SVNDebugLog.logError(e);
        }
    }

    public void endTarget() {
        this.myLineNumber = 1L;
        try {
            this.closeTag(TARGET_TAG);
        }
        catch (SAXException e) {
            SVNDebugLog.logError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleLine(Date date, long revision, String author, String line) throws SVNException {
        try {
            this.addAttribute(LINE_NUMBER_TAG, this.myLineNumber + "");
            this.openTag(ENTRY_TAG);
            if (revision >= 0L) {
                this.addAttribute(REVISION_ATTR, revision + "");
                this.openTag(COMMIT_TAG);
                this.addTag(AUTHOR_TAG, author);
                this.addTag(DATE_TAG, SVNTimeUtil.formatDate(date));
                this.closeTag(COMMIT_TAG);
            }
            this.closeTag(ENTRY_TAG);
        }
        catch (SAXException e) {
            SVNDebugLog.logError(e);
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.XML_MALFORMED, e.getLocalizedMessage());
            SVNErrorManager.error(err, e);
        }
        finally {
            ++this.myLineNumber;
        }
    }
}

