/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.SVNExternalInfo;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNProperties;
import org.tmatesoft.svn.core.internal.wc.SVNWCAccess;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SVNWCUtil {
    private static final String ECLIPSE_AUTH_MANAGER_CLASSNAME = "org.tmatesoft.svn.core.internal.wc.EclipseSVNAuthenticationManager";
    static /* synthetic */ Class class$org$tmatesoft$svn$core$wc$SVNWCUtil;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$lang$String;

    public static File getDefaultConfigurationDirectory() {
        if (SVNFileUtil.isWindows) {
            return new File(SVNFileUtil.getApplicationDataPath(), "Subversion");
        }
        return new File(System.getProperty("user.home"), ".subversion");
    }

    public static ISVNAuthenticationManager createDefaultAuthenticationManager() {
        return SVNWCUtil.createDefaultAuthenticationManager(SVNWCUtil.getDefaultConfigurationDirectory(), null, null);
    }

    public static ISVNAuthenticationManager createDefaultAuthenticationManager(File configDir) {
        return SVNWCUtil.createDefaultAuthenticationManager(configDir, null, null, true);
    }

    public static ISVNAuthenticationManager createDefaultAuthenticationManager(String userName, String password) {
        return SVNWCUtil.createDefaultAuthenticationManager(null, userName, password);
    }

    public static ISVNAuthenticationManager createDefaultAuthenticationManager(File configDir, String userName, String password) {
        ISVNOptions options = SVNWCUtil.createDefaultOptions(configDir, true);
        boolean store = options.isAuthStorageEnabled();
        return SVNWCUtil.createDefaultAuthenticationManager(configDir, userName, password, store);
    }

    public static ISVNAuthenticationManager createDefaultAuthenticationManager(File configDir, String userName, String password, boolean storeAuth) {
        if (SVNWCUtil.isEclipse()) {
            try {
                Constructor<?> method;
                Class<?> managerClass = (class$org$tmatesoft$svn$core$wc$SVNWCUtil == null ? (class$org$tmatesoft$svn$core$wc$SVNWCUtil = SVNWCUtil.class$("org.tmatesoft.svn.core.wc.SVNWCUtil")) : class$org$tmatesoft$svn$core$wc$SVNWCUtil).getClassLoader().loadClass(ECLIPSE_AUTH_MANAGER_CLASSNAME);
                if (managerClass != null && (method = managerClass.getConstructor(class$java$io$File == null ? (class$java$io$File = SVNWCUtil.class$("java.io.File")) : class$java$io$File, Boolean.TYPE, class$java$lang$String == null ? (class$java$lang$String = SVNWCUtil.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = SVNWCUtil.class$("java.lang.String")) : class$java$lang$String)) != null) {
                    return (ISVNAuthenticationManager)method.newInstance(configDir, storeAuth ? Boolean.TRUE : Boolean.FALSE, userName, password);
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return new DefaultSVNAuthenticationManager(configDir, storeAuth, userName, password);
    }

    public static ISVNOptions createDefaultOptions(File dir, boolean readonly) {
        return new DefaultSVNOptions(dir, readonly);
    }

    public static ISVNOptions createDefaultOptions(boolean readonly) {
        return new DefaultSVNOptions(null, readonly);
    }

    public static boolean isVersionedDirectory(File dir) {
        return SVNWCAccess.isVersionedDirectory(dir);
    }

    public static boolean isWorkingCopyRoot(final File versionedDir, final boolean considerExternalAsRoot) throws SVNException {
        if (versionedDir == null || !SVNWCUtil.isVersionedDirectory(versionedDir)) {
            return false;
        }
        if (versionedDir.getParentFile() == null) {
            return true;
        }
        SVNStatusClient stClient = new SVNStatusClient((ISVNAuthenticationManager)null, null);
        final boolean[] isRoot = new boolean[]{true};
        try {
            stClient.doStatus(versionedDir.getParentFile(), false, false, true, true, new ISVNStatusHandler(){

                public void handleStatus(SVNStatus status) {
                    if (versionedDir.equals(status.getFile())) {
                        isRoot[0] = false;
                        if (status.getContentsStatus() == SVNStatusType.STATUS_IGNORED || status.getContentsStatus() == SVNStatusType.STATUS_UNVERSIONED || status.getContentsStatus() == SVNStatusType.STATUS_EXTERNAL) {
                            if (status.getContentsStatus() == SVNStatusType.STATUS_EXTERNAL && !considerExternalAsRoot) {
                                return;
                            }
                            isRoot[0] = true;
                        }
                    }
                }
            });
        }
        catch (SVNException e) {
            if (e instanceof SVNCancelException) {
                throw e;
            }
            return true;
        }
        return isRoot[0];
    }

    public static File getWorkingCopyRoot(File versionedDir, boolean stopOnExtenrals) throws SVNException {
        if ((versionedDir = versionedDir.getAbsoluteFile()) == null || !SVNWCUtil.isVersionedDirectory(versionedDir) && !SVNWCUtil.isVersionedDirectory(versionedDir.getParentFile())) {
            return null;
        }
        if (SVNWCUtil.isWorkingCopyRoot(versionedDir, true)) {
            if (stopOnExtenrals) {
                return versionedDir;
            }
            File parent = versionedDir.getParentFile();
            File parentRoot = SVNWCUtil.getWorkingCopyRoot(parent, stopOnExtenrals);
            if (parentRoot == null) {
                return versionedDir;
            }
            while (parent != null) {
                block9: {
                    try {
                        SVNWCAccess parentAccess = SVNWCAccess.create(parent);
                        SVNProperties props = parentAccess.getTarget().getProperties("", false);
                        SVNExternalInfo[] externals = SVNWCAccess.parseExternals("", props.getPropertyValue("svn:externals"));
                        for (int i = 0; i < externals.length; ++i) {
                            SVNExternalInfo external = externals[i];
                            File externalFile = new File(parent, external.getPath());
                            if (!externalFile.equals(versionedDir)) continue;
                            return parentRoot;
                        }
                    }
                    catch (SVNException e) {
                        if (!(e instanceof SVNCancelException)) break block9;
                        throw e;
                    }
                }
                if (parent.equals(parentRoot)) break;
                parent = parent.getParentFile();
            }
            return versionedDir;
        }
        if (versionedDir.getParentFile() != null) {
            return SVNWCUtil.getWorkingCopyRoot(versionedDir.getParentFile(), stopOnExtenrals);
        }
        return versionedDir;
    }

    private static boolean isEclipse() {
        try {
            Class<?> platform = (class$org$tmatesoft$svn$core$wc$SVNWCUtil == null ? (class$org$tmatesoft$svn$core$wc$SVNWCUtil = SVNWCUtil.class$("org.tmatesoft.svn.core.wc.SVNWCUtil")) : class$org$tmatesoft$svn$core$wc$SVNWCUtil).getClassLoader().loadClass("org.eclipse.core.runtime.Platform");
            Method isRunning = platform.getMethod("isRunning", new Class[0]);
            Object result = isRunning.invoke(null, new Object[0]);
            if (result != null && Boolean.TRUE.equals(result)) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

