/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableEditor;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNExternalInfo;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNProperties;
import org.tmatesoft.svn.core.internal.wc.SVNReporter;
import org.tmatesoft.svn.core.internal.wc.SVNStatusEditor;
import org.tmatesoft.svn.core.internal.wc.SVNStatusReporter;
import org.tmatesoft.svn.core.internal.wc.SVNWCAccess;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SVNStatusClient
extends SVNBasicClient {
    public SVNStatusClient(ISVNAuthenticationManager authManager, ISVNOptions options) {
        super(authManager, options);
    }

    protected SVNStatusClient(ISVNRepositoryPool repositoryPool, ISVNOptions options) {
        super(repositoryPool, options);
    }

    public long doStatus(File path, boolean recursive, boolean remote, boolean reportAll, boolean includeIgnored, ISVNStatusHandler handler) throws SVNException {
        return this.doStatus(path, recursive, remote, reportAll, includeIgnored, false, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long doStatus(File path, boolean recursive, boolean remote, boolean reportAll, boolean includeIgnored, boolean collectParentExternals, final ISVNStatusHandler handler) throws SVNException {
        SVNExternalInfo thisExternal;
        if (handler == null) {
            return -1L;
        }
        SVNWCAccess wcAccess = this.createWCAccess(path);
        wcAccess.open(false, recursive);
        Map parentExternals = new HashMap();
        if (collectParentExternals && (thisExternal = (SVNExternalInfo)(parentExternals = this.collectParentExternals(path, wcAccess.getAnchor() != wcAccess.getTarget())).remove("")) != null) {
            handler.handleStatus(new SVNStatus(null, path, SVNNodeKind.DIR, SVNRevision.UNDEFINED, SVNRevision.UNDEFINED, null, null, SVNStatusType.STATUS_EXTERNAL, SVNStatusType.STATUS_NONE, SVNStatusType.STATUS_NONE, SVNStatusType.STATUS_NONE, false, false, false, null, null, null, null, null, SVNRevision.UNDEFINED, null, null, null));
        }
        final boolean[] deletedInRepos = new boolean[]{false};
        ISVNStatusHandler realHandler = new ISVNStatusHandler(){

            public void handleStatus(SVNStatus status) throws SVNException {
                if (deletedInRepos[0] && status.getCommittedRevision() != SVNRevision.UNDEFINED && status.getCommittedRevision() != null) {
                    status.setRemoteStatus(SVNStatusType.STATUS_DELETED, null, null, null);
                }
                handler.handleStatus(status);
            }
        };
        SVNStatusEditor statusEditor = new SVNStatusEditor(this.getOptions(), wcAccess, realHandler, parentExternals, includeIgnored, reportAll, recursive);
        if (remote) {
            SVNURL url = wcAccess.getAnchor().getEntries().getEntry("", true).getSVNURL();
            SVNRepository repos = this.createRepository(url, true);
            SVNNodeKind kind = repos.checkPath("", -1L);
            if (kind == SVNNodeKind.NONE) {
                deletedInRepos[0] = true;
                reportAll = true;
                statusEditor = new SVNStatusEditor(this.getOptions(), wcAccess, realHandler, parentExternals, includeIgnored, reportAll, recursive);
            } else {
                SVNRepository locksRepos = this.createRepository(url, false);
                SVNReporter reporter = new SVNReporter(wcAccess, false, recursive);
                SVNStatusReporter statusReporter = new SVNStatusReporter(locksRepos, reporter, statusEditor);
                String target = "".equals(wcAccess.getTargetName()) ? null : wcAccess.getTargetName();
                repos.status(-1L, target, recursive, statusReporter, SVNCancellableEditor.newInstance(statusEditor, this));
            }
        }
        this.checkCancelled();
        statusEditor.closeEdit();
        if (remote && statusEditor.getTargetRevision() >= 0L) {
            SVNEvent event = SVNEventFactory.createStatusCompletedEvent(wcAccess, statusEditor.getTargetRevision());
            this.handleEvent(event, -1.0);
        }
        wcAccess.close(false);
        if (!this.isIgnoreExternals() && recursive) {
            Map externals = statusEditor.getCollectedExternals();
            Iterator paths = externals.keySet().iterator();
            while (paths.hasNext()) {
                String externalPath = (String)paths.next();
                File externalFile = new File(wcAccess.getAnchor().getRoot(), externalPath);
                if (!externalFile.exists() || !externalFile.isDirectory() || !SVNWCUtil.isWorkingCopyRoot(externalFile, true)) continue;
                this.handleEvent(SVNEventFactory.createStatusExternalEvent(wcAccess, externalPath), -1.0);
                this.setEventPathPrefix(externalPath);
                try {
                    this.doStatus(externalFile, recursive, remote, reportAll, includeIgnored, false, handler);
                }
                catch (SVNException e) {
                    if (!(e instanceof SVNCancelException)) continue;
                    throw e;
                }
                finally {
                    this.setEventPathPrefix(null);
                }
            }
        }
        return statusEditor.getTargetRevision();
    }

    public SVNStatus doStatus(File path, boolean remote) throws SVNException {
        return this.doStatus(path, remote, false);
    }

    public SVNStatus doStatus(final File path, boolean remote, boolean collectParentExternals) throws SVNException {
        final SVNStatus[] result = new SVNStatus[]{null};
        ISVNStatusHandler handler = new ISVNStatusHandler(){

            public void handleStatus(SVNStatus status) {
                if (path.equals(status.getFile())) {
                    if (result[0] != null && result[0].getContentsStatus() == SVNStatusType.STATUS_EXTERNAL && path.isDirectory()) {
                        result[0] = status;
                        result[0].markExternal();
                    } else if (result[0] == null) {
                        result[0] = status;
                    }
                }
            }
        };
        if (!remote) {
            Map parentExternals;
            SVNExternalInfo thisExternal;
            SVNWCAccess wcAccess = this.createWCAccess(path);
            SVNStatusEditor statusEditor = new SVNStatusEditor(this.getOptions(), wcAccess, handler, new HashMap(), true, true, false);
            String name = wcAccess.getTargetName();
            if (wcAccess.getAnchor() != wcAccess.getTarget()) {
                name = "";
            }
            if (collectParentExternals && path.isDirectory() && (thisExternal = (SVNExternalInfo)(parentExternals = this.collectParentExternals(path, wcAccess.getAnchor() != wcAccess.getTarget())).remove("")) != null) {
                handler.handleStatus(new SVNStatus(null, path, SVNNodeKind.DIR, SVNRevision.UNDEFINED, SVNRevision.UNDEFINED, null, null, SVNStatusType.STATUS_EXTERNAL, SVNStatusType.STATUS_NONE, SVNStatusType.STATUS_NONE, SVNStatusType.STATUS_NONE, false, false, false, null, null, null, null, null, SVNRevision.UNDEFINED, null, null, null));
            }
            statusEditor.reportStatus(wcAccess.getTarget(), name, false, false);
            return result[0];
        }
        this.doStatus(path, false, remote, true, true, collectParentExternals, handler);
        return result[0];
    }

    private Map collectParentExternals(File path, boolean asTarget) throws SVNException {
        HashMap<String, SVNExternalInfo> externals = new HashMap<String, SVNExternalInfo>();
        if (path.isFile()) {
            return externals;
        }
        File wcRoot = path.getAbsoluteFile();
        if (wcRoot.getParentFile() == null) {
            return externals;
        }
        if ((wcRoot = wcRoot.getParentFile().getAbsoluteFile()) == null || !new File(wcRoot, SVNFileUtil.getAdminDirectoryName()).isDirectory()) {
            return externals;
        }
        Stack<String> dirs = new Stack<String>();
        String currentPath = path.getName();
        String baseName = path.getName();
        while (wcRoot.getParentFile() != null && new File(wcRoot.getParentFile(), SVNFileUtil.getAdminDirectoryName()).isDirectory()) {
            dirs.push(currentPath);
            currentPath = SVNPathUtil.append(wcRoot.getName(), currentPath);
            wcRoot = wcRoot.getParentFile();
        }
        dirs.push(currentPath);
        while (!dirs.isEmpty()) {
            currentPath = (String)dirs.pop();
            SVNProperties props = new SVNProperties(new File(wcRoot, SVNFileUtil.getAdminDirectoryName() + "/dir-props"), "");
            String externalsProperty = props.getPropertyValue("svn:externals");
            if (externalsProperty != null) {
                SVNExternalInfo[] infos = SVNWCAccess.parseExternals("", externalsProperty);
                for (int i = 0; i < infos.length; ++i) {
                    SVNExternalInfo info = infos[i];
                    String infoPath = info.getPath();
                    if (infoPath.equals(currentPath)) {
                        info.setPath("");
                        externals.put(info.getPath(), info);
                        continue;
                    }
                    if (!infoPath.startsWith(currentPath + "/")) continue;
                    info.setPath(infoPath.substring((currentPath + "/").length()));
                    if (asTarget) {
                        info.setPath(baseName + "/" + info.getPath());
                    }
                    externals.put(info.getPath(), info);
                }
            }
            wcRoot = new File(wcRoot, SVNPathUtil.head(currentPath));
        }
        return externals;
    }
}

