/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableEditor;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableOutputStream;
import org.tmatesoft.svn.core.internal.wc.SVNDiffEditor;
import org.tmatesoft.svn.core.internal.wc.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNMergeEditor;
import org.tmatesoft.svn.core.internal.wc.SVNMerger;
import org.tmatesoft.svn.core.internal.wc.SVNRemoteDiffEditor;
import org.tmatesoft.svn.core.internal.wc.SVNReporter;
import org.tmatesoft.svn.core.internal.wc.SVNWCAccess;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.DefaultSVNDiffGenerator;
import org.tmatesoft.svn.core.wc.ISVNDiffGenerator;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SVNDiffClient
extends SVNBasicClient {
    private ISVNDiffGenerator myDiffGenerator;

    public SVNDiffClient(ISVNAuthenticationManager authManager, ISVNOptions options) {
        super(authManager, options);
    }

    protected SVNDiffClient(ISVNRepositoryPool repositoryPool, ISVNOptions options) {
        super(repositoryPool, options);
    }

    public void setDiffGenerator(ISVNDiffGenerator diffGenerator) {
        this.myDiffGenerator = diffGenerator;
    }

    public ISVNDiffGenerator getDiffGenerator() {
        if (this.myDiffGenerator == null) {
            this.myDiffGenerator = new DefaultSVNDiffGenerator();
        }
        return this.myDiffGenerator;
    }

    public void doDiff(SVNURL url, SVNRevision pegRevision, SVNRevision rN, SVNRevision rM, boolean recursive, boolean useAncestry, OutputStream result) throws SVNException {
        SVNErrorMessage err;
        if (!rN.isValid() || !rM.isValid()) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Both rN and rM revisions should be specified");
            SVNErrorManager.error(err);
        }
        if (rN.isLocal() || rM.isLocal()) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Both rN and rM revisions must be non-local for a pegged diff of an URL");
            SVNErrorManager.error(err);
        }
        this.getDiffGenerator().init(url.toString(), url.toString());
        this.doDiffURLURL(url, null, rN, url, null, rM, pegRevision, recursive, useAncestry, result);
    }

    public void doDiff(File path, SVNRevision pegRevision, SVNRevision rN, SVNRevision rM, boolean recursive, boolean useAncestry, OutputStream result) throws SVNException {
        SVNErrorMessage err;
        if (!rN.isValid() || !rM.isValid()) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Both rN and rM revisions should be specified");
            SVNErrorManager.error(err);
        }
        if (rN.isLocal() && rM.isLocal()) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "At least one revision must be non-local for a pegged diff");
            SVNErrorManager.error(err);
        }
        this.getDiffGenerator().init(path.getAbsolutePath(), path.getAbsolutePath());
        if (!rM.isLocal()) {
            this.doDiffURLURL(null, path, rN, null, path, rM, pegRevision, recursive, useAncestry, result);
        } else {
            this.doDiffURLWC(path, rN, pegRevision, path, rM, false, recursive, useAncestry, result);
        }
    }

    public void doDiff(SVNURL url1, SVNRevision rN, SVNURL url2, SVNRevision rM, boolean recursive, boolean useAncestry, OutputStream result) throws SVNException {
        if (!rN.isValid() || !rM.isValid()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Both rN and rM revisions should be specified");
            SVNErrorManager.error(err);
        }
        this.getDiffGenerator().init(url1.toString(), url2.toString());
        this.doDiffURLURL(url1, null, rN, url2, null, rM, SVNRevision.UNDEFINED, recursive, useAncestry, result);
    }

    public void doDiff(File path1, SVNRevision rN, SVNURL url2, SVNRevision rM, boolean recursive, boolean useAncestry, OutputStream result) throws SVNException {
        if (!rN.isValid() || !rM.isValid()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Both rN and rM revisions should be specified");
            SVNErrorManager.error(err);
        }
        this.getDiffGenerator().init(path1.getAbsolutePath(), url2.toString());
        if (rN == SVNRevision.BASE || rN == SVNRevision.WORKING) {
            this.doDiffURLWC(url2, rM, SVNRevision.UNDEFINED, path1, rN, true, recursive, useAncestry, result);
        } else {
            this.doDiffURLURL(null, path1, rN, url2, null, rM, SVNRevision.UNDEFINED, recursive, useAncestry, result);
        }
    }

    public void doDiff(SVNURL url1, SVNRevision rN, File path2, SVNRevision rM, boolean recursive, boolean useAncestry, OutputStream result) throws SVNException {
        if (!rN.isValid() || !rM.isValid()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Both rN and rM revisions should be specified");
            SVNErrorManager.error(err);
        }
        this.getDiffGenerator().init(url1.toString(), path2.getAbsolutePath());
        if (rM == SVNRevision.BASE || rM == SVNRevision.WORKING) {
            this.doDiffURLWC(url1, rN, SVNRevision.UNDEFINED, path2, rM, false, recursive, useAncestry, result);
        } else {
            this.doDiffURLURL(url1, null, rN, null, path2, rM, SVNRevision.UNDEFINED, recursive, useAncestry, result);
        }
    }

    public void doDiff(File path1, SVNRevision rN, File path2, SVNRevision rM, boolean recursive, boolean useAncestry, OutputStream result) throws SVNException {
        if (!rN.isValid() || !rM.isValid()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Both rN and rM revisions should be specified");
            SVNErrorManager.error(err);
        }
        boolean isPath1Local = rN == SVNRevision.WORKING || rN == SVNRevision.BASE;
        boolean isPath2Local = rM == SVNRevision.WORKING || rM == SVNRevision.BASE;
        this.getDiffGenerator().init(path1.getAbsolutePath(), path2.getAbsolutePath());
        if (isPath1Local && isPath2Local) {
            this.doDiffWCWC(path1, rN, path2, rM, recursive, useAncestry, result);
        } else if (isPath1Local) {
            this.doDiffURLWC(path2, rM, SVNRevision.UNDEFINED, path1, rN, true, recursive, useAncestry, result);
        } else if (isPath2Local) {
            this.doDiffURLWC(path1, rN, SVNRevision.UNDEFINED, path2, rM, false, recursive, useAncestry, result);
        } else {
            this.doDiffURLURL(null, path1, rN, null, path2, rM, SVNRevision.UNDEFINED, recursive, useAncestry, result);
        }
    }

    private void doDiffURLWC(SVNURL url1, SVNRevision revision1, SVNRevision pegRevision, File path2, SVNRevision revision2, boolean reverse, boolean recursive, boolean useAncestry, OutputStream result) throws SVNException {
        SVNErrorMessage err;
        SVNWCAccess wcAccess = this.createWCAccess(path2);
        wcAccess.open(false, recursive);
        File anchorPath = wcAccess.getAnchor().getRoot();
        String target = "".equals(wcAccess.getTargetName()) ? null : wcAccess.getTargetName();
        SVNEntry anchorEntry = wcAccess.getAnchor().getEntries().getEntry("", false);
        if (anchorEntry == null) {
            err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", anchorPath);
            SVNErrorManager.error(err);
        } else if (anchorEntry.getURL() == null) {
            err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", anchorPath);
            SVNErrorManager.error(err);
        }
        SVNURL anchorURL = anchorEntry.getSVNURL();
        if (pegRevision.isValid()) {
            SVNBasicClient.SVNRepositoryLocation[] locations = this.getLocations(url1, null, pegRevision, revision1, SVNRevision.UNDEFINED);
            url1 = locations[0].getURL();
            String anchorPath2 = SVNPathUtil.append(anchorURL.toString(), target == null ? "" : target);
            this.getDiffGenerator().init(url1.toString(), anchorPath2);
        }
        SVNRepository repository = this.createRepository(anchorURL, true);
        SVNDiffEditor editor = new SVNDiffEditor(wcAccess, this.getDiffGenerator(), useAncestry, reverse, revision2 == SVNRevision.BASE, result);
        SVNReporter reporter = new SVNReporter(wcAccess, false, recursive);
        long revNumber = this.getRevisionNumber(revision1, repository, null);
        long pegRevisionNumber = this.getRevisionNumber(revision2, repository, path2);
        repository.diff(url1, revNumber, pegRevisionNumber, target, !useAncestry, recursive, reporter, SVNCancellableEditor.newInstance(editor, this));
        wcAccess.close(false);
    }

    private void doDiffURLWC(File path1, SVNRevision revision1, SVNRevision pegRevision, File path2, SVNRevision revision2, boolean reverse, boolean recursive, boolean useAncestry, OutputStream result) throws SVNException {
        SVNURL url1;
        SVNErrorMessage err;
        SVNWCAccess wcAccess = this.createWCAccess(path2);
        wcAccess.open(false, recursive);
        File anchorPath = wcAccess.getAnchor().getRoot();
        String target = "".equals(wcAccess.getTargetName()) ? null : wcAccess.getTargetName();
        SVNEntry anchorEntry = wcAccess.getAnchor().getEntries().getEntry("", false);
        if (anchorEntry == null) {
            err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", anchorPath);
            SVNErrorManager.error(err);
        } else if (anchorEntry.getURL() == null) {
            err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", anchorPath);
            SVNErrorManager.error(err);
        }
        SVNURL anchorURL = anchorEntry.getSVNURL();
        if (pegRevision.isValid()) {
            SVNBasicClient.SVNRepositoryLocation[] locations = this.getLocations(null, path1, pegRevision, revision1, SVNRevision.UNDEFINED);
            url1 = locations[0].getURL();
            String anchorPath2 = SVNPathUtil.append(anchorURL.toString(), target == null ? "" : target);
            this.getDiffGenerator().init(url1.toString(), anchorPath2);
        } else {
            url1 = this.getURL(path1);
        }
        SVNRepository repository = this.createRepository(anchorURL, true);
        SVNDiffEditor editor = new SVNDiffEditor(wcAccess, this.getDiffGenerator(), useAncestry, reverse, revision2 == SVNRevision.BASE, result);
        SVNReporter reporter = new SVNReporter(wcAccess, false, recursive);
        long revNumber = this.getRevisionNumber(revision1, repository, path1);
        long pegRevisionNumber = this.getRevisionNumber(revision2, repository, path2);
        repository.diff(url1, revNumber, pegRevisionNumber, target, !useAncestry, recursive, reporter, SVNCancellableEditor.newInstance(editor, this));
        wcAccess.close(false);
    }

    private void doDiffWCWC(File path1, SVNRevision revision1, File path2, SVNRevision revision2, boolean recursive, boolean useAncestry, OutputStream result) throws SVNException {
        if (!path1.equals(path2) || revision1 != SVNRevision.BASE || revision2 != SVNRevision.WORKING) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Only diffs between a path's text-base and its working files are supported at this time (-rBASE:WORKING)");
            SVNErrorManager.error(err);
        }
        SVNWCAccess wcAccess = this.createWCAccess(path1);
        wcAccess.open(false, recursive);
        if (wcAccess.getTargetEntry() == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", path1);
            SVNErrorManager.error(err);
        }
        SVNDiffEditor editor = new SVNDiffEditor(wcAccess, this.getDiffGenerator(), useAncestry, false, false, result);
        editor.closeEdit();
        wcAccess.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doDiffURLURL(SVNURL url1, File path1, SVNRevision revision1, SVNURL url2, File path2, SVNRevision revision2, SVNRevision pegRevision, boolean recursive, boolean useAncestry, OutputStream result) throws SVNException {
        SVNErrorMessage err;
        File basePath = null;
        if (path1 != null) {
            basePath = path1;
        }
        if (path2 != null) {
            basePath = path2;
        }
        if (pegRevision.isValid()) {
            SVNBasicClient.SVNRepositoryLocation[] locations = this.getLocations(url2, path2, pegRevision, revision1, revision2);
            url1 = locations[0].getURL();
            url2 = locations[1].getURL();
            this.getDiffGenerator().init(url1.toString(), url2.toString());
        } else {
            url1 = url1 == null ? this.getURL(path1) : url1;
            url2 = url2 == null ? this.getURL(path2) : url2;
        }
        SVNRepository repository1 = this.createRepository(url1, true);
        SVNRepository repository2 = this.createRepository(url2, false);
        final long rev1 = this.getRevisionNumber(revision1, repository1, path1);
        long rev2 = this.getRevisionNumber(revision2, repository2, path2);
        SVNNodeKind kind1 = repository1.checkPath("", rev1);
        SVNNodeKind kind2 = repository2.checkPath("", rev2);
        String target1 = null;
        if (kind1 == SVNNodeKind.NONE) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "''{0}'' was not found in the repository at revision {1}", new Object[]{url1, new Long(rev1)});
            SVNErrorManager.error(err);
        } else if (kind2 == SVNNodeKind.NONE) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "''{0}'' was not found in the repository at revision {1}", new Object[]{url2, new Long(rev2)});
            SVNErrorManager.error(err);
        }
        if (kind1 == SVNNodeKind.FILE || kind2 == SVNNodeKind.FILE) {
            target1 = SVNPathUtil.tail(url1.getPath());
            if (basePath != null) {
                basePath = basePath.getParentFile();
            }
            url1 = SVNURL.parseURIEncoded(SVNPathUtil.removeTail(url1.toString()));
            repository1 = this.createRepository(url1, true);
        }
        repository2 = this.createRepository(url1, false);
        File tmpFile = this.getDiffGenerator().createTempDirectory();
        try {
            String baseDisplayPath = basePath != null ? basePath.getAbsolutePath().replace(File.separatorChar, '/') : "";
            SVNRemoteDiffEditor editor = new SVNRemoteDiffEditor(baseDisplayPath, tmpFile, this.getDiffGenerator(), repository2, rev1, result, this);
            ISVNReporterBaton reporter = new ISVNReporterBaton(){

                public void report(ISVNReporter reporter) throws SVNException {
                    reporter.setPath("", null, rev1, false);
                    reporter.finishReport();
                }
            };
            repository1.diff(url2, rev2, rev1, target1, !useAncestry, recursive, reporter, SVNCancellableEditor.newInstance(editor, this));
            Object var26_23 = null;
            if (tmpFile == null) return;
        }
        catch (Throwable throwable) {
            Object var26_24 = null;
            if (tmpFile == null) throw throwable;
            SVNFileUtil.deleteAll(tmpFile, true, null);
            throw throwable;
        }
        SVNFileUtil.deleteAll(tmpFile, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doMerge(File path1, SVNRevision revision1, File path2, SVNRevision revision2, File dstPath, boolean recusrsive, boolean useAncestry, boolean force, boolean dryRun) throws SVNException {
        SVNURL url2;
        SVNURL url1;
        SVNRevision pegRevision = SVNRevision.UNDEFINED;
        if (path1.equals(path2)) {
            pegRevision = SVNRevision.WORKING;
        }
        if ((url1 = this.getURL(path1)) == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", path1);
            SVNErrorManager.error(err);
        }
        if ((url2 = this.getURL(path2)) == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", path2);
            SVNErrorManager.error(err);
        }
        SVNWCAccess wcAccess = this.createWCAccess(dstPath);
        try {
            wcAccess.open(!dryRun, recusrsive);
            SVNEntry targetEntry = wcAccess.getTargetEntry();
            if (targetEntry == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", dstPath);
                SVNErrorManager.error(err);
            }
            if (targetEntry.isFile()) {
                this.doMergeFile(url1, path1, revision1, url2, path2, revision2, pegRevision, wcAccess, force, dryRun);
            } else if (targetEntry.isDirectory()) {
                this.doMerge(url1, path1, revision1, url2, path2, revision2, pegRevision, wcAccess, recusrsive, useAncestry, force, dryRun);
            }
            wcAccess.close(!dryRun);
        }
        catch (Throwable throwable) {
            wcAccess.close(!dryRun);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doMerge(File path1, SVNRevision revision1, SVNURL url2, SVNRevision revision2, File dstPath, boolean recusrsive, boolean useAncestry, boolean force, boolean dryRun) throws SVNException {
        SVNURL url1 = this.getURL(path1);
        if (url1 == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", path1);
            SVNErrorManager.error(err);
        }
        SVNRevision pegRevision = SVNRevision.UNDEFINED;
        if (url1.equals(url2)) {
            pegRevision = SVNRevision.HEAD;
        }
        SVNWCAccess wcAccess = this.createWCAccess(dstPath);
        try {
            wcAccess.open(!dryRun, recusrsive);
            SVNEntry targetEntry = wcAccess.getTargetEntry();
            if (targetEntry == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", dstPath);
                SVNErrorManager.error(err);
            }
            if (targetEntry.isFile()) {
                this.doMergeFile(url1, path1, revision1, url2, null, revision2, pegRevision, wcAccess, force, dryRun);
            } else if (targetEntry.isDirectory()) {
                this.doMerge(url1, path1, revision1, url2, null, revision2, pegRevision, wcAccess, recusrsive, useAncestry, force, dryRun);
            }
            wcAccess.close(!dryRun);
        }
        catch (Throwable throwable) {
            wcAccess.close(!dryRun);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doMerge(SVNURL url1, SVNRevision revision1, File path2, SVNRevision revision2, File dstPath, boolean recusrsive, boolean useAncestry, boolean force, boolean dryRun) throws SVNException {
        SVNURL url2 = this.getURL(path2);
        if (url2 == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", path2);
            SVNErrorManager.error(err);
        }
        SVNRevision pegRevision = SVNRevision.UNDEFINED;
        if (url1.equals(url2)) {
            pegRevision = SVNRevision.WORKING;
        }
        SVNWCAccess wcAccess = this.createWCAccess(dstPath);
        try {
            wcAccess.open(!dryRun, recusrsive);
            SVNEntry targetEntry = wcAccess.getTargetEntry();
            if (targetEntry == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", dstPath);
                SVNErrorManager.error(err);
            }
            if (targetEntry.isFile()) {
                this.doMergeFile(url1, null, revision1, url2, path2, revision2, pegRevision, wcAccess, force, dryRun);
            } else if (targetEntry.isDirectory()) {
                this.doMerge(url1, null, revision1, url2, path2, revision2, pegRevision, wcAccess, recusrsive, useAncestry, force, dryRun);
            }
            wcAccess.close(!dryRun);
        }
        catch (Throwable throwable) {
            wcAccess.close(!dryRun);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doMerge(SVNURL url1, SVNRevision revision1, SVNURL url2, SVNRevision revision2, File dstPath, boolean recusrsive, boolean useAncestry, boolean force, boolean dryRun) throws SVNException {
        SVNWCAccess wcAccess = this.createWCAccess(dstPath);
        SVNRevision pegRevision = SVNRevision.UNDEFINED;
        if (url1.equals(url2)) {
            pegRevision = SVNRevision.HEAD;
        }
        try {
            wcAccess.open(!dryRun, recusrsive);
            SVNEntry targetEntry = wcAccess.getTargetEntry();
            if (targetEntry == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", dstPath);
                SVNErrorManager.error(err);
            }
            if (targetEntry.isFile()) {
                this.doMergeFile(url1, null, revision1, url2, null, revision2, pegRevision, wcAccess, force, dryRun);
            } else if (targetEntry.isDirectory()) {
                this.doMerge(url1, null, revision1, url2, null, revision2, pegRevision, wcAccess, recusrsive, useAncestry, force, dryRun);
            }
            wcAccess.close(!dryRun);
        }
        catch (Throwable throwable) {
            wcAccess.close(!dryRun);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doMerge(SVNURL url1, SVNRevision pegRevision, SVNRevision revision1, SVNRevision revision2, File dstPath, boolean recusrsive, boolean useAncestry, boolean force, boolean dryRun) throws SVNException {
        SVNWCAccess wcAccess = this.createWCAccess(dstPath);
        if (pegRevision == null || !pegRevision.isValid()) {
            pegRevision = SVNRevision.HEAD;
        }
        try {
            wcAccess.open(!dryRun, recusrsive);
            SVNEntry targetEntry = wcAccess.getTargetEntry();
            if (targetEntry == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", dstPath);
                SVNErrorManager.error(err);
            }
            if (targetEntry.isFile()) {
                this.doMergeFile(url1, null, revision1, url1, null, revision2, pegRevision, wcAccess, force, dryRun);
            } else if (targetEntry.isDirectory()) {
                this.doMerge(url1, null, revision1, url1, null, revision2, pegRevision, wcAccess, recusrsive, useAncestry, force, dryRun);
            }
            wcAccess.close(!dryRun);
        }
        catch (Throwable throwable) {
            wcAccess.close(!dryRun);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doMerge(File path1, SVNRevision pegRevision, SVNRevision revision1, SVNRevision revision2, File dstPath, boolean recusrsive, boolean useAncestry, boolean force, boolean dryRun) throws SVNException {
        SVNURL url1 = this.getURL(path1);
        if (url1 == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", path1);
            SVNErrorManager.error(err);
        }
        if (pegRevision == null || !pegRevision.isValid()) {
            pegRevision = SVNRevision.WORKING;
        }
        SVNWCAccess wcAccess = this.createWCAccess(dstPath);
        try {
            wcAccess.open(!dryRun, recusrsive);
            SVNEntry targetEntry = wcAccess.getTargetEntry();
            if (targetEntry == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", dstPath);
                SVNErrorManager.error(err);
            }
            if (targetEntry.isFile()) {
                this.doMergeFile(url1, path1, revision1, url1, path1, revision2, pegRevision, wcAccess, force, dryRun);
            } else if (targetEntry.isDirectory()) {
                this.doMerge(url1, path1, revision1, url1, path1, revision2, pegRevision, wcAccess, recusrsive, useAncestry, force, dryRun);
            }
            wcAccess.close(!dryRun);
        }
        catch (Throwable throwable) {
            wcAccess.close(!dryRun);
            throw throwable;
        }
    }

    private void doMerge(SVNURL url1, File path1, SVNRevision revision1, SVNURL url2, File path2, SVNRevision revision2, SVNRevision pegRevision, SVNWCAccess wcAccess, boolean recursive, boolean useAncestry, boolean force, boolean dryRun) throws SVNException {
        if (!revision1.isValid() || !revision2.isValid()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Both rN and rM revisions should be specified");
            SVNErrorManager.error(err);
        }
        if (pegRevision.isValid()) {
            SVNBasicClient.SVNRepositoryLocation[] locations = this.getLocations(url2, path2, pegRevision, revision1, revision2);
            url1 = locations[0].getURL();
            url2 = locations[1].getURL();
            revision1 = SVNRevision.create(locations[0].getRevisionNumber());
            revision2 = SVNRevision.create(locations[1].getRevisionNumber());
            path1 = null;
            path2 = null;
        }
        SVNRepository repository1 = this.createRepository(url1, true);
        final long rev1 = this.getRevisionNumber(revision1, repository1, path1);
        long rev2 = this.getRevisionNumber(revision2, repository1, path2);
        SVNRepository repository2 = this.createRepository(url1, false);
        SVNMerger merger = new SVNMerger(wcAccess, url2.toString(), rev2, force, dryRun, this.isLeaveConflictsUnresolved());
        SVNMergeEditor mergeEditor = new SVNMergeEditor(wcAccess, repository2, rev1, rev2, merger, this);
        repository1.diff(url2, rev2, rev1, null, !useAncestry, recursive, new ISVNReporterBaton(){

            public void report(ISVNReporter reporter) throws SVNException {
                reporter.setPath("", null, rev1, false);
                reporter.finishReport();
            }
        }, SVNCancellableEditor.newInstance(mergeEditor, this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doMergeFile(SVNURL url1, File path1, SVNRevision revision1, SVNURL url2, File path2, SVNRevision revision2, SVNRevision pegRevision, SVNWCAccess wcAccess, boolean force, boolean dryRun) throws SVNException {
        SVNStatusType[] mergeResult;
        String mimeType2;
        if (pegRevision.isValid()) {
            SVNBasicClient.SVNRepositoryLocation[] locations = this.getLocations(url2, path2, pegRevision, revision1, revision2);
            url1 = locations[0].getURL();
            url2 = locations[1].getURL();
            revision1 = SVNRevision.create(locations[0].getRevisionNumber());
            revision2 = SVNRevision.create(locations[1].getRevisionNumber());
            path1 = null;
            path2 = null;
        }
        long[] rev1 = new long[1];
        long[] rev2 = new long[2];
        Map props1 = new HashMap();
        Map props2 = new HashMap();
        File f1 = null;
        File f2 = null;
        String name = wcAccess.getTargetName();
        try {
            f1 = this.loadFile(url1, path1, revision1, props1, wcAccess, rev1);
            f2 = this.loadFile(url2, path2, revision2, props2, wcAccess, rev2);
            String mimeType1 = (String)props1.get("svn:mime-type");
            mimeType2 = (String)props2.get("svn:mime-type");
            props1 = SVNDiffClient.filterProperties(props1, true, false, false);
            props2 = SVNDiffClient.filterProperties(props2, true, false, false);
            Map propsDiff = SVNDiffClient.computePropsDiff(props1, props2);
            Iterator names = props1.keySet().iterator();
            while (names.hasNext()) {
                String propertyName = (String)names.next();
                if (!propertyName.startsWith("svn:entry:") && !propertyName.startsWith("svn:wc:")) continue;
                names.remove();
            }
            SVNMerger merger = new SVNMerger(wcAccess, url2.toString(), rev2[0], force, dryRun, this.isLeaveConflictsUnresolved());
            mergeResult = merger.fileChanged(name, f1, f2, rev1[0], rev2[0], mimeType1, mimeType2, props1, propsDiff);
        }
        catch (Throwable throwable) {
            SVNFileUtil.deleteAll(f1, null);
            SVNFileUtil.deleteAll(f2, null);
            throw throwable;
        }
        SVNFileUtil.deleteAll(f1, null);
        SVNFileUtil.deleteAll(f2, null);
        this.handleEvent(SVNEventFactory.createUpdateModifiedEvent(wcAccess, wcAccess.getAnchor(), name, SVNNodeKind.FILE, SVNEventAction.UPDATE_UPDATE, mimeType2, mergeResult[0], mergeResult[1], SVNStatusType.LOCK_INAPPLICABLE), -1.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File loadFile(SVNURL url, File path, SVNRevision revision, Map properties, SVNWCAccess wcAccess, long[] revNumber) throws SVNException {
        String name = wcAccess.getTargetName();
        File tmpDir = wcAccess.getAnchor().getRoot();
        File result = SVNFileUtil.createUniqueFile(tmpDir, name, ".tmp");
        SVNFileUtil.createEmptyFile(result);
        SVNRepository repository = this.createRepository(url, true);
        long revisionNumber = this.getRevisionNumber(revision, repository, path);
        OutputStream os = null;
        try {
            os = SVNFileUtil.openFileForWriting(result);
            repository.getFile("", revisionNumber, properties, new SVNCancellableOutputStream(os, this));
        }
        finally {
            SVNFileUtil.closeFile(os);
        }
        if (revNumber != null && revNumber.length > 0) {
            revNumber[0] = revisionNumber;
        }
        return result;
    }

    private static Map computePropsDiff(Map props1, Map props2) {
        HashMap propsDiff = new HashMap();
        Iterator names = props2.keySet().iterator();
        while (names.hasNext()) {
            String newPropName = (String)names.next();
            if (props1.containsKey(newPropName)) {
                Object oldValue = props2.get(newPropName);
                if (oldValue.equals(props1.get(newPropName))) continue;
                propsDiff.put(newPropName, props2.get(newPropName));
                continue;
            }
            propsDiff.put(newPropName, props2.get(newPropName));
        }
        names = props1.keySet().iterator();
        while (names.hasNext()) {
            String oldPropName = (String)names.next();
            if (props2.containsKey(oldPropName)) continue;
            propsDiff.put(oldPropName, null);
        }
        return propsDiff;
    }

    private static Map filterProperties(Map props1, boolean leftRegular, boolean leftEntry, boolean leftWC) {
        HashMap result = new HashMap();
        Iterator names = props1.keySet().iterator();
        while (names.hasNext()) {
            String propName = (String)names.next();
            if (!leftEntry && propName.startsWith("svn:entry:") || !leftWC && propName.startsWith("svn:wc:") || !leftRegular && !propName.startsWith("svn:entry:") && !propName.startsWith("svn:wc:")) continue;
            result.put(propName, props1.get(propName));
        }
        return result;
    }
}

