/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.DefaultSVNRepositoryPool;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNCopyClient;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNMoveClient;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SVNClientManager
implements ISVNRepositoryPool {
    private ISVNOptions myOptions;
    private SVNCommitClient myCommitClient;
    private SVNCopyClient myCopyClient;
    private SVNDiffClient myDiffClient;
    private SVNLogClient myLogClient;
    private SVNMoveClient myMoveClient;
    private SVNStatusClient myStatusClient;
    private SVNUpdateClient myUpdateClient;
    private SVNWCClient myWCClient;
    private ISVNEventHandler myEventHandler;
    private ISVNRepositoryPool myRepositoryPool;

    private SVNClientManager(ISVNOptions options, ISVNRepositoryPool repositoryPool) {
        this.myOptions = options;
        if (this.myOptions == null) {
            this.myOptions = SVNWCUtil.createDefaultOptions(true);
        }
        this.myRepositoryPool = repositoryPool;
    }

    private SVNClientManager(ISVNOptions options, ISVNAuthenticationManager authManager) {
        this(options, new DefaultSVNRepositoryPool(authManager == null ? SVNWCUtil.createDefaultAuthenticationManager() : authManager));
    }

    public static SVNClientManager newInstance() {
        return new SVNClientManager(null, (ISVNAuthenticationManager)null);
    }

    public static SVNClientManager newInstance(ISVNOptions options) {
        return new SVNClientManager(options, (ISVNAuthenticationManager)null);
    }

    public static SVNClientManager newInstance(ISVNOptions options, ISVNAuthenticationManager authManager) {
        return new SVNClientManager(options, authManager);
    }

    public static SVNClientManager newInstance(ISVNOptions options, ISVNRepositoryPool repositoryPool) {
        return new SVNClientManager(options, repositoryPool);
    }

    public static SVNClientManager newInstance(ISVNOptions options, String userName, String password) {
        boolean storeAuth = options == null ? true : options.isAuthStorageEnabled();
        ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager(null, userName, password, storeAuth);
        return new SVNClientManager(options, authManager);
    }

    public SVNRepository createRepository(SVNURL url, boolean mayReuse) throws SVNException {
        if (this.myRepositoryPool != null) {
            return this.myRepositoryPool.createRepository(url, mayReuse);
        }
        SVNRepository repository = SVNRepositoryFactory.create(url);
        repository.setAuthenticationManager(SVNWCUtil.createDefaultAuthenticationManager());
        return repository;
    }

    public void shutdownConnections(boolean shutdownAll) {
        if (this.myRepositoryPool != null) {
            this.myRepositoryPool.shutdownConnections(shutdownAll);
        }
    }

    public ISVNOptions getOptions() {
        return this.myOptions;
    }

    public void setEventHandler(ISVNEventHandler handler) {
        this.myEventHandler = handler;
        if (this.myCommitClient != null) {
            this.myCommitClient.setEventHandler(handler);
        }
        if (this.myCopyClient != null) {
            this.myCopyClient.setEventHandler(handler);
        }
        if (this.myDiffClient != null) {
            this.myDiffClient.setEventHandler(handler);
        }
        if (this.myLogClient != null) {
            this.myLogClient.setEventHandler(handler);
        }
        if (this.myMoveClient != null) {
            this.myMoveClient.setEventHandler(handler);
        }
        if (this.myStatusClient != null) {
            this.myStatusClient.setEventHandler(handler);
        }
        if (this.myUpdateClient != null) {
            this.myUpdateClient.setEventHandler(handler);
        }
        if (this.myWCClient != null) {
            this.myWCClient.setEventHandler(handler);
        }
    }

    public SVNCommitClient getCommitClient() {
        if (this.myCommitClient == null) {
            this.myCommitClient = new SVNCommitClient(this, this.myOptions);
            this.myCommitClient.setEventHandler(this.myEventHandler);
        }
        return this.myCommitClient;
    }

    public SVNCopyClient getCopyClient() {
        if (this.myCopyClient == null) {
            this.myCopyClient = new SVNCopyClient(this, this.myOptions);
            this.myCopyClient.setEventHandler(this.myEventHandler);
        }
        return this.myCopyClient;
    }

    public SVNDiffClient getDiffClient() {
        if (this.myDiffClient == null) {
            this.myDiffClient = new SVNDiffClient(this, this.myOptions);
            this.myDiffClient.setEventHandler(this.myEventHandler);
        }
        return this.myDiffClient;
    }

    public SVNLogClient getLogClient() {
        if (this.myLogClient == null) {
            this.myLogClient = new SVNLogClient(this, this.myOptions);
            this.myLogClient.setEventHandler(this.myEventHandler);
        }
        return this.myLogClient;
    }

    public SVNMoveClient getMoveClient() {
        if (this.myMoveClient == null) {
            this.myMoveClient = new SVNMoveClient(this, this.myOptions);
            this.myMoveClient.setEventHandler(this.myEventHandler);
        }
        return this.myMoveClient;
    }

    public SVNStatusClient getStatusClient() {
        if (this.myStatusClient == null) {
            this.myStatusClient = new SVNStatusClient(this, this.myOptions);
            this.myStatusClient.setEventHandler(this.myEventHandler);
        }
        return this.myStatusClient;
    }

    public SVNUpdateClient getUpdateClient() {
        if (this.myUpdateClient == null) {
            this.myUpdateClient = new SVNUpdateClient(this, this.myOptions);
            this.myUpdateClient.setEventHandler(this.myEventHandler);
        }
        return this.myUpdateClient;
    }

    public SVNWCClient getWCClient() {
        if (this.myWCClient == null) {
            this.myWCClient = new SVNWCClient(this, this.myOptions);
            this.myWCClient.setEventHandler(this.myEventHandler);
        }
        return this.myWCClient;
    }
}

