/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.io.diff;

import de.regnis.q.sequence.QSequenceDifferenceBlock;
import de.regnis.q.sequence.core.QSequenceException;
import de.regnis.q.sequence.line.QSequenceLineCache;
import de.regnis.q.sequence.line.QSequenceLineFixedTempDirectoryFactory;
import de.regnis.q.sequence.line.QSequenceLineMedia;
import de.regnis.q.sequence.line.QSequenceLineResult;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.ISVNDeltaGenerator;
import org.tmatesoft.svn.core.io.diff.ISVNRAData;
import org.tmatesoft.svn.core.io.diff.SVNAllDeltaGenerator;
import org.tmatesoft.svn.core.io.diff.SVNDiffInstruction;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.io.diff.SVNSequenceLineRAData;

public class SVNSequenceDeltaGenerator
implements ISVNDeltaGenerator {
    private static final SVNAllDeltaGenerator ALL_DELTA_GENERATOR = new SVNAllDeltaGenerator();
    private final int memoryThreshold;
    private final int fileSegmentSize;
    private final double searchDepthExponent;
    private final File tempDirectory;

    public SVNSequenceDeltaGenerator(File tempDirectory) {
        this(tempDirectory, QSequenceLineMedia.MEMORY_THRESHOLD, 16384, QSequenceLineMedia.SEARCH_DEPTH_EXPONENT);
    }

    SVNSequenceDeltaGenerator(File tempDirectory, int memoryThreshold, int fileSegmentSize, double searchDepthExponent) {
        this.memoryThreshold = memoryThreshold;
        this.searchDepthExponent = searchDepthExponent;
        this.tempDirectory = tempDirectory;
        this.fileSegmentSize = fileSegmentSize;
    }

    public void generateDiffWindow(String commitPath, ISVNEditor consumer, ISVNRAData workFile, ISVNRAData baseFile) throws SVNException {
        try {
            if (!SVNSequenceDeltaGenerator.canProcess(workFile, baseFile)) {
                ALL_DELTA_GENERATOR.generateDiffWindow(commitPath, consumer, workFile, baseFile);
                return;
            }
            SVNSequenceDeltaGenerator.doGenerateDiffWindow(commitPath, workFile, baseFile, consumer, this.memoryThreshold, this.fileSegmentSize, this.searchDepthExponent, this.tempDirectory);
        }
        catch (IOException ex) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ex.getLocalizedMessage());
            SVNErrorManager.error(err, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doGenerateDiffWindow(String commitPath, ISVNRAData workFile, ISVNRAData baseFile, ISVNEditor consumer, int memoryTreshold, int fileSegmentSize, double searchDepthExponent, File tempDirectory) throws IOException, SVNException {
        QSequenceLineResult result;
        try {
            result = QSequenceLineMedia.createBlocks(new SVNSequenceLineRAData(baseFile), new SVNSequenceLineRAData(workFile), memoryTreshold, fileSegmentSize, searchDepthExponent, new QSequenceLineFixedTempDirectoryFactory(tempDirectory));
        }
        catch (QSequenceException ex) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ex.getLocalizedMessage());
            SVNErrorManager.error(err, ex);
            return;
        }
        try {
            ArrayList instructions = new ArrayList();
            ArrayList newDatas = new ArrayList();
            SVNSequenceDeltaGenerator.createInstructions(result, instructions, newDatas);
            QSequenceLineCache baseLines = result.getLeftCache();
            QSequenceLineCache workLines = result.getRightCache();
            long sourceLength = baseLines.getLineCount() > 0 ? baseLines.getLine(baseLines.getLineCount() - 1).getTo() + 1L : 0L;
            long targetLength = workLines.getLineCount() > 0 ? workLines.getLine(workLines.getLineCount() - 1).getTo() + 1L : 0L;
            long newDataLength = SVNSequenceDeltaGenerator.determineNewDataLength(newDatas);
            SVNDiffInstruction[] instructionsArray = instructions.toArray(new SVNDiffInstruction[instructions.size()]);
            OutputStream stream = consumer.textDeltaChunk(commitPath, new SVNDiffWindow(0L, sourceLength, targetLength, instructionsArray, newDataLength));
            SVNSequenceDeltaGenerator.sendData(newDatas, stream);
            stream.close();
            consumer.textDeltaEnd(commitPath);
        }
        finally {
            result.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canProcess(ISVNRAData workFile, ISVNRAData baseFile) throws SVNException {
        SVNErrorMessage err;
        InputStream is = workFile.read(0L, Math.min(1024L, workFile.length()));
        try {
            if (SVNFileUtil.detectMimeType(workFile.read(0L, Math.min(workFile.length(), 1024L))) != null) {
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException e) {
            err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
            SVNErrorManager.error(err, e);
        }
        finally {
            SVNFileUtil.closeFile(is);
        }
        is = baseFile.read(0L, Math.min(1024L, baseFile.length()));
        try {
            if (SVNFileUtil.detectMimeType(is) != null) {
                boolean e = false;
                return e;
            }
        }
        catch (IOException e) {
            err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
            SVNErrorManager.error(err, e);
        }
        finally {
            SVNFileUtil.closeFile(is);
        }
        return true;
    }

    private static void createInstructions(QSequenceLineResult result, List instructions, List bytesToSend) throws IOException {
        QSequenceLineCache baseLines = result.getLeftCache();
        QSequenceLineCache workLines = result.getRightCache();
        List blockList = result.getBlocks();
        int lastBase = 0;
        Iterator it = blockList.iterator();
        while (it.hasNext()) {
            long charTo;
            long charFrom;
            QSequenceDifferenceBlock block = (QSequenceDifferenceBlock)it.next();
            int baseFrom = block.getLeftFrom();
            int baseTo = block.getLeftTo();
            int workFrom = block.getRightFrom();
            int workTo = block.getRightTo();
            if (lastBase < baseFrom) {
                charFrom = baseLines.getLine(lastBase).getFrom();
                charTo = baseLines.getLine(baseFrom - 1).getTo();
                instructions.add(new SVNDiffInstruction(0, charTo - charFrom + 1L, charFrom));
            }
            if (workTo >= workFrom) {
                charFrom = workLines.getLine(workFrom).getFrom();
                charTo = workLines.getLine(workTo).getTo();
                instructions.add(new SVNDiffInstruction(2, charTo - charFrom + 1L, 0L));
                for (int lineIndex = workFrom; lineIndex <= workTo; ++lineIndex) {
                    bytesToSend.add(workLines.getLine(lineIndex).getBytes());
                }
            }
            lastBase = baseTo + 1;
        }
        if (lastBase <= baseLines.getLineCount() - 1) {
            long baseFrom = baseLines.getLine(lastBase).getFrom();
            long baseTo = baseLines.getLine(baseLines.getLineCount() - 1).getTo();
            instructions.add(new SVNDiffInstruction(0, baseTo - baseFrom + 1L, baseFrom));
        }
    }

    private static long determineNewDataLength(List datas) {
        long length = 0L;
        Iterator it = datas.iterator();
        while (it.hasNext()) {
            byte[] data = (byte[])it.next();
            length += (long)data.length;
        }
        return length;
    }

    private static void sendData(List datas, OutputStream stream) throws IOException {
        Iterator it = datas.iterator();
        while (it.hasNext()) {
            byte[] bytes = (byte[])it.next();
            stream.write(bytes);
        }
    }
}

