/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.io.diff;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.diff.ISVNRAData;

public class SVNRAFileData
implements ISVNRAData {
    private RandomAccessFile myFile;
    private File myRawFile;
    private boolean myIsReadonly;

    public SVNRAFileData(File file, boolean readonly) {
        this.myRawFile = file;
        this.myIsReadonly = readonly;
    }

    public InputStream readAll() throws SVNException {
        return SVNFileUtil.openFileForReading(this.myRawFile);
    }

    public InputStream read(long offset, long length) throws SVNException {
        byte[] resultingArray = new byte[(int)length];
        int read = 0;
        try {
            this.getRAFile().seek(offset);
            read = this.getRAFile().read(resultingArray);
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
            SVNErrorManager.error(err, e);
        }
        int i = read;
        while ((long)i < length) {
            resultingArray[i] = resultingArray[i - read];
            ++i;
        }
        return new LocalInputStream(resultingArray);
    }

    public void append(InputStream source, long length) throws SVNException {
        try {
            this.getRAFile().seek(this.getRAFile().length());
            if (source instanceof LocalInputStream) {
                byte[] bytes = ((LocalInputStream)source).getBuffer();
                this.getRAFile().write(bytes, 0, (int)length);
            } else {
                byte[] bytes = new byte[(int)length];
                source.read(bytes, 0, (int)length);
                this.getRAFile().write(bytes, 0, (int)length);
            }
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
            SVNErrorManager.error(err, e);
        }
    }

    public void close() throws IOException {
        if (this.myFile == null) {
            return;
        }
        this.myFile.close();
        this.myFile = null;
    }

    public long length() {
        return this.myRawFile.length();
    }

    public long lastModified() {
        return this.myRawFile.lastModified();
    }

    private RandomAccessFile getRAFile() throws IOException {
        if (this.myFile == null) {
            if (!this.myRawFile.exists()) {
                this.myRawFile.getParentFile().mkdirs();
                this.myRawFile.createNewFile();
            } else if (!this.myIsReadonly) {
                SVNFileUtil.setReadonly(this.myRawFile, false);
            }
            this.myFile = new RandomAccessFile(this.myRawFile, this.myIsReadonly ? "r" : "rw");
        }
        return this.myFile;
    }

    private static class LocalInputStream
    extends ByteArrayInputStream {
        public LocalInputStream(byte[] buffer) {
            super(buffer);
        }

        public byte[] getBuffer() {
            return this.buf;
        }
    }
}

