/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.io.diff;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.ISVNDeltaGenerator;
import org.tmatesoft.svn.core.io.diff.ISVNRAData;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindowBuilder;

public class SVNAllDeltaGenerator
implements ISVNDeltaGenerator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateDiffWindow(String commitPath, ISVNEditor consumer, ISVNRAData workFile, ISVNRAData baseFile) throws SVNException {
        long length = workFile.length();
        if (length == 0L) {
            SVNDiffWindow window = SVNDiffWindowBuilder.createReplacementDiffWindow(length);
            OutputStream os = consumer.textDeltaChunk(commitPath, window);
            SVNFileUtil.closeFile(os);
            consumer.textDeltaEnd(commitPath);
            return;
        }
        int maxWindowLenght = 102400;
        SVNDiffWindow[] windows = SVNDiffWindowBuilder.createReplacementDiffWindows(length, 102400);
        InputStream is = null;
        OutputStream os = null;
        byte[] newDataBuffer = new byte[maxWindowLenght];
        try {
            is = workFile.readAll();
            for (int i = 0; i < windows.length; ++i) {
                SVNDiffWindow window = windows[i];
                os = consumer.textDeltaChunk(commitPath, window);
                is.read(newDataBuffer, 0, (int)window.getNewDataLength());
                os.write(newDataBuffer, 0, (int)window.getNewDataLength());
                SVNFileUtil.closeFile(os);
            }
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
            SVNErrorManager.error(err, e);
        }
        finally {
            SVNFileUtil.closeFile(os);
            SVNFileUtil.closeFile(is);
        }
        consumer.textDeltaEnd(commitPath);
    }
}

