/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.io;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.ISVNSession;
import org.tmatesoft.svn.core.io.SVNRepository;

public abstract class SVNRepositoryFactory {
    private static final Map myFactoriesMap = new HashMap();

    protected static void registerRepositoryFactory(String protocol, SVNRepositoryFactory factory) {
        if (protocol != null && factory != null && !myFactoriesMap.containsKey(protocol)) {
            myFactoriesMap.put(protocol, factory);
        }
    }

    protected static boolean hasRepositoryFactory(String protocol) {
        if (protocol != null) {
            return myFactoriesMap.get(protocol) != null;
        }
        return false;
    }

    public static SVNRepository create(SVNURL url) throws SVNException {
        return SVNRepositoryFactory.create(url, null);
    }

    public static SVNRepository create(SVNURL url, ISVNSession options) throws SVNException {
        SVNErrorMessage err;
        String urlString = url.toString();
        Iterator keys = myFactoriesMap.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!Pattern.matches(key, urlString)) continue;
            return ((SVNRepositoryFactory)myFactoriesMap.get(key)).createRepositoryImpl(url, options);
        }
        if ("file".equalsIgnoreCase(url.getProtocol())) {
            err = SVNErrorMessage.create(SVNErrorCode.RA_LOCAL_REPOS_OPEN_FAILED, "Unable to open an ra_local session to URL");
            SVNErrorManager.error(err);
        }
        err = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "Unable to create SVNRepository object for ''{0}''", url);
        SVNErrorManager.error(err);
        return null;
    }

    protected abstract SVNRepository createRepositoryImpl(SVNURL var1, ISVNSession var2);
}

