/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.SVNDirectory;
import org.tmatesoft.svn.core.internal.wc.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNExternalInfo;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNEvent;

public class SVNWCAccess
implements ISVNEventHandler {
    private SVNDirectory myAnchor;
    private SVNDirectory myTarget;
    private String myName;
    private ISVNOptions myOptions;
    private ISVNEventHandler myDispatcher;
    private Map myDirectories;
    private Map myExternals;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SVNWCAccess create(File file) throws SVNException {
        SVNDirectory target;
        file = new File(file.getAbsolutePath());
        File parentFile = file.getParentFile();
        String name = file.getName();
        SVNFileType parentType = SVNFileType.getType(parentFile);
        if (!(parentFile == null || parentType == SVNFileType.DIRECTORY || parentType == SVNFileType.SYMLINK && parentFile.isDirectory())) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "''{0}'' does not exist", parentFile);
            SVNErrorManager.error(err);
        }
        SVNFileType targetType = SVNFileType.getType(file);
        SVNDirectory anchor = parentFile != null ? new SVNDirectory(null, "", parentFile) : null;
        SVNDirectory sVNDirectory = target = targetType == SVNFileType.DIRECTORY ? new SVNDirectory(null, name, file) : null;
        if (anchor == null || !anchor.isVersioned()) {
            anchor = null;
            if (target != null) {
                target.setWCAccess(null, "");
            } else if (targetType == SVNFileType.SYMLINK && file.isDirectory()) {
                target = new SVNDirectory(null, name, file);
                target.setWCAccess(null, "");
            }
        }
        if (!(target != null && target.isVersioned() || (target = null) == null)) {
            target.setWCAccess(null, "");
        }
        if (target != null && anchor != null) {
            SVNEntry targetInAnchor = anchor.getEntries().getEntry(name, false);
            SVNDirectory anchorCopy = anchor;
            try {
                if (targetInAnchor == null) {
                    anchor = null;
                    if (target != null) {
                        target.setWCAccess(null, "");
                    }
                } else {
                    String urlName;
                    String expectedURL;
                    String targetURL;
                    SVNEntry anchorEntry = anchor.getEntries().getEntry("", false);
                    SVNEntry targetEntry = target.getEntries().getEntry("", false);
                    String anchorURL = anchorEntry != null ? anchorEntry.getURL() : null;
                    String string = targetURL = targetEntry != null ? targetEntry.getURL() : null;
                    if (!(anchorURL == null || targetURL == null || (expectedURL = SVNPathUtil.append(anchorURL, urlName = SVNEncodingUtil.uriEncode(targetInAnchor.getName()))).equals(targetURL) && anchorURL.equals(SVNPathUtil.removeTail(targetURL)))) {
                        anchor = null;
                        if (target != null) {
                            target.setWCAccess(null, "");
                        }
                    }
                }
                Object var16_16 = null;
                if (anchor == null && anchorCopy != null) {
                    anchorCopy.getEntries().close();
                    anchorCopy.dispose();
                    anchorCopy = null;
                }
                if (target == null) return new SVNWCAccess(anchor != null ? anchor : target, target != null ? target : anchor, anchor != null ? name : "");
                target.dispose();
                return new SVNWCAccess(anchor != null ? anchor : target, target != null ? target : anchor, anchor != null ? name : "");
            }
            catch (Throwable throwable) {
                Object var16_17 = null;
                if (anchor == null && anchorCopy != null) {
                    anchorCopy.getEntries().close();
                    anchorCopy.dispose();
                    anchorCopy = null;
                }
                if (target == null) throw throwable;
                target.dispose();
                throw throwable;
            }
        } else {
            if (target != null || anchor != null) return new SVNWCAccess(anchor != null ? anchor : target, target != null ? target : anchor, anchor != null ? name : "");
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "''{0}'' is not under version control", file);
            SVNErrorManager.error(err);
        }
        return new SVNWCAccess(anchor != null ? anchor : target, target != null ? target : anchor, anchor != null ? name : "");
    }

    public static boolean isVersionedDirectory(File path) {
        SVNDirectory dir = new SVNDirectory(null, null, path);
        return dir.isVersioned();
    }

    public SVNWCAccess(SVNDirectory anchor, SVNDirectory target, String name) {
        this.myAnchor = anchor;
        this.myTarget = target;
        this.myName = name;
        this.myAnchor.setWCAccess(this, "");
        if (this.myTarget != this.myAnchor) {
            this.myTarget.setWCAccess(this, this.myName);
        }
    }

    public void setOptions(ISVNOptions options) {
        this.myOptions = options;
    }

    public void setEventDispatcher(ISVNEventHandler dispatcher) {
        this.myDispatcher = dispatcher;
    }

    public ISVNOptions getOptions() {
        if (this.myOptions == null) {
            this.myOptions = new DefaultSVNOptions();
        }
        return this.myOptions;
    }

    public String getTargetName() {
        return this.myName;
    }

    public SVNDirectory getAnchor() {
        return this.myAnchor;
    }

    public SVNDirectory getTarget() {
        return this.myTarget;
    }

    public SVNEntry getTargetEntry() throws SVNException {
        SVNEntry entry;
        if (this.getAnchor() != this.getTarget() && (entry = this.getTarget().getEntries().getEntry("", false)) != null) {
            return entry;
        }
        return this.getAnchor().getEntries().getEntry(this.getTargetName(), false);
    }

    public SVNDirectory getDirectory(String path) {
        if (this.myDirectories == null || path == null) {
            return null;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return (SVNDirectory)this.myDirectories.get(path);
    }

    public SVNDirectory[] getAllDirectories() {
        return this.myDirectories.values().toArray(new SVNDirectory[this.myDirectories.size()]);
    }

    public SVNDirectory[] getChildDirectories(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        ArrayList dirs = new ArrayList();
        Iterator paths = this.myDirectories.keySet().iterator();
        while (paths.hasNext()) {
            String p = (String)paths.next();
            if ("".equals(path)) {
                if ("".equals(p) || p.indexOf("/") >= 0) continue;
                dirs.add(this.myDirectories.get(p));
                continue;
            }
            if (!(p = SVNPathUtil.removeTail(p)).equals(path)) continue;
            dirs.add(this.myDirectories.get(p));
        }
        return dirs.toArray(new SVNDirectory[dirs.size()]);
    }

    public boolean hasDirectory(String path) {
        if (this.myDirectories == null || path == null) {
            return false;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return this.myDirectories.containsKey(path);
    }

    public void open(boolean lock, boolean recursive) throws SVNException {
        this.open(lock, false, recursive);
    }

    public void open(final boolean lock, final boolean stealLock, boolean recursive) throws SVNException {
        if (this.myDirectories == null) {
            this.myDirectories = new TreeMap();
        }
        try {
            if (!(!lock || stealLock && this.myAnchor.isLocked())) {
                this.myAnchor.innerLock();
            }
            this.myDirectories.put("", this.myAnchor);
            if (this.myTarget != this.myAnchor) {
                if (!(!lock || stealLock && this.myTarget.isLocked())) {
                    this.myTarget.innerLock();
                }
                this.myDirectories.put(this.myName, this.myTarget);
            }
            if (recursive) {
                if (this.myTarget == this.myAnchor && this.myName != null && !"".equals(this.myName)) {
                    return;
                }
                this.visitDirectories(this.myTarget == this.myAnchor ? "" : this.myName, this.myTarget, new ISVNDirectoryVisitor(){

                    public void visit(String path, SVNDirectory dir) throws SVNException {
                        SVNWCAccess.this.checkCancelled();
                        if (!(!lock || dir.isLocked() && stealLock)) {
                            dir.innerLock();
                        }
                        SVNWCAccess.this.myDirectories.put(path, dir);
                    }
                });
            }
        }
        catch (SVNException e) {
            this.close(lock);
            throw e;
        }
    }

    public void close(boolean unlock) throws SVNException {
        SVNDirectory directory;
        if (!unlock || this.myDirectories == null) {
            if (this.myDirectories != null) {
                this.myDirectories = null;
            }
            this.myAnchor.dispose();
            this.myTarget.dispose();
            return;
        }
        this.myAnchor.dispose();
        this.myAnchor.unlock();
        if (this.myTarget != this.myAnchor) {
            this.myTarget.dispose();
            this.myTarget.unlock();
        }
        Iterator dirs = this.myDirectories.values().iterator();
        while (dirs.hasNext() && (directory = (SVNDirectory)dirs.next()).unlock()) {
            directory.dispose();
        }
        this.myDirectories = null;
    }

    public SVNExternalInfo[] addExternals(SVNDirectory directory, String externals) {
        SVNExternalInfo info;
        if (externals == null) {
            return null;
        }
        ArrayList<SVNExternalInfo> result = new ArrayList<SVNExternalInfo>();
        SVNExternalInfo[] parsed = SVNWCAccess.parseExternals(directory.getPath(), externals);
        for (int i = 0; i < parsed.length; ++i) {
            info = this.addExternal(directory, parsed[i].getPath(), parsed[i].getOldURL(), parsed[i].getOldRevision());
            result.add(info);
        }
        Iterator exts = this.externals();
        while (exts.hasNext()) {
            info = (SVNExternalInfo)exts.next();
            if (result.contains(info) || !directory.getPath().equals(info.getOwnerPath())) continue;
            info.setNewExternal(null, -1L);
        }
        return result.toArray(new SVNExternalInfo[result.size()]);
    }

    public static SVNExternalInfo[] parseExternals(String rootPath, String externals) {
        ArrayList<SVNExternalInfo> result = new ArrayList<SVNExternalInfo>();
        if (externals == null) {
            return result.toArray(new SVNExternalInfo[result.size()]);
        }
        StringTokenizer lines = new StringTokenizer(externals, "\n\r");
        while (lines.hasMoreTokens()) {
            String revStr;
            String line = lines.nextToken().trim();
            if (line.length() == 0 || line.startsWith("#")) continue;
            String url = null;
            long rev = -1L;
            ArrayList<String> parts = new ArrayList<String>(4);
            StringTokenizer tokens = new StringTokenizer(line, " \t");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken().trim();
                parts.add(token);
            }
            if (parts.size() < 2) continue;
            String path = SVNPathUtil.append(rootPath, (String)parts.get(0));
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if (parts.size() == 2) {
                url = (String)parts.get(1);
            } else if (parts.size() == 3 && parts.get(1).toString().startsWith("-r")) {
                revStr = parts.get(1).toString();
                if (!"HEAD".equals(revStr = revStr.substring("-r".length()))) {
                    try {
                        rev = Long.parseLong(revStr);
                    }
                    catch (NumberFormatException nfe) {
                        continue;
                    }
                }
                url = (String)parts.get(2);
            } else if (parts.size() == 4 && "-r".equals(parts.get(1))) {
                revStr = parts.get(2).toString();
                if (!"HEAD".equals(revStr)) {
                    try {
                        rev = Long.parseLong(revStr);
                    }
                    catch (NumberFormatException nfe) {
                        continue;
                    }
                }
                url = (String)parts.get(3);
            }
            if (path == null || url == null) continue;
            if ("".equals(rootPath) && ((String)parts.get(0)).startsWith("/")) {
                path = "/" + path;
            }
            try {
                url = SVNURL.parseURIEncoded(url).toString();
            }
            catch (SVNException e) {
                continue;
            }
            try {
                SVNExternalInfo info = new SVNExternalInfo("", null, path, SVNURL.parseURIEncoded(url), rev);
                result.add(info);
            }
            catch (SVNException e) {}
        }
        return result.toArray(new SVNExternalInfo[result.size()]);
    }

    private SVNExternalInfo addExternal(SVNDirectory dir, String path, SVNURL url, long revision) {
        SVNExternalInfo info;
        if (this.myExternals == null) {
            this.myExternals = new TreeMap();
        }
        if ((info = (SVNExternalInfo)this.myExternals.get(path)) == null) {
            info = new SVNExternalInfo(dir.getPath(), new File(this.getAnchor().getRoot(), path), path, null, -1L);
            this.myExternals.put(path, info);
        }
        info.setNewExternal(url, revision);
        return info;
    }

    public Iterator externals() {
        if (this.myExternals == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.myExternals.values().iterator();
    }

    private void visitDirectories(String parentPath, SVNDirectory root, ISVNDirectoryVisitor visitor) throws SVNException {
        Iterator entries = root.getEntries().entries(true);
        while (entries.hasNext()) {
            SVNEntry entry = (SVNEntry)entries.next();
            if ("".equals(entry.getName()) || entry.getKind() == SVNNodeKind.FILE) continue;
            File dir = new File(root.getRoot(), entry.getName());
            if (entry.getKind() != SVNNodeKind.DIR || SVNFileType.getType(dir) != SVNFileType.DIRECTORY) continue;
            String path = SVNPathUtil.append(parentPath, dir.getName());
            SVNDirectory svnDir = new SVNDirectory(this, "".equals(parentPath) ? dir.getName() : SVNPathUtil.append(parentPath, dir.getName()), dir);
            if (!svnDir.isVersioned()) continue;
            this.visitDirectories(path, svnDir, visitor);
            visitor.visit(path, svnDir);
        }
    }

    public SVNDirectory addDirectory(String path, File file) throws SVNException {
        return this.addDirectory(path, file, false, false, false);
    }

    public SVNDirectory addDirectory(String path, File file, boolean recursive, boolean lock, boolean checkVersioned) throws SVNException {
        if (file == null || SVNFileType.getType(file) != SVNFileType.DIRECTORY) {
            return null;
        }
        if (this.myDirectories != null) {
            SVNDirectory dir = new SVNDirectory(this, path, file);
            if (checkVersioned && !dir.isVersioned()) {
                return null;
            }
            if (this.myDirectories.put(path, dir) == null && lock && !dir.isLocked()) {
                dir.lock();
            }
            if (recursive) {
                File[] dirs = file.listFiles();
                for (int i = 0; dirs != null && i < dirs.length; ++i) {
                    SVNFileType fType;
                    File childDir = dirs[i];
                    if (SVNFileUtil.getAdminDirectoryName().equals(childDir) || (fType = SVNFileType.getType(childDir)) != SVNFileType.DIRECTORY || !SVNWCAccess.isVersionedDirectory(childDir)) continue;
                    String childPath = SVNPathUtil.append(path, childDir.getName());
                    this.addDirectory(childPath, childDir, recursive, lock, checkVersioned);
                }
            }
            return dir;
        }
        return null;
    }

    public void removeDirectory(String path) throws SVNException {
        this.removeDirectory(path, false);
    }

    public void removeDirectory(String path, boolean recursive) throws SVNException {
        SVNDirectory dir = (SVNDirectory)this.myDirectories.remove(path);
        if (dir != null) {
            if (this.myExternals != null) {
                this.myExternals.remove(path);
            }
            dir.unlock();
        }
        if (recursive) {
            Iterator paths = this.myDirectories.keySet().iterator();
            while (paths.hasNext()) {
                String p = (String)paths.next();
                SVNDirectory childDir = (SVNDirectory)this.myDirectories.get(p);
                if (!p.startsWith(path + "/")) continue;
                paths.remove();
                childDir.unlock();
            }
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("anchor: '" + this.getAnchor().getRoot().toString() + "'\n");
        result.append("target: '" + this.getTarget().getRoot().toString() + "'\n");
        result.append("target name: '" + this.getTargetName() + "'");
        return result.toString();
    }

    public void handleEvent(SVNEvent event) {
        this.handleEvent(event, -1.0);
    }

    public void handleEvent(SVNEvent event, double progress) {
        if (this.myDispatcher != null) {
            try {
                this.myDispatcher.handleEvent(event, progress);
            }
            catch (Throwable th) {
                // empty catch block
            }
        }
    }

    public void checkCancelled() throws SVNCancelException {
        if (this.myDispatcher != null) {
            this.myDispatcher.checkCancelled();
        }
    }

    public ISVNEventHandler getEventDispatcher() {
        return this.myDispatcher;
    }

    private static interface ISVNDirectoryVisitor {
        public void visit(String var1, SVNDirectory var2) throws SVNException;
    }
}

