/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.util.Date;
import java.util.Iterator;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNTimeUtil;
import org.tmatesoft.svn.core.internal.wc.SVNDirectory;
import org.tmatesoft.svn.core.internal.wc.SVNEntries;
import org.tmatesoft.svn.core.internal.wc.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNExternalInfo;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNProperties;
import org.tmatesoft.svn.core.internal.wc.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc.SVNWCAccess;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.util.SVNDebugLog;

public class SVNReporter
implements ISVNReporterBaton {
    private SVNWCAccess myWCAccess;
    private boolean myIsRecursive;
    private boolean myIsRestore;

    public SVNReporter(SVNWCAccess wcAccess, boolean restoreFiles, boolean recursive) {
        this.myWCAccess = wcAccess;
        this.myIsRecursive = recursive;
        this.myIsRestore = restoreFiles;
    }

    public void report(ISVNReporter reporter) throws SVNException {
        try {
            boolean missing;
            long revision;
            SVNEntries targetEntries = this.myWCAccess.getTarget().getEntries();
            SVNEntries anchorEntries = this.myWCAccess.getAnchor().getEntries();
            SVNEntry targetEntry = anchorEntries.getEntry(this.myWCAccess.getTargetName(), true);
            if (targetEntry == null || targetEntry.isHidden() || targetEntry.isDirectory() && targetEntry.isScheduledForAddition()) {
                long revision2 = anchorEntries.getEntry("", true).getRevision();
                reporter.setPath("", null, revision2, targetEntry != null ? targetEntry.isIncomplete() : true);
                reporter.deletePath("");
                reporter.finishReport();
                return;
            }
            long l = revision = targetEntry.isFile() ? targetEntry.getRevision() : targetEntries.getEntry("", true).getRevision();
            if (revision < 0L) {
                revision = anchorEntries.getEntry("", true).getRevision();
            }
            reporter.setPath("", null, revision, targetEntry.isIncomplete());
            File file = this.myWCAccess.getAnchor().getFile(this.myWCAccess.getTargetName());
            SVNFileType fileType = SVNFileType.getType(file);
            boolean bl = missing = !targetEntry.isScheduledForDeletion() && fileType == SVNFileType.NONE;
            if (targetEntry.isDirectory()) {
                if (missing) {
                    reporter.deletePath("");
                } else {
                    this.reportEntries(reporter, this.myWCAccess.getTarget(), "", targetEntry.isIncomplete(), this.myIsRecursive);
                }
            } else if (targetEntry.isFile()) {
                if (missing) {
                    this.restoreFile(this.myWCAccess.getAnchor(), targetEntry.getName());
                }
                String url = targetEntry.getURL();
                SVNEntry parentEntry = targetEntries.getEntry("", true);
                String parentURL = parentEntry.getURL();
                String expectedURL = SVNPathUtil.append(parentURL, SVNEncodingUtil.uriEncode(targetEntry.getName()));
                if (!expectedURL.equals(url)) {
                    SVNURL svnURL = SVNURL.parseURIEncoded(url);
                    reporter.linkPath(svnURL, "", targetEntry.getLockToken(), targetEntry.getRevision(), false);
                } else if (targetEntry.getRevision() != parentEntry.getRevision() || targetEntry.getLockToken() != null) {
                    reporter.setPath("", targetEntry.getLockToken(), targetEntry.getRevision(), false);
                }
            }
            reporter.finishReport();
        }
        catch (Throwable th) {
            SVNDebugLog.logInfo(th);
            try {
                reporter.abortReport();
            }
            catch (SVNException e) {
                SVNDebugLog.logInfo(e);
            }
            if (th instanceof SVNException) {
                throw (SVNException)th;
            }
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "WC report failed: {1}", th.getLocalizedMessage());
            SVNErrorManager.error(err, th);
        }
    }

    private void reportEntries(ISVNReporter reporter, SVNDirectory directory, String dirPath, boolean reportAll, boolean recursive) throws SVNException {
        SVNEntries entries = directory.getEntries();
        long baseRevision = entries.getEntry("", true).getRevision();
        SVNExternalInfo[] externals = this.myWCAccess.addExternals(directory, directory.getProperties("", false).getPropertyValue("svn:externals"));
        for (int i = 0; externals != null && i < externals.length; ++i) {
            externals[i].setOldExternal(externals[i].getNewURL(), externals[i].getNewRevision());
        }
        Iterator e = entries.entries(true);
        while (e.hasNext()) {
            SVNURL svnURL;
            boolean missing;
            String path;
            SVNEntry entry = (SVNEntry)e.next();
            if ("".equals(entry.getName())) continue;
            String string = path = "".equals(dirPath) ? entry.getName() : SVNPathUtil.append(dirPath, entry.getName());
            if (entry.isDeleted() || entry.isAbsent()) {
                if (reportAll) continue;
                reporter.deletePath(path);
                continue;
            }
            if (entry.isScheduledForAddition()) continue;
            File file = directory.getFile(entry.getName());
            SVNFileType fileType = SVNFileType.getType(file);
            boolean bl = missing = fileType == SVNFileType.NONE;
            if (entry.isFile()) {
                if (!reportAll && !missing) {
                    SVNFileType expectedType;
                    boolean special = !SVNFileUtil.isWindows && directory.getProperties(entry.getName(), false).getPropertyValue("svn:special") != null;
                    SVNFileType sVNFileType = expectedType = special ? SVNFileType.SYMLINK : SVNFileType.FILE;
                    if (fileType != expectedType) {
                        reporter.deletePath(path);
                        continue;
                    }
                }
                if (missing && !entry.isScheduledForDeletion() && !entry.isScheduledForReplacement()) {
                    this.restoreFile(directory, entry.getName());
                }
                String url = entry.getURL();
                String parentURL = entries.getPropertyValue("", "svn:entry:url");
                String expectedURL = SVNPathUtil.append(parentURL, SVNEncodingUtil.uriEncode(entry.getName()));
                if (reportAll) {
                    if (!(url.equals(expectedURL) || entry.isScheduledForAddition() || entry.isScheduledForReplacement())) {
                        svnURL = SVNURL.parseURIEncoded(url);
                        reporter.linkPath(svnURL, path, entry.getLockToken(), entry.getRevision(), false);
                        continue;
                    }
                    reporter.setPath(path, entry.getLockToken(), entry.getRevision(), false);
                    continue;
                }
                if (!entry.isScheduledForReplacement() && !url.equals(expectedURL)) {
                    svnURL = SVNURL.parseURIEncoded(url);
                    reporter.linkPath(svnURL, path, entry.getLockToken(), entry.getRevision(), false);
                    continue;
                }
                if (entry.getRevision() == baseRevision && entry.getLockToken() == null) continue;
                reporter.setPath(path, entry.getLockToken(), entry.getRevision(), false);
                continue;
            }
            if (!entry.isDirectory() || !recursive) continue;
            if (missing || directory.getChildDirectory(entry.getName()) == null) {
                if (reportAll) continue;
                reporter.deletePath(path);
                continue;
            }
            if (file.isFile()) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "The entry ''{0}'' is no longer a directory; remove the entry before updating", file);
                SVNErrorManager.error(err);
            }
            SVNDirectory childDir = directory.getChildDirectory(entry.getName());
            SVNEntry childEntry = childDir.getEntries().getEntry("", true);
            String url = childEntry.getURL();
            if (reportAll) {
                if (!url.equals(entry.getURL())) {
                    svnURL = SVNURL.parseURIEncoded(url);
                    reporter.linkPath(svnURL, path, childEntry.getLockToken(), childEntry.getRevision(), childEntry.isIncomplete());
                } else {
                    reporter.setPath(path, childEntry.getLockToken(), childEntry.getRevision(), childEntry.isIncomplete());
                }
            } else if (!url.equals(entry.getURL())) {
                svnURL = SVNURL.parseURIEncoded(url);
                reporter.linkPath(svnURL, path, childEntry.getLockToken(), childEntry.getRevision(), childEntry.isIncomplete());
            } else if (childEntry.getLockToken() != null || childEntry.getRevision() != baseRevision) {
                reporter.setPath(path, childEntry.getLockToken(), childEntry.getRevision(), childEntry.isIncomplete());
            }
            this.reportEntries(reporter, childDir, path, childEntry.isIncomplete(), recursive);
        }
    }

    private void restoreFile(SVNDirectory dir, String name) throws SVNException {
        boolean needsLock;
        if (!this.myIsRestore) {
            return;
        }
        SVNProperties props = dir.getProperties(name, false);
        SVNEntry entry = dir.getEntries().getEntry(name, true);
        boolean special = props.getPropertyValue("svn:special") != null;
        File src = dir.getBaseFile(name, false);
        File dst = dir.getFile(name);
        SVNTranslator.translate(dir, name, SVNFileUtil.getBasePath(src), SVNFileUtil.getBasePath(dst), true, true);
        dir.markResolved(name, true, false);
        boolean executable = props.getPropertyValue("svn:executable") != null;
        boolean bl = needsLock = props.getPropertyValue("svn:needs-lock") != null;
        if (executable) {
            SVNFileUtil.setExecutable(dst, true);
        }
        if (needsLock) {
            SVNFileUtil.setReadonly(dst, entry.getLockToken() == null);
        }
        long tstamp = dst.lastModified();
        if (this.myWCAccess.getOptions().isUseCommitTimes() && !special) {
            entry.setTextTime(entry.getCommittedDate());
            tstamp = SVNTimeUtil.parseDate(entry.getCommittedDate()).getTime();
            dst.setLastModified(tstamp);
        } else {
            entry.setTextTime(SVNTimeUtil.formatDate(new Date(tstamp)));
        }
        dir.getEntries().save(false);
        this.myWCAccess.handleEvent(SVNEventFactory.createRestoredEvent(this.myWCAccess, dir, entry));
    }
}

