/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableOutputStream;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.ISVNDiffGenerator;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;

public class SVNRemoteDiffEditor
implements ISVNEditor {
    private File myRoot;
    private SVNRepository myRepos;
    private long myRevision;
    private ISVNDiffGenerator myDiffGenerator;
    private SVNDirectoryInfo myCurrentDirectory;
    private SVNFileInfo myCurrentFile;
    private OutputStream myResult;
    private String myRevision1;
    private String myRevision2;
    private String myBasePath;
    private SVNDeltaProcessor myDeltaProcessor;
    private ISVNEventHandler myEventHandler;

    public SVNRemoteDiffEditor(String basePath, File tmpRoot, ISVNDiffGenerator diffGenerator, SVNRepository repos, long revision, OutputStream result, ISVNEventHandler handler) {
        this.myBasePath = basePath;
        this.myRoot = tmpRoot;
        this.myRepos = repos;
        this.myRevision = revision;
        this.myDiffGenerator = diffGenerator;
        this.myResult = result;
        this.myRevision1 = "(revision " + revision + ")";
        this.myEventHandler = handler;
        this.myDeltaProcessor = new SVNDeltaProcessor();
    }

    public void targetRevision(long revision) throws SVNException {
        this.myRevision2 = "(revision " + revision + ")";
    }

    public void openRoot(long revision) throws SVNException {
        this.myCurrentDirectory = new SVNDirectoryInfo(null, "");
        this.myCurrentDirectory.myBaseProperties = new HashMap();
        this.myRepos.getDir("", this.myRevision, this.myCurrentDirectory.myBaseProperties, (Collection)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteEntry(String path, long revision) throws SVNException {
        SVNNodeKind nodeKind = this.myRepos.checkPath(path, this.myRevision);
        if (nodeKind == SVNNodeKind.FILE) {
            String name = SVNPathUtil.tail(path);
            File tmpFile = SVNFileUtil.createUniqueFile(this.myRoot, name, ".tmp");
            SVNFileInfo info = new SVNFileInfo(path);
            try {
                info.loadFromRepository(tmpFile, this.myRepos, this.myRevision, this.myEventHandler);
                String mimeType = (String)info.myBaseProperties.get("svn:mime-type");
                String displayPath = SVNPathUtil.append(this.myBasePath, path);
                this.myDiffGenerator.displayFileDiff(displayPath, tmpFile, null, this.myRevision1, this.myRevision2, mimeType, mimeType, this.myResult);
            }
            finally {
                if (tmpFile != null) {
                    tmpFile.delete();
                }
            }
        }
    }

    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        this.myCurrentDirectory = new SVNDirectoryInfo(this.myCurrentDirectory, path);
        this.myCurrentDirectory.myBaseProperties = Collections.EMPTY_MAP;
    }

    public void openDir(String path, long revision) throws SVNException {
        this.myCurrentDirectory = new SVNDirectoryInfo(this.myCurrentDirectory, path);
        this.myCurrentDirectory.myBaseProperties = new HashMap();
        this.myRepos.getDir(path, this.myRevision, this.myCurrentDirectory.myBaseProperties, (Collection)null);
    }

    public void changeDirProperty(String name, String value) throws SVNException {
        if (name == null || name.startsWith("svn:wc:") || name.startsWith("svn:entry:")) {
            return;
        }
        if (this.myCurrentDirectory.myPropertyDiff == null) {
            this.myCurrentDirectory.myPropertyDiff = new HashMap();
        }
        this.myCurrentDirectory.myPropertyDiff.put(name, value);
    }

    public void closeDir() throws SVNException {
        if (this.myCurrentDirectory.myPropertyDiff != null) {
            String displayPath = SVNPathUtil.append(this.myBasePath, this.myCurrentDirectory.myPath);
            this.myDiffGenerator.displayPropDiff(displayPath, this.myCurrentDirectory.myBaseProperties, this.myCurrentDirectory.myPropertyDiff, this.myResult);
        }
        this.myCurrentDirectory = this.myCurrentDirectory.myParent;
    }

    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        this.myCurrentFile = new SVNFileInfo(path);
        this.myCurrentFile.myBaseProperties = Collections.EMPTY_MAP;
        this.myCurrentFile.myBaseFile = SVNFileUtil.createUniqueFile(this.myRoot, SVNPathUtil.tail(path), ".tmp");
        SVNFileUtil.createEmptyFile(this.myCurrentFile.myBaseFile);
        this.myCurrentFile.myFile = SVNFileUtil.createUniqueFile(this.myRoot, SVNPathUtil.tail(path), ".tmp");
        SVNFileUtil.createEmptyFile(this.myCurrentFile.myFile);
    }

    public void openFile(String path, long revision) throws SVNException {
        this.myCurrentFile = new SVNFileInfo(path);
    }

    public void changeFileProperty(String commitPath, String name, String value) throws SVNException {
        if (name == null || name.startsWith("svn:wc:") || name.startsWith("svn:entry:")) {
            return;
        }
        if (this.myCurrentFile.myPropertyDiff == null) {
            this.myCurrentFile.myPropertyDiff = new HashMap();
        }
        this.myCurrentFile.myPropertyDiff.put(name, value);
    }

    public void applyTextDelta(String commitPath, String baseChecksum) throws SVNException {
        if (this.myCurrentFile.myBaseFile == null) {
            this.myCurrentFile.myBaseFile = SVNFileUtil.createUniqueFile(this.myRoot, SVNPathUtil.tail(commitPath), ".tmp");
            this.myCurrentFile.loadFromRepository(this.myCurrentFile.myBaseFile, this.myRepos, this.myRevision, this.myEventHandler);
            this.myCurrentFile.myFile = SVNFileUtil.createUniqueFile(this.myRoot, SVNPathUtil.tail(commitPath), ".tmp");
            SVNFileUtil.createEmptyFile(this.myCurrentFile.myFile);
        }
        this.myDeltaProcessor.applyTextDelta(this.myCurrentFile.myBaseFile, this.myCurrentFile.myFile, false);
    }

    public OutputStream textDeltaChunk(String commitPath, SVNDiffWindow diffWindow) throws SVNException {
        return this.myDeltaProcessor.textDeltaChunk(diffWindow);
    }

    public void textDeltaEnd(String commitPath) throws SVNException {
        this.myDeltaProcessor.textDeltaEnd();
    }

    public void closeFile(String commitPath, String textChecksum) throws SVNException {
        String displayPath = SVNPathUtil.append(this.myBasePath, this.myCurrentFile.myPath);
        if (this.myCurrentFile.myFile != null) {
            String mimeType2;
            String mimeType1 = (String)this.myCurrentFile.myBaseProperties.get("svn:mime-type");
            String string = mimeType2 = this.myCurrentFile.myPropertyDiff != null ? (String)this.myCurrentFile.myPropertyDiff.get("svn:mime-type") : null;
            if (mimeType2 == null) {
                mimeType2 = mimeType1;
            }
            this.myDiffGenerator.displayFileDiff(displayPath, this.myCurrentFile.myBaseFile, this.myCurrentFile.myFile, this.myRevision1, this.myRevision2, mimeType1, mimeType2, this.myResult);
        }
        if (this.myCurrentFile.myPropertyDiff != null) {
            this.myDiffGenerator.displayPropDiff(displayPath, this.myCurrentFile.myBaseProperties, this.myCurrentFile.myPropertyDiff, this.myResult);
        }
        if (this.myCurrentFile.myFile != null) {
            this.myCurrentFile.myFile.delete();
        }
        if (this.myCurrentFile.myBaseFile != null) {
            this.myCurrentFile.myBaseFile.delete();
        }
    }

    public SVNCommitInfo closeEdit() throws SVNException {
        return null;
    }

    public void abortEdit() throws SVNException {
    }

    public void absentDir(String path) throws SVNException {
    }

    public void absentFile(String path) throws SVNException {
    }

    private static class SVNFileInfo {
        private String myPath;
        private File myFile;
        private File myBaseFile;
        private Map myBaseProperties;
        private Map myPropertyDiff;

        public SVNFileInfo(String path) {
            this.myPath = path;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void loadFromRepository(File dst, SVNRepository repos, long revision, ISVNEventHandler handler) throws SVNException {
            OutputStream os = SVNFileUtil.openFileForWriting(dst);
            try {
                this.myBaseProperties = new HashMap();
                repos.getFile(this.myPath, revision, this.myBaseProperties, new SVNCancellableOutputStream(os, handler));
            }
            finally {
                SVNFileUtil.closeFile(os);
            }
        }
    }

    private static class SVNDirectoryInfo {
        private String myPath;
        private Map myBaseProperties;
        private Map myPropertyDiff;
        private SVNDirectoryInfo myParent;

        public SVNDirectoryInfo(SVNDirectoryInfo parent, String path) {
            this.myParent = parent;
            this.myPath = path;
        }
    }
}

