/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNTimeUtil;
import org.tmatesoft.svn.core.internal.wc.SVNDirectory;
import org.tmatesoft.svn.core.internal.wc.SVNEntries;
import org.tmatesoft.svn.core.internal.wc.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNProperties;
import org.tmatesoft.svn.core.internal.wc.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc.SVNWCAccess;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SVNLogRunner {
    private boolean myIsEntriesChanged;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runCommand(SVNDirectory dir, String name, Map attributes) throws SVNException {
        block74: {
            String fileName;
            block84: {
                block83: {
                    block82: {
                        block81: {
                            block80: {
                                block79: {
                                    block78: {
                                        block77: {
                                            fileName = (String)attributes.get("name");
                                            if (!"delete-entry".equals(name)) break block77;
                                            dir.destroy(fileName, true);
                                            break block74;
                                        }
                                        if (!"modify-entry".equals(name)) break block78;
                                        SVNEntries entries = dir.getEntries();
                                        boolean modified = false;
                                        if (entries.getEntry(fileName, true) == null) {
                                            entries.addEntry(fileName);
                                            modified = true;
                                        }
                                        Iterator atts = attributes.keySet().iterator();
                                        while (atts.hasNext()) {
                                            String attName = (String)atts.next();
                                            if ("".equals(attName) || "name".equals(attName)) continue;
                                            String value = (String)attributes.get(attName);
                                            attName = "svn:entry:" + attName;
                                            if ("working".equals(value)) {
                                                File file;
                                                String path;
                                                if ("svn:entry:prop-time".equals(attName)) {
                                                    path = "".equals(fileName) ? "dir-props" : "props/" + fileName + ".svn-work";
                                                    file = dir.getAdminFile(path);
                                                    value = SVNTimeUtil.formatDate(new Date(file.lastModified()));
                                                } else if ("svn:entry:text-time".equals(attName)) {
                                                    path = "".equals(fileName) ? "" : fileName;
                                                    file = new File(dir.getRoot(), path);
                                                    value = SVNTimeUtil.formatDate(new Date(file.lastModified()));
                                                }
                                            }
                                            entries.setPropertyValue(fileName, attName, value);
                                            modified = true;
                                        }
                                        this.setEntriesChanged(modified);
                                        break block74;
                                    }
                                    if (!"modify-wcprop".equals(name)) break block79;
                                    SVNProperties props = dir.getWCProperties(fileName);
                                    String propName = (String)attributes.get("propname");
                                    String propValue = (String)attributes.get("propval");
                                    props.setPropertyValue(propName, propValue);
                                    break block74;
                                }
                                if (!"delete-lock".equals(name)) break block80;
                                SVNEntries entries = dir.getEntries();
                                SVNEntry entry = entries.getEntry(fileName, true);
                                if (entry != null) {
                                    entry.setLockToken(null);
                                    entry.setLockOwner(null);
                                    entry.setLockCreationDate(null);
                                    entry.setLockComment(null);
                                    this.setEntriesChanged(true);
                                }
                                break block74;
                            }
                            if (!"rm".equals(name)) break block81;
                            File file = new File(dir.getRoot(), fileName);
                            file.delete();
                            break block74;
                        }
                        if (!"readonly".equals(name)) break block82;
                        File file = new File(dir.getRoot(), fileName);
                        SVNFileUtil.setReadonly(file, true);
                        break block74;
                    }
                    if (!"mv".equals(name)) break block83;
                    File src = new File(dir.getRoot(), fileName);
                    File dst = new File(dir.getRoot(), (String)attributes.get("dest"));
                    SVNFileUtil.rename(src, dst);
                    break block74;
                }
                if (!"append".equals(name)) break block84;
                File src = new File(dir.getRoot(), fileName);
                File dst = new File(dir.getRoot(), (String)attributes.get("dest"));
                OutputStream os = null;
                InputStream is = null;
                try {
                    int r;
                    os = SVNFileUtil.openFileForWriting(dst, true);
                    is = SVNFileUtil.openFileForReading(src);
                    while ((r = is.read()) >= 0) {
                        os.write(r);
                    }
                }
                catch (IOException e) {
                    try {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot write to ''{0}'': {1}", new Object[]{dst, e.getLocalizedMessage()});
                        SVNErrorManager.error(err, e);
                    }
                    catch (Throwable throwable) {
                        SVNFileUtil.closeFile(os);
                        SVNFileUtil.closeFile(is);
                        throw throwable;
                    }
                    SVNFileUtil.closeFile(os);
                    SVNFileUtil.closeFile(is);
                    break block74;
                }
                SVNFileUtil.closeFile(os);
                SVNFileUtil.closeFile(is);
                break block74;
            }
            if ("set-timestamp".equals(name)) {
                File file = new File(dir.getRoot(), fileName);
                Date time = SVNTimeUtil.parseDate((String)attributes.get("timestamp"));
                file.setLastModified(time.getTime());
            } else if ("maybe-readonly".equals(name)) {
                SVNEntries entries = dir.getEntries();
                if (entries.getEntry(fileName, true) != null && entries.getEntry(fileName, true).getLockToken() == null) {
                    SVNFileUtil.setReadonly(new File(dir.getRoot(), fileName), true);
                }
            } else if ("cp-and-translate".equals(name)) {
                SVNEntry entry;
                String dstName = (String)attributes.get("dest");
                File dst = new File(dir.getRoot(), dstName);
                SVNProperties props = dir.getProperties(dstName, false);
                boolean executable = SVNFileUtil.isWindows ? false : props.getPropertyValue("svn:executable") != null;
                SVNTranslator.translate(dir, dstName, fileName, dstName, true, true);
                if (executable) {
                    SVNFileUtil.setExecutable(dst, true);
                }
                if ((entry = dir.getEntries().getEntry(dstName, true)).getLockToken() == null && props.getPropertyValue("svn:needs-lock") != null) {
                    SVNFileUtil.setReadonly(dst, true);
                }
            } else if ("cp-and-detranslate".equals(name)) {
                String dstName = (String)attributes.get("dest");
                SVNTranslator.translate(dir, fileName, fileName, dstName, false, true);
            } else if ("merge".equals(name)) {
                File target = new File(dir.getRoot(), fileName);
                String leftPath = (String)attributes.get("arg1");
                String rightPath = (String)attributes.get("arg2");
                String leftLabel = (String)attributes.get("arg3");
                leftLabel = leftLabel == null ? ".old" : leftLabel;
                String rightLabel = (String)attributes.get("arg4");
                rightLabel = rightLabel == null ? ".new" : rightLabel;
                String targetLabel = (String)attributes.get("arg5");
                targetLabel = targetLabel == null ? ".working" : targetLabel;
                SVNProperties props = dir.getProperties(fileName, false);
                SVNEntry entry = dir.getEntries().getEntry(fileName, true);
                String leaveConglictsAttr = (String)attributes.get("arg6");
                boolean leaveConflicts = Boolean.TRUE.toString().equals(leaveConglictsAttr);
                SVNStatusType mergeResult = dir.mergeText(fileName, leftPath, rightPath, targetLabel, leftLabel, rightLabel, leaveConflicts, false);
                if (props.getPropertyValue("svn:executable") != null) {
                    SVNFileUtil.setExecutable(target, true);
                }
                if (props.getPropertyValue("svn:needs-lock") != null && entry.getLockToken() == null) {
                    SVNFileUtil.setReadonly(target, true);
                }
                this.setEntriesChanged(mergeResult == SVNStatusType.CONFLICTED || mergeResult == SVNStatusType.CONFLICTED_UNRESOLVED);
            } else if ("committed".equals(name)) {
                File tmpFile;
                SVNFileType fileType;
                SVNEntry entry;
                if (attributes.get("revision") == null) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_BAD_ADM_LOG, "Missing revision attribute for ''{0}''", fileName);
                    SVNErrorManager.error(err);
                }
                if ((entry = dir.getEntries().getEntry(fileName, true)) == null || !"".equals(fileName) && entry.getKind() != SVNNodeKind.FILE) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_BAD_ADM_LOG, "Log command for directory ''{0}'' is mislocated", dir.getRoot());
                    SVNErrorManager.error(err);
                }
                boolean implicit = attributes.get("implicit") != null && entry.isCopied();
                this.setEntriesChanged(true);
                long revisionNumber = Long.parseLong((String)attributes.get("revision"));
                if (!implicit && entry.isScheduledForDeletion()) {
                    if ("".equals(fileName)) {
                        entry.setRevision(revisionNumber);
                        entry.setKind(SVNNodeKind.DIR);
                        File killMe = dir.getAdminFile("KILLME");
                        if (killMe.getParentFile().isDirectory()) {
                            try {
                                killMe.createNewFile();
                            }
                            catch (IOException e) {
                                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot create file ''{0}'': {1}", new Object[]{killMe, e.getLocalizedMessage()});
                                SVNErrorManager.error(err, e);
                            }
                        }
                    } else {
                        dir.destroy(fileName, false);
                        SVNEntry parentEntry = dir.getEntries().getEntry("", true);
                        if (revisionNumber > parentEntry.getRevision()) {
                            SVNEntry fileEntry = dir.getEntries().addEntry(fileName);
                            fileEntry.setKind(SVNNodeKind.FILE);
                            fileEntry.setDeleted(true);
                            fileEntry.setRevision(revisionNumber);
                        }
                    }
                    return;
                }
                if (!implicit && entry.isScheduledForReplacement() && "".equals(fileName)) {
                    Iterator ents = dir.getEntries().entries(true);
                    while (ents.hasNext()) {
                        SVNEntry currentEntry = (SVNEntry)ents.next();
                        if (!currentEntry.isScheduledForDeletion() || currentEntry.getKind() != SVNNodeKind.FILE && currentEntry.getKind() != SVNNodeKind.DIR) continue;
                        dir.destroy(currentEntry.getName(), false);
                    }
                }
                long textTime = 0L;
                if (!(implicit || "".equals(fileName) || (fileType = SVNFileType.getType(tmpFile = dir.getBaseFile(fileName, true))) != SVNFileType.FILE && fileType != SVNFileType.SYMLINK)) {
                    File tmpFile2 = SVNFileUtil.createUniqueFile(tmpFile.getParentFile(), fileName, ".tmp");
                    boolean equals = true;
                    try {
                        String tmpFile2Path = SVNFileUtil.getBasePath(tmpFile2);
                        SVNTranslator.translate(dir, fileName, fileName, tmpFile2Path, false, false);
                        equals = SVNFileUtil.compareFiles(tmpFile, tmpFile2, null);
                    }
                    finally {
                        tmpFile2.delete();
                    }
                    textTime = equals ? dir.getFile(fileName).lastModified() : tmpFile.lastModified();
                }
                SVNProperties baseProps = dir.getBaseProperties(fileName, false);
                SVNProperties wcProps = dir.getProperties(fileName, false);
                SVNProperties tmpProps = dir.getBaseProperties(fileName, true);
                if (!implicit && entry.isScheduledForReplacement()) {
                    baseProps.delete();
                }
                long propTime = 0L;
                boolean setReadWrite = false;
                boolean setNotExecutable = false;
                SVNFileType tmpPropsType = SVNFileType.getType(tmpProps.getFile());
                if (tmpPropsType == SVNFileType.FILE) {
                    Map propDiff = wcProps.compareTo(tmpProps);
                    boolean equals = propDiff == null || propDiff.isEmpty();
                    long l = propTime = equals ? wcProps.getFile().lastModified() : tmpProps.getFile().lastModified();
                    if (!"".equals(fileName)) {
                        propDiff = baseProps.compareTo(tmpProps);
                        setReadWrite = propDiff != null && propDiff.containsKey("svn:needs-lock") && propDiff.get("svn:needs-lock") == null;
                        setNotExecutable = propDiff != null && propDiff.containsKey("svn:executable") && propDiff.get("svn:executable") == null;
                    }
                    try {
                        tmpProps.copyTo(baseProps);
                        SVNFileUtil.setReadonly(baseProps.getFile(), true);
                    }
                    finally {
                        tmpProps.delete();
                    }
                } else if (entry.getPropTime() == null && !wcProps.isEmpty()) {
                    propTime = wcProps.getFile().lastModified();
                }
                if (!"".equals(fileName) && !implicit) {
                    File tmpFile2 = dir.getBaseFile(fileName, true);
                    File baseFile = dir.getBaseFile(fileName, false);
                    File wcFile = dir.getFile(fileName);
                    File tmpFile22 = SVNFileUtil.createUniqueFile(tmpFile2.getParentFile(), fileName, ".tmp");
                    try {
                        boolean needsExecutable;
                        boolean special;
                        boolean overwritten = false;
                        SVNFileType fileType2 = SVNFileType.getType(tmpFile2);
                        boolean bl = special = dir.getProperties(fileName, false).getPropertyValue("svn:special") != null;
                        if (SVNFileUtil.isWindows || !special) {
                            if (fileType2 == SVNFileType.FILE) {
                                SVNTranslator.translate(dir, fileName, SVNFileUtil.getBasePath(tmpFile2), SVNFileUtil.getBasePath(tmpFile22), true, false);
                            } else {
                                SVNTranslator.translate(dir, fileName, fileName, SVNFileUtil.getBasePath(tmpFile22), true, false);
                            }
                            if (!SVNFileUtil.compareFiles(tmpFile22, wcFile, null)) {
                                SVNFileUtil.copyFile(tmpFile22, wcFile, true);
                                overwritten = true;
                            }
                        }
                        boolean needsReadonly = dir.getProperties(fileName, false).getPropertyValue("svn:needs-lock") != null && entry.getLockToken() == null;
                        boolean bl2 = needsExecutable = dir.getProperties(fileName, false).getPropertyValue("svn:executable") != null;
                        if (needsReadonly) {
                            SVNFileUtil.setReadonly(wcFile, true);
                            overwritten = true;
                        }
                        if (needsExecutable) {
                            SVNFileUtil.setExecutable(wcFile, true);
                            overwritten = true;
                        }
                        if (fileType2 == SVNFileType.FILE) {
                            SVNFileUtil.rename(tmpFile2, baseFile);
                        }
                        if (setReadWrite) {
                            SVNFileUtil.setReadonly(wcFile, false);
                            overwritten = true;
                        }
                        if (setNotExecutable) {
                            SVNFileUtil.setExecutable(wcFile, false);
                            overwritten = true;
                        }
                        if (overwritten) {
                            textTime = wcFile.lastModified();
                        }
                    }
                    finally {
                        tmpFile22.delete();
                        tmpFile2.delete();
                    }
                }
                entry.setRevision(revisionNumber);
                entry.setKind("".equals(fileName) ? SVNNodeKind.DIR : SVNNodeKind.FILE);
                if (!implicit) {
                    entry.unschedule();
                }
                entry.setCopied(false);
                entry.setDeleted(false);
                if (textTime != 0L && !implicit) {
                    entry.setTextTime(SVNTimeUtil.formatDate(new Date(textTime)));
                }
                if (propTime != 0L && !implicit) {
                    entry.setPropTime(SVNTimeUtil.formatDate(new Date(propTime)));
                }
                entry.setConflictNew(null);
                entry.setConflictOld(null);
                entry.setConflictWorking(null);
                entry.setPropRejectFile(null);
                entry.setCopyFromRevision(-1L);
                entry.setCopyFromURL(null);
                this.setEntriesChanged(true);
                if (!"".equals(fileName)) {
                    return;
                }
                File dirFile = dir.getRoot();
                if (SVNWCUtil.isWorkingCopyRoot(dirFile, true)) {
                    return;
                }
                String parentPath = SVNPathUtil.removeTail(dir.getPath());
                SVNDirectory parentDir = dir.getWCAccess().getDirectory(parentPath);
                SVNWCAccess parentAccess = null;
                if (parentDir == null) {
                    parentDir = new SVNDirectory(null, "", dirFile);
                    parentAccess = new SVNWCAccess(parentDir, parentDir, "");
                    parentAccess.open(true, false);
                }
                String nameInParent = dirFile.getName();
                SVNEntry entryInParent = parentDir.getEntries().getEntry(nameInParent, false);
                if (entryInParent != null) {
                    if (!implicit) {
                        entryInParent.unschedule();
                    }
                    entryInParent.setCopied(false);
                    entryInParent.setCopyFromRevision(-1L);
                    entryInParent.setCopyFromURL(null);
                    entryInParent.setDeleted(false);
                }
                parentDir.getEntries().save(false);
                if (parentAccess != null) {
                    parentAccess.close(true);
                }
            }
        }
    }

    private void setEntriesChanged(boolean modified) {
        this.myIsEntriesChanged |= modified;
    }

    public void logFailed(SVNDirectory dir) throws SVNException {
        if (this.myIsEntriesChanged) {
            dir.getEntries().save(true);
        } else {
            dir.getEntries().close();
        }
    }

    public void logCompleted(SVNDirectory dir) throws SVNException {
        long dirRevision;
        boolean killMe = dir.getAdminFile("KILLME").isFile();
        long l = dirRevision = killMe ? dir.getEntries().getEntry("", true).getRevision() : -1L;
        if (this.myIsEntriesChanged) {
            dir.getEntries().save(false);
        } else {
            dir.getEntries().close();
        }
        if (killMe) {
            dir.destroy("", true);
            File dirFile = dir.getRoot();
            if (SVNWCUtil.isWorkingCopyRoot(dirFile, true)) {
                return;
            }
            String parentPath = SVNPathUtil.removeTail(dir.getPath());
            SVNDirectory parentDir = dir.getWCAccess().getDirectory(parentPath);
            SVNWCAccess parentAccess = null;
            if (parentDir == null) {
                parentDir = new SVNDirectory(null, "", dirFile);
                parentAccess = new SVNWCAccess(parentDir, parentDir, "");
                parentAccess.open(true, false);
            }
            String nameInParent = dirFile.getName();
            SVNEntry parentEntry = parentDir.getEntries().getEntry("", false);
            if (parentEntry != null && parentEntry.getRevision() <= dirRevision) {
                SVNEntry entryInParent = parentDir.getEntries().addEntry(nameInParent);
                entryInParent.setDeleted(true);
                entryInParent.setKind(SVNNodeKind.DIR);
                entryInParent.setRevision(dirRevision);
                parentDir.getEntries().save(false);
            }
            if (parentAccess != null) {
                parentAccess.close(true);
            }
        }
        this.myIsEntriesChanged = false;
    }
}

