/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.wc.SVNDirectory;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNLogRunner;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SVNLog {
    public static final String DELETE_ENTRY = "delete-entry";
    public static final String MODIFY_ENTRY = "modify-entry";
    public static final String MODIFY_WC_PROPERTY = "modify-wcprop";
    public static final String DELETE_LOCK = "delete-lock";
    public static final String MOVE = "mv";
    public static final String APPEND = "append";
    public static final String DELETE = "rm";
    public static final String READONLY = "readonly";
    public static final String COPY_AND_TRANSLATE = "cp-and-translate";
    public static final String COPY_AND_DETRANSLATE = "cp-and-detranslate";
    public static final String MERGE = "merge";
    public static final String MAYBE_READONLY = "maybe-readonly";
    public static final String SET_TIMESTAMP = "set-timestamp";
    public static final String COMMIT = "committed";
    public static final String NAME_ATTR = "name";
    public static final String PROPERTY_NAME_ATTR = "propname";
    public static final String PROPERTY_VALUE_ATTR = "propval";
    public static final String DEST_ATTR = "dest";
    public static final String TIMESTAMP_ATTR = "timestamp";
    public static final String REVISION_ATTR = "revision";
    public static final String ATTR1 = "arg1";
    public static final String ATTR2 = "arg2";
    public static final String ATTR3 = "arg3";
    public static final String ATTR4 = "arg4";
    public static final String ATTR5 = "arg5";
    public static final String ATTR6 = "arg6";
    public static final String WC_TIMESTAMP = "working";
    private File myFile;
    private File myTmpFile;
    private Collection myCache;
    private SVNDirectory myDirectory;

    public SVNLog(SVNDirectory directory, int id) {
        String name = id == 0 ? "log" : "log." + id;
        this.myFile = directory.getAdminFile(name);
        this.myTmpFile = directory.getAdminFile("tmp/" + name);
        this.myDirectory = directory;
    }

    public void addCommand(String name, Map attributes, boolean save) throws SVNException {
        if (this.myCache == null) {
            this.myCache = new ArrayList();
        }
        attributes = new HashMap<String, String>(attributes);
        attributes.put("", name);
        this.myCache.add(attributes);
        if (save) {
            this.save();
        }
    }

    public SVNStatusType logChangedEntryProperties(String name, Map modifiedEntryProps) throws SVNException {
        SVNStatusType status = SVNStatusType.LOCK_UNCHANGED;
        if (modifiedEntryProps != null) {
            HashMap<String, String> command = new HashMap<String, String>();
            command.put(NAME_ATTR, name);
            Iterator names = modifiedEntryProps.keySet().iterator();
            while (names.hasNext()) {
                String propName = (String)names.next();
                String propValue = (String)modifiedEntryProps.get(propName);
                String longPropName = "svn:entry:" + propName;
                if ("svn:entry:lock-token".equals(longPropName)) {
                    this.addCommand(DELETE_LOCK, command, false);
                    status = SVNStatusType.LOCK_UNLOCKED;
                    continue;
                }
                if (propValue == null) continue;
                command.put(propName, propValue);
                this.addCommand(MODIFY_ENTRY, command, false);
                command.remove(SVNEncodingUtil.xmlEncodeAttr(propName));
            }
        }
        return status;
    }

    public void logChangedWCProperties(String name, Map modifiedWCProps) throws SVNException {
        if (modifiedWCProps != null) {
            HashMap<String, String> command = new HashMap<String, String>();
            command.put(NAME_ATTR, name);
            Iterator names = modifiedWCProps.keySet().iterator();
            while (names.hasNext()) {
                String propName = (String)names.next();
                String propValue = (String)modifiedWCProps.get(propName);
                command.put(PROPERTY_NAME_ATTR, propName);
                if (propValue != null) {
                    command.put(PROPERTY_VALUE_ATTR, propValue);
                } else {
                    command.remove(PROPERTY_VALUE_ATTR);
                }
                this.addCommand(MODIFY_WC_PROPERTY, command, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws SVNException {
        OutputStreamWriter os = null;
        try {
            os = new OutputStreamWriter(SVNFileUtil.openFileForWriting(this.myTmpFile), "UTF-8");
            Iterator commands = this.myCache.iterator();
            while (commands.hasNext()) {
                Map command = (Map)commands.next();
                String name = (String)command.remove("");
                os.write("<");
                os.write(name);
                Iterator attrs = command.keySet().iterator();
                while (attrs.hasNext()) {
                    String attr = (String)attrs.next();
                    String value = (String)command.get(attr);
                    if (value == null) continue;
                    value = SVNEncodingUtil.xmlEncodeAttr(value);
                    os.write("\n   ");
                    os.write(attr);
                    os.write("=\"");
                    os.write(value);
                    os.write("\"");
                }
                os.write("/>\n");
            }
        }
        catch (IOException e) {
            try {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot write log file ''{0}'': {1}", new Object[]{this.myFile, e.getLocalizedMessage()});
                SVNErrorManager.error(err, e);
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(os);
                this.myCache = null;
                throw throwable;
            }
            SVNFileUtil.closeFile(os);
            this.myCache = null;
        }
        SVNFileUtil.closeFile(os);
        this.myCache = null;
        SVNFileUtil.rename(this.myTmpFile, this.myFile);
        SVNFileUtil.setReadonly(this.myFile, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(SVNLogRunner runner) throws SVNException {
        String name;
        if (!this.myFile.exists()) {
            return;
        }
        BufferedReader reader = null;
        ArrayList commands = new ArrayList();
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(SVNFileUtil.openFileForReading(this.myFile), "UTF-8"));
            HashMap<String, String> attrs = new HashMap<String, String>();
            name = null;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("<")) {
                    name = line.substring(1);
                    continue;
                }
                int index = line.indexOf(61);
                if (index > 0) {
                    String attrName = line.substring(0, index).trim();
                    String value = line.substring(index + 1).trim();
                    if (value.endsWith("/>")) {
                        value = value.substring(0, value.length() - "/>".length());
                    }
                    if (value.startsWith("\"")) {
                        value = value.substring(1);
                    }
                    if (value.endsWith("\"")) {
                        value = value.substring(0, value.length() - 1);
                    }
                    value = SVNEncodingUtil.xmlDecode(value);
                    attrs.put(attrName, value);
                }
                if (!line.endsWith("/>") || name == null) continue;
                attrs.put("", name);
                commands.add(attrs);
                attrs = new HashMap();
                name = null;
            }
        }
        catch (IOException e) {
            try {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot read log file ''{0}'': {1}", new Object[]{this.myFile, e.getLocalizedMessage()});
                SVNErrorManager.error(err, e);
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(reader);
                throw throwable;
            }
            SVNFileUtil.closeFile(reader);
        }
        SVNFileUtil.closeFile(reader);
        try {
            Iterator cmds = commands.iterator();
            while (cmds.hasNext()) {
                Map command = (Map)cmds.next();
                name = (String)command.get("");
                if (runner != null) {
                    runner.runCommand(this.myDirectory, name, command);
                }
                cmds.remove();
            }
        }
        catch (SVNException e) {
            this.myCache = null;
            Iterator cmds = commands.iterator();
            while (cmds.hasNext()) {
                Map command = (Map)cmds.next();
                String name2 = (String)command.remove("");
                this.addCommand(name2, command, false);
            }
            this.save();
            throw e;
        }
    }

    public String toString() {
        return "Log: " + this.myFile;
    }

    public void delete() {
        this.myFile.delete();
        this.myTmpFile.delete();
    }

    public boolean exists() {
        return this.myFile.exists();
    }
}

