/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNEntries;

public class SVNEntry
implements Comparable {
    private SVNEntries myEntries;
    private String myName;
    static /* synthetic */ Class class$org$tmatesoft$svn$core$internal$wc$SVNEntry;

    public SVNEntry(SVNEntries entries, String name) {
        this.myEntries = entries;
        this.myName = name;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != (class$org$tmatesoft$svn$core$internal$wc$SVNEntry == null ? (class$org$tmatesoft$svn$core$internal$wc$SVNEntry = SVNEntry.class$("org.tmatesoft.svn.core.internal.wc.SVNEntry")) : class$org$tmatesoft$svn$core$internal$wc$SVNEntry)) {
            return false;
        }
        SVNEntry entry = (SVNEntry)obj;
        return entry.myEntries == this.myEntries && entry.myName.equals(this.myName);
    }

    public int hashCode() {
        return this.myEntries.hashCode() + 17 * this.myName.hashCode();
    }

    public int compareTo(Object obj) {
        if (obj == null || obj.getClass() != (class$org$tmatesoft$svn$core$internal$wc$SVNEntry == null ? (class$org$tmatesoft$svn$core$internal$wc$SVNEntry = SVNEntry.class$("org.tmatesoft.svn.core.internal.wc.SVNEntry")) : class$org$tmatesoft$svn$core$internal$wc$SVNEntry)) {
            return 1;
        }
        return this.myName.compareTo(((SVNEntry)obj).myName);
    }

    public String getURL() {
        String url = this.myEntries.getPropertyValue(this.myName, "svn:entry:url");
        if (url == null && !"".equals(this.myName)) {
            url = this.myEntries.getPropertyValue("", "svn:entry:url");
            url = SVNPathUtil.append(url, SVNEncodingUtil.uriEncode(this.myName));
        }
        return url;
    }

    public SVNURL getSVNURL() throws SVNException {
        String url = this.getURL();
        if (url != null) {
            return SVNURL.parseURIEncoded(url);
        }
        return null;
    }

    public String getName() {
        return this.myName;
    }

    public boolean isDirectory() {
        return "dir".equals(this.myEntries.getPropertyValue(this.myName, "svn:entry:kind"));
    }

    public long getRevision() {
        String revStr = this.myEntries.getPropertyValue(this.myName, "svn:entry:revision");
        if (revStr == null && !"".equals(this.myName)) {
            revStr = this.myEntries.getPropertyValue("", "svn:entry:revision");
        }
        if (revStr == null) {
            return -1L;
        }
        return Long.parseLong(revStr);
    }

    public boolean isScheduledForAddition() {
        return "add".equals(this.myEntries.getPropertyValue(this.myName, "svn:entry:schedule"));
    }

    public boolean isScheduledForDeletion() {
        return "delete".equals(this.myEntries.getPropertyValue(this.myName, "svn:entry:schedule"));
    }

    public boolean isScheduledForReplacement() {
        return "replace".equals(this.myEntries.getPropertyValue(this.myName, "svn:entry:schedule"));
    }

    public boolean isHidden() {
        return (this.isDeleted() || this.isAbsent()) && !this.isScheduledForAddition() && !this.isScheduledForReplacement();
    }

    public boolean isFile() {
        return "file".equals(this.myEntries.getPropertyValue(this.myName, "svn:entry:kind"));
    }

    public String getLockToken() {
        return this.myEntries.getPropertyValue(this.myName, "svn:entry:lock-token");
    }

    public boolean isDeleted() {
        return Boolean.TRUE.toString().equals(this.myEntries.getPropertyValue(this.myName, "svn:entry:deleted"));
    }

    public boolean isAbsent() {
        return Boolean.TRUE.toString().equals(this.myEntries.getPropertyValue(this.myName, "svn:entry:absent"));
    }

    public String toString() {
        return this.myName;
    }

    public boolean setRevision(long revision) {
        return this.myEntries.setPropertyValue(this.myName, "svn:entry:revision", Long.toString(revision));
    }

    public boolean setURL(String url) {
        return this.myEntries.setPropertyValue(this.myName, "svn:entry:url", url);
    }

    public void setIncomplete(boolean incomplete) {
        this.myEntries.setPropertyValue(this.myName, "svn:entry:incomplete", incomplete ? Boolean.TRUE.toString() : null);
    }

    public boolean isIncomplete() {
        return Boolean.TRUE.toString().equals(this.myEntries.getPropertyValue(this.myName, "svn:entry:incomplete"));
    }

    public String getConflictOld() {
        return this.myEntries.getPropertyValue(this.myName, "svn:entry:conflict-old");
    }

    public void setConflictOld(String name) {
        this.myEntries.setPropertyValue(this.myName, "svn:entry:conflict-old", name);
    }

    public String getConflictNew() {
        return this.myEntries.getPropertyValue(this.myName, "svn:entry:conflict-new");
    }

    public void setConflictNew(String name) {
        this.myEntries.setPropertyValue(this.myName, "svn:entry:conflict-new", name);
    }

    public String getConflictWorking() {
        return this.myEntries.getPropertyValue(this.myName, "svn:entry:conflict-wrk");
    }

    public void setConflictWorking(String name) {
        this.myEntries.setPropertyValue(this.myName, "svn:entry:conflict-wrk", name);
    }

    public String getPropRejectFile() {
        return this.myEntries.getPropertyValue(this.myName, "svn:entry:prop-reject-file");
    }

    public void setPropRejectFile(String name) {
        this.myEntries.setPropertyValue(this.myName, "svn:entry:prop-reject-file", name);
    }

    public String getAuthor() {
        return this.myEntries.getPropertyValue(this.myName, "svn:entry:last-author");
    }

    public String getCommittedDate() {
        return this.myEntries.getPropertyValue(this.myName, "svn:entry:committed-date");
    }

    public long getCommittedRevision() {
        String rev = this.myEntries.getPropertyValue(this.myName, "svn:entry:committed-rev");
        if (rev == null) {
            return -1L;
        }
        return Long.parseLong(rev);
    }

    public void setTextTime(String time) {
        this.myEntries.setPropertyValue(this.myName, "svn:entry:text-time", time);
    }

    public void setKind(SVNNodeKind kind) {
        String kindStr = kind == SVNNodeKind.DIR ? "dir" : (kind == SVNNodeKind.FILE ? "file" : null);
        this.myEntries.setPropertyValue(this.myName, "svn:entry:kind", kindStr);
    }

    public void setAbsent(boolean absent) {
        this.myEntries.setPropertyValue(this.myName, "svn:entry:absent", absent ? Boolean.TRUE.toString() : null);
    }

    public void setDeleted(boolean deleted) {
        this.myEntries.setPropertyValue(this.myName, "svn:entry:deleted", deleted ? Boolean.TRUE.toString() : null);
    }

    public SVNNodeKind getKind() {
        String kind = this.myEntries.getPropertyValue(this.myName, "svn:entry:kind");
        if ("dir".equals(kind)) {
            return SVNNodeKind.DIR;
        }
        if ("file".equals(kind)) {
            return SVNNodeKind.FILE;
        }
        return SVNNodeKind.UNKNOWN;
    }

    public String getTextTime() {
        return this.myEntries.getPropertyValue(this.myName, "svn:entry:text-time");
    }

    public String getChecksum() {
        return this.myEntries.getPropertyValue(this.myName, "svn:entry:checksum");
    }

    public void setLockComment(String comment) {
        this.myEntries.setPropertyValue(this.myName, "svn:entry:lock-comment", comment);
    }

    public void setLockOwner(String owner) {
        this.myEntries.setPropertyValue(this.myName, "svn:entry:lock-owner", owner);
    }

    public void setLockCreationDate(String date) {
        this.myEntries.setPropertyValue(this.myName, "svn:entry:lock-creation-date", date);
    }

    public void setLockToken(String token) {
        this.myEntries.setPropertyValue(this.myName, "svn:entry:lock-token", token);
    }

    public void setUUID(String uuid) {
        this.myEntries.setPropertyValue(this.myName, "svn:entry:uuid", uuid);
    }

    public void unschedule() {
        this.myEntries.setPropertyValue(this.myName, "svn:entry:schedule", null);
    }

    public void scheduleForAddition() {
        this.myEntries.setPropertyValue(this.myName, "svn:entry:schedule", "add");
    }

    public void scheduleForDeletion() {
        this.myEntries.setPropertyValue(this.myName, "svn:entry:schedule", "delete");
    }

    public void scheduleForReplacement() {
        this.myEntries.setPropertyValue(this.myName, "svn:entry:schedule", "replace");
    }

    public void setCopyFromRevision(long revision) {
        this.myEntries.setPropertyValue(this.myName, "svn:entry:copyfrom-rev", revision >= 0L ? Long.toString(revision) : null);
    }

    public boolean setCopyFromURL(String url) {
        return this.myEntries.setPropertyValue(this.myName, "svn:entry:copyfrom-url", url);
    }

    public void setCopied(boolean copied) {
        this.myEntries.setPropertyValue(this.myName, "svn:entry:copied", copied ? Boolean.TRUE.toString() : null);
    }

    public String getCopyFromURL() {
        return this.myEntries.getPropertyValue(this.myName, "svn:entry:copyfrom-url");
    }

    public SVNURL getCopyFromSVNURL() throws SVNException {
        String url = this.getCopyFromURL();
        if (url != null) {
            return SVNURL.parseURIEncoded(url);
        }
        return null;
    }

    public long getCopyFromRevision() {
        String rev = this.myEntries.getPropertyValue(this.myName, "svn:entry:copyfrom-rev");
        if (rev == null) {
            return -1L;
        }
        return Long.parseLong(rev);
    }

    public String getPropTime() {
        return this.myEntries.getPropertyValue(this.myName, "svn:entry:prop-time");
    }

    public void setPropTime(String time) {
        this.myEntries.setPropertyValue(this.myName, "svn:entry:prop-time", time);
    }

    public boolean isCopied() {
        return Boolean.TRUE.toString().equals(this.myEntries.getPropertyValue(this.myName, "svn:entry:copied"));
    }

    public String getUUID() {
        return this.myEntries.getPropertyValue(this.myName, "svn:entry:uuid");
    }

    public String getRepositoryRoot() {
        return this.myEntries.getPropertyValue(this.myName, "svn:entry:repos");
    }

    public SVNURL getRepositoryRootURL() throws SVNException {
        String url = this.getRepositoryRoot();
        if (url != null) {
            return SVNURL.parseURIEncoded(url);
        }
        return null;
    }

    public boolean setRepositoryRoot(String url) {
        return this.myEntries.setPropertyValue(this.myName, "svn:entry:repos", url);
    }

    public boolean setRepositoryRootURL(SVNURL url) {
        return this.setRepositoryRoot(url == null ? null : url.toString());
    }

    public void loadProperties(Map entryProps) {
        if (entryProps == null) {
            return;
        }
        Iterator propNames = entryProps.keySet().iterator();
        while (propNames.hasNext()) {
            String propName = (String)propNames.next();
            this.myEntries.setPropertyValue(this.myName, propName, (String)entryProps.get(propName));
        }
    }

    public String getLockOwner() {
        return this.myEntries.getPropertyValue(this.myName, "svn:entry:lock-owner");
    }

    public String getLockComment() {
        return this.myEntries.getPropertyValue(this.myName, "svn:entry:lock-comment");
    }

    public String getLockCreationDate() {
        return this.myEntries.getPropertyValue(this.myName, "svn:entry:lock-creation-date");
    }

    public String getSchedule() {
        return this.myEntries.getPropertyValue(this.myName, "svn:entry:schedule");
    }

    public Map asMap() {
        return this.myEntries.getEntryMap(this.myName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

