/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNDebugLog;

public class SVNEntries {
    private File myFile;
    private Map myData;
    private Set myEntries;
    private static final Set BOOLEAN_PROPERTIES = new HashSet();

    public SVNEntries(File entriesFile) {
        this.myFile = entriesFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void open() throws SVNException {
        if (this.myData != null) {
            return;
        }
        if (!this.myFile.exists()) {
            return;
        }
        this.myData = new TreeMap<K, V>();
        this.myEntries = new TreeSet<E>();
        reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(SVNFileUtil.openFileForReading(this.myFile), "UTF-8"));
            entry = null;
lbl11:
            // 5 sources

            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).equals("<entry")) {
                    entry = new HashMap<String, String>();
                    continue;
                }
                if (entry == null || line.indexOf(61) <= 0 || line.indexOf(34) <= 0 || line.indexOf(34) == line.lastIndexOf(34)) continue;
                name = line.substring(0, line.indexOf(61));
                value = line.substring(line.indexOf(34) + 1, line.lastIndexOf(34));
                value = SVNEncodingUtil.xmlDecode(value);
                entry.put("svn:entry:" + name, value);
                if (line.charAt(line.length() - 1) != '>') continue;
                entryName = (String)entry.get("svn:entry:name");
                if (entryName != null) ** GOTO lbl-1000
                SVNDebugLog.logInfo("svn: '" + this.myFile + "' file includes invalid entry with missing 'name' attribute");
                this.myData.clear();
                this.myEntries.clear();
                ** GOTO lbl37
            }
            ** GOTO lbl61
        }
        catch (IOException e) {
            try {
                err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot read entries file ''{0}'': {1}", new Object[]{this.myFile, e.getLocalizedMessage()});
                SVNErrorManager.error(err, e);
            }
            catch (Throwable var9_10) {
                SVNFileUtil.closeFile(reader);
                throw var9_10;
            }
lbl37:
            // 1 sources

            SVNFileUtil.closeFile(reader);
            return;
lbl-1000:
            // 1 sources

            {
                this.myData.put(entryName, entry);
                this.myEntries.add(new SVNEntry(this, entryName));
                if (!"".equals(entryName) && (rootEntry = (Map)this.myData.get("")) != null) {
                    if (entry.get("svn:entry:revision") == null) {
                        entry.put("svn:entry:revision", (String)rootEntry.get("svn:entry:revision"));
                    }
                    if (entry.get("svn:entry:url") == null) {
                        url = (String)rootEntry.get("svn:entry:url");
                        if (url != null) {
                            url = SVNPathUtil.append(url, SVNEncodingUtil.uriEncode(entryName));
                        }
                        entry.put("svn:entry:url", url);
                    }
                    if (entry.get("svn:entry:uuid") == null) {
                        entry.put("svn:entry:uuid", (String)rootEntry.get("svn:entry:uuid"));
                    }
                    if (entry.get("svn:entry:repos") == null && rootEntry.get("svn:entry:repos") != null) {
                        entry.put("svn:entry:repos", (String)rootEntry.get("svn:entry:repos"));
                    }
                }
                entry = null;
                ** GOTO lbl11
            }
lbl61:
            // 1 sources

            SVNFileUtil.closeFile(reader);
            return;
            SVNFileUtil.closeFile(reader);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(boolean close) throws SVNException {
        if (this.myData == null) {
            return;
        }
        OutputStreamWriter os = null;
        File tmpFile = new File(this.myFile.getParentFile(), "tmp/entries");
        Map rootEntry = (Map)this.myData.get("");
        try {
            os = new OutputStreamWriter(SVNFileUtil.openFileForWriting(tmpFile), "UTF-8");
            os.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
            os.write("<wc-entries\n");
            os.write("   xmlns=\"svn:\">\n");
            Iterator entries = this.myData.keySet().iterator();
            while (entries.hasNext()) {
                String name = (String)entries.next();
                Map entry = (Map)this.myData.get(name);
                os.write("<entry");
                Iterator names = entry.keySet().iterator();
                while (names.hasNext()) {
                    Object expectedValue;
                    String propName = (String)names.next();
                    String propValue = (String)entry.get(propName);
                    if (propValue == null || BOOLEAN_PROPERTIES.contains(propName) && !Boolean.TRUE.toString().equals(propValue) || !"".equals(name) && ("dir".equals(entry.get("svn:entry:kind")) ? "svn:entry:uuid".equals(propName) || "svn:entry:revision".equals(propName) || "svn:entry:url".equals(propName) || "svn:entry:repos".equals(propName) : propValue.equals(expectedValue = "svn:entry:url".equals(propName) ? SVNPathUtil.append((String)rootEntry.get(propName), SVNEncodingUtil.uriEncode(name)) : ("svn:entry:uuid".equals(propName) || "svn:entry:revision".equals(propName) ? rootEntry.get(propName) : ("svn:entry:repos".equals(propName) ? rootEntry.get(propName) : null))))) continue;
                    propName = propName.substring("svn:entry:".length());
                    propValue = SVNEncodingUtil.xmlEncodeAttr(propValue);
                    os.write("\n   ");
                    os.write(propName);
                    os.write("=\"");
                    os.write(propValue);
                    os.write("\"");
                }
                os.write("/>\n");
            }
            os.write("</wc-entries>\n");
        }
        catch (IOException e) {
            try {
                SVNFileUtil.closeFile(os);
                SVNFileUtil.deleteFile(tmpFile);
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot wrtie entries file ''{0}'': {1}", new Object[]{this.myFile, e.getLocalizedMessage()});
                SVNErrorManager.error(err, e);
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(os);
                throw throwable;
            }
            SVNFileUtil.closeFile(os);
        }
        SVNFileUtil.closeFile(os);
        SVNFileUtil.rename(tmpFile, this.myFile);
        SVNFileUtil.setReadonly(this.myFile, true);
        if (close) {
            this.close();
        }
    }

    public void close() {
        this.myData = null;
        this.myEntries = null;
    }

    public String getPropertyValue(String name, String propertyName) {
        if (this.myData == null) {
            return null;
        }
        Map entry = (Map)this.myData.get(name);
        if (entry != null) {
            return (String)entry.get(propertyName);
        }
        return null;
    }

    public boolean setPropertyValue(String name, String propertyName, String propertyValue) {
        if (this.myData == null) {
            return false;
        }
        Map entry = (Map)this.myData.get(name);
        if (entry != null) {
            if ("svn:entry:schedule".equals(propertyName) && "delete".equals(propertyValue) && "add".equals(entry.get("svn:entry:schedule"))) {
                if (entry.get("svn:entry:deleted") == null) {
                    this.deleteEntry(name);
                } else {
                    entry.remove("svn:entry:schedule");
                }
                return true;
            }
            if (propertyValue == null) {
                return entry.remove(propertyName) != null;
            }
            String oldValue = entry.put(propertyName, propertyValue);
            return !propertyValue.equals(oldValue);
        }
        return false;
    }

    public Iterator entries(boolean hidden) {
        if (this.myEntries == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        LinkedList copy = new LinkedList(this.myEntries);
        if (!hidden) {
            Iterator iterator = copy.iterator();
            while (iterator.hasNext()) {
                SVNEntry entry = (SVNEntry)iterator.next();
                if (!entry.isHidden()) continue;
                iterator.remove();
            }
        }
        return copy.iterator();
    }

    public SVNEntry getEntry(String name, boolean hidden) {
        if (this.myData != null && this.myData.containsKey(name)) {
            SVNEntry entry = new SVNEntry(this, name);
            if (!hidden && entry.isHidden()) {
                return null;
            }
            return entry;
        }
        return null;
    }

    public SVNEntry addEntry(String name) {
        if (this.myData == null) {
            this.myData = new TreeMap();
            this.myEntries = new TreeSet();
        }
        if (this.myData != null) {
            HashMap map = this.myData.containsKey(name) ? (Map)this.myData.get(name) : new HashMap();
            this.myData.put(name, map);
            SVNEntry entry = new SVNEntry(this, name);
            this.myEntries.add(entry);
            this.setPropertyValue(name, "svn:entry:name", name);
            return entry;
        }
        return null;
    }

    public void deleteEntry(String name) {
        if (this.myData != null) {
            this.myData.remove(name);
            this.myEntries.remove(new SVNEntry(this, name));
        }
    }

    Map getEntryMap(String name) {
        if (this.myData != null && name != null) {
            return (Map)this.myData.get(name);
        }
        return null;
    }

    static {
        BOOLEAN_PROPERTIES.add("svn:entry:copied");
        BOOLEAN_PROPERTIES.add("svn:entry:deleted");
        BOOLEAN_PROPERTIES.add("svn:entry:absent");
        BOOLEAN_PROPERTIES.add("svn:entry:incomplete");
    }
}

