/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.ISVNCommitPathHandler;
import org.tmatesoft.svn.core.internal.wc.SVNDirectory;
import org.tmatesoft.svn.core.internal.wc.SVNEntries;
import org.tmatesoft.svn.core.internal.wc.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNProperties;
import org.tmatesoft.svn.core.internal.wc.SVNWCAccess;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.wc.SVNCommitItem;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SVNCommitUtil {
    public static void driveCommitEditor(ISVNCommitPathHandler handler, Collection paths, ISVNEditor editor, long revision) throws SVNException {
        if (paths == null || paths.isEmpty() || handler == null || editor == null) {
            return;
        }
        String[] pathsArray = paths.toArray(new String[paths.size()]);
        Arrays.sort(pathsArray, SVNPathUtil.PATH_COMPARATOR);
        int index = 0;
        String lastPath = null;
        if ("".equals(pathsArray[index])) {
            handler.handleCommitPath("", editor);
            lastPath = pathsArray[index];
            ++index;
        } else {
            editor.openRoot(revision);
        }
        while (index < pathsArray.length) {
            boolean closeDir;
            String relativeCommitPath;
            String commonAncestor;
            String commitPath = pathsArray[index];
            String string = commonAncestor = lastPath == null || "".equals(lastPath) ? "" : SVNPathUtil.getCommonPathAncestor(commitPath, lastPath);
            if (lastPath != null) {
                while (!lastPath.equals(commonAncestor)) {
                    editor.closeDir();
                    if (lastPath.lastIndexOf(47) >= 0) {
                        lastPath = lastPath.substring(0, lastPath.lastIndexOf(47));
                        continue;
                    }
                    lastPath = "";
                }
            }
            if ((relativeCommitPath = commitPath.substring(commonAncestor.length())).startsWith("/")) {
                relativeCommitPath = relativeCommitPath.substring(1);
            }
            StringTokenizer tokens = new StringTokenizer(relativeCommitPath, "/");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                String string2 = commonAncestor = "".equals(commonAncestor) ? token : commonAncestor + "/" + token;
                if (commonAncestor.equals(commitPath)) break;
                editor.openDir(commonAncestor, revision);
            }
            lastPath = (closeDir = handler.handleCommitPath(commitPath, editor)) ? commitPath : SVNPathUtil.removeTail(commitPath);
            ++index;
        }
        while (lastPath != null && !"".equals(lastPath)) {
            editor.closeDir();
            lastPath = lastPath.lastIndexOf(47) >= 0 ? lastPath.substring(0, lastPath.lastIndexOf(47)) : "";
        }
    }

    public static SVNWCAccess createCommitWCAccess(File[] paths, boolean recursive, boolean force, Collection relativePaths, SVNStatusClient statusClient) throws SVNException {
        File wcRoot = null;
        HashMap<File, File> localRootsCache = new HashMap<File, File>();
        for (int i = 0; i < paths.length; ++i) {
            File path = paths[i];
            File rootPath = path;
            if (rootPath.isFile()) {
                rootPath = rootPath.getParentFile();
            }
            File newWCRoot = localRootsCache.containsKey(rootPath) ? (File)localRootsCache.get(rootPath) : SVNWCUtil.getWorkingCopyRoot(rootPath, true);
            localRootsCache.put(rootPath, newWCRoot);
            if (wcRoot != null && !wcRoot.equals(newWCRoot)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Commit targets should belong to the same working copy");
                SVNErrorManager.error(err);
            }
            wcRoot = newWCRoot;
        }
        String[] validatedPaths = new String[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            File file = paths[i];
            validatedPaths[i] = SVNPathUtil.validateFilePath(file.getAbsolutePath());
        }
        String rootPath = SVNPathUtil.condencePaths(validatedPaths, relativePaths, recursive);
        if (rootPath == null) {
            return null;
        }
        File baseDir = new File(rootPath);
        TreeSet<String> dirsToLock = new TreeSet<String>();
        TreeSet<String> dirsToLockRecursively = new TreeSet<String>();
        boolean lockAll = false;
        if (relativePaths.isEmpty()) {
            String target = SVNCommitUtil.getTargetName(baseDir);
            if (!"".equals(target)) {
                SVNFileType targetType = SVNFileType.getType(new File(rootPath));
                relativePaths.add(target);
                if (targetType == SVNFileType.DIRECTORY) {
                    if (recursive || force && SVNCommitUtil.isRecursiveCommitForced(baseDir)) {
                        dirsToLockRecursively.add(target);
                    } else {
                        dirsToLock.add(target);
                    }
                }
                baseDir = baseDir.getParentFile();
            } else {
                lockAll = true;
            }
        } else {
            baseDir = SVNCommitUtil.adjustRelativePaths(baseDir, relativePaths);
            Iterator targets = relativePaths.iterator();
            while (targets.hasNext()) {
                SVNFileType targetType;
                String targetPath = (String)targets.next();
                File targetFile = new File(baseDir, targetPath);
                String target = SVNCommitUtil.getTargetName(targetFile);
                if (!"".equals(target) && (targetType = SVNFileType.getType(targetFile)) == SVNFileType.DIRECTORY) {
                    if (recursive || force && SVNCommitUtil.isRecursiveCommitForced(targetFile)) {
                        dirsToLockRecursively.add(targetPath);
                    } else {
                        dirsToLock.add(targetPath);
                    }
                }
                targetPath = SVNPathUtil.removeTail(targetPath);
                for (targetFile = targetFile.getParentFile(); !(targetFile == null || baseDir.equals(targetFile) || "".equals(targetPath) || dirsToLock.contains(targetPath)); targetFile = targetFile.getParentFile()) {
                    dirsToLock.add(targetPath);
                    targetPath = SVNPathUtil.removeTail(targetPath);
                }
            }
        }
        SVNDirectory anchor = new SVNDirectory(null, "", baseDir);
        SVNWCAccess baseAccess = new SVNWCAccess(anchor, anchor, "");
        if (!recursive && !force) {
            Iterator targets = relativePaths.iterator();
            while (targets.hasNext()) {
                SVNStatus status;
                String targetPath = (String)targets.next();
                File targetFile = new File(baseDir, targetPath);
                if (SVNFileType.getType(targetFile) != SVNFileType.DIRECTORY || (status = statusClient.doStatus(targetFile, false)) == null || status.getContentsStatus() != SVNStatusType.STATUS_DELETED && status.getContentsStatus() != SVNStatusType.STATUS_REPLACED) continue;
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot non-recursively commit a directory deletion");
                SVNErrorManager.error(err);
            }
        }
        try {
            if (lockAll) {
                baseAccess.open(true, recursive);
            } else {
                File pathFile;
                String path;
                baseAccess.open(true, false);
                SVNCommitUtil.removeRedundantPaths(dirsToLockRecursively, dirsToLock);
                Iterator nonRecusivePaths = dirsToLock.iterator();
                while (nonRecusivePaths.hasNext()) {
                    path = (String)nonRecusivePaths.next();
                    pathFile = new File(baseDir, path);
                    baseAccess.addDirectory(path, pathFile, false, true, true);
                }
                Iterator recusivePaths = dirsToLockRecursively.iterator();
                while (recusivePaths.hasNext()) {
                    path = (String)recusivePaths.next();
                    pathFile = new File(baseDir, path);
                    baseAccess.addDirectory(path, pathFile, true, true, true);
                }
            }
            if (!recursive && force) {
                SVNDirectory[] lockedDirs = baseAccess.getAllDirectories();
                for (int i = 0; i < lockedDirs.length; ++i) {
                    SVNDirectory dir = lockedDirs[i];
                    SVNEntry rootEntry = dir.getEntries().getEntry("", true);
                    if (rootEntry.getCopyFromURL() == null) continue;
                    File dirRoot = dir.getRoot();
                    boolean keep = false;
                    for (int j = 0; j < paths.length; ++j) {
                        if (!dirRoot.equals(paths[j])) continue;
                        keep = true;
                        break;
                    }
                    if (keep) continue;
                    baseAccess.removeDirectory(dir.getPath(), true);
                }
            }
        }
        catch (SVNException e) {
            baseAccess.close(true);
            throw e;
        }
        return baseAccess;
    }

    public static SVNWCAccess[] createCommitWCAccess2(File[] paths, boolean recursive, boolean force, Map relativePathsMap, SVNStatusClient statusClient) throws SVNException {
        HashMap rootsMap = new HashMap();
        HashMap<File, File> localRootsCache = new HashMap<File, File>();
        for (int i = 0; i < paths.length; ++i) {
            File path = paths[i];
            File rootPath = path;
            if (rootPath.isFile()) {
                rootPath = rootPath.getParentFile();
            }
            File wcRoot = localRootsCache.containsKey(rootPath) ? (File)localRootsCache.get(rootPath) : SVNWCUtil.getWorkingCopyRoot(rootPath, true);
            localRootsCache.put(path, wcRoot);
            if (!rootsMap.containsKey(wcRoot)) {
                rootsMap.put(wcRoot, new ArrayList());
            }
            Collection wcPaths = (Collection)rootsMap.get(wcRoot);
            wcPaths.add(path);
        }
        ArrayList<SVNWCAccess> result = new ArrayList<SVNWCAccess>();
        try {
            Iterator roots = rootsMap.keySet().iterator();
            while (roots.hasNext()) {
                File root = (File)roots.next();
                Collection filesList = (Collection)rootsMap.get(root);
                File[] filesArray = filesList.toArray(new File[filesList.size()]);
                TreeSet relativePaths = new TreeSet();
                SVNWCAccess wcAccess = SVNCommitUtil.createCommitWCAccess(filesArray, recursive, force, relativePaths, statusClient);
                relativePathsMap.put(wcAccess, relativePaths);
                result.add(wcAccess);
            }
        }
        catch (SVNException e) {
            Iterator wcAccesses = result.iterator();
            while (wcAccesses.hasNext()) {
                SVNWCAccess wcAccess = (SVNWCAccess)wcAccesses.next();
                wcAccess.close(true);
            }
            throw e;
        }
        return result.toArray(new SVNWCAccess[result.size()]);
    }

    public static SVNCommitItem[] harvestCommitables(SVNWCAccess baseAccess, Collection paths, Map lockTokens, boolean justLocked, boolean recursive, boolean force) throws SVNException {
        TreeMap commitables = new TreeMap();
        HashSet<File> danglers = new HashSet<File>();
        Iterator targets = paths.iterator();
        boolean isRecursionForced = false;
        do {
            SVNErrorMessage err;
            String target = targets.hasNext() ? (String)targets.next() : "";
            File targetFile = new File(baseAccess.getAnchor().getRoot(), target);
            String targetName = "".equals(target) ? "" : SVNPathUtil.tail(target);
            String parentPath = SVNPathUtil.removeTail(target);
            SVNDirectory dir = baseAccess.getDirectory(parentPath);
            SVNEntry entry = dir == null ? null : dir.getEntries().getEntry(targetName, false);
            String url = null;
            if (entry == null) {
                SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", targetFile);
                SVNErrorManager.error(err2);
            } else if (entry.getURL() == null) {
                SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", targetFile);
                SVNErrorManager.error(err3);
            } else {
                url = entry.getURL();
            }
            if (entry != null && (entry.isScheduledForAddition() || entry.isScheduledForReplacement())) {
                SVNEntry parentEntry;
                if (!"".equals(targetName)) {
                    parentEntry = dir.getEntries().getEntry("", false);
                } else {
                    File parentFile = targetFile.getParentFile();
                    SVNWCAccess parentAccess = SVNWCAccess.create(parentFile);
                    parentEntry = parentAccess.getTarget().getEntries().getEntry("", false);
                }
                if (parentEntry == null) {
                    err = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "''{0}'' is scheduled for addition within unversioned parent", targetFile);
                    SVNErrorManager.error(err);
                } else if (parentEntry.isScheduledForAddition() || parentEntry.isScheduledForReplacement()) {
                    danglers.add(targetFile.getParentFile());
                }
            }
            boolean recurse = recursive;
            if (entry != null && entry.isCopied() && entry.getSchedule() == null) {
                if (force) continue;
                err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Entry for ''{0}'' is marked as 'copied' but is not itself scheduled\nfor addition.  Perhaps you're committing a target that is\ninside an unversioned (or not-yet-versioned) directory?", targetFile);
                SVNErrorManager.error(err);
            } else if (entry != null && entry.isCopied() && entry.isScheduledForAddition()) {
                if (force) {
                    isRecursionForced = !recursive;
                    recurse = true;
                }
            } else if (entry != null && entry.isScheduledForDeletion() && force && !recursive) {
                SVNEntry parentEntry;
                if (!"".equals(targetName)) {
                    parentEntry = dir.getEntries().getEntry("", false);
                } else {
                    File parentFile = targetFile.getParentFile();
                    SVNWCAccess parentAccess = SVNWCAccess.create(parentFile);
                    parentEntry = parentAccess.getTarget().getEntries().getEntry("", false);
                }
                if (parentEntry != null && parentEntry.isScheduledForDeletion() && paths.contains(parentPath)) continue;
                recurse = true;
            }
            SVNCommitUtil.harvestCommitables(commitables, dir, targetFile, null, entry, url, null, false, false, justLocked, lockTokens, recurse, isRecursionForced);
        } while (targets.hasNext());
        Iterator ds = danglers.iterator();
        while (ds.hasNext()) {
            File file = (File)ds.next();
            if (commitables.containsKey(file)) continue;
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "''{0}'' is not under version control\nand is not part of the commit, \nyet its child is part of the commit", file);
            SVNErrorManager.error(err);
        }
        if (isRecursionForced) {
            Iterator items = commitables.values().iterator();
            while (items.hasNext()) {
                String itemPath;
                SVNCommitItem item = (SVNCommitItem)items.next();
                if (item.isDeleted()) {
                    File file = item.getFile();
                    if (item.getKind() == SVNNodeKind.DIR) {
                        if (!file.exists()) {
                            continue;
                        }
                    } else {
                        String path = SVNPathUtil.removeTail(item.getPath());
                        String name = SVNPathUtil.tail(item.getPath());
                        SVNDirectory dir = baseAccess.getDirectory(path);
                        if (!dir.getBaseFile(name, false).exists()) continue;
                    }
                }
                if (!item.isContentsModified() && !item.isDeleted() && !item.isPropertiesModified() || paths.contains(itemPath = item.getPath())) continue;
                items.remove();
            }
        }
        return commitables.values().toArray(new SVNCommitItem[commitables.values().size()]);
    }

    public static String translateCommitables(SVNCommitItem[] items, Map decodedPaths) throws SVNException {
        String url;
        TreeMap<String, SVNCommitItem> itemsMap = new TreeMap<String, SVNCommitItem>();
        for (int i = 0; i < items.length; ++i) {
            SVNCommitItem item = items[i];
            if (itemsMap.containsKey(item.getURL().toString())) {
                SVNCommitItem oldItem = (SVNCommitItem)itemsMap.get(item.getURL().toString());
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_DUPLICATE_COMMIT_URL, "Cannot commit both ''{0}'' and ''{1}'' as they refer to the same URL", new Object[]{item.getFile(), oldItem.getFile()});
                SVNErrorManager.error(err);
            }
            itemsMap.put(item.getURL().toString(), item);
        }
        Iterator urls = itemsMap.keySet().iterator();
        String baseURL = (String)urls.next();
        while (urls.hasNext()) {
            url = (String)urls.next();
            baseURL = SVNPathUtil.getCommonURLAncestor(baseURL, url);
        }
        if (itemsMap.containsKey(baseURL)) {
            SVNCommitItem root = (SVNCommitItem)itemsMap.get(baseURL);
            if (root.getKind() != SVNNodeKind.DIR) {
                baseURL = SVNPathUtil.removeTail(baseURL);
            } else if (root.getKind() == SVNNodeKind.DIR && (root.isAdded() || root.isDeleted() || root.isCopied() || root.isLocked())) {
                baseURL = SVNPathUtil.removeTail(baseURL);
            }
        }
        urls = itemsMap.keySet().iterator();
        while (urls.hasNext()) {
            url = (String)urls.next();
            SVNCommitItem item = (SVNCommitItem)itemsMap.get(url);
            String realPath = url.equals(baseURL) ? "" : url.substring(baseURL.length() + 1);
            decodedPaths.put(SVNEncodingUtil.uriDecode(realPath), item);
        }
        return baseURL;
    }

    public static Map translateLockTokens(Map lockTokens, String baseURL) {
        TreeMap<String, String> translatedLocks = new TreeMap<String, String>();
        Iterator urls = lockTokens.keySet().iterator();
        while (urls.hasNext()) {
            String url = (String)urls.next();
            String token = (String)lockTokens.get(url);
            url = url.equals(baseURL) ? "" : url.substring(baseURL.length() + 1);
            translatedLocks.put(SVNEncodingUtil.uriDecode(url), token);
        }
        lockTokens.clear();
        lockTokens.putAll(translatedLocks);
        return lockTokens;
    }

    public static void harvestCommitables(Map commitables, SVNDirectory dir, File path, SVNEntry parentEntry, SVNEntry entry, String url, String copyFromURL, boolean copyMode, boolean addsOnly, boolean justLocked, Map lockTokens, boolean recursive, boolean forcedRecursion) throws SVNException {
        boolean commitLock;
        boolean eolChanged;
        Map propDiff;
        SVNProperties baseProps;
        SVNProperties props;
        boolean propConflicts;
        boolean specialFile;
        SVNFileType fileType;
        if (commitables.containsKey(path)) {
            return;
        }
        if (dir != null && dir.getWCAccess() != null) {
            dir.getWCAccess().checkCancelled();
        }
        long cfRevision = entry.getCopyFromRevision();
        String cfURL = null;
        if (entry.getKind() != SVNNodeKind.DIR && entry.getKind() != SVNNodeKind.FILE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.NODE_UNKNOWN_KIND, "Unknown entry kind for ''{0}''", path);
            SVNErrorManager.error(err);
        }
        if ((fileType = SVNFileType.getType(path)) == SVNFileType.UNKNOWN) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.NODE_UNKNOWN_KIND, "Unknown entry kind for ''{0}''", path);
            SVNErrorManager.error(err);
        }
        String specialPropertyValue = dir.getProperties(entry.getName(), false).getPropertyValue("svn:special");
        boolean bl = specialFile = fileType == SVNFileType.SYMLINK;
        if (SVNFileType.isSymlinkSupportEnabled() && (specialPropertyValue == null && specialFile || !SVNFileUtil.isWindows && specialPropertyValue != null && !specialFile) && fileType != SVNFileType.NONE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.NODE_UNEXPECTED_KIND, "Entry ''{0}'' has unexpectedly changed special status", path);
            SVNErrorManager.error(err);
        }
        boolean textConflicts = false;
        SVNEntries entries = null;
        if (entry.getKind() == SVNNodeKind.DIR) {
            SVNDirectory childDir = dir.getChildDirectory(entry.getName());
            if (childDir != null && childDir.getEntries() != null) {
                entries = childDir.getEntries();
                if (entries.getEntry("", false) != null) {
                    entry = entries.getEntry("", false);
                    dir = childDir;
                }
                propConflicts = entry.getPropRejectFile() != null;
            } else {
                propConflicts = entry.getPropRejectFile() != null;
            }
        } else {
            propConflicts = entry.getPropRejectFile() != null;
            boolean bl2 = textConflicts = entry.getConflictOld() != null || entry.getConflictNew() != null || entry.getConflictWorking() != null;
        }
        if (propConflicts || textConflicts) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_FOUND_CONFLICT, "Aborting commit: ''{0}'' remains in conflict", path);
            SVNErrorManager.error(err);
        }
        if (entry.getURL() != null && !copyMode) {
            url = entry.getURL();
        }
        boolean commitDeletion = !addsOnly && (entry.isDeleted() && entry.getSchedule() == null || entry.isScheduledForDeletion() || entry.isScheduledForReplacement());
        boolean commitAddition = false;
        boolean commitCopy = false;
        if (entry.isScheduledForAddition() || entry.isScheduledForReplacement()) {
            commitAddition = true;
            if (entry.getCopyFromURL() != null) {
                cfURL = entry.getCopyFromURL();
                addsOnly = false;
                commitCopy = true;
            } else {
                addsOnly = true;
            }
        }
        if ((entry.isCopied() || copyMode) && !entry.isDeleted() && entry.getSchedule() == null) {
            SVNErrorMessage err;
            long parentRevision = entry.getRevision() - 1L;
            if (!SVNWCUtil.isWorkingCopyRoot(path, true)) {
                if (parentEntry != null) {
                    parentRevision = parentEntry.getRevision();
                }
            } else if (!copyMode) {
                err = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Did not expect ''{0}'' to be a working copy root", path);
                SVNErrorManager.error(err);
            }
            if (parentRevision != entry.getRevision()) {
                commitAddition = true;
                commitCopy = true;
                addsOnly = false;
                cfRevision = entry.getRevision();
                if (copyMode) {
                    cfURL = entry.getURL();
                } else if (copyFromURL != null) {
                    cfURL = copyFromURL;
                } else {
                    err = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "Commit item ''{0}'' has copy flag but no copyfrom URL", path);
                    SVNErrorManager.error(err);
                }
            }
        }
        boolean textModified = false;
        boolean propsModified = false;
        if (commitAddition) {
            props = dir.getProperties(entry.getName(), false);
            baseProps = dir.getBaseProperties(entry.getName(), false);
            propDiff = baseProps.compareTo(props);
            textModified = propDiff != null && propDiff.containsKey("svn:eol-style");
            eolChanged = textModified;
            if (entry.getKind() == SVNNodeKind.FILE) {
                if (commitCopy) {
                    boolean bl3 = textModified = propDiff != null && propDiff.containsKey("svn:eol-style");
                    if (!textModified) {
                        textModified = dir.hasTextModifications(entry.getName(), eolChanged);
                    }
                } else {
                    textModified = true;
                }
            }
            propsModified = propDiff != null && !propDiff.isEmpty();
        } else if (!commitDeletion) {
            props = dir.getProperties(entry.getName(), false);
            baseProps = dir.getBaseProperties(entry.getName(), false);
            propDiff = baseProps.compareTo(props);
            textModified = propDiff != null && propDiff.containsKey("svn:eol-style");
            eolChanged = textModified;
            boolean bl4 = propsModified = propDiff != null && !propDiff.isEmpty();
            if (entry.getKind() == SVNNodeKind.FILE) {
                textModified = dir.hasTextModifications(entry.getName(), eolChanged);
            }
        }
        boolean bl5 = commitLock = entry.getLockToken() != null && (justLocked || textModified || propsModified || commitDeletion || commitAddition || commitCopy);
        if (commitAddition || commitDeletion || textModified || propsModified || commitCopy || commitLock) {
            SVNCommitItem item = new SVNCommitItem(path, SVNURL.parseURIEncoded(url), cfURL != null ? SVNURL.parseURIEncoded(cfURL) : null, entry.getKind(), cfURL != null ? SVNRevision.create(cfRevision) : SVNRevision.create(entry.getRevision()), commitAddition, commitDeletion, propsModified, textModified, commitCopy, commitLock);
            String itemPath = dir.getPath();
            if ("".equals(itemPath)) {
                itemPath = itemPath + entry.getName();
            } else if (!"".equals(entry.getName())) {
                itemPath = itemPath + "/" + entry.getName();
            }
            item.setPath(itemPath);
            commitables.put(path, item);
            if (lockTokens != null && entry.getLockToken() != null) {
                lockTokens.put(url, entry.getLockToken());
            }
        }
        if (entries != null && recursive && (commitAddition || !commitDeletion)) {
            Iterator ents = entries.entries(copyMode);
            while (ents.hasNext()) {
                SVNDirectory childDir;
                String currentCFURL;
                SVNEntry currentEntry = (SVNEntry)ents.next();
                if ("".equals(currentEntry.getName()) || forcedRecursion && currentEntry.isCopied() && currentEntry.getCopyFromURL() != null) continue;
                String string = currentCFURL = cfURL != null ? cfURL : copyFromURL;
                if (currentCFURL != null) {
                    currentCFURL = SVNPathUtil.append(currentCFURL, SVNEncodingUtil.uriEncode(currentEntry.getName()));
                }
                String currentURL = currentEntry.getURL();
                if (copyMode || entry.getURL() == null) {
                    currentURL = SVNPathUtil.append(url, SVNEncodingUtil.uriEncode(currentEntry.getName()));
                }
                File currentFile = dir.getFile(currentEntry.getName());
                if (currentEntry.getKind() == SVNNodeKind.DIR && (childDir = dir.getChildDirectory(currentEntry.getName())) == null) {
                    SVNFileType currentType = SVNFileType.getType(currentFile);
                    if (currentType == SVNFileType.NONE && currentEntry.isScheduledForDeletion()) {
                        SVNCommitItem item = new SVNCommitItem(currentFile, SVNURL.parseURIEncoded(currentURL), null, currentEntry.getKind(), SVNRevision.UNDEFINED, false, true, false, false, false, false);
                        item.setPath(SVNPathUtil.append(dir.getPath(), currentEntry.getName()));
                        commitables.put(currentFile, item);
                        continue;
                    }
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Working copy ''{0}'' is missing or not locked", currentFile);
                    SVNErrorManager.error(err);
                }
                SVNCommitUtil.harvestCommitables(commitables, dir, currentFile, entry, currentEntry, currentURL, currentCFURL, copyMode, addsOnly, justLocked, lockTokens, true, forcedRecursion);
            }
        }
        if (lockTokens != null && entry.getKind() == SVNNodeKind.DIR && commitDeletion) {
            SVNCommitUtil.collectLocks(dir, lockTokens);
        }
    }

    private static void collectLocks(SVNDirectory dir, Map lockTokens) throws SVNException {
        SVNEntries entries = dir.getEntries();
        if (entries == null) {
            return;
        }
        Iterator ents = entries.entries(false);
        while (ents.hasNext()) {
            SVNDirectory child;
            SVNEntry entry = (SVNEntry)ents.next();
            if (entry.getURL() != null && entry.getLockToken() != null) {
                lockTokens.put(entry.getURL(), entry.getLockToken());
            }
            if ("".equals(entry.getName()) || !entry.isDirectory() || (child = dir.getChildDirectory(entry.getName())) == null) continue;
            SVNCommitUtil.collectLocks(child, lockTokens);
        }
        entries.close();
    }

    private static void removeRedundantPaths(Collection dirsToLockRecursively, Collection dirsToLock) {
        Iterator paths = dirsToLock.iterator();
        block0: while (paths.hasNext()) {
            String path = (String)paths.next();
            if (dirsToLockRecursively.contains(path)) {
                paths.remove();
                continue;
            }
            Iterator recPaths = dirsToLockRecursively.iterator();
            while (recPaths.hasNext()) {
                String existingPath = (String)recPaths.next();
                if (!path.startsWith(existingPath + "/")) continue;
                paths.remove();
                continue block0;
            }
        }
    }

    private static File adjustRelativePaths(File rootFile, Collection relativePaths) throws SVNException {
        String targetName;
        if (relativePaths.contains("") && !"".equals(targetName = SVNCommitUtil.getTargetName(rootFile)) && rootFile.getParentFile() != null) {
            rootFile = rootFile.getParentFile();
            TreeSet<String> result = new TreeSet<String>();
            Iterator paths = relativePaths.iterator();
            while (paths.hasNext()) {
                String path = (String)paths.next();
                path = "".equals(path) ? targetName : SVNPathUtil.append(targetName, path);
                result.add(path);
            }
            relativePaths.clear();
            relativePaths.addAll(result);
        }
        return rootFile;
    }

    private static String getTargetName(File file) throws SVNException {
        SVNWCAccess wcAccess = SVNWCAccess.create(file);
        return wcAccess.getTargetName();
    }

    private static boolean isRecursiveCommitForced(File directory) throws SVNException {
        SVNWCAccess wcAccess = SVNWCAccess.create(directory);
        SVNEntry targetEntry = wcAccess.getTargetEntry();
        if (targetEntry != null) {
            return targetEntry.isCopied() || targetEntry.isScheduledForDeletion() || targetEntry.isScheduledForReplacement();
        }
        return false;
    }
}

