/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;

public class SVNEncodingUtil {
    private static final Map XML_UNESCAPE_MAP = new HashMap();
    private static final byte[] uri_char_validity;

    public static String uriEncode(String src) {
        byte[] bytes;
        StringBuffer sb = null;
        try {
            bytes = src.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            bytes = src.getBytes();
        }
        for (int i = 0; i < bytes.length; ++i) {
            int index = bytes[i] & 0xFF;
            if (uri_char_validity[index] > 0) {
                if (sb == null) continue;
                sb.append((char)bytes[i]);
                continue;
            }
            if (sb == null) {
                sb = new StringBuffer();
                sb.append(new String(bytes, 0, i));
            }
            sb.append("%");
            sb.append(Character.toUpperCase(Character.forDigit((index & 0xF0) >> 4, 16)));
            sb.append(Character.toUpperCase(Character.forDigit(index & 0xF, 16)));
        }
        return sb == null ? src : sb.toString();
    }

    public static String autoURIEncode(String src) {
        byte[] bytes;
        StringBuffer sb = null;
        try {
            bytes = src.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            bytes = src.getBytes();
        }
        for (int i = 0; i < bytes.length; ++i) {
            int index = bytes[i] & 0xFF;
            if (uri_char_validity[index] > 0) {
                if (sb == null) continue;
                sb.append((char)bytes[i]);
                continue;
            }
            if (index == 37 && i + 2 < bytes.length && SVNEncodingUtil.isHexDigit((char)bytes[i + 1]) && SVNEncodingUtil.isHexDigit((char)bytes[i + 2])) {
                if (sb == null) continue;
                sb.append((char)bytes[i]);
                continue;
            }
            if (sb == null) {
                sb = new StringBuffer();
                sb.append(new String(bytes, 0, i));
            }
            sb.append("%");
            sb.append(Character.toUpperCase(Character.forDigit((index & 0xF0) >> 4, 16)));
            sb.append(Character.toUpperCase(Character.forDigit(index & 0xF, 16)));
        }
        return sb == null ? src : sb.toString();
    }

    public static void assertURISafe(String path) throws SVNException {
        byte[] bytes;
        path = path == null ? "" : path;
        try {
            bytes = path.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "path ''{0}'' could not be encoded as UTF-8", path);
            SVNErrorManager.error(err);
            return;
        }
        if (bytes == null || bytes.length != path.length()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "path ''{0}'' doesn not look like URI-encoded path", path);
            SVNErrorManager.error(err);
        }
        for (int i = 0; i < bytes.length; ++i) {
            if (uri_char_validity[bytes[i]] > 0 || bytes[i] == 37) continue;
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "path ''{0}'' doesn not look like URI-encoded path; character ''{1}'' is URI unsafe", new Object[]{path, (char)bytes[i] + ""});
            SVNErrorManager.error(err);
        }
    }

    public static String uriDecode(String src) {
        boolean query = false;
        boolean decoded = false;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(src.length());
        for (int i = 0; i < src.length(); ++i) {
            int ch = src.charAt(i);
            if (ch == 63) {
                query = true;
            } else if (ch == 43 && query) {
                ch = 32;
            } else if (ch == 37 && i + 2 < src.length() && SVNEncodingUtil.isHexDigit(src.charAt(i + 1)) && SVNEncodingUtil.isHexDigit(src.charAt(i + 2))) {
                ch = (byte)(SVNEncodingUtil.hexValue(src.charAt(i + 1)) * 16 + SVNEncodingUtil.hexValue(src.charAt(i + 2)));
                decoded = true;
                i += 2;
            }
            bos.write(ch);
        }
        if (!decoded) {
            return src;
        }
        try {
            return new String(bos.toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return src;
        }
    }

    public static String xmlEncodeCDATA(String src) {
        StringBuffer sb = null;
        block6: for (int i = 0; i < src.length(); ++i) {
            char ch = src.charAt(i);
            switch (ch) {
                case '&': {
                    if (sb == null) {
                        sb = SVNEncodingUtil.createStringBuffer(src, i);
                    }
                    sb.append("&amp;");
                    continue block6;
                }
                case '<': {
                    if (sb == null) {
                        sb = SVNEncodingUtil.createStringBuffer(src, i);
                    }
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    if (sb == null) {
                        sb = SVNEncodingUtil.createStringBuffer(src, i);
                    }
                    sb.append("&gt;");
                    continue block6;
                }
                case '\r': {
                    if (sb == null) {
                        sb = SVNEncodingUtil.createStringBuffer(src, i);
                    }
                    sb.append("&#13;");
                    continue block6;
                }
                default: {
                    if (sb == null) continue block6;
                    sb.append(ch);
                }
            }
        }
        return sb != null ? sb.toString() : src;
    }

    public static String xmlEncodeAttr(String src) {
        StringBuffer sb = new StringBuffer(src.length());
        block10: for (int i = 0; i < src.length(); ++i) {
            char ch = src.charAt(i);
            switch (ch) {
                case '&': {
                    if (sb == null) {
                        sb = SVNEncodingUtil.createStringBuffer(src, i);
                    }
                    sb.append("&amp;");
                    continue block10;
                }
                case '<': {
                    if (sb == null) {
                        sb = SVNEncodingUtil.createStringBuffer(src, i);
                    }
                    sb.append("&lt;");
                    continue block10;
                }
                case '>': {
                    if (sb == null) {
                        sb = SVNEncodingUtil.createStringBuffer(src, i);
                    }
                    sb.append("&gt;");
                    continue block10;
                }
                case '\'': {
                    if (sb == null) {
                        sb = SVNEncodingUtil.createStringBuffer(src, i);
                    }
                    sb.append("&apos;");
                    continue block10;
                }
                case '\"': {
                    if (sb == null) {
                        sb = SVNEncodingUtil.createStringBuffer(src, i);
                    }
                    sb.append("&quot;");
                    continue block10;
                }
                case '\r': {
                    if (sb == null) {
                        sb = SVNEncodingUtil.createStringBuffer(src, i);
                    }
                    sb.append("&#13;");
                    continue block10;
                }
                case '\n': {
                    if (sb == null) {
                        sb = SVNEncodingUtil.createStringBuffer(src, i);
                    }
                    sb.append("&#10;");
                    continue block10;
                }
                case '\t': {
                    if (sb == null) {
                        sb = SVNEncodingUtil.createStringBuffer(src, i);
                    }
                    sb.append("&#9;");
                    continue block10;
                }
                default: {
                    if (sb == null) continue block10;
                    sb.append(ch);
                }
            }
        }
        return sb != null ? sb.toString() : src;
    }

    public static boolean isXMLSafe(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (ch >= ' ' || ch == '\n' || ch == '\r' || ch == '\t' || ch == '\b') continue;
            return false;
        }
        return true;
    }

    public static String xmlDecode(String value) {
        StringBuffer result = new StringBuffer(value.length());
        int l = value.length();
        for (int i = 0; i < l; ++i) {
            char ch = value.charAt(i);
            if (ch == '&') {
                String replacement = null;
                for (int j = i + 1; j < i + 6 && j < l; ++j) {
                    if (value.charAt(j) != ';' || j - i <= 1) continue;
                    String escape = value.substring(i, j + 1);
                    replacement = (String)XML_UNESCAPE_MAP.get(escape);
                    if (replacement == null) break;
                    result.append(replacement);
                    i = j;
                    break;
                }
                if (replacement != null) continue;
            }
            result.append(ch);
        }
        return result.toString();
    }

    private static boolean isHexDigit(char ch) {
        return Character.isDigit(ch) || Character.toUpperCase(ch) >= 'A' && Character.toUpperCase(ch) <= 'F';
    }

    private static int hexValue(char ch) {
        if (Character.isDigit(ch)) {
            return ch - 48;
        }
        ch = Character.toUpperCase(ch);
        return ch - 65 + 10;
    }

    private static StringBuffer createStringBuffer(String src, int length) {
        StringBuffer sb = new StringBuffer(src.length());
        sb.append(src.toCharArray(), 0, length);
        return sb;
    }

    static {
        XML_UNESCAPE_MAP.put("&amp;", "&");
        XML_UNESCAPE_MAP.put("&lt;", "<");
        XML_UNESCAPE_MAP.put("&gt;", ">");
        XML_UNESCAPE_MAP.put("&quot;", "\"");
        XML_UNESCAPE_MAP.put("&apos;", "'");
        XML_UNESCAPE_MAP.put("&#13;", "\r");
        XML_UNESCAPE_MAP.put("&#10;", "\n");
        XML_UNESCAPE_MAP.put("&#9;", "\t");
        uri_char_validity = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }
}

