/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tmatesoft.svn.util.SVNDebugLoggerAdapter;

public class DefaultSVNDebugLogger
extends SVNDebugLoggerAdapter {
    private Logger myLogger;

    public void logInfo(String message) {
        this.getLogger().log(Level.FINE, message);
    }

    public void logError(String message) {
        this.getLogger().log(Level.SEVERE, message);
    }

    public void logInfo(Throwable th) {
        if (this.getLogger().isLoggable(Level.FINE)) {
            this.getLogger().log(Level.FINE, th != null ? th.getMessage() : "", th);
        }
    }

    public void logError(Throwable th) {
        if (this.getLogger().isLoggable(Level.SEVERE)) {
            this.getLogger().log(Level.SEVERE, th != null ? th.getMessage() : "", th);
        }
    }

    public void log(String message, byte[] data) {
        if (this.getLogger().isLoggable(Level.FINER)) {
            this.getLogger().log(Level.FINER, message + "\n" + new String(data));
        }
    }

    public InputStream createLogStream(InputStream is) {
        if (this.getLogger().isLoggable(Level.FINEST)) {
            return super.createLogStream(is);
        }
        return is;
    }

    public OutputStream createLogStream(OutputStream os) {
        if (this.getLogger().isLoggable(Level.FINEST)) {
            return super.createLogStream(os);
        }
        return os;
    }

    private Logger getLogger() {
        if (this.myLogger == null) {
            this.myLogger = Logger.getLogger("javasvn");
        }
        return this.myLogger;
    }
}

