/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPBasicAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPDigestAuthentication;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;

abstract class HTTPAuthentication {
    private Map myChallengeParameters;
    private SVNPasswordAuthentication myOriginalCredentials;

    public HTTPAuthentication(SVNPasswordAuthentication credentials) {
        this.myOriginalCredentials = credentials;
    }

    public void setChallengeParameter(String name, String value) {
        Map params = this.getChallengeParameters();
        params.put(name, value);
    }

    public String getChallengeParameter(String name) {
        if (this.myChallengeParameters == null) {
            return null;
        }
        return (String)this.myChallengeParameters.get(name);
    }

    protected Map getChallengeParameters() {
        if (this.myChallengeParameters == null) {
            this.myChallengeParameters = new TreeMap();
        }
        return this.myChallengeParameters;
    }

    public SVNPasswordAuthentication getCredentials() {
        return this.myOriginalCredentials;
    }

    public void setCredentials(SVNPasswordAuthentication originalCredentials) {
        this.myOriginalCredentials = originalCredentials;
    }

    public String getUserName() {
        if (this.myOriginalCredentials != null) {
            return this.myOriginalCredentials.getUserName();
        }
        return null;
    }

    public String getPassword() {
        if (this.myOriginalCredentials != null) {
            return this.myOriginalCredentials.getPassword();
        }
        return null;
    }

    public static HTTPAuthentication parseAuthParameters(Collection authHeaderValues) throws SVNException {
        if (authHeaderValues == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Missing HTTP authorization method");
            SVNErrorManager.error(err);
        }
        HTTPAuthentication auth = null;
        String authHeader = null;
        Iterator authSchemes = authHeaderValues.iterator();
        while (authSchemes.hasNext()) {
            authHeader = (String)authSchemes.next();
            String source = authHeader.trim();
            int index = source.indexOf(32);
            if (index <= 0 && !"NTLM".equalsIgnoreCase(source.substring(0, index = source.length()))) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "HTTP authorization method ''{0}'' is not supported", authHeader);
                SVNErrorManager.error(err);
            }
            String method = source.substring(0, index);
            source = source.substring(index).trim();
            if ("Basic".equalsIgnoreCase(method)) {
                auth = new HTTPBasicAuthentication(null);
                if (source.indexOf("realm=") < 0) break;
                source = source.substring(source.indexOf("realm=") + "realm=".length());
                if ((source = source.trim()).startsWith("\"")) {
                    source = source.substring(1);
                }
                if (source.endsWith("\"")) {
                    source = source.substring(0, source.length() - 1);
                }
                auth.setChallengeParameter("realm", source);
                break;
            }
            if (!"Digest".equalsIgnoreCase(method)) continue;
            auth = new HTTPDigestAuthentication(null);
            char[] chars = source.toCharArray();
            int tokenIndex = 0;
            boolean parsingToken = true;
            String name = null;
            int quotesCount = 0;
            for (int i = 0; i < chars.length; ++i) {
                if (parsingToken) {
                    if (chars[i] != '=') continue;
                    name = new String(chars, tokenIndex, i - tokenIndex);
                    name = name.trim();
                    tokenIndex = i + 1;
                    parsingToken = false;
                    continue;
                }
                if (chars[i] == '\"') {
                    quotesCount = quotesCount > 0 ? 0 : 1;
                    continue;
                }
                if (i + 1 < chars.length && (chars[i] != ',' || quotesCount != 0)) continue;
                String value = new String(chars, tokenIndex, i - tokenIndex);
                if ((value = value.trim()).charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                    value = value.substring(1);
                    value = value.substring(0, value.length() - 1);
                }
                auth.setChallengeParameter(name, value);
                tokenIndex = i + 1;
                parsingToken = true;
            }
            HTTPDigestAuthentication digestAuth = (HTTPDigestAuthentication)auth;
            digestAuth.init();
            break;
        }
        if (auth == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "HTTP authorization method ''{0}'' is not supported", authHeader);
            SVNErrorManager.error(err);
        }
        return auth;
    }

    public abstract String authenticate() throws SVNException;
}

