/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVHandler;
import org.tmatesoft.svn.core.internal.util.SVNTimeUtil;
import org.xml.sax.Attributes;

public class DAVLogHandler
extends BasicDAVHandler {
    private static final DAVElement LOG_ITEM = DAVElement.getElement("svn:", "log-item");
    private static final DAVElement ADDED_PATH = DAVElement.getElement("svn:", "added-path");
    private static final DAVElement DELETED_PATH = DAVElement.getElement("svn:", "deleted-path");
    private static final DAVElement MODIFIED_PATH = DAVElement.getElement("svn:", "modified-path");
    private static final DAVElement REPLACED_PATH = DAVElement.getElement("svn:", "replaced-path");
    private ISVNLogEntryHandler myLogEntryHandler;
    private long myRevision;
    private Map myPaths;
    private String myAuthor;
    private Date myDate;
    private String myComment;
    private SVNLogEntryPathEx myPath;
    private int myCount;
    private long myLimit;
    private boolean myIsCompatibleMode;

    public static StringBuffer generateLogRequest(StringBuffer buffer, long startRevision, long endRevision, boolean includeChangedPaths, boolean strictNodes, long limit, String[] paths) {
        buffer = buffer == null ? new StringBuffer() : buffer;
        buffer.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        buffer.append("<S:log-report xmlns:S=\"svn:\">");
        if (startRevision >= 0L) {
            buffer.append("<S:start-revision>" + startRevision + "</S:start-revision>");
        }
        if (endRevision >= 0L) {
            buffer.append("<S:end-revision>" + endRevision + "</S:end-revision>");
        }
        if (limit > 0L) {
            buffer.append("<S:limit>" + limit + "</S:limit>");
        }
        if (includeChangedPaths) {
            buffer.append("<S:discover-changed-paths />");
        }
        if (strictNodes) {
            buffer.append("<S:strict-node-history />");
        }
        for (int i = 0; i < paths.length; ++i) {
            buffer.append("<S:path>" + paths[i] + "</S:path>");
        }
        buffer.append("</S:log-report>");
        return buffer;
    }

    public DAVLogHandler(ISVNLogEntryHandler handler, long limit) {
        this.myLogEntryHandler = handler;
        this.myRevision = -1L;
        this.myCount = 0;
        this.myLimit = limit;
        this.init();
    }

    public boolean isCompatibleMode() {
        return this.myIsCompatibleMode;
    }

    protected void startElement(DAVElement parent, DAVElement element, Attributes attrs) {
        char type = '\u0000';
        String copyPath = null;
        long copyRevision = -1L;
        if (element == ADDED_PATH || element == REPLACED_PATH) {
            type = element == ADDED_PATH ? (char)'A' : 'R';
            copyPath = attrs.getValue("copyfrom-path");
            String copyRevisionStr = attrs.getValue("copyfrom-rev");
            if (copyPath != null && copyRevisionStr != null) {
                try {
                    copyRevision = Long.parseLong(copyRevisionStr);
                }
                catch (NumberFormatException e) {}
            }
        } else if (element == MODIFIED_PATH) {
            type = 'M';
        } else if (element == DELETED_PATH) {
            type = 'D';
        }
        if (type != '\u0000') {
            this.myPath = new SVNLogEntryPathEx(type, copyPath, copyRevision);
        }
    }

    protected void endElement(DAVElement parent, DAVElement element, StringBuffer cdata) throws SVNException {
        if (element == LOG_ITEM) {
            ++this.myCount;
            if (this.myLimit <= 0L || (long)this.myCount <= this.myLimit) {
                if (this.myLogEntryHandler != null) {
                    if (this.myPaths == null) {
                        this.myPaths = new HashMap();
                    }
                    SVNLogEntry logEntry = new SVNLogEntry(this.myPaths, this.myRevision, this.myAuthor, this.myDate, this.myComment);
                    this.myLogEntryHandler.handleLogEntry(logEntry);
                }
            } else if (this.myLimit < (long)this.myCount) {
                this.myIsCompatibleMode = true;
            }
            this.myPaths = null;
            this.myRevision = -1L;
            this.myAuthor = null;
            this.myDate = null;
            this.myComment = null;
        } else if (element == DAVElement.VERSION_NAME && cdata != null) {
            this.myRevision = Long.parseLong(cdata.toString());
        } else if (element == DAVElement.CREATOR_DISPLAY_NAME && cdata != null) {
            this.myAuthor = cdata.toString();
        } else if (element == DAVElement.COMMENT && cdata != null) {
            this.myComment = cdata.toString();
        } else if (element == DAVElement.DATE && cdata != null) {
            this.myDate = SVNTimeUtil.parseDate(cdata.toString());
        } else if (element == ADDED_PATH || element == MODIFIED_PATH || element == REPLACED_PATH || element == DELETED_PATH) {
            if (this.myPath != null && cdata != null) {
                if (this.myPaths == null) {
                    this.myPaths = new HashMap();
                }
                this.myPath.setPathValue(cdata.toString());
                String path = this.myPath.getPath();
                this.myPath.setPathValue(path);
                this.myPaths.put(this.myPath.getPath(), this.myPath);
            }
            this.myPath = null;
        }
    }

    public int getEntriesCount() {
        return this.myCount;
    }

    private static class SVNLogEntryPathEx
    extends SVNLogEntryPath {
        public SVNLogEntryPathEx(char type, String copyPath, long copyRevision) {
            super(null, type, copyPath, copyRevision);
        }

        public void setPathValue(String path) {
            super.setPath(path);
        }
    }
}

