/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVDeltaHandler;
import org.tmatesoft.svn.core.internal.util.SVNBase64;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNFileRevisionHandler;
import org.tmatesoft.svn.core.io.SVNFileRevision;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.xml.sax.Attributes;

public class DAVFileRevisionHandler
extends BasicDAVDeltaHandler {
    private static final DAVElement REVISION_PROPERTY = DAVElement.getElement("svn:", "rev-prop");
    private static final DAVElement FILE_REVISION = DAVElement.getElement("svn:", "file-rev");
    private static final DAVElement SET_PROPERTY = DAVElement.getElement("svn:", "set-prop");
    private static final DAVElement DELETE_PROPERTY = DAVElement.getElement("svn:", "remove-prop");
    private ISVNFileRevisionHandler myFileRevisionsHandler;
    private String myPath;
    private long myRevision;
    private Map myProperties;
    private Map myPropertiesDelta;
    private String myPropertyName;
    private String myPropertyEncoding;
    private int myCount;
    private SVNEditorWrapper myEditor;

    public static StringBuffer generateFileRevisionsRequest(StringBuffer buffer, long startRevision, long endRevision, String path) {
        buffer = buffer == null ? new StringBuffer() : buffer;
        buffer.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        buffer.append("<S:file-revs-report xmlns:S=\"svn:\">");
        if (startRevision >= 0L) {
            buffer.append("<S:start-revision>" + startRevision + "</S:start-revision>");
        }
        if (endRevision >= 0L) {
            buffer.append("<S:end-revision>" + endRevision + "</S:end-revision>");
        }
        buffer.append("<S:path>" + SVNEncodingUtil.xmlEncodeCDATA(path) + "</S:path>");
        buffer.append("</S:file-revs-report>");
        return buffer;
    }

    public DAVFileRevisionHandler(ISVNFileRevisionHandler handler) {
        this.myFileRevisionsHandler = handler;
        this.myCount = 0;
        this.myEditor = new SVNEditorWrapper(handler);
        this.init();
    }

    protected void startElement(DAVElement parent, DAVElement element, Attributes attrs) throws SVNException {
        if (element == FILE_REVISION) {
            this.myPath = attrs.getValue("path");
            this.myRevision = Long.parseLong(attrs.getValue("rev"));
        } else if (element == REVISION_PROPERTY || element == SET_PROPERTY || element == DELETE_PROPERTY) {
            this.myPropertyName = attrs.getValue("name");
            this.myPropertyEncoding = attrs.getValue("encoding");
        }
        if (element == TX_DELTA) {
            if (this.myPath != null && this.myFileRevisionsHandler != null) {
                if (this.myProperties == null) {
                    this.myProperties = Collections.EMPTY_MAP;
                }
                if (this.myPropertiesDelta == null) {
                    this.myPropertiesDelta = Collections.EMPTY_MAP;
                }
                SVNFileRevision revision = new SVNFileRevision(this.myPath, this.myRevision, this.myProperties, this.myPropertiesDelta);
                this.myFileRevisionsHandler.openRevision(revision);
                this.myProperties = null;
                this.myPropertiesDelta = null;
                this.myPath = null;
                this.myFileRevisionsHandler.applyTextDelta(this.myPath);
            }
            this.setDeltaProcessing(true);
        }
    }

    protected void endElement(DAVElement parent, DAVElement element, StringBuffer cdata) throws SVNException {
        if (element == FILE_REVISION) {
            if (this.myPath != null && this.myFileRevisionsHandler != null) {
                if (this.myProperties == null) {
                    this.myProperties = Collections.EMPTY_MAP;
                }
                if (this.myPropertiesDelta == null) {
                    this.myPropertiesDelta = Collections.EMPTY_MAP;
                }
                SVNFileRevision revision = new SVNFileRevision(this.myPath, this.myRevision, this.myProperties, this.myPropertiesDelta);
                this.myFileRevisionsHandler.openRevision(revision);
            }
            if (this.myFileRevisionsHandler != null) {
                this.myFileRevisionsHandler.closeRevision(this.myPath);
            }
            this.myPath = null;
            this.myProperties = null;
            this.myPropertiesDelta = null;
            this.myPropertyEncoding = null;
            this.myPropertyName = null;
        } else if (element == TX_DELTA) {
            this.setDeltaProcessing(false);
            ++this.myCount;
        } else if (element == REVISION_PROPERTY) {
            if (this.myProperties == null) {
                this.myProperties = new HashMap();
            }
            this.myProperties.put(this.myPropertyName, cdata != null ? cdata.toString() : "");
            this.myPropertyName = null;
        } else if (element == SET_PROPERTY) {
            if (this.myPropertiesDelta == null) {
                this.myPropertiesDelta = new HashMap();
            }
            if (this.myPropertyName != null) {
                String value;
                if ("base64".equals(this.myPropertyEncoding)) {
                    byte[] bytes = SVNBase64.base64ToByteArray(new StringBuffer(cdata.toString().trim()), null);
                    value = new String(bytes);
                } else {
                    value = cdata.toString();
                }
                this.myPropertiesDelta.put(this.myPropertyName, value);
            }
            this.myPropertyName = null;
            this.myPropertyEncoding = null;
        } else if (element == DELETE_PROPERTY) {
            if (this.myPropertiesDelta == null) {
                this.myPropertiesDelta = new HashMap();
            }
            if (this.myPropertyName != null) {
                this.myPropertiesDelta.put(this.myPropertyName, null);
            }
            this.myPropertyEncoding = null;
            this.myPropertyName = null;
        }
    }

    public int getEntriesCount() {
        return this.myCount;
    }

    protected ISVNEditor getEditor() {
        return this.myEditor;
    }

    protected String getCurrentPath() {
        return this.myPath;
    }

    private static class SVNEditorWrapper
    implements ISVNEditor {
        private ISVNFileRevisionHandler myHandler;

        public SVNEditorWrapper(ISVNFileRevisionHandler handler) {
            this.myHandler = handler;
        }

        public void targetRevision(long revision) throws SVNException {
        }

        public void openRoot(long revision) throws SVNException {
        }

        public void deleteEntry(String path, long revision) throws SVNException {
        }

        public void absentDir(String path) throws SVNException {
        }

        public void absentFile(String path) throws SVNException {
        }

        public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        }

        public void openDir(String path, long revision) throws SVNException {
        }

        public void changeDirProperty(String name, String value) throws SVNException {
        }

        public void closeDir() throws SVNException {
        }

        public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        }

        public void openFile(String path, long revision) throws SVNException {
        }

        public void applyTextDelta(String path, String baseChecksum) throws SVNException {
            if (this.myHandler != null) {
                this.myHandler.applyTextDelta(path);
            }
        }

        public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
            return this.myHandler != null ? this.myHandler.textDeltaChunk(path, diffWindow) : null;
        }

        public void textDeltaEnd(String path) throws SVNException {
            if (this.myHandler != null) {
                this.myHandler.textDeltaEnd(path);
            }
        }

        public void changeFileProperty(String path, String name, String value) throws SVNException {
        }

        public void closeFile(String path, String textChecksum) throws SVNException {
        }

        public SVNCommitInfo closeEdit() throws SVNException {
            return null;
        }

        public void abortEdit() throws SVNException {
        }
    }
}

