/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import java.io.ByteArrayInputStream;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVHandler;
import org.tmatesoft.svn.core.internal.util.SVNBase64;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindowBuilder;
import org.xml.sax.SAXException;

public abstract class BasicDAVDeltaHandler
extends BasicDAVHandler {
    protected static final DAVElement TX_DELTA = DAVElement.getElement("svn:", "txdelta");
    private boolean myIsDeltaProcessing;
    private SVNDiffWindowBuilder myDiffBuilder;
    private StringBuffer myDeltaOutputStream;
    private SequenceIntputStream myPreviousStream;
    private int eolCount;

    protected void setDeltaProcessing(boolean processing) throws SVNException {
        this.myIsDeltaProcessing = processing;
        this.myPreviousStream = null;
        if (!this.myIsDeltaProcessing) {
            this.getEditor().textDeltaEnd(this.getCurrentPath());
        } else {
            this.myDiffBuilder.reset();
            this.myDeltaOutputStream.delete(0, this.myDeltaOutputStream.length());
            this.myPreviousStream = null;
        }
    }

    protected void init() {
        this.myDiffBuilder = SVNDiffWindowBuilder.newInstance();
        this.myDeltaOutputStream = new StringBuffer();
        super.init();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.myIsDeltaProcessing) {
            int index;
            int stored;
            int offset = start;
            for (int i = start; i < start + length; ++i) {
                if (ch[i] != '\r' && ch[i] != '\n') continue;
                ++this.eolCount;
                this.myDeltaOutputStream.append(ch, offset, i - offset);
                offset = i + 1;
                if (i + 1 >= start + length || ch[i + 1] != '\n') continue;
                ++offset;
                ++i;
            }
            if (offset < start + length) {
                this.myDeltaOutputStream.append(ch, offset, start + length - offset);
            }
            if ((stored = this.myDeltaOutputStream.length()) < 4) {
                return;
            }
            int segmentsCount = stored / 4;
            int remains = stored - segmentsCount * 4;
            StringBuffer toDecode = new StringBuffer();
            toDecode.append(this.myDeltaOutputStream);
            toDecode.delete(this.myDeltaOutputStream.length() - remains, this.myDeltaOutputStream.length());
            for (index = 0; index < toDecode.length() && Character.isWhitespace(toDecode.charAt(index)); ++index) {
            }
            if (index > 0) {
                toDecode = toDecode.delete(0, index);
            }
            for (index = toDecode.length() - 1; index >= 0 && Character.isWhitespace(toDecode.charAt(index)); --index) {
                toDecode.delete(index, toDecode.length());
            }
            byte[] decoded = SVNBase64.base64ToByteArray(toDecode, null);
            this.myPreviousStream = new SequenceIntputStream(decoded, this.myPreviousStream);
            try {
                boolean needsMore;
                while ((needsMore = this.myDiffBuilder.accept(this.myPreviousStream, this.getEditor(), this.getCurrentPath())) && this.myPreviousStream.available() > 0) {
                }
            }
            catch (SVNException e) {
                throw new SAXException(e);
            }
            this.myDeltaOutputStream.delete(0, toDecode.length());
        } else {
            super.characters(ch, start, length);
        }
    }

    protected abstract String getCurrentPath();

    protected abstract ISVNEditor getEditor();

    private static class SequenceIntputStream
    extends ByteArrayInputStream {
        SequenceIntputStream(byte[] bytes, SequenceIntputStream previous) {
            super(bytes);
            if (previous != null && previous.available() > 0) {
                byte[] realBytes = new byte[bytes.length + previous.available()];
                System.arraycopy(previous.buf, previous.pos, realBytes, 0, previous.available());
                System.arraycopy(bytes, 0, realBytes, previous.available(), bytes.length);
                this.buf = realBytes;
                this.count = this.buf.length;
                this.pos = 0;
            }
        }
    }
}

