/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.dav.DAVBaselineInfo;
import org.tmatesoft.svn.core.internal.io.dav.DAVConnection;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepository;
import org.tmatesoft.svn.core.internal.io.dav.DAVResource;
import org.tmatesoft.svn.core.internal.io.dav.DAVUtil;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVMergeHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVProppatchHandler;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPStatus;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNWorkspaceMediator;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindowBuilder;

class DAVCommitEditor
implements ISVNEditor {
    private String myLogMessage;
    private DAVConnection myConnection;
    private SVNURL myLocation;
    private DAVRepository myRepository;
    private Runnable myCloseCallback;
    private String myActivity;
    private Stack myDirsStack;
    private ISVNWorkspaceMediator myCommitMediator;
    private Map myPathsMap;
    private Map myFilesMap;
    private OutputStream myCurrentDelta = null;
    private OutputStream myRealDeltaStream = null;
    private boolean myIsAborted;

    public DAVCommitEditor(DAVRepository repository, DAVConnection connection, String message, ISVNWorkspaceMediator mediator, Runnable closeCallback) {
        this.myConnection = connection;
        this.myLogMessage = message;
        this.myLocation = repository.getLocation();
        this.myRepository = repository;
        this.myCloseCallback = closeCallback;
        this.myCommitMediator = mediator;
        this.myDirsStack = new Stack();
        this.myPathsMap = new HashMap();
        this.myFilesMap = new HashMap();
    }

    public void targetRevision(long revision) throws SVNException {
    }

    public void absentDir(String path) throws SVNException {
    }

    public void absentFile(String path) throws SVNException {
    }

    public void openRoot(long revision) throws SVNException {
        this.myActivity = this.createActivity(this.myLogMessage);
        DAVResource root = new DAVResource(this.myCommitMediator, this.myConnection, "", revision);
        root.fetchVersionURL(false);
        this.myDirsStack.push(root);
        this.myPathsMap.put(root.getURL(), root.getPath());
    }

    public void deleteEntry(String path, long revision) throws SVNException {
        String url;
        path = SVNEncodingUtil.uriEncode(path);
        DAVResource parentResource = (DAVResource)this.myDirsStack.peek();
        this.checkoutResource(parentResource, true);
        String wPath = parentResource.getWorkingURL();
        if (this.myDirsStack.size() == 1) {
            wPath = SVNPathUtil.append(parentResource.getWorkingURL(), path);
            url = SVNPathUtil.append(parentResource.getURL(), path);
        } else {
            wPath = SVNPathUtil.append(wPath, SVNPathUtil.tail(path));
            url = SVNPathUtil.append(parentResource.getURL(), SVNPathUtil.tail(path));
        }
        this.myConnection.doDelete(url, wPath, revision);
        if (this.myDirsStack.size() == 1) {
            this.myPathsMap.put(SVNPathUtil.append(parentResource.getURL(), path), path);
        } else {
            this.myPathsMap.put(SVNPathUtil.append(parentResource.getURL(), SVNPathUtil.tail(path)), path);
        }
    }

    public void addDir(String path, String copyPath, long copyRevision) throws SVNException {
        path = SVNEncodingUtil.uriEncode(path);
        DAVResource parentResource = (DAVResource)this.myDirsStack.peek();
        this.checkoutResource(parentResource, true);
        String wPath = parentResource.getWorkingURL();
        DAVResource newDir = new DAVResource(this.myCommitMediator, this.myConnection, path, -1L, copyPath != null);
        newDir.setWorkingURL(SVNPathUtil.append(wPath, SVNPathUtil.tail(path)));
        this.myDirsStack.push(newDir);
        this.myPathsMap.put(newDir.getURL(), path);
        if (copyPath != null) {
            copyPath = this.myRepository.getFullPath(copyPath);
            copyPath = SVNEncodingUtil.uriEncode(copyPath);
            DAVBaselineInfo info = DAVUtil.getBaselineInfo(this.myConnection, this.myRepository, copyPath, copyRevision, false, false, null);
            copyPath = SVNPathUtil.append(info.baselineBase, info.baselinePath);
            wPath = this.myLocation.setPath(newDir.getWorkingURL(), true).toString();
            this.myConnection.doCopy(copyPath, wPath, 1);
        } else {
            try {
                this.myConnection.doMakeCollection(newDir.getWorkingURL());
            }
            catch (SVNException e) {
                if (!e.getErrorMessage().getErrorCode().isAuthentication() && e.getErrorMessage().getErrorCode() != SVNErrorCode.CANCELLED) {
                    SVNErrorMessage err = null;
                    try {
                        DAVBaselineInfo info = DAVUtil.getBaselineInfo(this.myConnection, this.myRepository, newDir.getURL(), -1L, false, false, null);
                        if (info != null) {
                            err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_ALREADY_EXISTS, "Path ''{0}'' already exists", newDir.getURL());
                        }
                    }
                    catch (SVNException inner) {
                        // empty catch block
                    }
                    if (err != null) {
                        SVNErrorManager.error(err);
                    }
                }
                throw e;
            }
        }
    }

    public void openDir(String path, long revision) throws SVNException {
        path = SVNEncodingUtil.uriEncode(path);
        DAVResource parent = this.myDirsStack.peek() != null ? (DAVResource)this.myDirsStack.peek() : null;
        DAVResource directory = new DAVResource(this.myCommitMediator, this.myConnection, path, revision, parent == null ? false : parent.isCopy());
        if (parent != null && parent.isCopy()) {
            directory.setWorkingURL(SVNPathUtil.append(parent.getWorkingURL(), SVNPathUtil.tail(path)));
        } else {
            directory.fetchVersionURL(false);
        }
        this.myDirsStack.push(directory);
        this.myPathsMap.put(directory.getURL(), directory.getPath());
    }

    public void changeDirProperty(String name, String value) throws SVNException {
        DAVResource directory = (DAVResource)this.myDirsStack.peek();
        this.checkoutResource(directory, true);
        directory.putProperty(name, value);
        this.myPathsMap.put(directory.getURL(), directory.getPath());
    }

    public void closeDir() throws SVNException {
        DAVResource resource = (DAVResource)this.myDirsStack.pop();
        if (resource.getProperties() != null) {
            StringBuffer request = DAVProppatchHandler.generatePropertyRequest(null, resource.getProperties());
            this.myConnection.doProppatch(resource.getURL(), resource.getWorkingURL(), request, null, null);
        }
        resource.dispose();
    }

    public void addFile(String path, String copyPath, long copyRevision) throws SVNException {
        String originalPath = path;
        path = SVNEncodingUtil.uriEncode(path);
        DAVResource parentResource = (DAVResource)this.myDirsStack.peek();
        if (parentResource.getWorkingURL() == null) {
            String filePath = SVNPathUtil.append(parentResource.getURL(), SVNPathUtil.tail(path));
            SVNErrorMessage err = null;
            try {
                DAVUtil.getResourceProperties(this.myConnection, filePath, null, DAVElement.STARTING_PROPERTIES);
            }
            catch (SVNException e) {
                if (e.getErrorMessage() == null) {
                    throw e;
                }
                err = e.getErrorMessage();
            }
            if (err == null) {
                err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_ALREADY_EXISTS, "File ''{0}'' already exists", filePath);
                SVNErrorManager.error(err);
            } else if (err.getErrorCode() != SVNErrorCode.RA_DAV_PATH_NOT_FOUND) {
                SVNErrorManager.error(err);
            }
        }
        this.checkoutResource(parentResource, true);
        String wPath = parentResource.getWorkingURL();
        DAVResource newFile = new DAVResource(this.myCommitMediator, this.myConnection, path, -1L, copyPath != null);
        newFile.setWorkingURL(SVNPathUtil.append(wPath, SVNPathUtil.tail(path)));
        this.myPathsMap.put(newFile.getURL(), newFile.getPath());
        this.myFilesMap.put(originalPath, newFile);
        if (copyPath != null) {
            copyPath = this.myRepository.getFullPath(copyPath);
            copyPath = SVNEncodingUtil.uriEncode(copyPath);
            DAVBaselineInfo info = DAVUtil.getBaselineInfo(this.myConnection, this.myRepository, copyPath, copyRevision, false, false, null);
            copyPath = SVNPathUtil.append(info.baselineBase, info.baselinePath);
            wPath = this.myLocation.setPath(newFile.getWorkingURL(), true).toString();
            this.myConnection.doCopy(copyPath, wPath, 0);
            newFile.setAdded(false);
        } else {
            newFile.setAdded(true);
        }
    }

    public void openFile(String path, long revision) throws SVNException {
        String originalPath = path;
        path = SVNEncodingUtil.uriEncode(path);
        DAVResource file = new DAVResource(this.myCommitMediator, this.myConnection, path, revision);
        DAVResource parent = (DAVResource)this.myDirsStack.peek();
        if (parent.isCopy()) {
            file.setWorkingURL(SVNPathUtil.append(parent.getWorkingURL(), SVNPathUtil.tail(path)));
        } else {
            file.fetchVersionURL(false);
        }
        this.checkoutResource(file, true);
        this.myPathsMap.put(file.getURL(), file.getPath());
        this.myFilesMap.put(originalPath, file);
    }

    public void applyTextDelta(String path, String baseChecksum) throws SVNException {
        this.myCurrentDelta = null;
        this.myRealDeltaStream = null;
    }

    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
        DAVResource currentFile = (DAVResource)this.myFilesMap.get(path);
        try {
            boolean firstWindow = this.myCurrentDelta == null;
            OutputStream outputStream = this.myCurrentDelta = this.myCurrentDelta == null ? currentFile.addTextDelta() : this.myCurrentDelta;
            if (firstWindow) {
                this.myRealDeltaStream = this.myCurrentDelta;
                this.myCurrentDelta = new FilterOutputStream(this.myCurrentDelta){

                    public void close() throws IOException {
                    }

                    public void write(byte[] b, int off, int len) throws IOException {
                        this.out.write(b, off, len);
                    }
                };
            }
            SVNDiffWindowBuilder.save(diffWindow, firstWindow, this.myCurrentDelta);
            return this.myCurrentDelta;
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getMessage());
            SVNErrorManager.error(err, e);
            return null;
        }
    }

    public void textDeltaEnd(String path) throws SVNException {
        SVNFileUtil.closeFile(this.myRealDeltaStream);
    }

    public void changeFileProperty(String path, String name, String value) throws SVNException {
        DAVResource currentFile = (DAVResource)this.myFilesMap.get(path);
        currentFile.putProperty(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeFile(String path, String textChecksum) throws SVNException {
        DAVResource currentFile = (DAVResource)this.myFilesMap.get(path);
        try {
            if (currentFile.isAdded() && currentFile.getDeltaCount() == 0) {
                OutputStream os = this.textDeltaChunk(path, SVNDiffWindowBuilder.createReplacementDiffWindow(0L));
                try {
                    os.close();
                }
                catch (IOException e) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getMessage());
                    SVNErrorManager.error(err, e);
                }
            } else if (currentFile.getDeltaCount() > 0) {
                InputStream combinedData = null;
                try {
                    combinedData = currentFile.getTextDelta(0);
                    this.myConnection.doPutDiff(currentFile.getURL(), currentFile.getWorkingURL(), combinedData);
                }
                finally {
                    SVNFileUtil.closeFile(combinedData);
                }
            }
            if (currentFile.getProperties() != null) {
                StringBuffer request = DAVProppatchHandler.generatePropertyRequest(null, currentFile.getProperties());
                this.myConnection.doProppatch(currentFile.getURL(), currentFile.getWorkingURL(), request, null, null);
            }
            Object var9_8 = null;
            currentFile.dispose();
            this.myCurrentDelta = null;
            this.myRealDeltaStream = null;
            this.myFilesMap.remove(path);
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            currentFile.dispose();
            this.myCurrentDelta = null;
            this.myRealDeltaStream = null;
            this.myFilesMap.remove(path);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNCommitInfo closeEdit() throws SVNException {
        try {
            DAVMergeHandler handler;
            HTTPStatus status;
            if (!this.myDirsStack.isEmpty()) {
                DAVResource resource = (DAVResource)this.myDirsStack.pop();
                if (resource.getProperties() != null) {
                    StringBuffer request = DAVProppatchHandler.generatePropertyRequest(null, resource.getProperties());
                    this.myConnection.doProppatch(resource.getURL(), resource.getWorkingURL(), request, null, null);
                }
                resource.dispose();
            }
            if ((status = this.myConnection.doMerge(this.myActivity, true, handler = new DAVMergeHandler(this.myCommitMediator, this.myPathsMap))).getError() != null) {
                this.myIsAborted = true;
                SVNErrorManager.error(status.getError());
            }
            this.abortEdit();
            SVNCommitInfo sVNCommitInfo = handler.getCommitInfo();
            return sVNCommitInfo;
        }
        finally {
            this.runCloseCallback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortEdit() throws SVNException {
        if (this.myIsAborted) {
            return;
        }
        this.myIsAborted = true;
        try {
            Iterator<Object> files2;
            block12: {
                try {
                    if (this.myActivity != null) {
                        this.myConnection.doDelete(this.myActivity);
                    }
                    Object var2_1 = null;
                    if (this.myFilesMap == null) break block12;
                    files2 = this.myFilesMap.values().iterator();
                }
                catch (Throwable throwable) {
                    Iterator<Object> files2;
                    Object var2_2 = null;
                    if (this.myFilesMap != null) {
                        files2 = this.myFilesMap.values().iterator();
                        while (files2.hasNext()) {
                            DAVResource file = (DAVResource)files2.next();
                            file.dispose();
                        }
                        this.myFilesMap = null;
                    }
                    files2 = this.myDirsStack.iterator();
                    while (files2.hasNext()) {
                        DAVResource resource = (DAVResource)files2.next();
                        resource.dispose();
                    }
                    this.myDirsStack = null;
                    throw throwable;
                }
                while (files2.hasNext()) {
                    DAVResource file = (DAVResource)files2.next();
                    file.dispose();
                }
                this.myFilesMap = null;
            }
            files2 = this.myDirsStack.iterator();
            while (files2.hasNext()) {
                DAVResource resource = (DAVResource)files2.next();
                resource.dispose();
            }
            this.myDirsStack = null;
            {
            }
        }
        finally {
            this.runCloseCallback();
        }
    }

    private void runCloseCallback() {
        if (this.myCloseCallback != null) {
            this.myCloseCallback.run();
            this.myCloseCallback = null;
        }
    }

    private String createActivity(String logMessage) throws SVNException {
        String path;
        String vcc;
        String head;
        String activity = this.myConnection.doMakeActivity();
        HTTPStatus status = this.myConnection.doCheckout(activity, null, head = DAVUtil.getPropertyValue(this.myConnection, vcc = DAVUtil.getPropertyValue(this.myConnection, path = SVNEncodingUtil.uriEncode(this.myLocation.getPath()), null, DAVElement.VERSION_CONTROLLED_CONFIGURATION), null, DAVElement.CHECKED_IN), false);
        String location = status.getHeader().getFirstHeaderValue("Location");
        if (location == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "The CHECKOUT response did not contain a 'Location:' header");
            SVNErrorManager.error(err);
        }
        logMessage = logMessage == null ? "" : logMessage;
        StringBuffer request = DAVProppatchHandler.generatePropertyRequest(null, "svn:log", logMessage);
        SVNErrorMessage context = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "applying log message to {0}", path);
        try {
            this.myConnection.doProppatch(null, location, request, null, context);
        }
        catch (SVNException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "applying log message to {0}", path);
            SVNErrorManager.error(err);
        }
        return activity;
    }

    private void checkoutResource(DAVResource resource, boolean allow404) throws SVNException {
        String location;
        if (resource.getWorkingURL() != null) {
            return;
        }
        HTTPStatus status = this.myConnection.doCheckout(this.myActivity, resource.getURL(), resource.getVersionURL(), allow404);
        if (allow404 && status.getCode() == 404) {
            resource.fetchVersionURL(true);
            status = this.myConnection.doCheckout(this.myActivity, resource.getURL(), resource.getVersionURL(), false);
        }
        if ((location = status.getHeader().getFirstHeaderValue("Location")) == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "The CHECKOUT response did not contain a 'Location:' header");
            SVNErrorManager.error(err);
        }
        resource.setWorkingURL(location);
    }
}

