/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.delta;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.tmatesoft.svn.core.io.diff.SVNDiffInstruction;

public abstract class SVNDeltaAlgorithm {
    private Collection myDiffInstructions = new ArrayList();
    private ByteArrayOutputStream myNewData = new ByteArrayOutputStream();

    public void reset() {
        this.myDiffInstructions.clear();
        this.myNewData.reset();
    }

    public abstract void computeDelta(byte[] var1, int var2, byte[] var3, int var4);

    public SVNDiffInstruction[] getDiffInstructions() {
        return this.myDiffInstructions.toArray(new SVNDiffInstruction[this.myDiffInstructions.size()]);
    }

    public ByteArrayOutputStream getNewDataStream() {
        return this.myNewData;
    }

    public Iterator diffInstructions() {
        return this.myDiffInstructions.iterator();
    }

    public byte[] getNewData() {
        return this.myNewData.toByteArray();
    }

    protected void copyFromSource(int position, int length) {
        SVNDiffInstruction instruction = new SVNDiffInstruction(0, length, position);
        this.myDiffInstructions.add(instruction);
    }

    protected void copyFromTarget(int position, int length) {
        SVNDiffInstruction instruction = new SVNDiffInstruction(1, length, position);
        this.myDiffInstructions.add(instruction);
    }

    protected void copyFromNewData(byte[] data, int offset, int length) {
        SVNDiffInstruction instruction = new SVNDiffInstruction(2, length, 0L);
        this.myDiffInstructions.add(instruction);
        this.myNewData.write(data, offset, length);
    }
}

