/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.validator;

import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.interceptor.AroundInterceptor;
import com.opensymphony.xwork.util.TextParseUtil;
import com.opensymphony.xwork.validator.ActionValidatorManagerFactory;
import java.util.Collections;
import java.util.Set;

public class ValidationInterceptor
extends AroundInterceptor {
    Set excludeMethods = Collections.EMPTY_SET;
    Set includeMethods = Collections.EMPTY_SET;

    public void setExcludeMethods(String excludeMethods) {
        this.excludeMethods = TextParseUtil.commaDelimitedStringToSet(excludeMethods);
    }

    public void setIncludeMethods(String includeMethods) {
        this.includeMethods = TextParseUtil.commaDelimitedStringToSet(includeMethods);
    }

    protected void after(ActionInvocation dispatcher, String result) throws Exception {
    }

    protected void before(ActionInvocation invocation) throws Exception {
        String method = invocation.getProxy().getMethod();
        if (this.excludeMethods.contains(method) && !this.includeMethods.contains(method)) {
            this.log.debug((Object)("Skipping validation. Method [" + method + "] found in exclude list."));
            return;
        }
        if (this.includeMethods.size() == 0 || this.includeMethods.contains(method)) {
            Object action = invocation.getAction();
            String context = invocation.getProxy().getActionName();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Validating " + invocation.getProxy().getNamespace() + "/" + invocation.getProxy().getActionName() + "."));
            }
            ActionValidatorManagerFactory.getInstance().validate(action, context);
        }
    }
}

